/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.tableview.html;

import com.sas.actionprovider.ActionList;
import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.tableview.AbstractBaseTableView;
import com.sas.servlet.tbeans.tableview.TableCellContentsRenderer;
import com.sas.servlet.tbeans.tableview.TableColumnModel;
import com.sas.servlet.tbeans.tableview.html.HtmlTableViewUtil;
import com.sas.servlet.tbeans.tableview.html.TableView;
import com.sas.util.SimpleTemplate;
import com.sas.util.Strings;
import com.sas.util.transforms.ObjectToStringTransform;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.table.TableModel;

@SASScope(value="ALL")
public class CellContentsSimpleTemplateRenderer
extends SimpleTemplate
implements TableCellContentsRenderer {
    private Locale locale;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private String tagProlog;
    private String tagEpilog;
    private String nullTextString = "&#160;";
    private ActionList actionList;
    private AbstractBaseTableView tableview;
    private boolean visible;
    private boolean encodeText = true;
    private TransformInterface inputTransform = null;

    public CellContentsSimpleTemplateRenderer() {
        this.visible = true;
    }

    public CellContentsSimpleTemplateRenderer(String pattern) {
        super(pattern);
    }

    public CellContentsSimpleTemplateRenderer(String pattern, Map dictionary) {
        super(pattern, dictionary);
    }

    public CellContentsSimpleTemplateRenderer(String pattern, Map dictionary, char marker, char open, char close) {
        super(pattern, dictionary, marker, open, close);
    }

    public CellContentsSimpleTemplateRenderer(String pattern, char marker, char open, char close) {
        super(pattern, marker, open, close);
    }

    public CellContentsSimpleTemplateRenderer(Map dictionary) {
        super(dictionary);
    }

    public CellContentsSimpleTemplateRenderer(boolean allowClassLoading) {
        super(allowClassLoading);
    }

    public CellContentsSimpleTemplateRenderer(String pattern, boolean allowClassLoading) {
        super(pattern, allowClassLoading);
    }

    public CellContentsSimpleTemplateRenderer(String pattern, Map dictionary, char marker, char open, char close, boolean allowClassLoading) {
        super(pattern, dictionary, marker, open, close, allowClassLoading);
    }

    public CellContentsSimpleTemplateRenderer(String pattern, char marker, char open, char close, boolean allowClassLoading) {
        super(pattern, marker, open, close, allowClassLoading);
    }

    public CellContentsSimpleTemplateRenderer(Map dictionary, boolean allowClassLoading) {
        super(dictionary, allowClassLoading);
    }

    @Override
    public TransformationInterface getCellContentsRendererComponent(AbstractBaseTableView viewer, Object value, ActionList actions) {
        this.setActions(actions);
        this.setTableView(viewer);
        if (viewer instanceof TableView) {
            TableView table = (TableView)viewer;
            TableModel model = table.getModel();
            TableColumnModel cm = table.getColumnModel();
            int row = table.getCurrentRow();
            if (this.dmapValues == null) {
                this.dmapValues = new HashMap();
            }
            int colCount = model.getColumnCount();
            for (int column = 0; column < colCount; ++column) {
                if (this.getInputTransform() == null) {
                    ObjectToStringTransform transform = new ObjectToStringTransform(this.getLocale());
                    transform.setNullString(null);
                    this.setInputTransform((TransformInterface)transform);
                }
                if (row > 0) {
                    Object cellValue = model.getValueAt(row - 1, column);
                    try {
                        cellValue = this.getInputTransform().transform(cellValue);
                    }
                    catch (TransformException transformException) {
                        // empty catch block
                    }
                    if (cellValue != null) {
                        if (this.isEncodeText()) {
                            cellValue = Strings.quoteForXML((String)cellValue.toString());
                        }
                    } else if (this.getNullTextString() != null) {
                        cellValue = this.getNullTextString();
                    }
                    this.dmapValues.put(HtmlTableViewUtil.getColumnName((TableModel)model, (int)column), cellValue);
                    continue;
                }
                if (row != 0) continue;
                String name = HtmlTableViewUtil.getColumnName((TableModel)model, (int)column);
                try {
                    name = this.getInputTransform().transform((Object)name).toString();
                }
                catch (TransformException transformException) {
                    // empty catch block
                }
                if (name != null) {
                    if (this.isEncodeText()) {
                        name = Strings.quoteForXML((String)name);
                    }
                } else if (this.getNullTextString() != null) {
                    name = this.getNullTextString();
                }
                this.dmapValues.put(name, name);
            }
            this.dmapValues.put("VIEW_ROW_NUMBER", new Integer(row));
            this.dmapValues.put("MODEL_ROW_NUMBER", new Integer(row - 1));
            this.dmapValues.put("VIEW_COLUMN_NUMBER", new Integer(table.getCurrentColumn()));
            this.dmapValues.put("MODEL_COLUMN_NUMBER", new Integer(cm.getColumn(table.getCurrentColumn() - 1).getModelIndex()));
            if (this.actionList != null && this.actionList.size() > 0) {
                try {
                    StringWriter sw = null;
                    Map names = this.getNameDictionary();
                    Set keySet = names.keySet();
                    for (String currentKey : keySet) {
                        if (!currentKey.equals("CELL_ACTIONS")) continue;
                        sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        HtmlTableViewUtil.writeActions(this.tableview, this.actionList, pw, this.isEncodeText());
                        break;
                    }
                    this.dmapValues.put("CELL_ACTIONS", sw);
                }
                catch (IOException e) {
                    this.dmapValues.put("CELL_ACTIONS", null);
                }
            } else {
                this.dmapValues.put("CELL_ACTIONS", null);
            }
        }
        return this;
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        try {
            if (this.isVisible()) {
                if (this.getTagProlog() != null) {
                    out.println(this.tagProlog);
                }
                this.setWriter(out);
                this.format();
                out.println();
                if (this.getTagEpilog() != null) {
                    out.println(this.tagEpilog);
                }
            }
        }
        finally {
            this.setWriter(null);
            this.setActions(null);
            this.setRequest(null);
            this.setResponse(null);
        }
    }

    @Override
    public void write(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.setRequest(req);
        this.setResponse(resp);
        PrintWriter out = resp.getWriter();
        this.write(out);
    }

    @Override
    public void write(Writer out) throws IOException {
        PrintWriter o = new PrintWriter(out);
        this.write(o);
        o.flush();
    }

    @Override
    public void write(OutputStream out) throws IOException {
        PrintWriter o = new PrintWriter(out);
        this.write(o);
        o.flush();
    }

    @Override
    public void setId(String value) {
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public void setCustomAttributes(String value) {
    }

    @Override
    public String getCustomAttributes() {
        return null;
    }

    @Override
    public void setDescription(String value) {
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public void setLocale(Locale loc) {
        if ((loc != null && !loc.equals(this.getLocale()) || this.getLocale() != null && !this.getLocale().equals(loc)) && this.getInputTransform() instanceof ObjectToStringTransform) {
            if (loc == null) {
                this.setInputTransform(null);
            } else {
                ObjectToStringTransform transform = new ObjectToStringTransform(loc);
                transform.setNullString(null);
                this.setInputTransform((TransformInterface)transform);
            }
        }
        this.locale = loc;
    }

    @Override
    public Locale getLocale() {
        if (this.locale == null) {
            if (this.request == null || this.getLocaleNotExist()) {
                return Locale.getDefault();
            }
            return this.request.getLocale();
        }
        return this.locale;
    }

    private boolean getLocaleNotExist() {
        Class<HttpServletRequest> c = HttpServletRequest.class;
        try {
            Method m = c.getMethod("getLocale", null);
            return m == null;
        }
        catch (Exception ex) {
            return true;
        }
    }

    public void setNullTextString(String nullTextString) {
        this.nullTextString = nullTextString;
    }

    public String getNullTextString() {
        return this.nullTextString;
    }

    public void setEncodeText(boolean encodeText) {
        this.encodeText = encodeText;
    }

    public boolean isEncodeText() {
        return this.encodeText;
    }

    @Override
    public void setName(String value) {
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    @Override
    public HttpServletResponse getResponse() {
        return this.response;
    }

    @Override
    public String getTagProlog() {
        return this.tagProlog;
    }

    @Override
    public void setTagProlog(String prolog) {
        this.tagProlog = prolog;
    }

    @Override
    public String getTagEpilog() {
        return this.tagEpilog;
    }

    @Override
    public void setTagEpilog(String epilog) {
        this.tagEpilog = epilog;
    }

    @Override
    public void setActions(ActionList actions) {
        this.actionList = actions;
    }

    @Override
    public ActionList getActions() {
        return this.actionList;
    }

    @Override
    public void setTableView(AbstractBaseTableView viewer) {
        this.tableview = viewer;
    }

    @Override
    public AbstractBaseTableView getTableView() {
        return this.tableview;
    }

    @Override
    public void setVisible(boolean b) {
        this.visible = b;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @SASScope
    public void setStyleClass(String value) {
    }

    @SASScope
    public String getStyleClass() {
        return null;
    }

    @SASScope
    public void setStyle(String value) {
    }

    @SASScope
    public String getStyle() {
        return null;
    }

    public void setInputTransform(TransformInterface transform) {
        this.inputTransform = transform;
    }

    public TransformInterface getInputTransform() {
        return this.inputTransform;
    }
}

