/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.tableview.html;

import com.sas.actionprovider.ActionList;
import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.HttpConstants;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.StyleInterface;
import com.sas.servlet.tbeans.tableview.AbstractBaseTableView;
import com.sas.servlet.tbeans.tableview.TableCell;
import com.sas.servlet.tbeans.tableview.html.RB;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;

@SASScope(value="ALL")
public abstract class BaseTableCell
implements TableCell,
HttpConstants,
StyleInterface {
    static final String RB_KEY = "BaseTableCell.";
    private int horizontalAlignment = 99;
    private int verticalAlignment = 99;
    private int colspan = 1;
    private int rowspan = 1;
    private int width;
    private int widthPercentage;
    private int height;
    private int heightPercentage;
    private boolean nowrap;
    private int scope = 99;
    private String bgcolor;
    private String customAttributes;
    private String id;
    private String headers;
    private StyleInfo styleInfo;
    private String styleClassPrefix;
    private boolean header;
    private Locale locale;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setHeaders(String headers) {
        this.headers = headers;
    }

    public String getHeaders() {
        return this.headers;
    }

    public void setHorizontalAlignment(int alignment) {
        switch (alignment) {
            case 0: 
            case 2: 
            case 4: 
            case 20: 
            case 21: 
            case 99: {
                this.horizontalAlignment = alignment;
                break;
            }
            default: {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidAlignment.txt", this.getLocale()));
            }
        }
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setVerticalAlignment(int alignment) {
        switch (alignment) {
            case 0: 
            case 1: 
            case 3: 
            case 22: 
            case 99: {
                this.verticalAlignment = alignment;
                break;
            }
            default: {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidAlignment.txt", this.getLocale()));
            }
        }
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setColSpan(int span) {
        this.colspan = span;
    }

    public int getColSpan() {
        return this.colspan;
    }

    public void setRowSpan(int span) {
        this.rowspan = span;
    }

    public int getRowSpan() {
        return this.rowspan;
    }

    public void setWidth(int pixels) {
        this.width = pixels;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidthPercentage(int percentage) {
        this.widthPercentage = percentage;
    }

    public int getWidthPercentage() {
        return this.widthPercentage;
    }

    public void setHeight(int pixels) {
        this.height = pixels;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeightPercentage(int percentage) {
        this.heightPercentage = percentage;
    }

    public int getHeightPercentage() {
        return this.heightPercentage;
    }

    public void setNoWrap(boolean nowrap) {
        this.nowrap = nowrap;
    }

    public boolean isNoWrap() {
        return this.nowrap;
    }

    public void setScope(int newScope) {
        switch (newScope) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 99: {
                this.scope = newScope;
                break;
            }
            default: {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidScope.txt", this.getLocale()));
            }
        }
    }

    public int getScope() {
        return this.scope;
    }

    public void setBgColor(String color) {
        this.bgcolor = color;
    }

    public String getBgColor() {
        return this.bgcolor;
    }

    public void setCustomAttributes(String value) {
        this.customAttributes = value;
    }

    public String getCustomAttributes() {
        return this.customAttributes;
    }

    @Override
    public StyleInfo getStyleInfo() {
        return this.styleInfo;
    }

    @Override
    public void setStyleInfo(StyleInfo styleInfo) {
        this.styleInfo = styleInfo;
    }

    @SASScope
    public void setStyle(String style) {
        if (this.getStyleInfo() == null) {
            this.setStyleInfo(new StyleInfo(style));
        } else {
            this.getStyleInfo().setStyle(style);
        }
    }

    @SASScope
    public String getStyle() {
        if (this.getStyleInfo() == null) {
            return null;
        }
        return this.getStyleInfo().getStyle();
    }

    @SASScope
    public void setStyleClass(String styleClass) {
        if (this.getStyleInfo() == null) {
            this.setStyleInfo(new StyleInfo(styleClass));
        } else {
            this.getStyleInfo().setClassid(styleClass);
        }
    }

    @SASScope
    public String getStyleClass() {
        if (this.getStyleInfo() == null) {
            return null;
        }
        return this.getStyleInfo().getClassid();
    }

    @SASScope
    public void setStyleClassPrefix(String styleClassPrefix) {
        this.styleClassPrefix = styleClassPrefix;
    }

    @SASScope
    public String getStyleClassPrefix() {
        return this.styleClassPrefix;
    }

    @Override
    public boolean isHeader() {
        return this.header;
    }

    @Override
    public void setHeader(boolean headerCell) {
        this.header = headerCell;
    }

    @Override
    public abstract void write(PrintWriter var1, AbstractBaseTableView var2, Object var3, String var4, ActionList var5) throws IOException;

    @Override
    public void writeBeginCell(PrintWriter out) throws IOException {
        StyleInfo si;
        if (this.isHeader()) {
            out.print("<th");
        } else {
            out.print("<td");
        }
        String attribute = BaseTableCell.getHorizontalAlignmentString(this.getHorizontalAlignment());
        if (attribute != null && attribute.length() > 0) {
            out.print(attribute);
        }
        if ((attribute = BaseTableCell.getVerticalAlignmentString(this.getVerticalAlignment())) != null && attribute.length() > 0) {
            out.print(attribute);
        }
        if ((attribute = this.getId()) != null) {
            out.print(" id=\"");
            out.print(this.id);
            out.print("\"");
        }
        if ((attribute = this.getHeaders()) != null) {
            out.print(" headers=\"");
            out.print(this.headers);
            out.print("\"");
        }
        if (this.getColSpan() != 1) {
            out.print(" colspan=\"");
            out.print(this.getColSpan());
            out.print("\"");
        }
        if (this.getRowSpan() != 1) {
            out.print(" rowspan=\"");
            out.print(this.getRowSpan());
            out.print("\"");
        }
        if (this.getWidth() > 0) {
            out.print(" width=\"");
            out.print(this.getWidth());
            out.print("\"");
        } else if (this.getWidthPercentage() > 0) {
            out.print(" width=\"");
            out.print(this.getWidthPercentage());
            out.print("%\"");
        }
        if (this.getHeight() > 0) {
            out.print(" height=\"");
            out.print(this.getHeight());
            out.print("\"");
        } else if (this.getHeightPercentage() > 0) {
            out.print(" height=\"");
            out.print(this.getHeightPercentage());
            out.print("%\"");
        }
        if (this.isNoWrap()) {
            out.print(" nowrap=\"nowrap\"");
        }
        if ((attribute = BaseTableCell.getScopeString(this.getScope())) != null && attribute.length() > 0) {
            out.print(attribute);
        }
        if (this.getBgColor() != null) {
            out.print(" bgcolor=\"");
            out.print(this.getBgColor());
            out.print("\"");
        }
        if ((attribute = this.getCustomAttributes()) != null && attribute.length() > 0) {
            out.print(" " + attribute);
        }
        if ((si = this.getStyleInfo()) != null) {
            out.print(si.write(new StringBuffer(), this.styleClassPrefix));
        }
        out.print(">");
    }

    @Override
    public void writeEndCell(PrintWriter out) throws IOException {
        if (this.isHeader()) {
            out.print("</th>");
        } else {
            out.print("</td>");
        }
    }

    private static String getHorizontalAlignmentString(int alignment) {
        String alignmentString = "";
        switch (alignment) {
            case 2: {
                alignmentString = " align=\"left\"";
                break;
            }
            case 4: {
                alignmentString = " align=\"right\"";
                break;
            }
            case 0: {
                alignmentString = " align=\"center\"";
                break;
            }
            case 20: {
                alignmentString = " align=\"justify\"";
                break;
            }
            case 21: {
                alignmentString = " align=\"char\"";
                break;
            }
        }
        return alignmentString;
    }

    private static String getVerticalAlignmentString(int alignment) {
        String alignmentString = "";
        switch (alignment) {
            case 1: {
                alignmentString = " valign=\"top\"";
                break;
            }
            case 3: {
                alignmentString = " valign=\"bottom\"";
                break;
            }
            case 0: {
                alignmentString = " valign=\"middle\"";
                break;
            }
            case 22: {
                alignmentString = " valign=\"baseline\"";
                break;
            }
        }
        return alignmentString;
    }

    private static String getScopeString(int scope) {
        String scopeString = "";
        switch (scope) {
            case 1: {
                scopeString = " scope=\"row\"";
                break;
            }
            case 2: {
                scopeString = " scope=\"col\"";
                break;
            }
            case 3: {
                scopeString = " scope=\"rowgroup\"";
                break;
            }
            case 4: {
                scopeString = " scope=\"colgroup\"";
                break;
            }
        }
        return scopeString;
    }

    public void setLocale(Locale loc) {
        this.locale = loc;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }
}

