/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.tableview.ajax;

import com.sas.servlet.tbeans.tableview.ajax.AJAXTableActions;
import com.sas.servlet.util.BaseUtil;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class AJAXPacket {
    private List infoList = new ArrayList();
    private Transport transport = new JSTransport();
    public static final String XML_TRANSPORT = "XML_TRANSPORT";
    public static final String JS_TRANSPORT = "JS_TRANSPORT";

    public AJAXPacket add(String html) {
        this.infoList.add(new Info(html));
        return this;
    }

    public AJAXPacket add(String html, String key, String value) {
        if (html == null) {
            return this;
        }
        this.add(html);
        this.set(key, value);
        return this;
    }

    public AJAXPacket set(String key, String value) {
        Info info = (Info)this.infoList.get(this.infoList.size() - 1);
        info.set(key, value);
        return this;
    }

    public void send(HttpServletResponse response) throws IOException {
        this.transport.send(response, this.infoList);
    }

    public void setTransportType(String type) {
        this.transport = XML_TRANSPORT.equals(type) ? new XMLTransport() : new JSTransport();
    }

    public String toString() {
        StringBuffer str = new StringBuffer("AJAXPacket: ");
        for (int i = 0; i < this.infoList.size(); ++i) {
            Info info = (Info)this.infoList.get(i);
            str.append("[").append(i).append("] : ").append(info).append("\n");
        }
        return str.toString();
    }

    static {
        JavaScriptIncludeHandler.addAlias(AJAXPacket.class, "AJAX");
    }

    private static class JSTransport
    implements Transport {
        @Override
        public void send(HttpServletResponse response, List infoList) throws IOException {
            response.setContentType(BaseUtil.TEXT_PLAIN_MIME_TYPE);
            PrintWriter out = response.getWriter();
            out.println("sas.ajax.updateViewers = function()");
            out.println("{");
            for (int i = 0; i < infoList.size(); ++i) {
                Info info = (Info)infoList.get(i);
                this.send(out, info);
            }
            out.println("}");
        }

        @Override
        public void send(PrintWriter out, Info info) {
            out.print("var str = \"");
            out.print(AJAXTableActions.escapeForJavaScript(info.html));
            out.println("\";");
            out.println("var parms={};");
            for (int i = 0; info.parms != null && i < info.parms.size(); ++i) {
                Pair parm = (Pair)info.parms.get(i);
                out.println("parms." + parm.key + " = \"" + parm.value + "\";");
            }
            out.println("  sas_AJAX_update(str, parms);");
        }
    }

    private static interface Transport {
        public void send(HttpServletResponse var1, List var2) throws IOException;

        public void send(PrintWriter var1, Info var2);
    }

    private static class Info {
        public String html;
        public List parms;

        Info(String html) {
            this.html = html;
        }

        public void set(String key, String val) {
            if (this.parms == null) {
                this.parms = new ArrayList();
            }
            this.parms.add(new Pair(key, val));
        }

        public String toString() {
            StringBuffer str = new StringBuffer("HTML = ");
            str.append(this.html).append("\n");
            for (int i = 0; i < this.parms.size(); ++i) {
                Pair pair = (Pair)this.parms.get(i);
                str.append(pair).append("\n");
            }
            return str.toString();
        }
    }

    private static class XMLTransport
    implements Transport {
        @Override
        public void send(HttpServletResponse response, List infoList) throws IOException {
            PrintWriter out = response.getWriter();
            out.println("<?xml version=\"1.0\"?>");
            out.println("<request>");
            for (int i = 0; i < infoList.size(); ++i) {
                Info info = (Info)infoList.get(i);
                this.send(out, info);
            }
            out.println("</request>");
        }

        @Override
        public void send(PrintWriter out, Info info) {
            out.println(XMLTransport.asCDATA("table", info.html));
            for (int i = 0; info.parms != null && i < info.parms.size(); ++i) {
                Pair parm = (Pair)info.parms.get(i);
                out.println(parm.value);
            }
        }

        static String asCDATA(String tag, String tableHTML) {
            String str = "";
            if (tableHTML != null && tableHTML.length() > 0) {
                str = "<" + tag + "><![CDATA[" + tableHTML + "]]</" + tag + ">";
            }
            return str;
        }
    }

    private static class Pair {
        String key;
        String value;

        public Pair(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return this.key + " = " + this.value;
        }
    }
}

