/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.tableview;

import com.sas.actionprovider.ActionList;
import com.sas.actionprovider.util.ActionUtil;
import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.entities.AttributeSetException;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.Role;
import com.sas.rpf.Context;
import com.sas.rpf.ContextInterface;
import com.sas.rpf.Rule;
import com.sas.rpf.RuleEngine;
import com.sas.rpf.TargetInterface;
import com.sas.rpf.data.DataVector;
import com.sas.rpf.data.DataVectorInterface;
import com.sas.servlet.tbeans.BaseLabel;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.StyleInterface;
import com.sas.servlet.tbeans.form.html.FormViewInterface;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.navigationbar.EditNavigationInterface;
import com.sas.servlet.tbeans.tableview.AbstractBaseTableView;
import com.sas.servlet.tbeans.tableview.BaseColumnHeader;
import com.sas.servlet.tbeans.tableview.BaseRowHeader;
import com.sas.servlet.tbeans.tableview.BaseTableViewHelper;
import com.sas.servlet.tbeans.tableview.ColumnHeaderAreaRenderer;
import com.sas.servlet.tbeans.tableview.ExportAsHyperlinkInterface;
import com.sas.servlet.tbeans.tableview.HttpEditController;
import com.sas.servlet.tbeans.tableview.RB;
import com.sas.servlet.tbeans.tableview.TableCellContentsEditor;
import com.sas.servlet.tbeans.tableview.TableCellContentsRenderer;
import com.sas.servlet.tbeans.tableview.TableCellEditor;
import com.sas.servlet.tbeans.tableview.TableCellRenderer;
import com.sas.servlet.tbeans.tableview.TableColumn;
import com.sas.servlet.tbeans.tableview.TableColumnModel;
import com.sas.servlet.tbeans.tableview.TableColumnModelEvent;
import com.sas.servlet.tbeans.tableview.TableColumnModelListener;
import com.sas.servlet.tbeans.tableview.TableRowModel;
import com.sas.servlet.tbeans.tableview.TableRowRenderer;
import com.sas.servlet.tbeans.tableview.TableViewActionSupportFilter;
import com.sas.servlet.tbeans.tableview.TableViewLockColumnHeadersFeature;
import com.sas.servlet.tbeans.tableview.html.BaseTableCell;
import com.sas.servlet.tbeans.tableview.html.CellContentsTextAreaEditor;
import com.sas.servlet.tbeans.tableview.html.CellContentsTextEntryEditor;
import com.sas.servlet.tbeans.tableview.html.DefaultTableCellEditor;
import com.sas.servlet.tbeans.tableview.html.DefaultTableHeaderRenderer;
import com.sas.servlet.tbeans.tableview.html.DefaultTableRowRenderer;
import com.sas.servlet.tbeans.tableview.html.HtmlTableViewUtil;
import com.sas.servlet.tbeans.tableview.html.ResizingUtil;
import com.sas.servlet.tbeans.tableview.html.TableView;
import com.sas.servlet.tbeans.tableview.rpf.RulesUtil;
import com.sas.servlet.tbeans.tableview.rpf.html.ConditionTableCellRenderer;
import com.sas.storage.iquery.BusinessQueryToTableModelAdapter;
import com.sas.storage.jdbc.export.SAStoExcelUtil;
import com.sas.swing.event.SwingTableModelEvent;
import com.sas.swing.models.TableModelInsertRowSupport;
import com.sas.swing.visuals.tableview.HoldInterface;
import com.sas.swing.visuals.tableview.TableColumnUniqueIDInterface;
import com.sas.swing.visuals.tableview.TableFormatAreaInterface;
import com.sas.swing.visuals.tableview.TableViewUtil;
import com.sas.table.AccurateRowCountInterface;
import com.sas.table.ColumnAlignmentInterface;
import com.sas.table.DeleteRowInterface;
import com.sas.table.FormattedInterface;
import com.sas.table.InsertRowInterface;
import com.sas.table.MoveColumnInterface;
import com.sas.table.SortException;
import com.sas.table.SortableInterface;
import com.sas.table.TableException;
import com.sas.table.TrueRowCountCalculatedInterface;
import com.sas.table.UpdateRowInterface;
import com.sas.util.ChainedException;
import com.sas.util.Util;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.transforms.BaseTransforms;
import com.sas.util.transforms.StringToDateTransform;
import com.sas.util.transforms.StringToDoubleTransform;
import com.sas.util.transforms.StringToFloatTransform;
import com.sas.util.transforms.StringToSQLDateTransform;
import com.sas.util.transforms.StringToSQLTimeTransform;
import com.sas.util.transforms.StringToSQLTimestampTransform;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

@SASScope(value="ALL")
public abstract class BaseTableView
extends AbstractBaseTableView
implements TableModelListener,
TableColumnModelListener,
EditNavigationInterface,
AccurateRowCountInterface,
MoveColumnInterface,
ExportAsHyperlinkInterface {
    static final long serialVersionUID = 6100599749255159868L;
    @SASScope
    public static final String RB_KEY = "BaseTableView.";
    public static final int LASTROW = -369;
    public static final int EDITROW = -22;
    private TableModel dataModel;
    private TableColumnModel columnModel;
    private boolean autoCreateColumnsFromModel;
    private TableRowModel rowModel;
    private BaseColumnHeader columnHeader;
    private BaseRowHeader rowHeader;
    private int currentRow;
    private int currentColumn;
    private Map cellRenderers;
    private Map cellEditors;
    private Map rowRenderers;
    private TableCellContentsRenderer noRowsRenderer;
    private ColumnHeaderAreaRenderer customHeaderRenderer;
    private HttpEditController editController;
    private int currentUpdateRow;
    private int currentInsertRow;
    private Map uncommittedValues;
    private Map rowsToDelete;
    private boolean lockColumnHeaders;
    private TableViewLockColumnHeadersFeature lockColumnHeadersFeature;
    private TableColumn editColumn;
    private TableColumn rowSelectionColumn;
    private int rowSelectionMode;
    private TableViewActionSupportFilter columnHeaderFilter;
    private TableViewActionSupportFilter editColumnFilter;
    private TableViewActionSupportFilter editRowFilter;
    private TableViewActionSupportFilter dataCellFilter;
    private ActionList columnHeaderActions;
    private ActionList editColumnActions;
    private ActionList editRowActions;
    private ActionList dataCellActions;
    private Boolean moveOnModel;
    private ColumnIterator columnIterator = new ColumnIterator();
    private ColumnIterator findColumnIterator = new ColumnIterator();
    private boolean cellIdsGenerated;
    private String[] sortedColumns;
    private int[] sortDirections;
    private ResizingUtil _resizingUtil;
    private StringBuffer smallTempBuffer;
    private CommonLoggerInterface log = LoggerRepository2.getLogger((String)BaseTableView.class.getPackage().getName(), null);
    protected String[] columnsToExportAsTextIfCustomFormatted = null;
    protected String[] columnsToNotEncode = null;
    private boolean toEncode = true;
    private static final int COLUMN_HEADER_FILTER_TYPE = 1;
    private static final int EDIT_COLUMN_FILTER_TYPE = 2;
    private static final int EDIT_ROW_FILTER_TYPE = 4;
    private static final int DATA_CELL_FILTER_TYPE = 3;

    public BaseTableView() {
        this.setId(Util.getName((String)"tv"));
        this.autoCreateColumnsFromModel = true;
        this.setActionSupportType("TABLEVIEW_SUPPORT");
        this.rowSelectionMode = 99;
        this.currentRow = -1;
        this.currentColumn = -1;
    }

    public TableModel getModel() {
        return this.dataModel;
    }

    public void setModel(TableModel tableModel) {
        if (this.dataModel != tableModel) {
            if (this.dataModel != null) {
                this.dataModel.removeTableModelListener(this);
            }
            this.dataModel = tableModel;
            if (this.dataModel != null) {
                this.dataModel.addTableModelListener(this);
                if (this.getAutoCreateColumnsFromModel()) {
                    this.createDefaultColumnsFromModel();
                }
            }
            this.initialize();
        }
    }

    @SASScope
    public boolean isLockColumnHeaders() {
        return this.lockColumnHeaders;
    }

    @SASScope
    public void setLockColumnHeaders(boolean value) {
        this.lockColumnHeaders = value;
    }

    public TableColumnModel getColumnModel() {
        if (this.columnModel == null) {
            this.columnModel = this.getDefaultColumnModel();
        }
        return this.columnModel;
    }

    public void setColumnModel(TableColumnModel columnModel) {
        if (columnModel == null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullColumnModel.txt", this.getLocale()));
        }
        TableColumnModel old = this.columnModel;
        if (columnModel != old) {
            if (old != null) {
                old.removeColumnModelListener(this);
            }
            this.columnModel = columnModel;
            columnModel.setLocale(this.getLocale());
            columnModel.addColumnModelListener(this);
            if (this.columnHeader != null) {
                this.columnHeader.setColumnModel(columnModel);
            }
        }
    }

    public abstract TableColumnModel getDefaultColumnModel();

    public void setAutoCreateColumnsFromModel(boolean autoCreate) {
        if (this.autoCreateColumnsFromModel != autoCreate) {
            this.autoCreateColumnsFromModel = autoCreate;
            if (autoCreate) {
                this.createDefaultColumnsFromModel();
            }
        }
    }

    public boolean getAutoCreateColumnsFromModel() {
        return this.autoCreateColumnsFromModel;
    }

    public void createDefaultColumnsFromModel() {
        if (this.dataModel != null) {
            TableColumnModel cm = this.getColumnModel();
            ArrayList<TableColumn> oldColumns = new ArrayList<TableColumn>(cm.getColumnCount());
            while (cm.getColumnCount() > 0) {
                TableColumn column = cm.getColumn(0);
                oldColumns.add(column);
                cm.removeColumn(column);
            }
            int count = this.dataModel.getColumnCount();
            for (int i = 0; i < count; ++i) {
                TableColumn newColumn = null;
                Object modelUniqueID = null;
                if (this.dataModel instanceof TableColumnUniqueIDInterface && (newColumn = this.getColumnForUniqueID(oldColumns, modelUniqueID = ((TableColumnUniqueIDInterface)this.dataModel).getColumnUniqueID(i))) != null) {
                    newColumn.setModelIndex(i);
                }
                if (newColumn == null) {
                    newColumn = new TableColumn(i);
                }
                newColumn.setUniqueModelIdentifier(modelUniqueID);
                this.addColumn(newColumn);
            }
        }
    }

    public TableRowModel getRowModel() {
        if (this.rowModel == null) {
            this.rowModel = this.getDefaultRowModel();
        }
        return this.rowModel;
    }

    public void setRowModel(TableRowModel rowModel) {
        this.rowModel = rowModel;
    }

    public abstract TableRowModel getDefaultRowModel();

    @Override
    public int getCurrentRow() {
        return this.currentRow;
    }

    public void setCurrentRow(int row) {
        this.currentRow = row;
    }

    public int getCurrentColumn() {
        return this.currentColumn;
    }

    public void setCurrentColumn(int column) {
        this.currentColumn = column;
    }

    public void setColumnHeader(BaseColumnHeader newHeader) {
        this.columnHeader = newHeader;
    }

    public BaseColumnHeader getColumnHeader() {
        if (this.columnHeader == null) {
            this.columnHeader = this.getDefaultColumnHeader();
        }
        return this.columnHeader;
    }

    public abstract BaseColumnHeader getDefaultColumnHeader();

    public void setRowHeader(BaseRowHeader newHeader) {
        this.rowHeader = newHeader;
    }

    public BaseRowHeader getRowHeader() {
        if (this.rowHeader == null) {
            this.rowHeader = this.getDefaultRowHeader();
        }
        return this.rowHeader;
    }

    public abstract BaseRowHeader getDefaultRowHeader();

    public void setEditController(HttpEditController newEditController) {
        this.editController = newEditController;
    }

    public HttpEditController getEditController() {
        if (this.editController == null) {
            this.editController = this.getDefaultEditController();
        }
        return this.editController;
    }

    public abstract HttpEditController getDefaultEditController();

    public abstract TableRowRenderer getDefaultColumnHeaderRowRenderer();

    public abstract TableRowRenderer getDefaultRowRenderer();

    public void setRowRenderer(int row, TableRowRenderer renderer) {
        if (row == -1) {
            this.setRowRenderer(1, row, 1, renderer);
        } else {
            this.setRowRenderer(row, row, 1, renderer);
        }
    }

    public void setRowRenderer(int startRow, int endRow, int repeatRowFactor, TableRowRenderer renderer) {
        if (this.rowRenderers == null) {
            this.rowRenderers = new LinkedHashMap();
        }
        TableViewUtil.setValuesOnMap((Map)this.rowRenderers, (int)startRow, (int)endRow, (int)repeatRowFactor, (int)1, (int)-1, (int)1, (Object)renderer);
    }

    public TableRowRenderer getRowRenderer(int row) {
        TableRowRenderer rowRenderer = (TableRowRenderer)TableViewUtil.checkForLastRowFromMap((Map)this.rowRenderers, (int)row, (int)1, (TableModel)this.getModel());
        if (rowRenderer == null) {
            rowRenderer = (TableRowRenderer)TableViewUtil.getValueFromMap((Map)this.rowRenderers, (int)row, (int)1);
        }
        if (rowRenderer == null) {
            rowRenderer = this.getDefaultRowRenderer();
        }
        return rowRenderer;
    }

    public abstract TableCellRenderer getDefaultRenderer();

    public void setCellRenderer(int row, int column, TableCellRenderer renderer) {
        if (row == -1 && column == -1) {
            this.setCellRenderer(1, -1, 1, 1, -1, 1, renderer);
        } else if (row == -1) {
            this.setCellRenderer(1, -1, 1, column, column, 1, renderer);
        } else if (column == -1) {
            this.setCellRenderer(row, row, 1, 1, -1, 1, renderer);
        } else {
            this.setCellRenderer(row, row, 1, column, column, 1, renderer);
        }
    }

    public void setCellRenderer(int startRow, int endRow, int repeatRowFactor, int startColumn, int endColumn, int repeatColumnFactor, TableCellRenderer renderer) {
        if (this.cellRenderers == null) {
            this.cellRenderers = new LinkedHashMap();
        }
        TableViewUtil.setValuesOnMap((Map)this.cellRenderers, (int)startRow, (int)endRow, (int)repeatRowFactor, (int)startColumn, (int)endColumn, (int)repeatColumnFactor, (Object)renderer);
    }

    public void setCellRenderer(TableFormatAreaInterface area, TableCellRenderer renderer) {
        if (this.cellRenderers == null) {
            this.cellRenderers = new LinkedHashMap();
        }
        TableViewUtil.setValuesOnMap((Map)this.cellRenderers, (TableFormatAreaInterface)area, (Object)renderer);
    }

    @SASScope
    public void removeAllCellRenderers() {
        if (this.cellRenderers != null) {
            this.cellRenderers.clear();
        }
    }

    @Override
    @SASScope
    public void removeCellRenderers(Collection collection) {
        if (this.cellRenderers != null) {
            TableViewUtil.removeCellRenderers((Map)this.cellRenderers, (Collection)collection);
        }
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer cellRenderer = (TableCellRenderer)TableViewUtil.checkForLastRowFromMap((Map)this.cellRenderers, (int)row, (int)column, (TableModel)this.getModel());
        TableColumn tableColumn = this.getColumnModel().getColumn(column - 1);
        if (cellRenderer == null) {
            cellRenderer = (TableCellRenderer)TableViewUtil.getValueFromMap((Map)this.cellRenderers, (int)row, (int)column, (Object)tableColumn.getUniqueModelIdentifier());
        }
        if (cellRenderer == null && (cellRenderer = tableColumn.getCellRenderer()) == null) {
            cellRenderer = this.getDefaultRenderer();
        }
        return cellRenderer;
    }

    public void setColumnHeaderAreaRenderer(ColumnHeaderAreaRenderer customRenderer) {
        this.customHeaderRenderer = customRenderer;
    }

    public ColumnHeaderAreaRenderer getColumnHeaderAreaRenderer() {
        return this.customHeaderRenderer;
    }

    public abstract TableCellEditor getDefaultEditor();

    public void setCellEditor(int row, int column, TableCellEditor editor) {
        if (row == -1 && column == -1) {
            this.setCellEditor(1, -1, 1, 1, -1, 1, editor);
        } else if (row == -1) {
            this.setCellEditor(1, -1, 1, column, column, 1, editor);
        } else if (column == -1) {
            this.setCellEditor(row, row, 1, 1, -1, 1, editor);
        } else {
            this.setCellEditor(row, row, 1, column, column, 1, editor);
        }
    }

    public void setCellEditor(int startRow, int endRow, int repeatRowFactor, int startColumn, int endColumn, int repeatColumnFactor, TableCellEditor editor) {
        if (this.cellEditors == null) {
            this.cellEditors = new LinkedHashMap();
        }
        TableViewUtil.setValuesOnMap((Map)this.cellEditors, (int)startRow, (int)endRow, (int)repeatRowFactor, (int)startColumn, (int)endColumn, (int)repeatColumnFactor, (Object)editor);
    }

    public void setCellEditor(TableFormatAreaInterface area, TableCellEditor editor) {
        if (this.cellEditors == null) {
            this.cellEditors = new LinkedHashMap();
        }
        TableViewUtil.setValuesOnMap((Map)this.cellEditors, (TableFormatAreaInterface)area, (Object)editor);
    }

    public TableCellEditor getCellEditor(int row, int column) {
        TableCellEditor cellEditor = (TableCellEditor)TableViewUtil.checkForLastRowFromMap((Map)this.cellEditors, (int)row, (int)column, (TableModel)this.getModel());
        TableColumn tableColumn = this.getColumnModel().getColumn(column - 1);
        if (cellEditor == null) {
            cellEditor = (TableCellEditor)TableViewUtil.getValueFromMap((Map)this.cellEditors, (int)row, (int)column, (Object)tableColumn.getUniqueModelIdentifier());
        }
        if (cellEditor == null && (cellEditor = tableColumn.getCellEditor()) == null) {
            cellEditor = this.getDefaultEditor();
        }
        return cellEditor;
    }

    public TableCellContentsRenderer getNoRowsRenderer() {
        if (this.noRowsRenderer == null) {
            return this.getDefaultNoRowsRenderer();
        }
        return this.noRowsRenderer;
    }

    public void setNoRowsRenderer(TableCellContentsRenderer renderer) {
        this.noRowsRenderer = renderer;
    }

    public abstract TableCellContentsRenderer getDefaultNoRowsRenderer();

    @Override
    public void cleanUpResources() {
        super.cleanUpResources();
        this.sortedColumns = null;
        this.sortDirections = null;
    }

    @Override
    public void writeColumnHeader(PrintWriter out) throws IOException {
        int saveCurrentRow = this.currentRow;
        this.currentRow = 0;
        TableRowRenderer columnHeaderRow = this.getRowModel().getColumnHeaderRowRenderer();
        if (columnHeaderRow == null) {
            columnHeaderRow = this.getDefaultColumnHeaderRowRenderer();
        }
        boolean resetStyle = this.initStyleOnRenderer(columnHeaderRow, "TABLEVIEW_COLUMN_HEADER_ROW_STYLE");
        columnHeaderRow.writeBeginRow(this, out);
        if (this.isRowHeaderVisible()) {
            this.writeCornerHeader(out);
        }
        TableColumnModel cModel = this.getColumnHeader().getColumnModel();
        boolean editColumnVisible = this.writeEditColumnHeaderIfNeeded(out, cModel);
        this._resizingUtil = new ResizingUtil(this);
        this.writeColumnHeaderCells(out, cModel, editColumnVisible);
        columnHeaderRow.writeEndRow(this, out);
        if (resetStyle) {
            this.resetStyleOnRenderer(columnHeaderRow);
        }
        this.moveOnModel = null;
        this.currentRow = saveCurrentRow;
        this._resizingUtil.writeResizingScript(out, this.getColumnModel(), "COLUMN_HEADER_AREA");
        this._resizingUtil = null;
    }

    private void writeCornerHeader(PrintWriter out) throws IOException {
        TableCellRenderer cornerRenderer = this.getColumnHeader().getDefaultRenderer();
        StringBuffer rendererId = null;
        boolean resetCRId = false;
        if (cornerRenderer instanceof BaseTableCell && this.isCellIdsGenerated() && ((BaseTableCell)((Object)cornerRenderer)).getId() == null) {
            rendererId = this.generateCornerHeaderId();
            ((BaseTableCell)((Object)cornerRenderer)).setId(rendererId.toString());
            resetCRId = true;
        }
        boolean resetCCRId = false;
        TableCellContentsRenderer ccr = cornerRenderer.getTableCellContentsRenderer();
        if (!(ccr instanceof Label) && ccr.getId() == null) {
            if (rendererId == null) {
                rendererId = this.generateCornerHeaderId();
            }
            rendererId.append("_ccr");
            ccr.setId(rendererId.toString());
            resetCCRId = true;
        }
        boolean resetStyleInfo = this.initStyleOnRenderer(cornerRenderer, "TABLEVIEW_COLUMN_HEADER_STYLE");
        this.render(cornerRenderer, out, this, "", null, null);
        if (resetStyleInfo) {
            this.resetStyleOnRenderer(cornerRenderer);
        }
        if (resetCRId) {
            ((BaseTableCell)((Object)cornerRenderer)).setId(null);
        }
        if (resetCCRId) {
            ccr.setId(null);
        }
    }

    private boolean writeEditColumnHeaderIfNeeded(PrintWriter out, TableColumnModel cModel) throws IOException {
        boolean found;
        boolean editColumnVisible = this.isEditColumnVisible();
        if (editColumnVisible && !(found = this.findEditColumn(cModel))) {
            this.writeEditColumnHeader(out, cModel);
        }
        return editColumnVisible;
    }

    private void writeEditColumnHeader(PrintWriter out, TableColumnModel cModel) throws IOException {
        TableColumn editColumn = this.getEditController().isSingleRowEditingEnabled() ? this.getEditColumn() : this.getRowSelectionColumn();
        TableCellRenderer renderer = editColumn.getHeaderRenderer();
        if (renderer == null) {
            renderer = this.getColumnHeader().getDefaultRenderer();
        }
        StringBuffer rendererId = null;
        boolean resetCRId = false;
        if (renderer instanceof BaseTableCell && this.isCellIdsGenerated() && ((BaseTableCell)((Object)renderer)).getId() == null) {
            rendererId = this.generateEditColumnHeaderId();
            ((BaseTableCell)((Object)renderer)).setId(rendererId.toString());
            resetCRId = true;
        }
        boolean resetCCRId = false;
        TableCellContentsRenderer ccr = renderer.getTableCellContentsRenderer();
        if (!(ccr instanceof Label) && ccr.getId() == null) {
            if (rendererId == null) {
                rendererId = this.generateEditColumnHeaderId();
            }
            rendererId.append("_ccr");
            ccr.setId(rendererId.toString());
            resetCCRId = true;
        }
        boolean resetStyleInfo = this.initStyleOnRenderer(renderer, "TABLEVIEW_COLUMN_HEADER_STYLE");
        String header = editColumn.getHeaderValue();
        this.render(renderer, out, this, header, null, null);
        if (resetStyleInfo) {
            this.resetStyleOnRenderer(renderer);
        }
        if (resetCRId) {
            ((BaseTableCell)((Object)renderer)).setId(null);
        }
        if (resetCCRId) {
            ccr.setId(null);
        }
    }

    private boolean findEditColumn(TableColumnModel cModel) {
        String searchString = this.getEditController().isSingleRowEditingEnabled() ? "TABLEVIEW_EDIT_COLUMN" : "TABLEVIEW_ROW_SELECTION";
        return this.findColumnIdentifier(cModel, searchString);
    }

    private boolean findColumnIdentifier(TableColumnModel cModel, String searchString) {
        this.findColumnIterator.init();
        int i = 0;
        while ((i = this.findColumnIterator.next()) >= 0) {
            String identString;
            TableColumn column = cModel.getColumn(i - 1);
            Object identObject = column.getIdentifier();
            if (identObject == null || !(identObject instanceof String) || !(identString = (String)identObject).equals(searchString)) continue;
            return true;
        }
        return false;
    }

    private void writeColumnHeaderCells(PrintWriter out, TableColumnModel cModel, boolean editColumnVisible) throws IOException {
        if (this.getColumnHeaderAreaRenderer() != null) {
            ArrayList<Integer> visColIndexList = new ArrayList<Integer>();
            this.columnIterator.init();
            while ((this.currentColumn = this.columnIterator.next()) >= 0) {
                visColIndexList.add(new Integer(this.currentColumn));
            }
            TableCellRenderer renderer = this.getColumnHeader().getDefaultRenderer();
            if (this.isExportToExcel() && renderer instanceof BaseTableCell) {
                StyleInfo currentStyleInfo = ((BaseTableCell)((Object)renderer)).getStyleInfo();
                String formatDirective = SAStoExcelUtil.getMicrosoftOfficeNumberFormatXMLDirective((String)SAStoExcelUtil.EXCEL_TEXT_FORMAT);
                if (!"".equals(formatDirective)) {
                    com.sas.servlet.commands.jdbc.export.Util.addFormatDirective((BaseTableCell)((Object)renderer), formatDirective);
                }
                this.getColumnHeaderAreaRenderer().writeColumnHeaderCells(out, renderer, cModel, visColIndexList);
                ((BaseTableCell)((Object)renderer)).setStyleInfo(currentStyleInfo);
            } else {
                this.getColumnHeaderAreaRenderer().writeColumnHeaderCells(out, renderer, cModel, visColIndexList);
            }
        } else {
            this.columnIterator.init();
            while ((this.currentColumn = this.columnIterator.next()) >= 0) {
                this.writeColumnHeaderCell(out, cModel, editColumnVisible);
            }
        }
    }

    private void writeColumnHeaderCell(PrintWriter out, TableColumnModel cModel, boolean editColumnVisible) throws IOException {
        TableColumn column = cModel.getColumn(this.currentColumn - 1);
        boolean isEditColumn = this.isEditColumn(column);
        if (!isEditColumn || editColumnVisible && this.getEditController().isSingleRowEditingEnabled()) {
            this.writeColumnHeaderCell(out, column);
        }
    }

    private boolean isEditColumn(TableColumn column) {
        String identString;
        boolean isEditColumn = false;
        Object identObject = column.getIdentifier();
        if (identObject != null && identObject instanceof String && (identString = (String)identObject).equals("TABLEVIEW_EDIT_COLUMN")) {
            isEditColumn = true;
        }
        return isEditColumn;
    }

    private void writeColumnHeaderCell(PrintWriter out, TableColumn column) throws IOException {
        String header;
        TableCellRenderer renderer = column.getHeaderRenderer();
        if (renderer == null) {
            renderer = this.getColumnHeader().getDefaultRenderer();
        }
        if ((header = column.getHeaderValue()) == null && column.getModelIndex() != -1) {
            header = this.dataModel.getColumnName(column.getModelIndex());
        }
        ActionList actions = null;
        if (this.isAllActionsVisible()) {
            actions = this.getColumnHeaderActions(column, header);
        }
        StringBuffer rendererId = null;
        boolean resetCRId = false;
        if (renderer instanceof BaseTableCell && (this.isCellIdsGenerated() || column.isResizable()) && ((BaseTableCell)((Object)renderer)).getId() == null) {
            rendererId = this.generateColumnHeaderId(this.currentColumn);
            ((BaseTableCell)((Object)renderer)).setId(rendererId.toString());
            resetCRId = true;
        }
        boolean resetCCRId = false;
        TableCellContentsRenderer ccr = renderer.getTableCellContentsRenderer();
        if (!(ccr instanceof Label) && ccr.getId() == null) {
            if (rendererId == null) {
                rendererId = this.generateColumnHeaderId(this.currentColumn);
            }
            rendererId.append("_ccr");
            ccr.setId(rendererId.toString());
            resetCCRId = true;
        }
        boolean resetStyleInfo = this.initStyleOnRenderer(renderer, "TABLEVIEW_COLUMN_HEADER_STYLE");
        boolean resetColSpan = false;
        if (renderer instanceof BaseTableCell) {
            if (this.getCellRenderer(1, this.getCurrentColumn()) instanceof ConditionTableCellRenderer && this.isExtraColumnsRequiredForRules(this.getCurrentColumn())) {
                ((BaseTableCell)((Object)renderer)).setColSpan(3);
            } else {
                ((BaseTableCell)((Object)renderer)).setColSpan(1);
            }
            resetColSpan = true;
        }
        StyleInfo resizingStyleInfo = this._resizingUtil.handleResizing(column, renderer, this.currentColumn - 1);
        if (actions != null && this.getTextWrapping() == -1 || this.getTextWrapping() == 1 && column.isTextWrappingEnabled()) {
            actions.setContainerWrappingEnabled(true);
        }
        StyleInfo saved = this.removeLastBorder(renderer);
        if (this.isExportToExcel() && renderer instanceof BaseTableCell) {
            StyleInfo currentStyleInfo = ((BaseTableCell)((Object)renderer)).getStyleInfo();
            String formatDirective = SAStoExcelUtil.getMicrosoftOfficeNumberFormatXMLDirective((String)SAStoExcelUtil.EXCEL_TEXT_FORMAT);
            if (!"".equals(formatDirective)) {
                com.sas.servlet.commands.jdbc.export.Util.addFormatDirective((BaseTableCell)((Object)renderer), formatDirective);
            }
            this.render(renderer, out, this, header, null, actions);
            ((BaseTableCell)((Object)renderer)).setStyleInfo(currentStyleInfo);
        } else {
            this.render(renderer, out, this, header, null, actions);
        }
        if (saved != MISSING_STYLEINFO) {
            ((StyleInterface)((Object)renderer)).setStyleInfo(saved);
        }
        this.resetColumnHeaderActions();
        if (resizingStyleInfo != null) {
            ((DefaultTableHeaderRenderer)renderer).setStyleInfo(resizingStyleInfo);
        }
        if (resetStyleInfo) {
            this.resetStyleOnRenderer(renderer);
        }
        if (resetCRId) {
            ((BaseTableCell)((Object)renderer)).setId(null);
        }
        if (resetCCRId) {
            ccr.setId(null);
        }
        if (resetColSpan) {
            ((BaseTableCell)((Object)renderer)).setColSpan(1);
        }
    }

    protected ActionList getColumnHeaderActions(TableColumn column, String header) {
        if (this.columnHeaderActions == null) {
            try {
                if (this.getActionProvider() != null && column.getModelIndex() != -1) {
                    this.columnHeaderFilter = this.getFilter(1);
                    StringBuffer viewerId = this.generateColumnHeaderId(this.currentColumn);
                    this.columnHeaderFilter.setViewerId(viewerId.toString());
                    Integer modelColumnIndex = new Integer(column.getModelIndex());
                    Integer viewerColumnIndex = new Integer(this.currentColumn);
                    this.columnHeaderFilter.setAttribute("table", this);
                    this.columnHeaderFilter.setAttribute("model", this.dataModel);
                    this.columnHeaderFilter.setAttribute("column", viewerColumnIndex);
                    this.columnHeaderFilter.setModelColumn(column.getModelIndex());
                    this.columnHeaderFilter.setAttribute("columnName", header);
                    this.columnHeaderFilter.setSortStatus(this.getSortStatus(column.getModelIndex()));
                    if (this.isMoveOnModel()) {
                        this.columnHeaderFilter.setAttribute("moveColumnInterface", this.dataModel);
                        this.columnHeaderFilter.setAttribute("moveColumn", modelColumnIndex);
                    } else {
                        this.columnHeaderFilter.setAttribute("moveColumnInterface", this);
                        this.columnHeaderFilter.setAttribute("moveColumn", viewerColumnIndex);
                    }
                    if (this instanceof FormViewInterface) {
                        this.columnHeaderFilter.setAttribute("formName", ((FormViewInterface)((Object)this)).getFormObject().getName());
                    }
                    if (this.getEditController().isEditEnabled()) {
                        int tempRow = this.getEditRow();
                        this.columnHeaderFilter.setAttribute("row", new Integer(tempRow));
                        this.columnHeaderFilter.setAttribute("autoCommit", new Boolean(this.isAutoCommit()));
                    }
                    this.columnHeaderActions = this.getActionProvider().getActions(this.columnHeaderFilter);
                }
            }
            catch (AttributeSetException ase) {
                this.log.error(ase.getMessage(), (Throwable)ase);
            }
        }
        return this.columnHeaderActions;
    }

    protected void resetColumnHeaderActions() {
        if (this.getActionProvider() != null) {
            this.getActionProvider().returnActionList(this.columnHeaderActions);
        }
        this.columnHeaderActions = null;
    }

    private int getEditRow() {
        int tempRow = this.currentRow;
        if (this.getEditController().isSingleRowEditingEnabled()) {
            if (this.currentUpdateRow > 0 || this.currentUpdateRow == -22) {
                tempRow = this.currentUpdateRow;
            } else if (this.currentInsertRow > 0 || this.currentInsertRow == -22) {
                tempRow = this.currentInsertRow;
            }
        }
        return tempRow;
    }

    @Override
    protected void writeRows(PrintWriter out) throws IOException {
        while (true) {
            ++this.currentRow;
            if (!this.rowExists(this.currentRow) || this.currentRow > this.endRow + 1) break;
            this.writeRow(this.currentRow, out);
        }
        if (this.currentInsertRow == -1 && this.currentRow <= this.rowCount) {
            this.currentRow = this.rowCount;
            this.writeRow(this.currentInsertRow, out);
        }
        this.currentRow = -1;
    }

    public void writeRow(int rowNumber, Writer out) throws IOException {
        PrintWriter o = new PrintWriter(out);
        this.writeRow(rowNumber, o);
        o.flush();
    }

    public void writeRow(int rowNumber, OutputStream out) throws IOException {
        PrintWriter o = new PrintWriter(out);
        this.writeRow(rowNumber, o);
        o.flush();
    }

    public void writeRow(int rowNumber, PrintWriter out) throws IOException {
        boolean isExtendRow = false;
        if (rowNumber == -1 || rowNumber == this.rowCount && this.currentInsertRow == -1) {
            isExtendRow = true;
            if (this.dataModel instanceof InsertRowInterface) {
                rowNumber = ((InsertRowInterface)this.dataModel).getUncommittedRowNumber() + 1;
            } else if (this.dataModel instanceof DefaultTableModel) {
                rowNumber = this.rowCount;
            }
        }
        if (this.getRulesContext() != null) {
            if (rowNumber == 1) {
                this.columnIterator.init();
                while ((this.currentColumn = this.columnIterator.next()) >= 0) {
                    TableCellRenderer cellRenderer = this.getCellRenderer(rowNumber, this.currentColumn);
                    if (!(cellRenderer instanceof ConditionTableCellRenderer)) continue;
                    ((ConditionTableCellRenderer)cellRenderer).reset();
                }
            }
            if (!this.isTotalRow(rowNumber)) {
                this.handleExceptionHighlighting(rowNumber);
            }
        }
        TableRowRenderer tableRow = this.getRowRenderer(isExtendRow ? this.endRow + 2 : rowNumber);
        boolean resetTableRowStyleInfo = this.initStyleOnRenderer(tableRow, this.isTotalRow(rowNumber) ? "TABLEVIEW_TOTALS_ROW_STYLE" : "TABLEVIEW_ROW_STYLE");
        tableRow.writeBeginRow(this, out);
        if (this.isRowHeaderVisible()) {
            this.writeRowHeader(out, rowNumber, isExtendRow);
        }
        TableColumnModel cModel = this.getColumnHeader().getColumnModel();
        ActionList editActions = null;
        boolean editColumnVisible = this.isEditColumnVisible();
        if (editColumnVisible) {
            editActions = this.writeEditColumn(out, rowNumber, isExtendRow, cModel);
        }
        this.columnIterator.init();
        while ((this.currentColumn = this.columnIterator.next()) >= 0) {
            this.writeColumn(out, rowNumber, cModel, editActions, isExtendRow, editColumnVisible);
        }
        this.resetEditColumnActions();
        tableRow.writeEndRow(this, out);
        if (resetTableRowStyleInfo) {
            this.resetStyleOnRenderer(tableRow);
        }
    }

    @SASScope
    protected boolean isTotalRow(int rowNumber) {
        BusinessQueryProviderInterface bqProvider;
        BusinessQuery query;
        boolean totalRow = false;
        if (this.getModel() instanceof BusinessQueryProviderInterface && ((query = (bqProvider = (BusinessQueryProviderInterface)this.getModel()).getBusinessQuery()).getTotalType(Role.COLUMN).equals(BusinessQuery.AXISTOTAL) || query.getTotalType(Role.COLUMN).equals(BusinessQuery.GRANDTOTAL)) && this.getModel().getRowCount() == rowNumber) {
            totalRow = true;
        }
        return totalRow;
    }

    private void writeRowHeader(PrintWriter out, int rowNumber, boolean isExtendRow) throws IOException {
        TableCellRenderer rowHeaderRenderer = this.getRowModel().getRowHeaderRenderer();
        if (rowHeaderRenderer == null) {
            rowHeaderRenderer = this.getRowHeader().getDefaultRenderer();
        }
        StringBuffer rendererId = null;
        boolean resetCRId = false;
        if (rowHeaderRenderer instanceof BaseTableCell && this.isCellIdsGenerated() && ((BaseTableCell)((Object)rowHeaderRenderer)).getId() == null) {
            rendererId = this.generateRowHeaderId(rowNumber);
            ((BaseTableCell)((Object)rowHeaderRenderer)).setId(rendererId.toString());
            resetCRId = true;
        }
        boolean resetCCRId = false;
        TableCellContentsRenderer ccr = rowHeaderRenderer.getTableCellContentsRenderer();
        if (!(ccr instanceof Label) && ccr.getId() == null) {
            if (rendererId == null) {
                rendererId = this.generateRowHeaderId(rowNumber);
            }
            rendererId.append("_ccr");
            ccr.setId(rendererId.toString());
            resetCCRId = true;
        }
        boolean resetStyleInfo = this.initStyleOnRenderer(rowHeaderRenderer, "TABLEVIEW_ROW_HEADER_STYLE");
        String rowHeaderValue = ActionUtil.getStringFromIndex((int)rowNumber);
        if (isExtendRow) {
            rowHeaderValue = "*";
        }
        StyleInfo saved = this.removeLastBorder(rowHeaderRenderer);
        this.render(rowHeaderRenderer, out, this, rowHeaderValue, null, null);
        if (saved != MISSING_STYLEINFO) {
            ((StyleInterface)((Object)rowHeaderRenderer)).setStyleInfo(saved);
        }
        if (resetStyleInfo) {
            this.resetStyleOnRenderer(rowHeaderRenderer);
        }
        if (resetCRId) {
            ((BaseTableCell)((Object)rowHeaderRenderer)).setId(null);
        }
        if (resetCCRId) {
            ccr.setId(null);
        }
    }

    private ActionList writeEditColumn(PrintWriter out, int rowNumber, boolean isExtendRow, TableColumnModel cModel) throws IOException {
        ActionList editActions = this.getEditColumnActions(rowNumber);
        boolean found = this.findEditColumn(cModel);
        if (!found) {
            this.writeEditColumn(out, editActions, isExtendRow, rowNumber);
        }
        return editActions;
    }

    protected ActionList getEditRowActions() {
        if (this.editRowActions == null) {
            this.editRowActions = this.getEditActions(-22);
        }
        return this.editRowActions;
    }

    protected void resetEditRowActions() {
        if (this.getActionProvider() != null) {
            this.getActionProvider().returnActionList(this.editRowActions);
        }
        this.editRowActions = null;
    }

    protected ActionList getEditColumnActions(int rowNumber) {
        if (this.editColumnActions == null) {
            this.editColumnActions = this.getEditActions(rowNumber);
        }
        return this.editColumnActions;
    }

    protected void resetEditColumnActions() {
        if (this.getActionProvider() != null) {
            this.getActionProvider().returnActionList(this.editColumnActions);
        }
        this.editColumnActions = null;
    }

    private ActionList getEditActions(int rowNumber) {
        ActionList actions = null;
        try {
            if (this.getActionProvider() != null) {
                StringBuffer viewerId = null;
                TableViewActionSupportFilter editFilter = null;
                if (rowNumber == -22) {
                    viewerId = this.generateEditRowId();
                    editFilter = this.getFilter(4);
                    editFilter.setAttribute("row", new Integer(-1));
                } else {
                    viewerId = this.generateEditColumnId(rowNumber);
                    editFilter = this.getFilter(2);
                    editFilter.setAttribute("row", new Integer(rowNumber));
                }
                editFilter.setViewerId(viewerId.toString());
                editFilter.setAttribute("table", this);
                editFilter.setAttribute("model", this);
                editFilter.setAttribute("autoCommit", new Boolean(this.isAutoCommit()));
                editFilter.setAttribute("promptOnDelete", new Boolean(this.isPromptOnDelete()));
                if (this instanceof FormViewInterface) {
                    editFilter.setAttribute("formName", ((FormViewInterface)((Object)this)).getFormObject().getName());
                }
                actions = this.getActionProvider().getActions(editFilter);
            }
        }
        catch (AttributeSetException ase) {
            this.log.error(ase.getMessage(), (Throwable)ase);
        }
        return actions;
    }

    private void writeEditColumn(PrintWriter out, ActionList editActions, boolean isExtendRow, int rowNumber) throws IOException {
        TableColumn editColumn = null;
        String styleKey = null;
        if (this.getEditController().isSingleRowEditingEnabled()) {
            styleKey = "TABLEVIEW_EDIT_COLUMN_CELL_STYLE";
            editColumn = this.getEditColumn();
        } else {
            styleKey = "TABLEVIEW_ROW_SELECTION_STYLE";
            editColumn = this.getRowSelectionColumn();
        }
        TableCellRenderer cellRenderer = editColumn.getCellRenderer();
        if (isExtendRow && !this.getEditController().isSingleRowEditingEnabled() || cellRenderer == null) {
            cellRenderer = this.getDefaultRenderer();
        }
        StringBuffer rendererId = null;
        boolean resetCRId = false;
        if (cellRenderer instanceof BaseTableCell && this.isCellIdsGenerated() && ((BaseTableCell)((Object)cellRenderer)).getId() == null) {
            rendererId = this.generateEditColumnId(rowNumber);
            ((BaseTableCell)((Object)cellRenderer)).setId(rendererId.toString());
            resetCRId = true;
        }
        boolean resetCCRId = false;
        TableCellContentsRenderer ccr = cellRenderer.getTableCellContentsRenderer();
        if (!(ccr instanceof Label) && ccr.getId() == null) {
            if (rendererId == null) {
                rendererId = this.generateEditColumnId(rowNumber);
            }
            rendererId.append("_ccr");
            ccr.setId(rendererId.toString());
            resetCCRId = true;
        }
        boolean resetStyleInfo = this.initStyleOnRenderer(cellRenderer, styleKey);
        this.render(cellRenderer, out, this, null, null, editActions);
        if (resetStyleInfo) {
            this.resetStyleOnRenderer(cellRenderer);
        }
        if (resetCRId) {
            ((BaseTableCell)((Object)cellRenderer)).setId(null);
        }
        if (resetCCRId) {
            ccr.setId(null);
        }
    }

    private void writeColumn(PrintWriter out, int rowNumber, TableColumnModel cModel, ActionList editActions, boolean isExtendRow, boolean editColumnVisible) throws IOException {
        TableCellEditor editor;
        TableColumn column = cModel.getColumn(this.currentColumn - 1);
        int colModelIndex = column.getModelIndex() + 1;
        Object identObject = column.getIdentifier();
        boolean isEditColumn = false;
        boolean isRowSelectionColumn = false;
        if (identObject != null && identObject instanceof String) {
            String identString = (String)identObject;
            if (identString.equals("TABLEVIEW_EDIT_COLUMN")) {
                isEditColumn = true;
            } else if (identString.equals("TABLEVIEW_ROW_SELECTION")) {
                isRowSelectionColumn = true;
            }
        }
        ActionList actions = null;
        if (this.isAllActionsVisible()) {
            actions = isEditColumn ? editActions : this.getDataCellActions(rowNumber, colModelIndex);
        }
        if ((editor = this.getCellEditor(rowNumber, isExtendRow, colModelIndex)) != null) {
            this.writeEditorCell(out, editor, rowNumber, colModelIndex, actions);
        } else if (!isEditColumn || editColumnVisible && this.getEditController().isSingleRowEditingEnabled()) {
            this.writeCell(out, rowNumber, colModelIndex, isExtendRow, isRowSelectionColumn, isEditColumn, actions);
        }
        if (!isEditColumn) {
            this.resetDataCellActions();
        }
    }

    protected ActionList getDataCellActions(int rowNumber, int colModelIndex) {
        if (this.dataCellActions == null) {
            try {
                if (this.getActionProvider() != null) {
                    this.dataCellFilter = this.getFilter(3);
                    StringBuffer viewerId = this.generateDataCellId(rowNumber, this.currentColumn);
                    this.dataCellFilter.setViewerId(viewerId.toString());
                    this.dataCellFilter.setAttribute("table", this);
                    this.dataCellFilter.setAttribute("model", this.getModel());
                    this.dataCellFilter.setRow(this.currentRow);
                    this.dataCellFilter.setModelRow(rowNumber - 1);
                    this.dataCellFilter.setColumn(this.currentColumn);
                    this.dataCellFilter.setModelColumn(colModelIndex - 1);
                    if (this instanceof FormViewInterface) {
                        this.dataCellFilter.setAttribute("formName", ((FormViewInterface)((Object)this)).getFormObject().getName());
                    }
                    this.dataCellActions = this.getActionProvider().getActions(this.dataCellFilter);
                }
            }
            catch (AttributeSetException ase) {
                this.log.error(ase.getMessage(), (Throwable)ase);
            }
        }
        return this.dataCellActions;
    }

    protected void resetDataCellActions() {
        if (this.getActionProvider() != null) {
            this.getActionProvider().returnActionList(this.dataCellActions);
        }
        this.dataCellActions = null;
    }

    @SASScope
    public TableCellEditor getCellEditor(int rowNumber, boolean isExtendRow, int colModelIndex) {
        DefaultTableCellEditor editor;
        if (!this.isAllActionsVisible()) {
            return null;
        }
        if (!this.isCellModifiable(isExtendRow ? -1 : rowNumber, colModelIndex)) {
            return null;
        }
        TableCellEditor cellEditor = this.getCellEditor(isExtendRow ? this.endRow + 2 : rowNumber, this.currentColumn);
        if (cellEditor instanceof DefaultTableCellEditor && !(editor = (DefaultTableCellEditor)cellEditor).isCellEditable(rowNumber - 1, colModelIndex - 1)) {
            return null;
        }
        return cellEditor;
    }

    @SASScope
    public void writeEditorCell(PrintWriter out, TableCellEditor cellEditor, int rowNumber, int colModelIndex, ActionList actions) throws IOException {
        TableCellContentsEditor contentsEditor = cellEditor.getTableCellContentsEditor();
        HtmlTableViewUtil.setOnModificationEvent(this, contentsEditor);
        String styleKey = null;
        styleKey = this.isNumericData(colModelIndex - 1) ? "TABLEVIEW_DATA_NUMERIC_STYLE" : "TABLEVIEW_DATA_STYLE";
        boolean resetStyleInfo = this.initStyleOnRenderer(cellEditor, styleKey);
        Object value = null;
        TableCellContentsEditor ccEditor = cellEditor.getTableCellContentsEditor();
        value = ccEditor instanceof CellContentsTextEntryEditor || ccEditor instanceof CellContentsTextAreaEditor ? this.getCell(rowNumber, colModelIndex, true) : this.getCell(rowNumber, colModelIndex);
        StringBuffer rendererId = null;
        boolean resetCRId = false;
        if (cellEditor instanceof BaseTableCell && this.isCellIdsGenerated() && ((BaseTableCell)((Object)cellEditor)).getId() == null) {
            rendererId = this.generateDataCellId(rowNumber, this.currentColumn);
            ((BaseTableCell)((Object)cellEditor)).setId(rendererId.toString());
            resetCRId = true;
        }
        StringBuffer editorId = this.generateEditCellId(rowNumber - 1, colModelIndex - 1);
        this.renderEditor(cellEditor, out, this, value, editorId.toString(), actions);
        if (resetStyleInfo) {
            this.resetStyleOnRenderer(cellEditor);
        }
        if (resetCRId) {
            ((BaseTableCell)((Object)cellEditor)).setId(null);
        }
    }

    @SASScope
    public void writeCell(PrintWriter out, int rowNumber, int colModelIndex, boolean isExtendRow, boolean isRowSelectionColumn, boolean isEditColumn, ActionList actions) throws IOException {
        Object dataCell;
        TableCellRenderer cellRenderer = this.getCellRenderer(rowNumber, this.currentColumn);
        String styleKey = null;
        if (isEditColumn) {
            styleKey = "TABLEVIEW_EDIT_COLUMN_CELL_STYLE";
        } else if (isRowSelectionColumn) {
            if (isExtendRow && !this.getEditController().isSingleRowEditingEnabled()) {
                cellRenderer = this.getDefaultRenderer();
            }
            styleKey = "TABLEVIEW_ROW_SELECTION_STYLE";
        } else {
            styleKey = this.isNumericData(colModelIndex - 1) ? "TABLEVIEW_DATA_NUMERIC_STYLE" : "TABLEVIEW_DATA_STYLE";
        }
        boolean resetStyleInfo = this.initStyleOnRenderer(cellRenderer, styleKey);
        StringBuffer rendererId = null;
        boolean resetCRId = false;
        if (cellRenderer instanceof BaseTableCell && this.isCellIdsGenerated() && ((BaseTableCell)((Object)cellRenderer)).getId() == null) {
            rendererId = this.generateId(rowNumber, isRowSelectionColumn, isEditColumn);
            ((BaseTableCell)((Object)cellRenderer)).setId(rendererId.toString());
            resetCRId = true;
        }
        boolean resetCCRId = false;
        TableCellContentsRenderer ccr = cellRenderer.getTableCellContentsRenderer();
        if (!(ccr instanceof Label) && ccr.getId() == null) {
            if (rendererId == null) {
                rendererId = this.generateId(rowNumber, isRowSelectionColumn, isEditColumn);
            }
            rendererId.append("_ccr");
            ccr.setId(rendererId.toString());
            resetCCRId = true;
        }
        Object object = dataCell = colModelIndex == 0 ? null : this.getCell(rowNumber, colModelIndex);
        if (dataCell != null && dataCell instanceof String) {
            RulesUtil.updateActionsForConditions(cellRenderer, actions, (String)dataCell);
        }
        if (!(!this.isExportToExcel() || !(cellRenderer instanceof BaseTableCell) || cellRenderer instanceof ConditionTableCellRenderer || this.getCellRenderer(1, this.currentColumn) instanceof ConditionTableCellRenderer && this.isExtraColumnsRequiredForRules(this.currentColumn))) {
            StyleInfo currentStyleInfo = ((BaseTableCell)((Object)cellRenderer)).getStyleInfo();
            TableModel tm = this.getModel();
            String currentCustomAttributes = ((BaseTableCell)((Object)cellRenderer)).getCustomAttributes();
            if (tm instanceof FormattedInterface) {
                if (com.sas.servlet.commands.jdbc.export.Util.isNumericMissingValue(this, dataCell.toString().trim())) {
                    dataCell = "";
                } else {
                    com.sas.servlet.commands.jdbc.export.Util.addExcelXMLDirective((BaseTableCell)((Object)cellRenderer), tm, rowNumber, colModelIndex, com.sas.servlet.commands.jdbc.export.Util.getDataLocale(this), currentCustomAttributes, dataCell.toString().trim(), this.isExportNumericCustomFormattedValuesAsText(colModelIndex));
                }
            } else {
                String formatDirective = SAStoExcelUtil.getMicrosoftOfficeNumberFormatXMLDirective((String)SAStoExcelUtil.EXCEL_TEXT_FORMAT);
                if (!"".equals(formatDirective)) {
                    com.sas.servlet.commands.jdbc.export.Util.addFormatDirective((BaseTableCell)((Object)cellRenderer), formatDirective);
                }
            }
            boolean encodeText = false;
            String text = null;
            this.toEncode = this.isValueToEncode(colModelIndex);
            if (ccr instanceof BaseLabel && this.toEncode) {
                encodeText = ((BaseLabel)((Object)ccr)).isEncodeText();
                ((BaseLabel)((Object)ccr)).setEncodeText(false);
                text = ((BaseLabel)((Object)ccr)).getText();
                ((BaseLabel)((Object)ccr)).setText(com.sas.servlet.commands.jdbc.export.Util.encodeForExcel(text));
            }
            this.writeCellRenderer(cellRenderer, out, dataCell, actions);
            ((BaseTableCell)((Object)cellRenderer)).setCustomAttributes(currentCustomAttributes);
            ((BaseTableCell)((Object)cellRenderer)).setStyleInfo(currentStyleInfo);
            if (ccr instanceof BaseLabel && this.toEncode) {
                ((BaseLabel)((Object)ccr)).setEncodeText(encodeText);
                if (text != null) {
                    ((BaseLabel)((Object)ccr)).setText(text);
                }
            }
            this.toEncode = true;
        } else {
            if (this.isExportToExcel()) {
                this.toEncode = this.isValueToEncode(colModelIndex);
            }
            this.writeCellRenderer(cellRenderer, out, dataCell, actions);
            if (this.isExportToExcel()) {
                this.toEncode = true;
            }
        }
        if (resetStyleInfo) {
            this.resetStyleOnRenderer(cellRenderer);
        }
        if (resetCRId) {
            ((BaseTableCell)((Object)cellRenderer)).setId(null);
        }
        if (resetCCRId) {
            ccr.setId(null);
        }
    }

    private boolean isValueToEncode(int colModelIndex) {
        String currentColumnUniqueModelIdentifier;
        boolean valueToEncode = true;
        if (this.columnsToNotEncode != null && (currentColumnUniqueModelIdentifier = this.getColumnUniqueModelId(colModelIndex)) != null) {
            for (int i = 0; i < this.columnsToNotEncode.length; ++i) {
                if (!currentColumnUniqueModelIdentifier.equals(this.columnsToNotEncode[i])) continue;
                valueToEncode = false;
                break;
            }
        }
        return valueToEncode;
    }

    private void writeCellRenderer(TableCellRenderer cellRenderer, PrintWriter out, Object dataCell, ActionList actions) throws IOException {
        StyleInfo saved = this.removeLastBorder(cellRenderer);
        if (cellRenderer instanceof ConditionTableCellRenderer) {
            if (!this.isExportToExcel()) {
                if (this.isExtraColumnsRequiredForRules(this.currentColumn)) {
                    ((ConditionTableCellRenderer)cellRenderer).writeWithExtraColumns(out, this, actions, null, dataCell);
                } else {
                    ((ConditionTableCellRenderer)cellRenderer).writeCenterComponent(out, this, actions, null, dataCell, false);
                }
            } else if (this.isExtraColumnsRequiredForRules(this.currentColumn)) {
                ((ConditionTableCellRenderer)cellRenderer).writeWithExtraColumnsForExcel(out, this, actions, null, dataCell);
            } else {
                ((ConditionTableCellRenderer)cellRenderer).writeCenterComponent(out, this, actions, null, dataCell, true);
            }
        } else if (this.getCellRenderer(1, this.currentColumn) instanceof ConditionTableCellRenderer) {
            if (this.isExtraColumnsRequiredForRules(this.currentColumn)) {
                if (this.isExportToExcel()) {
                    ConditionTableCellRenderer ctcr = (ConditionTableCellRenderer)this.getCellRenderer(1, this.currentColumn);
                    ctcr.setStyleInfo(((StyleInterface)((Object)cellRenderer)).getStyleInfo());
                    ctcr.writeWithExtraColumnsForExcel(out, this, actions, null, dataCell);
                } else {
                    ConditionTableCellRenderer.writeWithExtraColumns(out, this, actions, null, dataCell, cellRenderer, cellRenderer, 1, this.getRequest());
                }
            } else {
                this.render(cellRenderer, out, this, dataCell, null, actions);
            }
        } else {
            this.render(cellRenderer, out, this, dataCell, null, actions);
        }
        if (saved != MISSING_STYLEINFO) {
            ((StyleInterface)((Object)cellRenderer)).setStyleInfo(saved);
        }
    }

    private boolean isExtraColumnsRequiredForRules(int column) {
        List rulesForColumn = this.getRulesForColumn(column);
        Iterator rulesIterator = rulesForColumn.iterator();
        while (rulesIterator.hasNext()) {
            if (!RulesUtil.isMultiColumnRule((Rule)rulesIterator.next())) continue;
            return true;
        }
        return false;
    }

    private List getRulesForColumn(int columnIndex) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        Context context = this.getRulesContext();
        if (context == null) {
            return rules;
        }
        TableCellRenderer cellRenderer = this.getCellRenderer(1, columnIndex);
        if (!(cellRenderer instanceof ConditionTableCellRenderer)) {
            return rules;
        }
        ConditionTableCellRenderer renderer = (ConditionTableCellRenderer)cellRenderer;
        block0: for (Rule rule : context.getRules()) {
            TargetInterface[] targets = rule.getTargets();
            for (int i = 0; i < targets.length; ++i) {
                if (!this.compareIncludingBackupRenderers(renderer, targets[i])) continue;
                rules.add(rule);
                continue block0;
            }
        }
        return rules;
    }

    private boolean compareIncludingBackupRenderers(ConditionTableCellRenderer renderer, Object target) {
        while (renderer != null) {
            if (renderer == target) {
                return true;
            }
            TableCellRenderer backup = renderer.getBackupRenderer();
            if (backup instanceof ConditionTableCellRenderer) {
                renderer = (ConditionTableCellRenderer)backup;
                continue;
            }
            return false;
        }
        return false;
    }

    protected int getMultiColumnRuleCount() {
        int count = 0;
        int startIndex = this.getStartColumn();
        int endIndex = this.getEndColumn();
        for (int i = startIndex; i <= endIndex; ++i) {
            if (!this.isExtraColumnsRequiredForRules(i + 1)) continue;
            ++count;
        }
        return count;
    }

    private void handleExceptionHighlighting(int rowNumber) throws IOException {
        Context context = this.getRulesContext();
        if (context == null) {
            return;
        }
        try {
            DataVector data = this.getDataVector(rowNumber);
            RuleEngine.evaluateRules((ContextInterface)context, (DataVectorInterface)data);
        }
        catch (ChainedException e) {
            throw new IOException(e.getMessage());
        }
    }

    private StringBuffer generateId(int rowNumber, boolean isRowSelectionColumn, boolean isEditColumn) {
        StringBuffer rendererId = isEditColumn ? this.generateEditColumnId(rowNumber) : (isRowSelectionColumn ? this.generateRowSelectionId(rowNumber) : this.generateDataCellId(rowNumber, this.currentColumn));
        return rendererId;
    }

    @SASScope
    protected boolean rowExists(int row) {
        boolean rc = false;
        try {
            if (this.dataModel != null && row <= this.dataModel.getRowCount() || row > 0 && !this.isAccurateRowCountAvailable()) {
                rc = true;
            }
        }
        catch (Exception ex) {
            rc = false;
        }
        return rc;
    }

    @SASScope
    protected Object getCell(int row, int column, boolean returnUnFormattedData) throws IOException {
        if (returnUnFormattedData && this.dataModel instanceof FormattedInterface) {
            Object data = null;
            if (this.rowExists(row) && (data = ((FormattedInterface)this.dataModel).getUnformattedValueAt(row - 1, column - 1)) instanceof String) {
                data = ((String)data).trim();
            }
            return data;
        }
        return this.getCell(row, column);
    }

    @SASScope
    protected Object getCell(int row, int column) throws IOException {
        Object data = null;
        if (this.dataModel != null && this.rowExists(row) && (data = this.dataModel.getValueAt(row - 1, column - 1)) instanceof String) {
            data = ((String)data).trim();
        }
        return data;
    }

    @Override
    public void initialize() {
        this.initializeRowNumbers();
        this.initializeColumnNumbers();
    }

    public void initializeRowNumbers() {
        this.currentUpdateRow = -99;
        this.currentInsertRow = -99;
        this.currentRow = -1;
        this.startRow = -1;
        this.endRow = -1;
        if (this.dataModel != null) {
            this.rowCount = this.dataModel.getRowCount();
            int visibleRows = this.getRowPageSize();
            if (visibleRows == -1) {
                this.startRow = 0;
                if (this.rowCount > 0) {
                    this.endRow = this.rowCount - 1;
                }
            } else {
                this.startRow = 0;
                if (visibleRows < 1) {
                    visibleRows = 1;
                }
                this.endRow = visibleRows > this.rowCount && this.rowCount > -1 ? this.rowCount - 1 : visibleRows - 1;
            }
        }
    }

    public void initializeColumnNumbers() {
        this.startColumn = -1;
        this.endColumn = -1;
        this.currentColumn = -1;
        if (this.dataModel != null) {
            this.columnCount = this.getColumnCount();
            int visibleColumns = this.getColumnPageSize();
            if (visibleColumns == -1) {
                this.startColumn = 0;
                this.endColumn = this.columnCount - 1;
            } else {
                this.startColumn = 0;
                int heldCount = this.getColumnHeader().getHeldIndices(2).size() + this.getColumnHeader().getHeldIndices(4).size();
                if ((visibleColumns -= heldCount) < 1) {
                    visibleColumns = 1;
                }
                this.endColumn = visibleColumns > this.columnCount ? this.columnCount - 1 : visibleColumns - 1;
            }
        }
    }

    @Override
    public int getRowCount() {
        int count = -1;
        if (this.dataModel != null) {
            count = this.dataModel.getRowCount();
        }
        return count;
    }

    @Override
    public int getColumnCount() {
        int count = -1;
        if (this.columnModel != null) {
            count = this.columnModel.getColumnCount();
        }
        this.columnCount = count = count - this.getColumnHeader().getHeldIndices(2).size() - this.getColumnHeader().getHeldIndices(4).size();
        return this.columnCount;
    }

    @Override
    public boolean isGotoRowSupported() {
        return this.isPageForwardRowsSupported() || this.isPageBackwardRowsSupported();
    }

    @Override
    public boolean isGotoColumnSupported() {
        return this.isPageForwardColumnsSupported() || this.isPageBackwardColumnsSupported();
    }

    @Override
    public boolean isAccurateRowCountAvailable() {
        if (this.dataModel == null) {
            return true;
        }
        boolean accurate = false;
        if (this.dataModel instanceof AccurateRowCountInterface) {
            accurate = ((AccurateRowCountInterface)this.dataModel).isAccurateRowCountAvailable();
        } else if (this.dataModel.getRowCount() > 0) {
            accurate = true;
        } else if (this.dataModel instanceof DefaultTableModel) {
            accurate = true;
        }
        return accurate;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e != null && this.dataModel != null) {
            if (e.getFirstRow() == -1) {
                this.initialize();
                if (this.getAutoCreateColumnsFromModel()) {
                    this.createDefaultColumnsFromModel();
                }
            } else {
                switch (e.getType()) {
                    case -1: 
                    case 1: {
                        this.rowCount = this.dataModel.getRowCount();
                        int visibleRows = this.getRowPageSize();
                        if (visibleRows == -1) {
                            if (this.rowCount <= 0) break;
                            this.endRow = this.rowCount - 1;
                            break;
                        }
                        if (visibleRows < 1) {
                            visibleRows = 1;
                        }
                        if (this.isExportToExcel()) break;
                        if (visibleRows > this.rowCount && this.rowCount > -1) {
                            this.endRow = this.rowCount - 1;
                            break;
                        }
                        if (this.endRow >= this.rowCount && this.rowCount > -1) {
                            this.startRow = this.rowCount - visibleRows;
                            this.endRow = this.rowCount - 1;
                            break;
                        }
                        if (this.startRow + visibleRows - 1 >= this.rowCount) {
                            this.endRow = this.rowCount - 1;
                            break;
                        }
                        this.endRow = this.startRow + visibleRows - 1;
                        break;
                    }
                    case 0: {
                        int updatedRow = e.getFirstRow();
                        if (updatedRow == 0) {
                            if (this.currentInsertRow == -1) break;
                            this.initializeRowNumbers();
                            break;
                        }
                        if (updatedRow <= this.endRow || this.endRow - this.startRow >= this.getRowPageSize() - 1) break;
                        this.endRow = this.rowCount - 1;
                        break;
                    }
                    case 44: {
                        if (!(e instanceof SwingTableModelEvent) || !this.getAutoCreateColumnsFromModel()) break;
                        int oldColumn = ((SwingTableModelEvent)e).getColumn();
                        int newColumn = ((SwingTableModelEvent)e).getNewColumn();
                        TableColumnModel cm = this.getColumnModel();
                        cm.moveColumn(oldColumn, newColumn);
                        if (oldColumn > newColumn) {
                            for (int i = oldColumn; i >= newColumn; --i) {
                                cm.getColumn(i).setModelIndex(i);
                            }
                        } else {
                            if (oldColumn >= newColumn) break;
                            for (int i = newColumn; i >= oldColumn; --i) {
                                cm.getColumn(i).setModelIndex(i);
                            }
                        }
                        break;
                    }
                    case 17: {
                        if (!(e instanceof SwingTableModelEvent)) break;
                        SwingTableModelEvent stme = (SwingTableModelEvent)e;
                        int columnIndex = stme.getColumn();
                        String oldName = stme.getOldColumnName();
                        String newName = stme.getNewColumnName();
                        TableColumnModel cm = this.getColumnModel();
                        int count = cm.getColumnCount();
                        if (oldName == null && newName == null) {
                            for (int i = 0; i < count; ++i) {
                                TableColumn column = cm.getColumn(i);
                                if (column.getModelIndex() != columnIndex) continue;
                                column.setHeaderValue(this.getModel().getColumnName(columnIndex));
                            }
                        } else {
                            for (int i = 0; i < count; ++i) {
                                TableColumn column = cm.getColumn(i);
                                if (column.getModelIndex() != columnIndex || column.getHeaderValue() != oldName) continue;
                                column.setHeaderValue(newName);
                            }
                        }
                        break;
                    }
                }
            }
        }
    }

    private boolean isCellModifiable(int rowNumber, int columnNumber) {
        String name;
        HttpEditController controller;
        if (columnNumber != 0 && (controller = this.getEditController()) != null && controller.isEditEnabled() && this.dataModel.isCellEditable(rowNumber - 1, columnNumber - 1) && controller.isEditableColumn(name = TableViewUtil.getColumnName((TableModel)this.dataModel, (int)(columnNumber - 1)))) {
            ActionList actions;
            if (rowNumber == this.currentUpdateRow || rowNumber == this.currentInsertRow) {
                return true;
            }
            if (!controller.isSingleRowEditingEnabled() && (actions = this.getEditRowActions()) != null && !actions.isEmpty() && (actions.contains("COMMIT_DELETE_ACTION") || actions.contains("COMMIT_ACTION"))) {
                return true;
            }
        }
        return false;
    }

    @SASScope
    protected boolean isEditColumnVisible() {
        HttpEditController ec;
        boolean visible = false;
        if (this.isAllActionsVisible() && this.getEditController().isEditColumnVisible() && (ec = this.getEditController()).isEditEnabled()) {
            if (ec.isSingleRowEditingEnabled()) {
                int row = this.getCurrentRow();
                boolean headerRow = false;
                if (row == 0) {
                    row = this.getStartRow() + 1;
                    headerRow = true;
                    this.setCurrentRow(row);
                }
                ActionList actions = this.getEditColumnActions(row);
                if (headerRow) {
                    this.setCurrentRow(0);
                }
                if (actions != null && !actions.isEmpty()) {
                    visible = true;
                }
            } else {
                int temp = this.getCurrentRow();
                this.setCurrentRow(-22);
                ActionList actions = this.getEditRowActions();
                if (actions != null && !actions.isEmpty() && (actions.contains("COMMIT_DELETE_ACTION") || actions.contains("DELETE_ACTION"))) {
                    visible = true;
                }
                this.setCurrentRow(temp);
            }
        }
        return visible;
    }

    @SASScope
    protected boolean isEditRowVisible() {
        ActionList actions;
        boolean visible = false;
        if (this.isAllActionsVisible() && this.getEditController().isEditRowVisible() && this.getEditController().isEditEnabled() && (actions = this.getEditRowActions()) != null && !actions.isEmpty()) {
            visible = true;
        }
        return visible;
    }

    @Override
    public boolean isUpdateSupported() {
        boolean update = false;
        if (this.getEditController().isEditEnabled() && (this.dataModel instanceof UpdateRowInterface && ((UpdateRowInterface)this.dataModel).isRowUpdateAllowed() || this.dataModel instanceof DefaultTableModel) && this.getEditController().isSingleRowEditingEnabled() && this.currentRow <= this.endRow + 1 && this.currentRow != this.currentUpdateRow && this.currentRow != this.currentInsertRow) {
            update = this.currentInsertRow != -1 || this.currentRow != this.rowCount;
        }
        return update;
    }

    @Override
    public boolean isInsertSupported() {
        boolean insert = false;
        if (this.getEditController().isEditEnabled() && (this.dataModel instanceof InsertRowInterface && ((InsertRowInterface)this.dataModel).isRowInsertionAllowed() || this.dataModel instanceof DefaultTableModel)) {
            boolean isExtendOnly = false;
            if (this.dataModel instanceof InsertRowInterface) {
                isExtendOnly = ((InsertRowInterface)this.dataModel).isRowInsertionAllowed();
            }
            HttpEditController controller = this.getEditController();
            int mode = controller.getInsertMode();
            int insertMode = 1 & mode;
            int extendMode = 2 & mode;
            if (controller.isSingleRowEditingEnabled()) {
                if (insertMode == 1 && !isExtendOnly && this.currentRow != this.currentUpdateRow && this.currentRow != this.currentInsertRow && this.currentRow != -22 && this.currentRow <= this.endRow + 1) {
                    insert = this.currentInsertRow != -1 || this.currentRow != this.rowCount;
                } else if (extendMode == 2 && this.currentRow == -22) {
                    insert = true;
                }
            } else if (extendMode == 2 && this.currentRow == -22) {
                insert = true;
            }
        }
        return insert;
    }

    @Override
    public boolean isDeleteSupported() {
        boolean delete = false;
        if (this.getEditController().isEditEnabled() && (this.dataModel instanceof DeleteRowInterface && ((DeleteRowInterface)this.dataModel).isRowDeletionAllowed() || this.dataModel instanceof DefaultTableModel)) {
            if (this.getEditController().isSingleRowEditingEnabled()) {
                if (this.currentRow <= this.endRow + 1 && this.currentRow != this.currentUpdateRow && this.currentRow != this.currentInsertRow) {
                    delete = this.currentInsertRow != -1 || this.currentRow != this.rowCount;
                }
            } else if (this.currentRow <= this.endRow + 1) {
                delete = this.currentInsertRow != -1 || this.currentRow != this.rowCount;
            }
        }
        return delete;
    }

    @Override
    public boolean isCommitSupported() {
        boolean commit = false;
        if (this.getEditController().isEditEnabled() && (this.dataModel instanceof UpdateRowInterface && ((UpdateRowInterface)this.dataModel).isRowUpdateAllowed() || this.dataModel instanceof DefaultTableModel)) {
            if (this.getEditController().isSingleRowEditingEnabled()) {
                if (this.currentRow == this.currentUpdateRow || this.currentRow == this.currentInsertRow) {
                    commit = true;
                } else if (this.currentInsertRow == -1 && this.currentRow == this.rowCount) {
                    commit = true;
                }
            } else if (this.currentRow == -22) {
                commit = true;
            }
        }
        return commit;
    }

    @Override
    public boolean isCancelSupported() {
        boolean cancel = false;
        if (this.getEditController().isEditEnabled() && (this.dataModel instanceof UpdateRowInterface && ((UpdateRowInterface)this.dataModel).isRowUpdateAllowed() || this.dataModel instanceof DefaultTableModel)) {
            if (this.getEditController().isSingleRowEditingEnabled()) {
                if (this.currentRow == this.currentUpdateRow || this.currentRow == this.currentInsertRow) {
                    cancel = true;
                } else if (this.currentInsertRow == -1 && this.currentRow == this.rowCount) {
                    cancel = true;
                }
            } else if (this.currentRow == -22) {
                cancel = true;
            }
        }
        return cancel;
    }

    @Override
    @SASScope(value="ALL")
    @SubjectToChange
    public boolean isAutoCommit() {
        return true;
    }

    @Override
    @SASScope(value="ALL")
    @SubjectToChange
    public boolean isPromptOnDelete() {
        return false;
    }

    @Override
    public void delete(int row) {
        if (this.getEditController().isSingleRowEditingEnabled() && row != -22) {
            if (this.uncommittedValues != null) {
                this.commit();
            } else if ((this.currentInsertRow > 0 || this.currentInsertRow == -1) && row != this.currentInsertRow && this.dataModel instanceof InsertRowInterface) {
                ((InsertRowInterface)this.dataModel).commitUncommittedRow();
            }
            this.doDelete(row);
        } else if (!(this.getEditController().isSingleRowEditingEnabled() || row != -22 && row != -1 || this.rowsToDelete == null)) {
            Object[] rowsToDeleteArray = this.rowsToDelete.keySet().toArray();
            Arrays.sort(rowsToDeleteArray);
            for (int i = rowsToDeleteArray.length - 1; i >= 0; --i) {
                String name = (String)rowsToDeleteArray[i];
                if (!name.startsWith(this.getId())) continue;
                StringTokenizer cell = new StringTokenizer(name.substring(this.getId().length()), "_");
                String selectionString = cell.nextToken();
                try {
                    String value;
                    if (!selectionString.equals("SELECTION") || (value = (String)this.rowsToDelete.get(name)) == null) continue;
                    String rowNumberString = cell.nextToken();
                    Integer rowValue = Integer.valueOf(rowNumberString);
                    this.doDelete(rowValue);
                    continue;
                }
                catch (Exception e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        this.currentUpdateRow = -99;
        this.currentInsertRow = -99;
    }

    private void doDelete(int row) {
        if (this.dataModel instanceof DeleteRowInterface) {
            ((DeleteRowInterface)this.dataModel).deleteRow(row - 1);
        } else if (this.dataModel instanceof DefaultTableModel) {
            if (row == -1) {
                ((DefaultTableModel)this.dataModel).removeRow(this.rowCount - 1);
            } else {
                ((DefaultTableModel)this.dataModel).removeRow(row - 1);
            }
        }
    }

    @Override
    public void insert(int row) {
        if (this.uncommittedValues != null) {
            this.commit();
        } else if ((this.currentInsertRow > 0 || this.currentInsertRow == -1) && this.dataModel instanceof InsertRowInterface) {
            ((InsertRowInterface)this.dataModel).commitUncommittedRow();
        }
        if (this.dataModel instanceof InsertRowInterface && ((InsertRowInterface)this.dataModel).isRowInsertionAllowed()) {
            if (row == -1) {
                ((InsertRowInterface)this.dataModel).insertUncommittedRow(-1);
                this.currentInsertRow = row;
            } else {
                ((InsertRowInterface)this.dataModel).insertUncommittedRow(row - 1);
                this.currentInsertRow = ((InsertRowInterface)this.dataModel).getUncommittedRowNumber() + 1;
            }
        } else if (this.dataModel instanceof DefaultTableModel) {
            Object[] defaultValues = TableModelInsertRowSupport.getDefaultRowValues((TableModel)this.dataModel);
            if (row == -1) {
                ((DefaultTableModel)this.dataModel).addRow(defaultValues);
            } else {
                ((DefaultTableModel)this.dataModel).insertRow(row - 1, defaultValues);
            }
            this.currentInsertRow = row;
        }
        this.currentUpdateRow = -99;
    }

    @Override
    public void cancel() {
        if (this.currentInsertRow > 0 || this.currentInsertRow == -1) {
            if (this.dataModel instanceof InsertRowInterface && ((InsertRowInterface)this.dataModel).isRowInsertionAllowed()) {
                ((InsertRowInterface)this.dataModel).cancelUncommittedRow();
            } else if (this.dataModel instanceof DefaultTableModel) {
                this.delete(this.currentInsertRow);
            }
        }
        this.currentUpdateRow = -99;
        this.currentInsertRow = -99;
    }

    @Override
    public void commit() {
        if (this.uncommittedValues != null) {
            for (String name : this.uncommittedValues.keySet()) {
                if (!name.startsWith(this.getId())) continue;
                StringTokenizer cell = new StringTokenizer(name.substring(this.getId().length()), "_");
                String rowString = cell.nextToken();
                String columnString = cell.nextToken();
                String value = (String)this.uncommittedValues.get(name);
                try {
                    Integer rowValue = Integer.valueOf(rowString);
                    Integer columnValue = Integer.valueOf(columnString);
                    int row = rowValue;
                    int col = columnValue;
                    Object transformedValue = this.transformCommitString(value, col, row);
                    this.dataModel.setValueAt(transformedValue, row, col);
                }
                catch (Exception e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                }
            }
            if (this.dataModel instanceof InsertRowInterface && (this.currentInsertRow > 0 || this.currentInsertRow == -1)) {
                ((InsertRowInterface)this.dataModel).commitUncommittedRow();
            }
        } else if (this.dataModel instanceof InsertRowInterface && (this.currentInsertRow > 0 || this.currentInsertRow == -1)) {
            ((InsertRowInterface)this.dataModel).commitUncommittedRow();
        }
        this.currentUpdateRow = -99;
        this.currentInsertRow = -99;
    }

    @SASScope
    public Object transformCommitString(String value, int col, int row) throws TransformException {
        Class columnClass = this.getModel() instanceof FormattedInterface ? ((FormattedInterface)this.getModel()).getUnformattedColumnClass(col) : this.getModel().getColumnClass(col);
        TransformInterface editTransform = BaseTransforms.defaultInstance.lookupTransform(String.class, columnClass);
        if (editTransform instanceof StringToDoubleTransform) {
            editTransform = new StringToDoubleTransform(this.getLocale());
        } else if (editTransform instanceof StringToFloatTransform) {
            editTransform = new StringToFloatTransform(this.getLocale());
        } else if (editTransform instanceof StringToSQLDateTransform) {
            editTransform = new StringToSQLDateTransform(this.getLocale());
        } else if (editTransform instanceof StringToSQLTimeTransform) {
            editTransform = new StringToSQLTimeTransform(this.getLocale());
        } else if (editTransform instanceof StringToSQLTimestampTransform) {
            editTransform = new StringToSQLTimestampTransform(this.getLocale());
        } else if (editTransform instanceof StringToDateTransform) {
            editTransform = new StringToDateTransform(this.getLocale());
        }
        Constructor transformedValue = null;
        if (editTransform != null) {
            transformedValue = editTransform.transform((Object)value);
        } else {
            try {
                transformedValue = columnClass.getConstructor(String.class);
            }
            catch (Exception e) {
                transformedValue = value;
            }
        }
        return transformedValue;
    }

    @Override
    public void update(int row) {
        if (this.uncommittedValues != null) {
            this.commit();
        } else if ((this.currentInsertRow > 0 || this.currentInsertRow == -1) && row != this.currentInsertRow && this.dataModel instanceof InsertRowInterface) {
            ((InsertRowInterface)this.dataModel).commitUncommittedRow();
        }
        this.currentUpdateRow = row;
        this.currentInsertRow = -99;
    }

    @Override
    public void setUncommittedValues(Map values) {
        this.uncommittedValues = values;
    }

    public Map getUncommittedValues() {
        return this.uncommittedValues;
    }

    @Override
    public void setRowsToDelete(Map rows) {
        this.rowsToDelete = rows;
    }

    public Map getRowsToDelete() {
        return this.rowsToDelete;
    }

    @SASScope
    public void setSortedColumns(List sortColumns, List sortDirections) {
        TableModel model = this.getModel();
        if (model != null && model instanceof SortableInterface) {
            String[] columnNames = new String[sortColumns.size()];
            int[] dirs = new int[sortDirections.size()];
            for (int i = 0; i < sortColumns.size(); ++i) {
                int index = (Integer)sortColumns.get(i);
                columnNames[i] = model.getColumnName(index);
                dirs[i] = (Integer)sortDirections.get(i);
            }
            try {
                ((SortableInterface)model).sort(columnNames, dirs);
            }
            catch (SortException se) {
                throw new IllegalStateException(se.getMessage());
            }
        }
    }

    public TableColumn getColumn(Object identifier) {
        TableColumnModel cm = this.getColumnModel();
        int columnIndex = cm.getColumnIndex(identifier);
        return cm.getColumn(columnIndex);
    }

    public void addColumn(TableColumn column) {
        int modelColumn;
        if (this.dataModel == null) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "nullDataModelWhileAddingColumn.txt", this.getLocale()));
        }
        if (column.getHeaderValue() == null && (modelColumn = column.getModelIndex()) != -1) {
            column.setHeaderValue(this.dataModel.getColumnName(modelColumn));
        }
        this.getColumnModel().addColumn(column);
    }

    public void removeColumn(TableColumn column) {
        this.getColumnModel().removeColumn(column);
    }

    public void moveColumn(int column, int targetColumn) {
        this.getColumnModel().moveColumn(column - 1, targetColumn - 1);
    }

    @Override
    public void columnAdded(TableColumnModelEvent event) {
        this.initializeColumnNumbers();
    }

    @Override
    public void columnRemoved(TableColumnModelEvent event) {
        this.initializeColumnNumbers();
    }

    @Override
    public void columnMoved(TableColumnModelEvent event) {
        TableViewUtil.updateValuesOnMap((Map)this.cellRenderers, (int)-89, (int)(event.getFromIndex() + 1), (int)(event.getToIndex() + 1));
        TableViewUtil.updateValuesOnMap((Map)this.cellEditors, (int)-89, (int)(event.getFromIndex() + 1), (int)(event.getToIndex() + 1));
    }

    public TableColumn getRowSelectionColumn() {
        if (this.rowSelectionColumn == null) {
            this.rowSelectionColumn = this.getDefaultRowSelectionColumn();
        }
        return this.rowSelectionColumn;
    }

    public void setRowSelectionColumn(TableColumn column) {
        this.rowSelectionColumn = column;
    }

    public abstract TableColumn getDefaultRowSelectionColumn();

    @SASScope
    public int getRowSelectionMode() {
        return this.rowSelectionMode;
    }

    @SASScope
    public void setRowSelectionMode(int mode) {
        switch (mode) {
            case 31: 
            case 32: 
            case 99: {
                this.rowSelectionMode = mode;
                break;
            }
            default: {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidRowSelectionMode.txt", this.getLocale()));
            }
        }
    }

    public TableColumn getEditColumn() {
        if (this.editColumn == null) {
            this.editColumn = this.getDefaultEditColumn();
        }
        return this.editColumn;
    }

    public void setEditColumn(TableColumn column) {
        this.editColumn = column;
    }

    public abstract TableColumn getDefaultEditColumn();

    @SASScope
    protected void setStyleOnRenderer(Object renderer, String styleKey, String prefix) {
        if (this instanceof TableView) {
            StyleInfo si;
            if (renderer instanceof StyleInterface && ((StyleInterface)renderer).getStyleInfo() == null && (si = (StyleInfo)this.getStyleMap().get(styleKey)) != null) {
                ((StyleInterface)renderer).setStyleInfo(si);
            }
            if (prefix != null) {
                if (renderer instanceof BaseTableCell) {
                    ((BaseTableCell)renderer).setStyleClassPrefix(prefix);
                } else if (renderer instanceof DefaultTableRowRenderer) {
                    ((DefaultTableRowRenderer)renderer).setStyleClassPrefix(prefix);
                }
            }
        }
    }

    private boolean initStyleOnRenderer(TableRowRenderer renderer, String styleKey) {
        boolean reset = this.initStyleOnObject(renderer, styleKey);
        renderer.setLocale(this.getLocale());
        return reset;
    }

    private boolean initStyleOnRenderer(TableCellRenderer renderer, String styleKey) {
        ConditionTableCellRenderer ctcr;
        if (renderer instanceof ConditionTableCellRenderer && (ctcr = (ConditionTableCellRenderer)renderer).isDeepestBackupJustForStyle()) {
            return false;
        }
        boolean reset = this.initStyleOnObject(renderer, styleKey);
        renderer.setLocale(this.getLocale());
        return reset;
    }

    private boolean initStyleOnRenderer(TableCellEditor renderer, String styleKey) {
        boolean reset = this.initStyleOnObject(renderer, styleKey);
        renderer.setLocale(this.getLocale());
        return reset;
    }

    private boolean initStyleOnObject(Object renderer, String styleKey) {
        boolean reset = false;
        if (renderer instanceof StyleInterface && ((StyleInterface)renderer).getStyleInfo() == null) {
            reset = true;
        }
        this.setStyleOnRenderer(renderer, styleKey, this.getStyleClassPrefix());
        return reset;
    }

    private StyleInfo removeLastBorder(TableCellRenderer renderer) {
        int row = this.currentRow - 1;
        if (this.isLockColumnHeaders()) {
            row = -1;
        }
        int col = this.currentColumn - 1 - this.columnIterator.heldLeft - this.columnIterator.heldRight;
        return this.removeLastBorder(renderer, col, row, MISSING_STYLEINFO);
    }

    @SASScope
    protected void resetStyleOnRenderer(Object renderer) {
        if (this instanceof TableView && renderer instanceof StyleInterface) {
            ((StyleInterface)renderer).setStyleInfo(null);
        }
    }

    @Override
    public void setLocale(Locale loc) {
        super.setLocale(loc);
        this.getColumnModel().setLocale(loc);
        this.getRowModel().setLocale(loc);
        this.getColumnHeader().setLocale(loc);
        this.getRowHeader().setLocale(loc);
        this.getDefaultColumnHeaderRowRenderer().setLocale(loc);
        this.getDefaultRowRenderer().setLocale(loc);
        this.getDefaultRenderer().setLocale(loc);
        this.getDefaultEditor().setLocale(loc);
    }

    @Override
    public void lastRow() {
        if (!this.isLastRowSupported()) {
            throw new UnsupportedOperationException(RB.getStringResource(RB_KEY, "operationNotSupported.txt", this.getLocale()) + " lastRow()");
        }
        if (this.rowCount != -1) {
            if (!this.isAccurateRowCountAvailable() && this.dataModel instanceof TrueRowCountCalculatedInterface) {
                ((TrueRowCountCalculatedInterface)this.dataModel).setTrueRowCountCalculated(true);
                this.rowCount = this.getRowCount();
            }
            super.lastRow();
        }
    }

    @Override
    public void gotoRow(int row) {
        if (!this.isGotoRowSupported()) {
            throw new UnsupportedOperationException(RB.getStringResource(RB_KEY, "operationNotSupported.txt", this.getLocale()) + " gotoRow()");
        }
        if (row <= 0) {
            row = 1;
        } else if (row > this.rowCount) {
            if (this.isAccurateRowCountAvailable()) {
                row = this.rowCount;
            } else {
                try {
                    this.dataModel.getValueAt(row - 1, 0);
                }
                catch (Exception e) {
                    if (this.dataModel instanceof TrueRowCountCalculatedInterface) {
                        ((TrueRowCountCalculatedInterface)this.dataModel).setTrueRowCountCalculated(true);
                        row = this.getRowCount();
                    }
                    row = this.rowCount;
                }
            }
        }
        this.startRow = row - 1;
        this.endRow = this.startRow + this.rowPageSize > this.rowCount ? this.rowCount - 1 : this.startRow + this.rowPageSize - 1;
    }

    private boolean isNumericData(int column) {
        if (column < 0) {
            return false;
        }
        if (this.getModel() instanceof ColumnAlignmentInterface) {
            return ((ColumnAlignmentInterface)this.getModel()).getColumnAlignment(column) == 4;
        }
        Class colClass = this.getModel() instanceof FormattedInterface ? ((FormattedInterface)this.getModel()).getUnformattedColumnClass(column) : this.getModel().getColumnClass(column);
        return Number.class.isAssignableFrom(colClass) || Date.class.isAssignableFrom(colClass);
    }

    public boolean isColumnMoveAllowed(int columnIndex, int newIndex) {
        return BaseTableView.isColumnMoveAllowed(columnIndex - 1, newIndex - 1, this.getColumnHeader(), this.getColumnModel().getColumnCount());
    }

    private static boolean isColumnMoveAllowed(int columnIndex, int newIndex, HoldInterface ch, int cc) {
        int leadingHeld = 0;
        int trailingHeld = 0;
        if (ch != null) {
            leadingHeld = ch.getHeldIndices(10).size();
            trailingHeld = ch.getHeldIndices(11).size();
        }
        return columnIndex >= leadingHeld && columnIndex <= cc - 1 - trailingHeld && newIndex >= leadingHeld && newIndex <= cc - 1 - trailingHeld;
    }

    private boolean isMoveOnModel() {
        if (this.moveOnModel == null) {
            if (this.dataModel instanceof MoveColumnInterface) {
                int dataModelCount;
                TableColumnModel cm = this.getColumnModel();
                int columnModelCount = cm.getColumnCount();
                if (columnModelCount == (dataModelCount = this.getModel().getColumnCount())) {
                    for (int i = 0; i < columnModelCount; ++i) {
                        if (cm.getColumn(i).getModelIndex() == i) continue;
                        this.moveOnModel = Boolean.FALSE;
                        break;
                    }
                    if (this.moveOnModel == null) {
                        this.moveOnModel = Boolean.TRUE;
                    }
                } else {
                    this.moveOnModel = Boolean.FALSE;
                }
            } else {
                this.moveOnModel = Boolean.FALSE;
            }
        }
        return this.moveOnModel;
    }

    private TableViewActionSupportFilter getFilter(int type) {
        if (type == 1) {
            this.columnHeaderFilter = this.getFilter(this.columnHeaderFilter, "COLUMN_HEADER_AREA");
            return this.columnHeaderFilter;
        }
        if (type == 2) {
            this.editColumnFilter = this.getFilter(this.editColumnFilter, "EDIT_COLUMN_AREA");
            return this.editColumnFilter;
        }
        if (type == 4) {
            this.editRowFilter = this.getFilter(this.editRowFilter, "EDIT_ROW_AREA");
            return this.editRowFilter;
        }
        if (type == 3) {
            this.dataCellFilter = this.getFilter(this.dataCellFilter, "DATA_CELL_AREA");
            return this.dataCellFilter;
        }
        return null;
    }

    private TableViewActionSupportFilter getFilter(TableViewActionSupportFilter filter, String area) {
        if (filter == null) {
            filter = new TableViewActionSupportFilter(this.getActionSupportType(), area, this);
            filter.setHiddenActionsMap(this.getViewerSupport().getHiddenActionsMap());
            filter.setPoolingOn(true);
            filter.setSwing(false);
        }
        try {
            filter.setAttribute("editEnabled", this.getEditController().isEditEnabled() ? Boolean.TRUE : Boolean.FALSE);
        }
        catch (AttributeSetException attributeSetException) {
            // empty catch block
        }
        return filter;
    }

    private int getHeldCount() {
        int heldCount = this.getColumnHeader().getHeldIndices(2).size() + this.getColumnHeader().getHeldIndices(4).size();
        return heldCount;
    }

    @Override
    public int getColumnScrollSize() {
        return this.columnPageSize - this.getHeldCount();
    }

    private DataVector getDataVector(int row) {
        TableModel tableModel = this.getModel();
        DataVector dataVector = new DataVector();
        if (tableModel == null) {
            return dataVector;
        }
        BusinessQueryToTableModelAdapter bqAdapter = null;
        if (tableModel instanceof BusinessQueryToTableModelAdapter) {
            bqAdapter = (BusinessQueryToTableModelAdapter)tableModel;
        }
        int count = tableModel.getColumnCount();
        for (int i = 0; i < count; ++i) {
            String name = tableModel.getColumnName(i);
            if (bqAdapter != null) {
                try {
                    name = (String)bqAdapter.getColumnInfo(i + 1, "NAME");
                }
                catch (TableException e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                }
            }
            RulesUtil.setValueOnDataVector(dataVector, name, tableModel, row, i, this.getLocale());
        }
        return dataVector;
    }

    public boolean isCellIdsGenerated() {
        return this.cellIdsGenerated;
    }

    public void setCellIdsGenerated(boolean cellIdsGenerated) {
        this.cellIdsGenerated = cellIdsGenerated;
    }

    private int getSortStatus(int columnModelIndex) {
        if (this.sortedColumns == null || this.sortedColumns.length < 1) {
            return 2;
        }
        String columnName = TableViewUtil.getColumnName((TableModel)this.dataModel, (int)columnModelIndex);
        for (int i = 0; i < this.sortedColumns.length; ++i) {
            if (!this.sortedColumns[i].equals(columnName)) continue;
            return this.sortDirections[i];
        }
        return 2;
    }

    private StringBuffer generateCornerHeaderId() {
        StringBuffer sb = this.getSmallBuffer().append(this.getId());
        sb.append("_c");
        sb.append("_rh");
        return sb;
    }

    private StringBuffer generateEditColumnHeaderId() {
        StringBuffer sb = this.getSmallBuffer().append(this.getId());
        sb.append("_c");
        sb.append("_ec");
        return sb;
    }

    private StringBuffer generateColumnHeaderId(int colNum) {
        StringBuffer sb = this.getSmallBuffer().append(this.getId());
        sb.append("_c");
        sb.append(ActionUtil.getStringFromIndex((int)colNum));
        return sb;
    }

    private StringBuffer generateRowHeaderId(int rowNum) {
        StringBuffer sb = this.getSmallBuffer().append(this.getId());
        sb.append("_rh");
        sb.append(ActionUtil.getStringFromIndex((int)rowNum));
        return sb;
    }

    private StringBuffer generateDataCellId(int rowNum, int colNum) {
        StringBuffer sb = this.getSmallBuffer().append(this.getId());
        sb.append("_r");
        sb.append(ActionUtil.getStringFromIndex((int)rowNum));
        sb.append("_c");
        sb.append(ActionUtil.getStringFromIndex((int)colNum));
        return sb;
    }

    private StringBuffer generateEditCellId(int rowNum, int colNum) {
        StringBuffer sb = this.getSmallBuffer().append(this.getId());
        sb.append("_");
        sb.append(ActionUtil.getStringFromIndex((int)rowNum));
        sb.append("_");
        sb.append(ActionUtil.getStringFromIndex((int)colNum));
        return sb;
    }

    private StringBuffer generateEditColumnId(int rowNum) {
        StringBuffer sb = this.getSmallBuffer().append(this.getId());
        sb.append("_ec");
        sb.append(ActionUtil.getStringFromIndex((int)rowNum));
        return sb;
    }

    private StringBuffer generateEditRowId() {
        StringBuffer sb = this.getSmallBuffer().append(this.getId());
        sb.append("_er");
        return sb;
    }

    private StringBuffer generateRowSelectionId(int rowNum) {
        StringBuffer sb = this.getSmallBuffer().append(this.getId());
        sb.append("_rs");
        sb.append(ActionUtil.getStringFromIndex((int)rowNum));
        return sb;
    }

    private StringBuffer getSmallBuffer() {
        if (this.smallTempBuffer == null) {
            this.smallTempBuffer = new StringBuffer(32);
        }
        this.smallTempBuffer.setLength(0);
        return this.smallTempBuffer;
    }

    private TableColumn getColumnForUniqueID(Collection columns, Object uniqueID) {
        for (TableColumn currentColumn : columns) {
            Object columnUniqueID = currentColumn.getUniqueModelIdentifier();
            if (columnUniqueID == null || uniqueID == null || !columnUniqueID.equals(uniqueID)) continue;
            return currentColumn;
        }
        return null;
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        if (this.isLockColumnHeaders() && this.isColumnHeaderVisible()) {
            if (this.lockColumnHeadersFeature == null) {
                this.lockColumnHeadersFeature = new TableViewLockColumnHeadersFeature();
                this.getFeatures().add(this.lockColumnHeadersFeature);
            }
            this.lockColumnHeadersFeature.setTable(this);
            if (this.styleInfo == null) {
                this.styleInfo = new StyleInfo();
            }
            this.styleInfo.setClassid("mainTableComponentContainer tableLockedHeaderDiv");
        } else if (this.styleInfo != null) {
            this.styleInfo.setClassid(null);
        }
        if (this.isExportToExcel()) {
            DataItem[] dataItems = com.sas.servlet.commands.jdbc.export.Util.getDataItemsInTableModel(this.getModel());
            this.columnsToExportAsTextIfCustomFormatted = this.getColumnsToExportAsTextIfCustomFormatted(dataItems);
            TableColumnModel cModel = this.getColumnModel();
            if (cModel != null) {
                String[] columnUniqueModelIdentifiers = com.sas.servlet.commands.jdbc.export.Util.getColumnUniqueModelIdentifiers(cModel.getColumns());
                this.columnsToNotEncode = com.sas.servlet.commands.jdbc.export.Util.getColumnsToNotEncode(dataItems, columnUniqueModelIdentifiers);
            }
        }
        super.write(out);
    }

    @Override
    protected void writeContent(PrintWriter out) throws IOException {
        if (this.dataModel == null || this.getRowCount() == 0) {
            this.writeEmptyTable(out);
            this.writeFeatures(this.getRequest(), out);
            this.resetEditColumnActions();
        } else {
            if (this.dataModel instanceof SortableInterface) {
                this.sortedColumns = ((SortableInterface)this.dataModel).getSortedColumns();
                this.sortDirections = ((SortableInterface)this.dataModel).getSortedDirections();
            }
            if (this.getRulesContext() != null) {
                RulesUtil.validateRules(this);
            }
            this.currentRow = this.startRow;
            super.writeContent(out);
        }
    }

    public boolean isExportNumericCustomFormattedValuesAsText(int colModelIndex) {
        String currentColumnUniqueModelIdentifier;
        boolean exportNumericCustomFormattedValuesAsText = false;
        if (this.columnsToExportAsTextIfCustomFormatted != null && (currentColumnUniqueModelIdentifier = this.getColumnUniqueModelId(colModelIndex)) != null) {
            for (int i = 0; i < this.columnsToExportAsTextIfCustomFormatted.length; ++i) {
                if (!currentColumnUniqueModelIdentifier.equals(this.columnsToExportAsTextIfCustomFormatted[i])) continue;
                exportNumericCustomFormattedValuesAsText = true;
                break;
            }
        }
        return exportNumericCustomFormattedValuesAsText;
    }

    protected String getColumnUniqueModelId(int colModelIndex) {
        Object uniqueModelIdentifier;
        TableColumn column;
        String currentColumnUniqueModelIdentifier = null;
        if (colModelIndex > 0 && (column = BaseTableViewHelper.getColumnForTableModelColumnIndex(this.getColumnModel(), colModelIndex)) != null && (uniqueModelIdentifier = column.getUniqueModelIdentifier()) != null) {
            currentColumnUniqueModelIdentifier = uniqueModelIdentifier.toString();
        }
        return currentColumnUniqueModelIdentifier;
    }

    protected String[] getColumnsToExportAsTextIfCustomFormatted(DataItem[] dataItems) {
        String[] columnsToExportAsTextIfCustomFormatted = null;
        if (dataItems != null && dataItems.length > 0) {
            Enumeration columns = null;
            TableColumnModel cModel = this.getColumnModel();
            if (cModel != null) {
                columns = cModel.getColumns();
            }
            columnsToExportAsTextIfCustomFormatted = com.sas.servlet.commands.jdbc.export.Util.getColumnsToExportAsTextIfCustomFormatted(com.sas.servlet.commands.jdbc.export.Util.getColumnUniqueModelIdentifiers(columns), dataItems);
        }
        return columnsToExportAsTextIfCustomFormatted;
    }

    @Override
    public boolean isCurrentValueToEncode() {
        return this.toEncode;
    }

    @SASScope
    private class ColumnIterator {
        int heldLeft = 0;
        int heldRight = 0;
        int state = 0;
        int curIndex = 0;
        int colIndex = 0;
        int scrollSize = 0;

        void init() {
            this.state = 0;
            this.scrollSize = BaseTableView.this.endColumn - BaseTableView.this.startColumn + 1;
            this.heldLeft = BaseTableView.this.getColumnHeader().getHeldIndices(10).size();
            this.heldRight = BaseTableView.this.getColumnHeader().getHeldIndices(11).size();
            this.curIndex = 0;
            this.colIndex = 0;
        }

        int next() {
            if (this.state == 0) {
                if (this.curIndex++ < this.heldLeft) {
                    return this.curIndex;
                }
                this.state = 1;
                this.curIndex = 0;
                this.colIndex = this.heldLeft + BaseTableView.this.startColumn + 1;
            }
            if (this.state == 1) {
                if (this.curIndex++ < this.scrollSize) {
                    return this.colIndex++;
                }
                this.state = 2;
                this.curIndex = 0;
                this.colIndex = BaseTableView.this.getColumnModel().getColumnCount() - this.heldRight + 1;
            }
            if (this.state == 2) {
                if (this.curIndex++ < this.heldRight) {
                    return this.colIndex++;
                }
                this.state = 3;
                this.curIndex = 0;
            }
            return -1;
        }
    }
}

