/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.tableview;

import com.sas.actionprovider.ActionList;
import com.sas.codepolicy.SASScope;
import com.sas.rpf.Context;
import com.sas.servlet.tbeans.BaseActionTransformation2;
import com.sas.servlet.tbeans.ComplexStyleInterface;
import com.sas.servlet.tbeans.HttpConstants;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.StyleInterface;
import com.sas.servlet.tbeans.StyleMap;
import com.sas.servlet.tbeans.features.Feature;
import com.sas.servlet.tbeans.features.FeatureList;
import com.sas.servlet.tbeans.features.FeatureListInterface;
import com.sas.servlet.tbeans.form.html.FormViewInterface;
import com.sas.servlet.tbeans.navigationbar.ColumnNavigationInterface;
import com.sas.servlet.tbeans.navigationbar.RowNavigationInterface;
import com.sas.servlet.tbeans.olaptableview.html.OLAPTableView;
import com.sas.servlet.tbeans.tableview.RB;
import com.sas.servlet.tbeans.tableview.TableCellEditor;
import com.sas.servlet.tbeans.tableview.TableCellRenderer;
import com.sas.servlet.tbeans.tableview.html.BaseTableCell;
import com.sas.servlet.util.BaseUtil;
import com.sas.servlet.util.ComponentSessionManager;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.swing.util.Action;
import com.sas.util.ConditionEvaluationInterface;
import com.sas.util.MapWithDefaults;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@SASScope(value="ALL")
public abstract class AbstractBaseTableView
extends BaseActionTransformation2
implements RowNavigationInterface,
ColumnNavigationInterface,
HttpConstants,
ComplexStyleInterface,
FeatureListInterface {
    static final long serialVersionUID = 6100599749255159868L;
    @SASScope
    public static final String RB_KEY = "AbstractBaseTableView.";
    @SASScope
    protected int startRow = -1;
    @SASScope
    protected int endRow = -1;
    @SASScope
    protected int rowCount;
    @SASScope
    protected int rowPageSize = -1;
    @SASScope
    protected int startColumn = -1;
    @SASScope
    protected int endColumn = -1;
    @SASScope
    protected int columnCount;
    @SASScope
    protected int columnPageSize = -1;
    private boolean columnHeaderVisible = true;
    private boolean rowHeaderVisible = true;
    private int borderWidth = 0;
    private int cellSpacing = 0;
    private int cellPadding = 3;
    private int width;
    private int widthPercentage;
    private int horizontalAlignment = 99;
    private String summary;
    private String caption;
    private String styleClassPrefix;
    private boolean allActionsVisible = true;
    private boolean exportToExcel;
    private ConditionEvaluationInterface conditionEvaluator;
    private Context rulesContext;
    private boolean columnsResizable = false;
    private int textWrapping = 0;
    private String title;
    private String footer;
    private TableCellRenderer titleRenderer;
    private TableCellRenderer footerRenderer;
    private FeatureList features = new FeatureList();
    public static final int WRAP_NONE = 0;
    public static final int WRAP_ALL = -1;
    public static final int WRAP_PER_COLUMN = 1;
    public static boolean DEFAULT_EXPORT_NUMERIC_CUSTOM_FORMATED_VALUES_AS_TEXT = false;
    @SASScope
    protected MapWithDefaults styleMap = new StyleMap();
    protected static final StyleInfo MISSING_STYLEINFO = new ImmutableStyleInfo();
    TableCellRenderer currentRenderer;

    public abstract void initialize();

    public void writeTableHeader(Writer out) throws IOException {
        PrintWriter o = new PrintWriter(out);
        this.writeTableHeader(o);
        o.flush();
    }

    public void writeTableHeader(OutputStream out) throws IOException {
        PrintWriter o = new PrintWriter(out);
        this.writeTableHeader(o);
        o.flush();
    }

    public abstract void writeTableHeader(PrintWriter var1) throws IOException;

    public void writeColumnHeader(Writer out) throws IOException {
        PrintWriter o = new PrintWriter(out);
        this.writeColumnHeader(o);
        o.flush();
    }

    public void writeColumnHeader(OutputStream out) throws IOException {
        PrintWriter o = new PrintWriter(out);
        this.writeColumnHeader(o);
        o.flush();
    }

    public abstract void writeColumnHeader(PrintWriter var1) throws IOException;

    protected void writeRows(Writer out) throws IOException {
        this.writeRows(new PrintWriter(out));
    }

    protected void writeRows(OutputStream out) throws IOException {
        this.writeRows(new PrintWriter(out));
    }

    protected abstract void writeRows(PrintWriter var1) throws IOException;

    public void writeTableFooter(Writer out) throws IOException {
        PrintWriter o = new PrintWriter(out);
        this.writeTableFooter(o);
        o.flush();
    }

    public void writeTableFooter(OutputStream out) throws IOException {
        PrintWriter o = new PrintWriter(out);
        this.writeTableFooter(o);
        o.flush();
    }

    public abstract void writeTableFooter(PrintWriter var1) throws IOException;

    public void writeEmptyTable(Writer out) throws IOException {
        PrintWriter o = new PrintWriter(out);
        this.writeEmptyTable(o);
        o.flush();
    }

    public void writeEmptyTable(OutputStream out) throws IOException {
        PrintWriter o = new PrintWriter(out);
        this.writeEmptyTable(o);
        o.flush();
    }

    public abstract void writeEmptyTable(PrintWriter var1) throws IOException;

    @Override
    public Map getStyleMap() {
        return this.styleMap;
    }

    private boolean notAllRowsVisible() {
        return this.rowPageSize != -1 && this.rowCount > this.rowPageSize || this.startRow > 0 && this.rowCount <= this.rowPageSize;
    }

    private boolean _baseRowBackwardSupported() {
        return (this.notAllRowsVisible() || !this.isAccurateRowCountAvailable()) && this.startRow > 0;
    }

    private boolean _baseRowForwardSupported() {
        return this.notAllRowsVisible() && this.endRow + 1 < this.rowCount || !this.isAccurateRowCountAvailable();
    }

    @Override
    public boolean isFirstRowSupported() {
        return this._baseRowBackwardSupported();
    }

    @Override
    public boolean isPageBackwardRowsSupported() {
        return this._baseRowBackwardSupported();
    }

    @Override
    public boolean isPreviousRowSupported() {
        return this._baseRowBackwardSupported();
    }

    @Override
    public boolean isNextRowSupported() {
        return this._baseRowForwardSupported();
    }

    @Override
    public boolean isPageForwardRowsSupported() {
        return this._baseRowForwardSupported();
    }

    @Override
    public boolean isLastRowSupported() {
        return this._baseRowForwardSupported();
    }

    @Override
    public boolean isGotoRowSupported() {
        return false;
    }

    @Override
    public void firstRow() {
        if (!this.isFirstRowSupported()) {
            throw new UnsupportedOperationException(RB.getStringResource(RB_KEY, "operationNotSupported.txt", this.getLocale()) + " firstRow()");
        }
        if (this.startRow != 0) {
            this.setStartRow(0);
            if (this.rowPageSize < this.rowCount) {
                this.setEndRow(this.rowPageSize - 1);
            } else {
                this.setEndRow(this.rowCount - 1);
            }
        }
    }

    @Override
    public void pageBackwardRows() {
        if (!this.isPageBackwardRowsSupported()) {
            throw new UnsupportedOperationException(RB.getStringResource(RB_KEY, "operationNotSupported.txt", this.getLocale()) + " pageBackwardRows()");
        }
        if (this.startRow != 0) {
            if (this.startRow - this.rowPageSize > 0) {
                this.setStartRow(this.startRow - this.rowPageSize);
            } else {
                this.setStartRow(0);
            }
            if (this.startRow + this.rowPageSize - 1 < this.rowCount) {
                this.setEndRow(this.startRow + this.rowPageSize - 1);
            } else {
                this.setEndRow(this.rowCount - 1);
            }
        }
    }

    @Override
    public void previousRow() {
        if (!this.isPreviousRowSupported()) {
            throw new UnsupportedOperationException(RB.getStringResource(RB_KEY, "operationNotSupported.txt", this.getLocale()) + " previousRow()");
        }
        if (this.startRow > 0) {
            this.setStartRow(this.startRow - 1);
            if (this.startRow + this.rowPageSize - 1 < this.rowCount) {
                this.setEndRow(this.startRow + this.rowPageSize - 1);
            } else {
                this.setEndRow(this.rowCount - 1);
            }
        }
    }

    @Override
    public void nextRow() {
        if (!this.isNextRowSupported()) {
            throw new UnsupportedOperationException(RB.getStringResource(RB_KEY, "operationNotSupported.txt", this.getLocale()) + " nextRow()");
        }
        if (this.endRow < this.rowCount - 1) {
            this.setStartRow(this.startRow + 1);
            if (this.startRow + this.rowPageSize - 1 < this.rowCount) {
                this.setEndRow(this.startRow + this.rowPageSize - 1);
            } else {
                this.setEndRow(this.rowCount - 1);
            }
        }
    }

    @Override
    public void pageForwardRows() {
        if (!this.isPageForwardRowsSupported()) {
            throw new UnsupportedOperationException(RB.getStringResource(RB_KEY, "operationNotSupported.txt", this.getLocale()) + " pageForwardRows()");
        }
        if (this.endRow != this.rowCount - 1) {
            if (this.startRow + this.rowPageSize < this.rowCount) {
                this.setStartRow(this.startRow + this.rowPageSize);
            } else {
                this.setStartRow(this.rowCount - 1);
            }
            if (this.endRow + this.rowPageSize < this.rowCount) {
                this.setEndRow(this.endRow + this.rowPageSize);
            } else {
                this.setEndRow(this.rowCount - 1);
            }
        }
    }

    @Override
    public void lastRow() {
        if (!this.isLastRowSupported()) {
            throw new UnsupportedOperationException(RB.getStringResource(RB_KEY, "operationNotSupported.txt", this.getLocale()) + " lastRow()");
        }
        if (this.rowCount != -1) {
            this.setEndRow(this.rowCount - 1);
            if (this.endRow - this.rowPageSize + 1 >= 0) {
                this.setStartRow(this.endRow - this.rowPageSize + 1);
            } else {
                this.setStartRow(0);
            }
        }
    }

    @Override
    public void gotoRow(int row) {
        if (!this.isGotoRowSupported()) {
            throw new UnsupportedOperationException(RB.getStringResource(RB_KEY, "operationNotSupported.txt", this.getLocale()) + " gotoRow()");
        }
        if (row <= 0) {
            row = 1;
        } else if (row > this.rowCount) {
            row = this.rowCount;
        }
        this.setStartRow(row - 1);
        if (this.startRow + this.rowPageSize > this.rowCount) {
            this.setEndRow(this.rowCount - 1);
        } else {
            this.setEndRow(this.startRow + this.rowPageSize - 1);
        }
    }

    @Override
    public int getStartRow() {
        return this.startRow;
    }

    public void setStartRow(int start) {
        int oldStartRow = this.startRow;
        this.startRow = start;
        this.firePropertyChange("startRow", oldStartRow, this.startRow);
    }

    @Override
    public int getEndRow() {
        return this.endRow;
    }

    public void setEndRow(int end) {
        this.endRow = end;
    }

    @Override
    public abstract int getRowCount();

    @Override
    public int getRowPageSize() {
        return this.rowPageSize;
    }

    @Override
    public void setRowPageSize(int rows) {
        if (this.rowPageSize != rows) {
            this.rowPageSize = rows;
            this.initialize();
        }
    }

    public abstract boolean isAccurateRowCountAvailable();

    @Override
    public String getFormName() {
        if (this instanceof FormViewInterface) {
            return ((FormViewInterface)((Object)this)).getFormObject().getName();
        }
        return null;
    }

    public int getColumnScrollSize() {
        return this.columnPageSize;
    }

    private boolean _baseColumnBackwardsSupported() {
        return this.startColumn > 0 && (this.columnPageSize != -1 && this.columnCount > this.getColumnScrollSize() || this.columnCount <= this.getColumnScrollSize());
    }

    private boolean _baseColumnForwardSupported() {
        return this.endColumn + 1 < this.columnCount && (this.columnPageSize != -1 && this.columnCount > this.getColumnScrollSize() || this.startColumn > 0 && this.columnCount <= this.getColumnScrollSize());
    }

    @Override
    public boolean isFirstColumnSupported() {
        return this._baseColumnBackwardsSupported();
    }

    @Override
    public boolean isPageBackwardColumnsSupported() {
        return this._baseColumnBackwardsSupported();
    }

    @Override
    public boolean isPreviousColumnSupported() {
        return this._baseColumnBackwardsSupported();
    }

    @Override
    public boolean isNextColumnSupported() {
        return this._baseColumnForwardSupported();
    }

    @Override
    public boolean isPageForwardColumnsSupported() {
        return this._baseColumnForwardSupported();
    }

    @Override
    public boolean isLastColumnSupported() {
        return this._baseColumnForwardSupported();
    }

    @Override
    public boolean isGotoColumnSupported() {
        return false;
    }

    @Override
    public void firstColumn() {
        if (!this.isFirstColumnSupported()) {
            throw new UnsupportedOperationException(RB.getStringResource(RB_KEY, "operationNotSupported.txt", this.getLocale()) + " firstColumn()");
        }
        if (this.startColumn != 0) {
            this.setStartColumn(0);
            if (this.getColumnScrollSize() < this.columnCount) {
                this.setEndColumn(this.getColumnScrollSize() - 1);
            } else {
                this.setEndColumn(this.columnCount - 1);
            }
        }
    }

    @Override
    public void pageBackwardColumns() {
        if (!this.isPageBackwardColumnsSupported()) {
            throw new UnsupportedOperationException(RB.getStringResource(RB_KEY, "operationNotSupported.txt", this.getLocale()) + " pageBackwardColumns()");
        }
        if (this.startColumn != 0) {
            if (this.startColumn - this.getColumnScrollSize() > 0) {
                this.setStartColumn(this.startColumn - this.getColumnScrollSize());
            } else {
                this.setStartColumn(0);
            }
            if (this.startColumn + this.getColumnScrollSize() - 1 < this.columnCount) {
                this.setEndColumn(this.startColumn + this.getColumnScrollSize() - 1);
            } else {
                this.setEndColumn(this.columnCount - 1);
            }
        }
    }

    @Override
    public void previousColumn() {
        if (!this.isPreviousColumnSupported()) {
            throw new UnsupportedOperationException(RB.getStringResource(RB_KEY, "operationNotSupported.txt", this.getLocale()) + " previousColumn()");
        }
        if (this.startColumn > 0) {
            this.setStartColumn(this.startColumn - 1);
            if (this.startColumn + this.getColumnScrollSize() - 1 < this.columnCount) {
                this.setEndColumn(this.startColumn + this.getColumnScrollSize() - 1);
            } else {
                this.setEndColumn(this.columnCount - 1);
            }
        }
    }

    @Override
    public void nextColumn() {
        if (!this.isNextColumnSupported()) {
            throw new UnsupportedOperationException(RB.getStringResource(RB_KEY, "operationNotSupported.txt", this.getLocale()) + " nextColumn()");
        }
        if (this.endColumn < this.columnCount - 1) {
            this.setStartColumn(this.startColumn + 1);
            if (this.startColumn + this.getColumnScrollSize() - 1 < this.columnCount) {
                this.setEndColumn(this.startColumn + this.getColumnScrollSize() - 1);
            } else {
                this.setEndColumn(this.columnCount - 1);
            }
        }
    }

    @Override
    public void pageForwardColumns() {
        if (!this.isPageForwardColumnsSupported()) {
            throw new UnsupportedOperationException(RB.getStringResource(RB_KEY, "operationNotSupported.txt", this.getLocale()) + " pageForwardColumns()");
        }
        if (this.endColumn != this.columnCount - 1) {
            if (this.startColumn + this.getColumnScrollSize() < this.columnCount) {
                this.setStartColumn(this.startColumn + this.getColumnScrollSize());
            } else {
                this.setStartColumn(this.endColumn + 1);
            }
            if (this.endColumn + this.getColumnScrollSize() + 1 <= this.columnCount - 1) {
                this.setEndColumn(this.endColumn + this.getColumnScrollSize());
            } else {
                this.setEndColumn(this.columnCount - 1);
            }
        }
    }

    @Override
    public void lastColumn() {
        if (!this.isLastColumnSupported()) {
            throw new UnsupportedOperationException(RB.getStringResource(RB_KEY, "operationNotSupported.txt", this.getLocale()) + " lastColumn()");
        }
        if (this.endColumn != this.columnCount - 1) {
            this.setEndColumn(this.columnCount - 1);
            if (this.endColumn - this.getColumnScrollSize() + 1 >= 0) {
                this.setStartColumn(this.endColumn - this.getColumnScrollSize() + 1);
            } else {
                this.setStartColumn(0);
            }
        }
    }

    @Override
    public void gotoColumn(int column) {
        if (!this.isGotoColumnSupported()) {
            throw new UnsupportedOperationException(RB.getStringResource(RB_KEY, "operationNotSupported.txt", this.getLocale()) + " gotoColumn()");
        }
        if (column <= 0) {
            column = 1;
        } else if (column > this.columnCount) {
            column = this.columnCount;
        }
        this.setStartColumn(column - 1);
        if (this.startColumn + this.getColumnScrollSize() > this.columnCount) {
            this.setEndColumn(this.columnCount - 1);
        } else {
            this.setEndColumn(this.startColumn + this.getColumnScrollSize() - 1);
        }
    }

    @Override
    public int getStartColumn() {
        return this.startColumn;
    }

    public void setStartColumn(int start) {
        int oldStartColumn = this.startColumn;
        this.startColumn = start;
        this.firePropertyChange("startColumn", oldStartColumn, this.startColumn);
    }

    @Override
    public int getEndColumn() {
        return this.endColumn;
    }

    public void setEndColumn(int end) {
        this.endColumn = end;
    }

    @Override
    public abstract int getColumnCount();

    @Override
    public int getColumnPageSize() {
        return this.columnPageSize;
    }

    @Override
    public void setColumnPageSize(int columns) {
        if (this.columnPageSize != columns) {
            this.columnPageSize = columns;
            this.initialize();
        }
    }

    public void setPageSize(int rows, int columns) {
        this.setRowPageSize(rows);
        this.setColumnPageSize(columns);
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int border) {
        if (border < 0) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidBorderWidth.txt", this.getLocale()));
        }
        this.borderWidth = border;
    }

    public int getCellSpacing() {
        return this.cellSpacing;
    }

    public void setCellSpacing(int spacing) {
        if (spacing < 0) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidCellSpacing.txt", this.getLocale()));
        }
        this.cellSpacing = spacing;
    }

    public int getCellPadding() {
        return this.cellPadding;
    }

    public void setCellPadding(int padding) {
        if (padding < 0) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidCellPadding.txt", this.getLocale()));
        }
        this.cellPadding = padding;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        if (width < 0) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidWidth.txt", this.getLocale()));
        }
        this.width = width;
    }

    public int getWidthPercentage() {
        return this.widthPercentage;
    }

    public void setWidthPercentage(int percentage) {
        if (percentage < 0) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidWidthPercentage.txt", this.getLocale()));
        }
        this.widthPercentage = percentage;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int alignment) {
        switch (alignment) {
            case 0: 
            case 2: 
            case 4: 
            case 99: {
                this.horizontalAlignment = alignment;
                break;
            }
            default: {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidOrientation.txt", this.getLocale()));
            }
        }
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    @SASScope
    public String getStyleClassPrefix() {
        return this.styleClassPrefix;
    }

    @SASScope
    public void setStyleClassPrefix(String prefix) {
        this.styleClassPrefix = prefix;
    }

    public boolean isColumnHeaderVisible() {
        return this.columnHeaderVisible;
    }

    public void setColumnHeaderVisible(boolean visible) {
        this.columnHeaderVisible = visible;
    }

    public boolean isRowHeaderVisible() {
        return this.rowHeaderVisible;
    }

    public void setRowHeaderVisible(boolean visible) {
        this.rowHeaderVisible = visible;
    }

    public void setAllActionsVisible(boolean visible) {
        this.allActionsVisible = visible;
    }

    public boolean isAllActionsVisible() {
        return this.allActionsVisible;
    }

    @SASScope
    public void setConditionEvaluator(ConditionEvaluationInterface evaluator) {
        this.conditionEvaluator = evaluator;
    }

    @SASScope
    public ConditionEvaluationInterface getConditionEvaluator() {
        return this.conditionEvaluator;
    }

    public Context getRulesContext() {
        return this.rulesContext;
    }

    public void setRulesContext(Context rulesContext) {
        this.rulesContext = rulesContext;
    }

    @SASScope
    public void removeCellRenderers(Collection collection) {
    }

    @SASScope
    public boolean isExportToExcel() {
        return this.exportToExcel;
    }

    @SASScope
    public void setExportToExcel(boolean exportToExcel) {
        this.exportToExcel = exportToExcel;
    }

    public boolean isColumnsResizable() {
        if (this.isAllActionsVisible()) {
            return this.columnsResizable;
        }
        return false;
    }

    public void setColumnsResizable(boolean columnsResizable) {
        this.columnsResizable = columnsResizable;
    }

    public int getTextWrapping() {
        return this.textWrapping;
    }

    public void setTextWrapping(int textWrapping) {
        this.textWrapping = textWrapping;
    }

    @SASScope
    public String getTitle() {
        return this.title;
    }

    @SASScope
    public void setTitle(String title) {
        this.title = title;
    }

    @SASScope
    public String getFooter() {
        return this.footer;
    }

    @SASScope
    public void setFooter(String footer) {
        this.footer = footer;
    }

    @SASScope
    public TableCellRenderer getTitleRenderer() {
        return this.titleRenderer;
    }

    @SASScope
    public void setTitleRenderer(TableCellRenderer titleRenderer) {
        this.titleRenderer = titleRenderer;
    }

    @SASScope
    public TableCellRenderer getFooterRenderer() {
        return this.footerRenderer;
    }

    @SASScope
    public void setFooterRenderer(TableCellRenderer footerRenderer) {
        this.footerRenderer = footerRenderer;
    }

    @SASScope
    protected void writeSpanAll(PrintWriter out, TableCellRenderer renderer, String value, String styleMapKey) throws IOException {
        out.println("<tr>");
        if (renderer instanceof BaseTableCell) {
            BaseTableCell tablecell = (BaseTableCell)((Object)renderer);
            tablecell.setHeader(true);
            int width = this.getColSpanAll();
            tablecell.setColSpan(width);
        }
        if (renderer instanceof StyleInterface) {
            StyleInterface si = (StyleInterface)((Object)renderer);
            StyleInfo titleStyle = (StyleInfo)this.getStyleMap().get(styleMapKey);
            si.setStyleInfo(titleStyle);
        }
        renderer.write(out, this, value, null, null);
        out.println("</tr>");
    }

    @SASScope
    public int getColSpanAll() {
        int width = this.getEndColumn() - this.getStartColumn() + 1;
        if (this.getRulesContext() != null && this.getRulesContext().getRules().size() != 0) {
            width *= 3;
        }
        return ++width;
    }

    @Override
    protected void writeContent(PrintWriter out) throws IOException {
        this.flushActionProvider();
        this.setDefaultFormAction();
        this.initPartialRefresh(out);
        this.writeTableHeader(out);
        if (this.isColumnHeaderVisible()) {
            this.writeColumnHeader(out);
        }
        this.writeTableTFoot(out);
        this.writeRows(out);
        this.writeTableFooter(out);
        this.writeFeatures(this.getRequest(), out);
    }

    protected void writeTableTFoot(PrintWriter out) throws IOException {
    }

    private void initPartialRefresh(PrintWriter out) throws IOException {
        if (this.isAllActionsVisible() && this.isPartialRefreshActionsEnabled()) {
            HttpServletRequest request;
            JavaScriptIncludeHandler.writeIncludes(out, "AJAX", this.getRequest());
            if (this.getPartialRefreshProxy() == null && (request = this.getRequest()) != null) {
                ComponentSessionManager.getSessionManager(request).put(this.getId(), this);
            }
        }
    }

    public void addFeature(Feature feature) {
        this.features.add(feature);
    }

    @Override
    @SASScope
    public FeatureList getFeatures() {
        return this.features;
    }

    protected void writeFeatures(HttpServletRequest request, PrintWriter out) throws IOException {
        if (this.allActionsVisible) {
            this.features.writeFeatures(request, out);
        }
    }

    @SASScope
    public TableCellRenderer getCurrentRenderer() {
        return this.currentRenderer;
    }

    @SASScope
    public void render(TableCellRenderer renderer, PrintWriter out, AbstractBaseTableView tableview, Object value, String name, ActionList actions) throws IOException {
        this.currentRenderer = renderer;
        this.addMoveMenu(renderer, actions);
        renderer.write(out, tableview, value, name, actions);
        this.currentRenderer = null;
    }

    protected void addMoveMenu(TableCellRenderer renderer, ActionList actions) {
        if (renderer instanceof BaseTableCell && this instanceof OLAPTableView && this.isRightClickContextMenu(this.getRequest(), actions) && this.isAllActionsVisible()) {
            BaseTableCell tablecell = (BaseTableCell)((Object)renderer);
            tablecell.setCustomAttributes("oncontextmenu=\"otMoveMenu(event,this);\"");
        }
    }

    private boolean isRightClickContextMenu(HttpServletRequest request, ActionList actionList) {
        if (actionList == null) {
            return false;
        }
        List actions = actionList.getActions();
        for (int i = 0; i < actionList.size(); ++i) {
            Action action;
            Object obj = actions.get(i);
            if (!(obj instanceof Action) || !((action = (Action)obj) instanceof ActionList)) continue;
            ActionList al = (ActionList)action;
            return al != null && !al.isEmpty();
        }
        return false;
    }

    @SASScope
    public void renderEditor(TableCellEditor editor, PrintWriter out, AbstractBaseTableView tableview, Object value, String name, ActionList actions) throws IOException {
        editor.write(out, tableview, value, name, actions);
    }

    protected StyleInfo removeLastBorder(TableCellRenderer renderer, int col, int row, StyleInfo savedStyle) {
        boolean skipRight;
        boolean skipBottom = row >= this.endRow && row >= 0;
        boolean bl = skipRight = col >= this.endColumn && col >= 0;
        if ((skipBottom || skipRight) && renderer instanceof StyleInterface) {
            StyleInfo removeBorder;
            StyleInterface styleSource = (StyleInterface)((Object)renderer);
            StyleInfo currentStyleInfo = styleSource.getStyleInfo();
            StyleInfo styleInfo = removeBorder = currentStyleInfo == null ? new StyleInfo() : new StyleInfo(currentStyleInfo);
            if (skipBottom) {
                removeBorder.addStyle("border-bottom: none");
            }
            if (skipRight) {
                removeBorder.addStyle(BaseUtil.isRTL(this.getRequest()) ? "border-left: none" : "border-right: none");
            }
            styleSource.setStyleInfo(removeBorder);
            if (savedStyle == MISSING_STYLEINFO) {
                savedStyle = currentStyleInfo;
            }
        }
        return savedStyle;
    }
}

