/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.remotefileselector2.html;

import com.sas.codepolicy.SASScope;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.servlet.tbeans.remotefileselector2.html.CellContentsDateRenderer;
import com.sas.servlet.tbeans.remotefileselector2.html.RB;
import com.sas.servlet.tbeans.remotefileselector2.html.RemoteFileSearch;
import com.sas.servlet.tbeans.tableview.DefaultTableColumnModel;
import com.sas.servlet.tbeans.tableview.TableColumn;
import com.sas.servlet.tbeans.tableview.TableColumnModel;
import com.sas.servlet.tbeans.tableview.html.TableView;
import com.sas.swing.models.remotefileselector2.RemoteFileSearchModelInterface;
import com.sas.swing.models.remotefileselector2.informationservices.InformationServicesSearchModel;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Locale;

@SASScope(value="ALL")
public class InformationServicesSearch
extends RemoteFileSearch {
    public static final String RB_KEY = "InformationServicesSearch.";

    public InformationServicesSearch() {
    }

    public InformationServicesSearch(RepositoryInterface repository, Locale locale) {
        super((RemoteFileSearchModelInterface)new InformationServicesSearchModel(repository), locale);
        this.initialize(locale);
    }

    public InformationServicesSearch(UserContextInterface user, Locale locale) {
        super((RemoteFileSearchModelInterface)new InformationServicesSearchModel(user), locale);
        this.initialize(locale);
    }

    @SASScope
    public InformationServicesSearch(UserContextInterface user, boolean navigateUsingServer, Locale locale) {
        super((RemoteFileSearchModelInterface)new InformationServicesSearchModel(user, navigateUsingServer), locale);
        this.initialize(locale);
    }

    @SASScope
    public InformationServicesSearch(ServerInterface dataServer, Locale locale) {
        super((RemoteFileSearchModelInterface)new InformationServicesSearchModel(dataServer), locale);
        this.initialize(locale);
    }

    private void initialize(Locale locale) {
        if (locale != null) {
            this.setLocale(locale);
        }
        DefaultTableColumnModel searchColumnModel = new DefaultTableColumnModel();
        InformationServicesSearchModel model = (InformationServicesSearchModel)this.getModel();
        searchColumnModel.addColumn(new TableColumn(model.getColumnIndex("NAME_COLUMN")));
        searchColumnModel.addColumn(new TableColumn(model.getColumnIndex("TYPE_COLUMN")));
        TableColumn modifiedDateColumn = new TableColumn(model.getColumnIndex("MODIFIED_DATE_COLUMN"));
        searchColumnModel.addColumn(modifiedDateColumn);
        searchColumnModel.addColumn(new TableColumn(model.getColumnIndex("KEYWORDS_COLUMN")));
        searchColumnModel.addColumn(new TableColumn(model.getColumnIndex("PATH_COLUMN")));
        searchColumnModel.addColumn(new TableColumn(model.getColumnIndex("DESCRIPTION_COLUMN")));
        TableView searchFileView = (TableView)this.getComponent("RFS_SEARCHRESULTS_DETAILVIEW");
        searchFileView.setAutoCreateColumnsFromModel(false);
        searchFileView.setColumnModel(searchColumnModel);
        this.updateColumnHeaderValues(searchColumnModel, locale);
        modifiedDateColumn.setCellRenderer(new CellContentsDateRenderer(new SimpleDateFormat(RB.getStringResource(RB_KEY, "datePattern.lcl", this.getLocale()), this.getLocale())));
    }

    protected void updateColumnHeaderValues(TableColumnModel searchColumnModel, Locale locale) {
        InformationServicesSearchModel model = (InformationServicesSearchModel)this.getModel();
        Enumeration e = searchColumnModel.getColumns();
        while (e.hasMoreElements()) {
            TableColumn searchColumn = (TableColumn)e.nextElement();
            if (searchColumn.getModelIndex() == model.getColumnIndex("NAME_COLUMN")) {
                searchColumn.setHeaderValue(RB.getStringResource(RB_KEY, "nameColumn.txt", locale));
                continue;
            }
            if (searchColumn.getModelIndex() == model.getColumnIndex("TYPE_COLUMN")) {
                searchColumn.setHeaderValue(RB.getStringResource(RB_KEY, "typeColumn.txt", locale));
                continue;
            }
            if (searchColumn.getModelIndex() == model.getColumnIndex("MODIFIED_DATE_COLUMN")) {
                searchColumn.setHeaderValue(RB.getStringResource(RB_KEY, "modifiedDateColumn.txt", locale));
                continue;
            }
            if (searchColumn.getModelIndex() == model.getColumnIndex("KEYWORDS_COLUMN")) {
                searchColumn.setHeaderValue(RB.getStringResource(RB_KEY, "keywordsColumn.txt", locale));
                continue;
            }
            if (searchColumn.getModelIndex() == model.getColumnIndex("PATH_COLUMN")) {
                searchColumn.setHeaderValue(RB.getStringResource(RB_KEY, "pathColumn.txt", locale));
                continue;
            }
            if (searchColumn.getModelIndex() != model.getColumnIndex("DESCRIPTION_COLUMN")) continue;
            searchColumn.setHeaderValue(RB.getStringResource(RB_KEY, "descriptionColumn.txt", locale));
        }
    }

    public void setRepository(RepositoryInterface repository) {
        InformationServicesSearchModel model = (InformationServicesSearchModel)this.getModel();
        if (model == null) {
            model = new InformationServicesSearchModel(repository);
            this.setModel((RemoteFileSearchModelInterface)model);
            this.initialize(this.getLocale());
        } else {
            model.setRepository(repository);
        }
    }

    public RepositoryInterface getRepository() {
        InformationServicesSearchModel model = (InformationServicesSearchModel)this.getModel();
        if (model != null) {
            return model.getRepository();
        }
        return null;
    }

    public void setUserContext(UserContextInterface user) {
        InformationServicesSearchModel model = (InformationServicesSearchModel)this.getModel();
        if (model == null) {
            model = new InformationServicesSearchModel(user);
            this.setModel((RemoteFileSearchModelInterface)model);
            this.initialize(this.getLocale());
        } else {
            model.setUserContext(user);
        }
    }

    public UserContextInterface getUserContext() {
        InformationServicesSearchModel model = (InformationServicesSearchModel)this.getModel();
        if (model != null) {
            return model.getUserContext();
        }
        return null;
    }

    @Override
    protected void setLocaleDependentProperties(Locale locale) {
        super.setLocaleDependentProperties(locale);
        TableView searchDetailView = (TableView)this.getComponent("RFS_SEARCHRESULTS_DETAILVIEW");
        if (searchDetailView != null) {
            this.updateColumnHeaderValues(searchDetailView.getColumnModel(), locale);
        }
    }
}

