/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.remotefileselector2.html;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SAS.IWorkspace;
import com.sas.servlet.tbeans.remotefileselector2.html.CellContentsDateRenderer;
import com.sas.servlet.tbeans.remotefileselector2.html.CellContentsSizeRenderer;
import com.sas.servlet.tbeans.remotefileselector2.html.RB;
import com.sas.servlet.tbeans.remotefileselector2.html.RemoteFileSelector;
import com.sas.servlet.tbeans.tableview.BaseTableView;
import com.sas.servlet.tbeans.tableview.DefaultTableColumnModel;
import com.sas.servlet.tbeans.tableview.TableColumn;
import com.sas.servlet.tbeans.tableview.TableColumnModel;
import com.sas.servlet.tbeans.tableview.html.TableView;
import com.sas.swing.models.remotefileselector2.BaseRemoteFileModelInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileNavigationModelInterface;
import com.sas.swing.models.remotefileselector2.ifileservice.BaseIFileServiceModel;
import com.sas.swing.models.remotefileselector2.ifileservice.IFileServiceNavigationModel;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Locale;

@SASScope
public class IFileServiceSelector
extends RemoteFileSelector {
    public static final String RB_KEY = "IFileServiceSelector.";
    private RemoteFileNavigationModelInterface model;

    public IFileServiceSelector() {
    }

    public IFileServiceSelector(IWorkspace workspace, String path, Locale locale) {
        super((RemoteFileNavigationModelInterface)new IFileServiceNavigationModel(workspace, false), locale);
        this.initialize(path, locale);
    }

    public IFileServiceSelector(IWorkspace workspace, int fileSystem, String path, Locale locale) {
        super((RemoteFileNavigationModelInterface)new IFileServiceNavigationModel(workspace, fileSystem, false), locale);
        this.initialize(path, locale);
    }

    private void initialize(String path, Locale locale) {
        if (locale != null) {
            this.setLocale(locale);
        }
        this.model = this.getModel();
        if (path != null && !"".equals(path)) {
            this.model.setLocation(path);
        }
        this.setupDetailViewDisplayedColumns(locale);
    }

    public void setupDetailViewDisplayedColumns(Locale locale) {
        DefaultTableColumnModel fileColumnModel = new DefaultTableColumnModel();
        fileColumnModel.addColumn(new TableColumn(this.model.getColumnIndex("NAME_COLUMN")));
        TableColumn sizeColumn = new TableColumn(this.model.getColumnIndex("SIZE_COLUMN"));
        fileColumnModel.addColumn(sizeColumn);
        TableColumn modifiedDateColumn = new TableColumn(this.model.getColumnIndex("MODIFIED_DATE_COLUMN"));
        fileColumnModel.addColumn(modifiedDateColumn);
        fileColumnModel.addColumn(new TableColumn(this.model.getColumnIndex("ENGINE_COLUMN")));
        TableView regularFileView = (TableView)this.getComponent("RFS_FILE_DETAILVIEW");
        regularFileView.setAutoCreateColumnsFromModel(false);
        regularFileView.setColumnModel(fileColumnModel);
        this.updateColumnHeaderValues(fileColumnModel, locale);
        CellContentsSizeRenderer ccsr = new CellContentsSizeRenderer();
        ccsr.setHorizontalAlignment(4);
        sizeColumn.setCellRenderer(ccsr);
        modifiedDateColumn.setCellRenderer(new CellContentsDateRenderer(new SimpleDateFormat(RB.getStringResource(RB_KEY, "datePattern.lcl", this.getLocale()), this.getLocale())));
    }

    protected void updateColumnHeaderValues(TableColumnModel fileColumnModel, Locale locale) {
        this.model = this.getModel();
        Enumeration e = fileColumnModel.getColumns();
        while (e.hasMoreElements()) {
            TableColumn fileColumn = (TableColumn)e.nextElement();
            if (fileColumn.getModelIndex() == this.model.getColumnIndex("NAME_COLUMN")) {
                fileColumn.setHeaderValue(RB.getStringResource(RB_KEY, "nameColumn.txt", locale));
                continue;
            }
            if (fileColumn.getModelIndex() == this.model.getColumnIndex("SIZE_COLUMN")) {
                fileColumn.setHeaderValue(RB.getStringResource(RB_KEY, "sizeColumn.txt", locale));
                continue;
            }
            if (fileColumn.getModelIndex() == this.model.getColumnIndex("MODIFIED_DATE_COLUMN")) {
                fileColumn.setHeaderValue(RB.getStringResource(RB_KEY, "modifiedDateColumn.txt", locale));
                continue;
            }
            if (fileColumn.getModelIndex() != this.model.getColumnIndex("ENGINE_COLUMN")) continue;
            fileColumn.setHeaderValue(RB.getStringResource(RB_KEY, "engineColumn.txt", locale));
        }
    }

    public void setWorkspace(IWorkspace workspace) {
        this.model = this.getModel();
        if (this.model == null) {
            this.model = new IFileServiceNavigationModel(workspace);
            this.setModel(this.model);
            this.initialize(null, this.getLocale());
        } else if (this.model instanceof BaseIFileServiceModel) {
            ((BaseIFileServiceModel)this.model).setWorkspace(workspace);
        }
    }

    public IWorkspace getWorkspace() {
        this.model = this.getModel();
        if (this.model != null && this.model instanceof BaseIFileServiceModel) {
            return ((BaseIFileServiceModel)this.model).getWorkspace();
        }
        return null;
    }

    @Override
    protected void setupView(BaseTableView table, BaseRemoteFileModelInterface model) {
        super.setupView(table, model);
        this.sort(table, model, "NAME_COLUMN", 0);
    }

    @Override
    protected void setLocaleDependentProperties(Locale locale) {
        super.setLocaleDependentProperties(locale);
        TableView detailView = (TableView)this.getComponent("RFS_FILE_DETAILVIEW");
        if (detailView != null) {
            this.updateColumnHeaderValues(detailView.getColumnModel(), locale);
        }
    }
}

