/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.remotefileselector.html;

import com.sas.actionprovider.ActionList;
import com.sas.actionprovider.ActionProviderViewInterface;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.HttpAction;
import com.sas.codepolicy.SASScope;
import com.sas.entities.AttributeSetException;
import com.sas.servlet.tbeans.BaseButton;
import com.sas.servlet.tbeans.BaseLabel;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.form.BaseCheckBox;
import com.sas.servlet.tbeans.form.BaseChoiceBox;
import com.sas.servlet.tbeans.form.BaseFormElement;
import com.sas.servlet.tbeans.form.BaseTextEntry;
import com.sas.servlet.tbeans.form.html.CheckBox;
import com.sas.servlet.tbeans.form.html.ChoiceBox;
import com.sas.servlet.tbeans.form.html.Form;
import com.sas.servlet.tbeans.form.html.FormViewInterface;
import com.sas.servlet.tbeans.form.html.TextEntry;
import com.sas.servlet.tbeans.html.Button;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.models.Item;
import com.sas.servlet.tbeans.remotefileselector.BaseRemoteFileSearch;
import com.sas.servlet.tbeans.remotefileselector.html.RB;
import com.sas.servlet.util.BaseUtil;
import com.sas.swing.models.remotefileselector.RemoteFileSearchModelInterface;
import com.sas.swing.models.remotefileselector.RemoteFileServerModel;
import com.sas.swing.models.remotefileselector.RemoteFileServiceModelInterface;
import com.sas.swing.util.ActionUtils;
import com.sas.util.Util;
import com.sas.util.transforms.TransformInterface;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;

@SASScope(value="ALL")
public class RemoteFileSearch
extends BaseRemoteFileSearch
implements FormViewInterface {
    @SASScope
    public static final String RB_KEY = "RemoteFileSearch.";
    private Form formObject;
    private HashMap additionalParameters;
    private boolean formEnabled;
    private String searchActionCmdId;
    private String searchActionAP;
    private BaseChoiceBox searchLimitsEntry;
    private BaseTextEntry limitValueEntry;
    private BaseChoiceBox unitTypeEntry;

    public RemoteFileSearch() {
        this(null, null, null);
    }

    public RemoteFileSearch(RemoteFileSearchModelInterface serviceModel, TransformInterface[] transforms, String[] columnLabels) {
        this.setSearchOpen(false);
        this.setFormEnabled(true);
        this.setVisible(true);
        this.setSearchMode(false);
        if (serviceModel != null) {
            this.model = new RemoteFileServerModel("", (RemoteFileServiceModelInterface)serviceModel);
            if (transforms != null) {
                this.model.setTransforms(transforms);
            }
            if (columnLabels != null) {
                this.model.setColumnNames(columnLabels);
            }
            this.setModel(this.model);
        }
        this.setId(Util.getName((String)"rfsrch"));
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        if (this.isVisible()) {
            super.write(out);
            this.writeSearchLink(out);
            if (this.isSearchOpen() || this.isSearchMode()) {
                out.println("<div id=\"" + this.getId() + "_DisplayArea\" style=\"display: block\" class=\"RFSSearchDisplayArea\" >");
            } else {
                out.println("<div id=\"" + this.getId() + "_DisplayArea\" style=\"display: none\" class=\"RFSSearchDisplayArea\" >");
            }
            this.writeSearch(out);
            out.println("</div>");
        }
        this.cleanUpResources();
    }

    public void writeSearchLink(PrintWriter out) throws IOException {
        out.println("<table class=\"RFSSearchLink\" cellpadding=\"0\" cellspacing=\"0\" >");
        out.print("<tr><td class=\"RFSSearchLinkLabel_cell\" >");
        BaseLabel searchLinkLabel = this.getSearchLinkLabel();
        HttpServletRequest request = this.getRequest();
        HttpServletResponse response = this.getResponse();
        searchLinkLabel.setRequest(request);
        searchLinkLabel.setResponse(response);
        searchLinkLabel.setLocale(this.getLocale());
        searchLinkLabel.write(out);
        out.println("</td>");
        BaseButton expandButton = this.getExpandButton();
        BaseButton collapseButton = this.getCollapseButton();
        if (expandButton.getImage() == null || collapseButton.getImage() == null) {
            String imageLocation = this.getActionProvider().getImageLocation();
            if (expandButton.getImage() == null && expandButton.getLabel() == null) {
                expandButton.setImageKey("Maximize_Button_Default");
                expandButton.setDisabledImageKey("Maximize_Button_Inactive");
                expandButton.setImageLocation(imageLocation);
            }
            if (collapseButton.getImage() == null && collapseButton.getLabel() == null) {
                collapseButton.setImageKey("Minimize_Button_Default");
                collapseButton.setDisabledImageKey("Minimize_Button_Inactive");
                collapseButton.setImageLocation(imageLocation);
            }
        }
        if (this.isSearchOpen() || this.isSearchMode()) {
            expandButton.setEnabled(false);
            collapseButton.setEnabled(true);
        } else {
            expandButton.setEnabled(true);
            collapseButton.setEnabled(false);
        }
        collapseButton.setOnClick("sas_RemoteFileSelector_expandCollapseSearch('" + this.getId() + "_DisplayArea',false,'" + expandButton.getId() + "','" + collapseButton.getId() + "');");
        expandButton.setOnClick("sas_RemoteFileSelector_expandCollapseSearch('" + this.getId() + "_DisplayArea',true,'" + expandButton.getId() + "','" + collapseButton.getId() + "');");
        out.print("<td class=\"minmax_cell\" >");
        out.println("<table cellpadding=\"0\" cellspacing=\"0\" class=\"RFSSearch_ExpandCollapseButtons\" >");
        out.print("<tr><td>");
        collapseButton.setRequest(request);
        collapseButton.setResponse(response);
        collapseButton.setLocale(this.getLocale());
        collapseButton.write(out);
        out.print("</td><td>");
        expandButton.setRequest(request);
        expandButton.setResponse(response);
        expandButton.setLocale(this.getLocale());
        expandButton.write(out);
        out.print("</td></tr>");
        out.print("</table>");
        out.println("</td>");
        out.println("</tr></table>");
    }

    public void writeSearch(PrintWriter out) throws IOException {
        Form formObject = this.getFormObject();
        this.processSearchButtonActions();
        if (this.isFormEnabled()) {
            formObject.setLocale(this.getLocale());
            formObject.setRequest(this.getRequest());
            formObject.setResponse(this.getResponse());
            formObject.writeHeader(out);
        }
        this.writeSearchArea(out);
        out.println("<div class=\"RFSSearchButtonsContainer\">");
        this.writeButtons(out);
        out.println("</div>");
        out.println("<input type=\"hidden\" name=\"" + this.getActionProvider().getParameterPrefix() + "startDateTime\" value=\"\">");
        out.println("<input type=\"hidden\" name=\"" + this.getActionProvider().getParameterPrefix() + "endDateTime\" value=\"\">");
        BaseUtil.writeAdditionalParameters(this.getAdditionalParameters(), out);
        if (this.isFormEnabled()) {
            formObject.writeFooter(out);
        }
    }

    public void writeSearchArea(PrintWriter out) throws IOException {
        out.println("<table cellpadding=\"0\" cellspacing=\"0\" class=\"RFSSearchFields\" >");
        this.writeSearchText(out);
        this.writeSearchField(out);
        this.writeSearchFolder(out);
        this.writeSearchSubfolders(out);
        this.writeSearchLimitType(out);
        this.writeSearchLimits(out);
        out.println("</table>");
        this.setContentUpdateMode(false);
    }

    public void writeSearchText(PrintWriter out) throws IOException {
        String searchText;
        BaseLabel searchTextLabel = this.getSearchTextLabel();
        BaseTextEntry searchTextEntry = this.getSearchTextComponent();
        HttpServletRequest request = this.getRequest();
        HttpServletResponse response = this.getResponse();
        searchTextLabel.setRequest(request);
        searchTextLabel.setResponse(response);
        searchTextLabel.setLocale(this.getLocale());
        searchTextLabel.setFor(searchTextEntry.getId());
        searchTextEntry.setRequest(request);
        searchTextEntry.setResponse(response);
        searchTextEntry.setLocale(this.getLocale());
        String searchTextParameterName = this.getActionProvider().getParameterPrefix() + "searchText";
        searchTextEntry.setName(searchTextParameterName);
        if (this.isContentUpdateMode() && (searchText = request.getParameter(searchTextParameterName)) != null) {
            searchTextEntry.setText(searchText);
        }
        out.print("<tr class=\"RFSSearchText\" ><td class=\"RFSSearchTextLabel_cell\" nowrap=\"nowrap\">");
        searchTextLabel.write(out);
        out.print("</td>");
        out.print("<td class=\"RFSSearchTextComponent_cell\" >");
        searchTextEntry.write(out);
        out.println("</td></tr>");
    }

    public void writeSearchField(PrintWriter out) throws IOException {
        String searchFieldValue;
        BaseLabel searchFieldLabel = this.getSearchFieldLabel();
        BaseChoiceBox searchFieldEntry = this.getSearchFieldComponent();
        HttpServletRequest request = this.getRequest();
        HttpServletResponse response = this.getResponse();
        searchFieldLabel.setRequest(request);
        searchFieldLabel.setResponse(response);
        searchFieldLabel.setLocale(this.getLocale());
        searchFieldLabel.setFor(searchFieldEntry.getId());
        searchFieldEntry.setRequest(request);
        searchFieldEntry.setResponse(response);
        searchFieldEntry.setLocale(this.getLocale());
        String searchFieldParameterName = this.getActionProvider().getParameterPrefix() + "searchContext";
        searchFieldEntry.setName(searchFieldParameterName);
        if (this.isContentUpdateMode() && (searchFieldValue = request.getParameter(searchFieldParameterName)) != null) {
            searchFieldEntry.setSelectedItem(searchFieldValue);
        }
        out.print("<tr class=\"RFSSearchField\" ><td class=\"RFSSearchFieldLabel_cell\" nowrap=\"nowrap\">");
        searchFieldLabel.write(out);
        out.print("</td>");
        out.print("<td class=\"RFSSearchFieldComponent_cell\">");
        searchFieldEntry.write(out);
        out.println("</td></tr>");
    }

    public void writeSearchFolder(PrintWriter out) throws IOException {
        BaseLabel searchFolderLabel = this.getSearchFolderLabel();
        BaseChoiceBox searchFolderEntry = this.getSearchFolderComponent();
        HttpServletRequest request = this.getRequest();
        HttpServletResponse response = this.getResponse();
        searchFolderLabel.setRequest(request);
        searchFolderLabel.setResponse(response);
        searchFolderLabel.setLocale(this.getLocale());
        searchFolderLabel.setFor(searchFolderEntry.getId());
        searchFolderEntry.setRequest(request);
        searchFolderEntry.setResponse(response);
        searchFolderEntry.setLocale(this.getLocale());
        String searchFolderParameterName = this.getActionProvider().getParameterPrefix() + "startingPath";
        searchFolderEntry.setName(searchFolderParameterName);
        if (this.isContentUpdateMode()) {
            String searchFolderValue = request.getParameter(searchFolderParameterName);
            searchFolderEntry.setSelectedItem(searchFolderValue);
        } else {
            DefaultComboBoxModel comboModel = (DefaultComboBoxModel)searchFolderEntry.getModel();
            int numOfFolders = comboModel.getSize();
            if (numOfFolders > 0) {
                searchFolderEntry.setSelectedIndex(numOfFolders - 1);
            }
        }
        out.print("<tr class=\"RFSSearchFolder\" ><td class=\"RFSSearchFolderLabel_cell\" nowrap=\"nowrap\">");
        searchFolderLabel.write(out);
        out.print("</td>");
        out.print("<td class=\"RFSSearchFolderComponent_cell\">");
        searchFolderEntry.write(out);
        out.println("</td></tr>");
    }

    public void writeSearchSubfolders(PrintWriter out) throws IOException {
        HttpServletRequest request = this.getRequest();
        BaseCheckBox searchSubfoldersEntry = this.getSearchSubfoldersComponent();
        String searchSubfoldersParameterName = this.getActionProvider().getParameterPrefix() + "recursive";
        searchSubfoldersEntry.setName(searchSubfoldersParameterName);
        if (this.getSearchFolderComponent().getModel().getSize() < 1) {
            searchSubfoldersEntry.setSelected(true);
            searchSubfoldersEntry.setEnabled(false);
        } else {
            searchSubfoldersEntry.setEnabled(true);
            if (this.isContentUpdateMode()) {
                String searchSubfoldersValue = request.getParameter(searchSubfoldersParameterName);
                if ("true".equals(searchSubfoldersValue)) {
                    searchSubfoldersEntry.setSelected(true);
                } else if ("false".equals(searchSubfoldersValue)) {
                    searchSubfoldersEntry.setSelected(false);
                }
            }
        }
        searchSubfoldersEntry.setRequest(request);
        searchSubfoldersEntry.setResponse(this.getResponse());
        searchSubfoldersEntry.setLocale(this.getLocale());
        out.print("<tr class = \"RFSSearchSubfolders\"><td></td><td class=\"RFSSearchSubfoldersComponent_cell\" nowrap=\"nowrap\">");
        searchSubfoldersEntry.write(out);
        out.println("</td></tr>");
    }

    public void writeSearchLimitType(PrintWriter out) throws IOException {
        String searchLimitsValue;
        BaseLabel searchLimitsLabel = this.getSearchLimitsLabel();
        this.searchLimitsEntry = this.getSearchLimitsComponent();
        HttpServletRequest request = this.getRequest();
        HttpServletResponse response = this.getResponse();
        searchLimitsLabel.setRequest(request);
        searchLimitsLabel.setResponse(response);
        searchLimitsLabel.setLocale(this.getLocale());
        searchLimitsLabel.setFor(this.searchLimitsEntry.getId());
        this.searchLimitsEntry.setRequest(request);
        this.searchLimitsEntry.setResponse(response);
        this.searchLimitsEntry.setLocale(this.getLocale());
        String searchLimitsParameterName = this.getActionProvider().getParameterPrefix() + "searchDateTimeType";
        this.searchLimitsEntry.setName(searchLimitsParameterName);
        if (this.isContentUpdateMode() && (searchLimitsValue = request.getParameter(searchLimitsParameterName)) != null) {
            this.searchLimitsEntry.setSelectedItem(searchLimitsValue);
        }
        out.print("<tr class=\"RFSSearchDateTimeLimits\"><td class=\"RFSSearchDateTimeLimits_cell\" nowrap=\"nowrap\">");
        searchLimitsLabel.write(out);
        out.print("</td>");
        out.print("<td class=\"RFSSearchDateTimeLimitsComponent_cell\">");
        this.searchLimitsEntry.write(out);
        out.println("</td></tr>");
    }

    public void writeSearchLimits(PrintWriter out) throws IOException {
        BaseLabel searchLimitValueLabel = this.getSearchLimitValueLabel();
        this.limitValueEntry = this.getSearchLimitValueComponent();
        this.unitTypeEntry = this.getSearchUnitComponent();
        HttpServletRequest request = this.getRequest();
        HttpServletResponse response = this.getResponse();
        String searchLimitValueParameterName = this.getActionProvider().getParameterPrefix() + "limitValue";
        this.limitValueEntry.setName(searchLimitValueParameterName);
        String unitTypeParameterName = this.getActionProvider().getParameterPrefix() + "unitType";
        this.unitTypeEntry.setName(unitTypeParameterName);
        if (this.isContentUpdateMode()) {
            String unitTypeValue;
            String searchLimitsValue = request.getParameter(searchLimitValueParameterName);
            if (searchLimitsValue != null) {
                this.limitValueEntry.setText(searchLimitsValue);
            }
            if ((unitTypeValue = request.getParameter(unitTypeParameterName)) != null) {
                this.unitTypeEntry.setSelectedItem(unitTypeValue);
            }
        }
        searchLimitValueLabel.setRequest(request);
        searchLimitValueLabel.setResponse(response);
        searchLimitValueLabel.setLocale(this.getLocale());
        searchLimitValueLabel.setFor(this.limitValueEntry.getId());
        this.limitValueEntry.setRequest(request);
        this.limitValueEntry.setResponse(response);
        this.limitValueEntry.setLocale(this.getLocale());
        this.unitTypeEntry.setRequest(request);
        this.unitTypeEntry.setResponse(response);
        this.unitTypeEntry.setLocale(this.getLocale());
        out.print("<tr class=\"RFSSearchLimitValues\" ><td></td><td class=\"RFSSearchLimitValues_cell\" nowrap=\"nowrap\">");
        out.print("<table class=\"RFSSearchLimitValues_table\" cellspacing=\"0\" cellpadding=\"0\" ><tr>");
        out.print("<td class=\"RFSSearchLimitValueLabel_cell\">");
        searchLimitValueLabel.write(out);
        out.print("</td><td class=\"RFSSearchLimitValueComponent_cell\">");
        this.limitValueEntry.write(out);
        this.unitTypeEntry.write(out);
        out.print("</td>");
        out.print("</tr></table>");
        out.print("</td>");
        out.println("</tr>");
    }

    public void writeButtons(PrintWriter out) throws IOException {
        out.println("<table class=\"RFSSearchButtons\" cellpadding=\"0\" cellspacing=\"0\" >");
        BaseButton searchButton = this.getSearchButton();
        BaseButton cancelButton = this.getCancelButton();
        String formName = this.getFormObject().getName();
        searchButton.setOnClick(formName + ".searchMode.value='on';sas_RemoteFileSelector_processSearch('" + formName + "','" + this.getActionProvider().getParameterPrefix() + "','" + this.searchLimitsEntry.getName() + "','" + this.limitValueEntry.getName() + "','" + this.unitTypeEntry.getName() + "');return false;");
        out.println("<tr><td>");
        HttpServletRequest request = this.getRequest();
        HttpServletResponse response = this.getResponse();
        searchButton.setRequest(request);
        searchButton.setResponse(response);
        searchButton.setLocale(this.getLocale());
        searchButton.write(out);
        out.println("</td><td>");
        cancelButton.setRequest(request);
        cancelButton.setResponse(response);
        cancelButton.setLocale(this.getLocale());
        cancelButton.write(out);
        out.println("</td></tr>");
        out.println("</table>");
        out.println("<input type=\"hidden\" name=\"searchMode\" value=\"off\" >");
    }

    @SASScope
    protected void processSearchButtonActions() {
        ActionList searchButtonAreaActions = this.getSearchButtonAreaActions();
        if (searchButtonAreaActions != null) {
            StringBuffer actionAnchor = new StringBuffer();
            Iterator iterator = ActionUtils.iterator((com.sas.swing.util.ActionList)searchButtonAreaActions);
            while (iterator.hasNext()) {
                HttpAction searchButtonAction;
                Object listElement = iterator.next();
                if (listElement == ActionList.SEPARATOR || listElement instanceof com.sas.swing.util.ActionList || !(searchButtonAction = (HttpAction)((Object)listElement)).getActionType().equals("START_SEARCH_ACTION")) continue;
                this.getFormObject().setAction((String)searchButtonAction.getValue("URL"));
            }
            this.getActionProvider().returnActionList(searchButtonAreaActions);
        }
    }

    @SASScope
    protected ActionList getSearchButtonAreaActions() {
        ActionSupportFilter searchButtonAreaFilter = new ActionSupportFilter(this.getActionSupportType(), "SEARCH_BUTTON_AREA", (ActionProviderViewInterface)this, false);
        searchButtonAreaFilter.setPoolingOn(true);
        searchButtonAreaFilter.setViewerId(this.getId());
        searchButtonAreaFilter.setHiddenActionsMap(this.getViewerSupport().getHiddenActionsMap());
        try {
            this.model = this.getModel();
            if (this.model != null) {
                searchButtonAreaFilter.setAttribute("remoteModel", (Object)this.model);
                searchButtonAreaFilter.setAttribute("serviceModel", (Object)this.model.getModel());
            }
        }
        catch (AttributeSetException attributeSetException) {
            // empty catch block
        }
        return this.getActionProvider().getActions(searchButtonAreaFilter);
    }

    @Override
    public BaseTextEntry getDefaultSearchTextComponent() {
        TextEntry st = new TextEntry();
        st.setStyleClass("RFSSearchTextComponent");
        st.setId(this.getId() + "_searchFor");
        return st;
    }

    @Override
    public BaseChoiceBox getDefaultSearchFieldComponent() {
        ChoiceBox searchFieldEntry = new ChoiceBox();
        searchFieldEntry.setStyleClass("RFSSearchFieldComponent");
        searchFieldEntry.setId(this.getId() + "_searchWhat");
        DefaultComboBoxModel comboModel = (DefaultComboBoxModel)searchFieldEntry.getModel();
        Item itemNode_1 = new Item();
        itemNode_1.setText(RB.getStringResource(RB_KEY, "searchField1.txt", this.getLocale()));
        itemNode_1.setValue("Name");
        Item itemNode_2 = new Item();
        itemNode_2.setText(RB.getStringResource(RB_KEY, "searchField2.txt", this.getLocale()));
        itemNode_2.setValue("Desc");
        Item itemNode_4 = new Item();
        itemNode_4.setText(RB.getStringResource(RB_KEY, "searchField4.txt", this.getLocale()));
        itemNode_4.setValue("Keywords");
        comboModel.addElement(itemNode_1);
        comboModel.addElement(itemNode_2);
        comboModel.addElement(itemNode_4);
        return searchFieldEntry;
    }

    @Override
    public BaseChoiceBox getDefaultSearchFolderComponent() {
        ChoiceBox searchFolderChoice = new ChoiceBox();
        searchFolderChoice.setStyleClass("RFSSearchFolderComponent");
        searchFolderChoice.setId(this.getId() + "_searchWhere");
        return searchFolderChoice;
    }

    @Override
    public BaseCheckBox getDefaultSearchSubfoldersComponent() {
        CheckBox subfoldersComponent = new CheckBox();
        ((BaseFormElement)subfoldersComponent).setStyleClass("RFSSearchSubfoldersComponent");
        subfoldersComponent.setText(this.getSearchSubfoldersLabel());
        subfoldersComponent.setSelected(true);
        subfoldersComponent.setValue("true");
        subfoldersComponent.setSubmitUncheckedValue(true);
        subfoldersComponent.setUncheckedValue("false");
        return subfoldersComponent;
    }

    @Override
    public BaseChoiceBox getDefaultSearchLimitsComponent() {
        ChoiceBox searchLimitsEntry = new ChoiceBox();
        searchLimitsEntry.setStyleClass("RFSSearchDateTimeLimitsComponent");
        searchLimitsEntry.setId(this.getId() + "_searchDateTimeLimits");
        DefaultComboBoxModel comboModel = (DefaultComboBoxModel)searchLimitsEntry.getModel();
        Item itemNode_1 = new Item();
        itemNode_1.setText(RB.getStringResource(RB_KEY, "DateTimeLimits1.txt", this.getLocale()));
        itemNode_1.setValue("none");
        Item itemNode_3 = new Item();
        itemNode_3.setText(RB.getStringResource(RB_KEY, "DateTimeLimits3.txt", this.getLocale()));
        itemNode_3.setValue("modified");
        comboModel.addElement(itemNode_1);
        comboModel.addElement(itemNode_3);
        return searchLimitsEntry;
    }

    @Override
    public BaseTextEntry getDefaultSearchLimitValueComponent() {
        TextEntry limitValueEntry = new TextEntry();
        limitValueEntry.setStyleClass("RFSLimitValueComponent");
        limitValueEntry.setText("1");
        limitValueEntry.setId(this.getId() + "_InTheLast");
        return limitValueEntry;
    }

    @Override
    public BaseChoiceBox getDefaultSearchUnitComponent() {
        ChoiceBox unitTypeEntry = new ChoiceBox();
        unitTypeEntry.setStyleClass("RFSSearchUnitComponent");
        DefaultComboBoxModel comboModel = (DefaultComboBoxModel)unitTypeEntry.getModel();
        Item itemNode_1 = new Item();
        itemNode_1.setText(RB.getStringResource(RB_KEY, "unitType1.txt", this.getLocale()));
        itemNode_1.setValue("Hours");
        Item itemNode_2 = new Item();
        itemNode_2.setText(RB.getStringResource(RB_KEY, "unitType2.txt", this.getLocale()));
        itemNode_2.setValue("Days");
        Item itemNode_3 = new Item();
        itemNode_3.setText(RB.getStringResource(RB_KEY, "unitType3.txt", this.getLocale()));
        itemNode_3.setValue("Weeks");
        Item itemNode_4 = new Item();
        itemNode_4.setText(RB.getStringResource(RB_KEY, "unitType4.txt", this.getLocale()));
        itemNode_4.setValue("Months");
        comboModel.addElement(itemNode_1);
        comboModel.addElement(itemNode_2);
        comboModel.addElement(itemNode_3);
        comboModel.addElement(itemNode_4);
        return unitTypeEntry;
    }

    @Override
    public BaseButton getDefaultSearchButton() {
        Button searchButton = new Button(RB.getStringResource(RB_KEY, "searchButton.txt", this.getLocale()));
        searchButton.setId(this.getId() + "_searchButton");
        searchButton.setStyleClassPrefix("RFSSearch_");
        return searchButton;
    }

    @Override
    public BaseButton getDefaultCancelButton() {
        Button cancelButton = new Button(RB.getStringResource(RB_KEY, "cancelButton.txt", this.getLocale()));
        cancelButton.setStyleClassPrefix("RFSCancel_");
        cancelButton.setEnabled(false);
        cancelButton.setId(this.getId() + "_cancelButton");
        return cancelButton;
    }

    @Override
    public BaseButton getDefaultExpandButton() {
        Button expandButton = new Button();
        expandButton.setId(this.getId() + "_expandButton");
        expandButton.getStyleMap().put("BUTTON_STYLE", new StyleInfo("RFSExpand_button"));
        expandButton.getStyleMap().put("BUTTON_ROLLOVER_STYLE", new StyleInfo("RFSExpand_rolloverButton"));
        expandButton.setAlternateText(RB.getStringResource(RB_KEY, "expandButtonAltText.txt", this.getLocale()));
        expandButton.setTitle(RB.getStringResource(RB_KEY, "expandButtonAltText.txt", this.getLocale()));
        if (this.getStyleClassPrefix() != null) {
            expandButton.setStyleClassPrefix(this.getStyleClassPrefix());
        }
        return expandButton;
    }

    @Override
    public BaseButton getDefaultCollapseButton() {
        Button collapseButton = new Button();
        collapseButton.setId(this.getId() + "_collapseButton");
        collapseButton.getStyleMap().put("BUTTON_STYLE", new StyleInfo("RFSCollapse_button"));
        collapseButton.getStyleMap().put("BUTTON_ROLLOVER_STYLE", new StyleInfo("RFSCollapse_rolloverButton"));
        collapseButton.setAlternateText(RB.getStringResource(RB_KEY, "collapseButtonAltText.txt", this.getLocale()));
        collapseButton.setTitle(RB.getStringResource(RB_KEY, "collapseButtonAltText.txt", this.getLocale()));
        if (this.getStyleClassPrefix() != null) {
            collapseButton.setStyleClassPrefix(this.getStyleClassPrefix());
        }
        return collapseButton;
    }

    @Override
    public BaseLabel getDefaultSearchTextLabel() {
        Label searchTextLabel = new Label(RB.getStringResource(RB_KEY, "searchTextLabel.txt", this.getLocale()));
        searchTextLabel.setStyleClass("RFSSearchTextLabel");
        searchTextLabel.setId(this.getId() + "_searchTextLabel");
        return searchTextLabel;
    }

    @Override
    public BaseLabel getDefaultSearchFieldLabel() {
        Label searchFieldLabel = new Label(RB.getStringResource(RB_KEY, "searchWhatLabel.txt", this.getLocale()));
        searchFieldLabel.setStyleClass("RFSSearchFieldLabel");
        searchFieldLabel.setId(this.getId() + "_searchFieldLabel");
        return searchFieldLabel;
    }

    @Override
    public BaseLabel getDefaultSearchFolderLabel() {
        Label searchFolderLabel = new Label(RB.getStringResource(RB_KEY, "searchWhereLabel.txt", this.getLocale()));
        searchFolderLabel.setStyleClass("RFSSearchFolderLabel");
        searchFolderLabel.setId(this.getId() + "_searchFolderLabel");
        return searchFolderLabel;
    }

    @Override
    public String getDefaultSearchSubfoldersLabel() {
        return RB.getStringResource(RB_KEY, "searchSubfolders.txt", this.getLocale());
    }

    @Override
    public BaseLabel getDefaultSearchLimitsLabel() {
        Label searchLimitsLabel = new Label(RB.getStringResource(RB_KEY, "DateTimeLimitsLabel.txt", this.getLocale()));
        searchLimitsLabel.setStyleClass("RFSSearchDateTimeLimitsLabel");
        searchLimitsLabel.setId(this.getId() + "_searchLimitsLabel");
        return searchLimitsLabel;
    }

    @Override
    public BaseLabel getDefaultSearchLinkLabel() {
        Label searchLinkLabel = new Label(RB.getStringResource(RB_KEY, "SearchTitle.txt", this.getLocale()));
        searchLinkLabel.setStyleClass("RFSSearchLinkLabel");
        searchLinkLabel.setId(this.getId() + "_searchLinkLabel");
        return searchLinkLabel;
    }

    @Override
    public BaseLabel getDefaultSearchLimitValueLabel() {
        Label searchLimitValueLabel = new Label(RB.getStringResource(RB_KEY, "LimitValueLabel.txt", this.getLocale()));
        searchLimitValueLabel.setStyleClass("RFSSearchLimitValueLabel");
        searchLimitValueLabel.setId(this.getId() + "_searchLimitValueLabel");
        return searchLimitValueLabel;
    }

    @Override
    public void setFormObject(Form form) {
        this.formObject = form;
    }

    @Override
    public Form getFormObject() {
        if (this.formObject == null) {
            this.formObject = this.getDefaultFormObject();
        }
        return this.formObject;
    }

    @Override
    public Form getDefaultFormObject() {
        return new Form(this.getId() + "_RFSSearchForm");
    }

    @Override
    public void setFormEnabled(boolean value) {
        this.formEnabled = value;
    }

    @Override
    public boolean isFormEnabled() {
        return this.formEnabled;
    }

    @Override
    public HashMap getAdditionalParameters() {
        return this.additionalParameters;
    }

    @Override
    public void setAdditionalParameters(HashMap map) {
        this.additionalParameters = map;
    }

    @Override
    public void setAdditionalParameter(String name, String value) {
        if (this.additionalParameters == null) {
            this.additionalParameters = new HashMap();
        }
        this.additionalParameters.put(name, value);
    }
}

