/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.remotefileselector;

import com.sas.actionprovider.ActionProviderEvent;
import com.sas.actionprovider.HttpActionProvider;
import com.sas.codepolicy.SASScope;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.iom.SAS.IWorkspace;
import com.sas.servlet.tbeans.BaseActionTransformation;
import com.sas.servlet.tbeans.remotefileselector.BaseRemoteFileSearch;
import com.sas.servlet.tbeans.remotefileselector.BaseRemoteFileToolBar;
import com.sas.servlet.tbeans.tableview.BaseTableView;
import com.sas.servlet.tbeans.tableview.TableColumnModel;
import com.sas.swing.models.remotefileselector.RemoteFileServerModelInterface;
import com.sas.swing.models.remotefileselector.RemoteFileServiceModelInterface;
import com.sas.util.transforms.TransformInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@SASScope(value="ALL")
public abstract class BaseRemoteFileSelector
extends BaseActionTransformation
implements ContentsChangedListener {
    private boolean displaySearchResults;
    private boolean toolBarVisible;
    private boolean externalSearch;
    private boolean searchVisible;
    private BaseRemoteFileToolBar toolBar;
    private BaseTableView detailsComponent;
    private BaseTableView searchResultsComponent;
    private String path;
    private String styleClassPrefix;
    private TransformInterface[] transforms;
    private String[] columnNames;
    private IWorkspace workspace;
    private Map fileTypes;
    private BaseRemoteFileSearch searchArea;
    private String mode;
    private TableColumnModel defaultDetailsViewColumnModel;
    public static final String SEARCH = "SEARCH";
    public static final String REGULAR = "REGULAR";
    @SASScope
    protected RemoteFileServerModelInterface model;

    public BaseRemoteFileSelector() {
        this.setActionSupportType("REMOTE_FILE_SELECTOR_COMPOSITE_SUPPORT");
    }

    @SASScope
    public void setStyleClassPrefix(String prefix) {
        this.styleClassPrefix = prefix;
    }

    @SASScope
    public String getStyleClassPrefix() {
        return this.styleClassPrefix;
    }

    public void setModel(RemoteFileServerModelInterface model) {
        this.model = model;
    }

    public RemoteFileServerModelInterface getModel() {
        return this.model;
    }

    public void setPath(String path) {
        this.path = path;
        this.model = this.getModel();
        if (this.model != null) {
            RemoteFileServiceModelInterface serviceModel = this.model.getModel();
            if (serviceModel != null) {
                this.model.setPath(serviceModel.getDirectoryPath(path));
            } else {
                this.model.setPath(path);
            }
        }
    }

    public String getPath() {
        this.model = this.getModel();
        if (this.model != null) {
            return this.model.getPath();
        }
        return this.path;
    }

    public void setToolBarVisible(boolean visibility) {
        this.toolBarVisible = visibility;
    }

    public boolean isToolBarVisible() {
        return this.toolBarVisible;
    }

    public void setToolBar(BaseRemoteFileToolBar tb) {
        this.toolBar = tb;
    }

    public BaseRemoteFileToolBar getToolBar() {
        if (this.toolBar == null) {
            this.toolBar = this.getDefaultToolBar();
        }
        return this.toolBar;
    }

    @SASScope
    protected abstract BaseRemoteFileToolBar getDefaultToolBar();

    public void setSearchVisible(boolean visibility) {
        this.searchVisible = visibility;
    }

    public boolean isSearchVisible() {
        return this.searchVisible;
    }

    public void setSearch(BaseRemoteFileSearch searchArea) {
        this.searchArea = searchArea;
    }

    public BaseRemoteFileSearch getSearch() {
        if (this.searchArea == null) {
            this.searchArea = this.getDefaultSearch();
        }
        return this.searchArea;
    }

    @SASScope
    protected abstract BaseRemoteFileSearch getDefaultSearch();

    public void setSearchResultsDisplayed(boolean display) {
        this.displaySearchResults = display;
    }

    public boolean isSearchResultsDisplayed() {
        return this.displaySearchResults;
    }

    public void setDetailsComponent(BaseTableView dc) {
        this.detailsComponent = dc;
    }

    public BaseTableView getDetailsComponent() {
        if (this.detailsComponent == null) {
            this.detailsComponent = this.getDefaultDetailsComponent();
        }
        if (this.detailsComponent.getActionProvider() == null) {
            this.detailsComponent.setActionProvider(this.getActionProvider());
            this.detailsComponent.setActionSupportType(this.getActionSupportType());
            this.detailsComponent.setWidthPercentage(100);
        }
        return this.detailsComponent;
    }

    @SASScope
    protected abstract BaseTableView getDefaultDetailsComponent();

    public void setSearchResultsComponent(BaseTableView src) {
        this.searchResultsComponent = src;
    }

    public BaseTableView getSearchResultsComponent() {
        if (this.searchResultsComponent == null) {
            this.searchResultsComponent = this.getDefaultSearchResultsComponent();
        }
        if (this.searchResultsComponent.getActionProvider() == null) {
            this.searchResultsComponent.setActionProvider(this.getActionProvider());
            this.searchResultsComponent.setActionSupportType(this.getActionSupportType());
            this.searchResultsComponent.setWidthPercentage(100);
        }
        return this.searchResultsComponent;
    }

    @SASScope
    protected abstract BaseTableView getDefaultSearchResultsComponent();

    public void setDefaultDetailsViewColumnModel(TableColumnModel model) {
        this.defaultDetailsViewColumnModel = model;
    }

    public TableColumnModel getDefaultDetailsViewColumnModel() {
        return this.defaultDetailsViewColumnModel;
    }

    public void setFileTypes(Map fileTypes) {
        RemoteFileServerModelInterface searchModel;
        this.fileTypes = fileTypes;
        ArrayList typeValues = new ArrayList(fileTypes.values());
        String filterValue = (String)typeValues.get(0);
        ArrayList<String> tempList = new ArrayList<String>();
        tempList.add(filterValue);
        RemoteFileServerModelInterface model = this.getModel();
        if (model != null) {
            model.getModel().setFilterValues(tempList);
        }
        if (this.isSearchVisible() && (searchModel = this.getSearch().getModel()) != null) {
            searchModel.getModel().setFilterValues(tempList);
        }
    }

    public Map getFileTypes() {
        return this.fileTypes;
    }

    @SASScope
    protected abstract List getDefaultFilterValues();

    @SASScope
    public String getMode() {
        if (this.mode == null) {
            this.mode = REGULAR;
        }
        return this.mode;
    }

    @SASScope
    public void setMode(String mode) {
        this.mode = mode;
        BaseRemoteFileSearch searchComponent = this.getSearch();
        if (searchComponent != null) {
            if (SEARCH.equals(mode)) {
                searchComponent.setSearchMode(true);
            } else {
                searchComponent.setSearchMode(false);
            }
        }
    }

    @Override
    public void setActionProvider(HttpActionProvider provider) {
        HttpActionProvider oldAP = this.getActionProvider();
        if (oldAP != provider) {
            if (oldAP != null) {
                oldAP.removeContentsChangedListener(this);
            }
            super.setActionProvider(provider);
            if (provider != null) {
                provider.addContentsChangedListener(this);
            }
        }
    }

    @SASScope
    public void contentsChanged(ContentsChangedEvent event) {
        ActionProviderEvent apEvent = (ActionProviderEvent)event;
        Object eventSource = apEvent.getSource();
        if (eventSource instanceof RemoteFileServerModelInterface) {
            Map info = ((ActionProviderEvent)event).getEventInfo();
            String type = (String)info.get("type");
            if ("NAVIGATE".equals(type) && this.getModel() == (RemoteFileServerModelInterface)eventSource) {
                this.setMode(REGULAR);
            } else if (SEARCH.equals(type)) {
                BaseRemoteFileSearch searchComponent = this.getSearch();
                if (searchComponent != null && searchComponent.getModel() == (RemoteFileServerModelInterface)eventSource) {
                    this.setMode(SEARCH);
                    searchComponent.setContentUpdateMode(true);
                } else if (searchComponent != null && this.getModel() == (RemoteFileServerModelInterface)eventSource) {
                    this.setMode(SEARCH);
                }
            }
        }
    }
}

