/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.range.html;

import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.html.TimeStampPicker;
import com.sas.servlet.tbeans.models.JavaScriptNode;
import com.sas.servlet.tbeans.range.BaseRange;
import com.sas.servlet.tbeans.range.RB;
import com.sas.util.DatePeriod;
import com.sas.util.DateTypes;
import com.sas.util.validators.ValidationInterface;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.MutableComboBoxModel;

public class TimeStampPickerRange
extends BaseRange {
    private TimeStampPicker min;
    private TimeStampPicker max;
    public static final String RB_KEY = "BaseDateTimeRange.";
    protected ValidationInterface minValidator;
    protected ValidationInterface maxValidator;
    private TimeZone timezone;

    @Override
    public TransformationInterface getMinimumRangeComponent() {
        if (this.min == null) {
            this.min = this.getDefaultComponent();
        }
        return this.min;
    }

    @Override
    public TransformationInterface getMaximumRangeComponent() {
        if (this.max == null) {
            this.max = this.getDefaultComponent();
        }
        return this.max;
    }

    @Override
    protected void setLocaleDependentProperties(Locale locale) {
        super.setLocaleDependentProperties(locale);
        this._setLocaleDependentProperties(locale);
    }

    private void _setLocaleDependentProperties(Locale currentLocale) {
        Label minLabel = (Label)this.getComponent(MINIMUM_LABEL);
        minLabel.setText(RB.getStringResource(RB_KEY, "from.txt", this.getLocale()));
        Label maxLabel = (Label)this.getComponent(MAXIMUM_LABEL);
        maxLabel.setText(RB.getStringResource(RB_KEY, "to.txt", this.getLocale()));
    }

    protected TimeStampPicker getDefaultComponent() {
        TimeStampPicker tsp = new TimeStampPicker();
        tsp.removeComponent("COMBO_LABEL_COMPONENT");
        tsp.setRelativeValuesIncluded(true);
        return tsp;
    }

    private ComboBoxModel getRelativeValues(int alignment) {
        DefaultComboBoxModel comboModel = new DefaultComboBoxModel();
        Locale locale = this.getLocale();
        JavaScriptNode currentDateTime = new JavaScriptNode();
        DatePeriod dp = new DatePeriod(DateTypes.TIMESTAMP, locale);
        currentDateTime.setValue(dp.toString());
        currentDateTime.setText(dp.toDisplayString(null, locale));
        dp = new DatePeriod(DateTypes.TIMESTAMP, -1, 0, 0, 0, 0, 0, 0, null, locale);
        JavaScriptNode currentDateTimePreviousYear = new JavaScriptNode();
        currentDateTimePreviousYear.setValue(dp.toString());
        currentDateTimePreviousYear.setText(dp.toDisplayString(null, locale));
        dp = new DatePeriod(DateTypes.TIMESTAMP, 1, 0, 0, 0, 0, 0, 0, null, locale);
        JavaScriptNode currentDateTimeNextYear = new JavaScriptNode();
        currentDateTimeNextYear.setValue(dp.toString());
        currentDateTimeNextYear.setText(dp.toDisplayString(null, locale));
        JavaScriptNode currentHour = new JavaScriptNode();
        dp = new DatePeriod(DateTypes.TIMESTAMP, DateTypes.HOUR, alignment, locale);
        currentHour.setValue(dp.toString());
        currentHour.setText(dp.toDisplayString(null, locale));
        JavaScriptNode previousHour = new JavaScriptNode();
        dp = new DatePeriod(DateTypes.TIMESTAMP, 0, 0, 0, 0, 0, -1, 0, DateTypes.HOUR, alignment, locale);
        previousHour.setValue(dp.toString());
        previousHour.setText(dp.toDisplayString(null, locale));
        JavaScriptNode nextHour = new JavaScriptNode();
        dp = new DatePeriod(DateTypes.TIMESTAMP, 0, 0, 0, 0, 0, 1, 0, DateTypes.HOUR, alignment, locale);
        nextHour.setValue(dp.toString());
        nextHour.setText(dp.toDisplayString(null, locale));
        JavaScriptNode currentMinute = new JavaScriptNode();
        dp = new DatePeriod(DateTypes.TIMESTAMP, DateTypes.MINUTE, alignment, locale);
        currentMinute.setValue(dp.toString());
        currentMinute.setText(dp.toDisplayString(null, locale));
        JavaScriptNode previousMinute = new JavaScriptNode();
        dp = new DatePeriod(DateTypes.TIMESTAMP, 0, 0, 0, 0, 0, 0, -1, DateTypes.MINUTE, alignment, locale);
        previousMinute.setValue(dp.toString());
        previousMinute.setText(dp.toDisplayString(null, locale));
        JavaScriptNode nextMinute = new JavaScriptNode();
        dp = new DatePeriod(DateTypes.TIMESTAMP, 0, 0, 0, 0, 0, 0, 1, DateTypes.MINUTE, alignment, locale);
        nextMinute.setValue(dp.toString());
        nextMinute.setText(dp.toDisplayString(null, locale));
        JavaScriptNode nHoursAgoNode = new JavaScriptNode();
        nHoursAgoNode.setValue("T-NH");
        nHoursAgoNode.setText(com.sas.swing.visuals.RB.getStringResource((String)"DatePicker.", (String)"nHoursAgo.txt", (Locale)locale));
        JavaScriptNode nHoursFromNowNode = new JavaScriptNode();
        nHoursFromNowNode.setValue("TNH");
        nHoursFromNowNode.setText(com.sas.swing.visuals.RB.getStringResource((String)"DatePicker.", (String)"nHoursFromNow.txt", (Locale)locale));
        JavaScriptNode nMinutesAgoNode = new JavaScriptNode();
        nMinutesAgoNode.setValue("T-Nm");
        nMinutesAgoNode.setText(com.sas.swing.visuals.RB.getStringResource((String)"DatePicker.", (String)"nMinutesAgo.txt", (Locale)locale));
        JavaScriptNode nMinutesFromNowNode = new JavaScriptNode();
        nMinutesFromNowNode.setValue("TNm");
        nMinutesFromNowNode.setText(com.sas.swing.visuals.RB.getStringResource((String)"DatePicker.", (String)"nMinutesFromNow.txt", (Locale)locale));
        ((MutableComboBoxModel)comboModel).insertElementAt(currentDateTime, 0);
        ((MutableComboBoxModel)comboModel).insertElementAt(currentDateTimePreviousYear, 1);
        ((MutableComboBoxModel)comboModel).insertElementAt(currentDateTimeNextYear, 2);
        ((MutableComboBoxModel)comboModel).insertElementAt(currentHour, 3);
        ((MutableComboBoxModel)comboModel).insertElementAt(previousHour, 4);
        ((MutableComboBoxModel)comboModel).insertElementAt(nextHour, 5);
        ((MutableComboBoxModel)comboModel).insertElementAt(currentMinute, 6);
        ((MutableComboBoxModel)comboModel).insertElementAt(previousMinute, 7);
        ((MutableComboBoxModel)comboModel).insertElementAt(nextMinute, 8);
        ((MutableComboBoxModel)comboModel).insertElementAt(nHoursAgoNode, 9);
        ((MutableComboBoxModel)comboModel).insertElementAt(nHoursFromNowNode, 10);
        ((MutableComboBoxModel)comboModel).insertElementAt(nMinutesAgoNode, 11);
        ((MutableComboBoxModel)comboModel).insertElementAt(nMinutesFromNowNode, 12);
        return comboModel;
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        TimeStampPicker minTsp = (TimeStampPicker)this.getComponent(MINIMUM_RANGE_COMPONENT);
        TimeStampPicker maxTsp = (TimeStampPicker)this.getComponent(MAXIMUM_RANGE_COMPONENT);
        if (this.getTimeZone() != null) {
            minTsp.setTimeZone(this.getTimeZone());
            maxTsp.setTimeZone(this.getTimeZone());
        }
        minTsp.setOnChange(this.getId() + "_Obj.onChange()");
        maxTsp.setOnChange(this.getId() + "_Obj.onChange()");
        minTsp.setModel(this.getRelativeValues(1));
        maxTsp.setModel(this.getRelativeValues(2));
        minTsp.setRelativeValuesAddedToModel(true);
        maxTsp.setRelativeValuesAddedToModel(true);
        super.write(out);
    }

    @Override
    public ValidationInterface getMinimumValidator() {
        return this.minValidator;
    }

    @Override
    public ValidationInterface getMaximumValidator() {
        return this.maxValidator;
    }

    @Override
    protected String getRangeType() {
        return "sas_Range.TIMESTAMP";
    }

    public void setTimeZone(TimeZone timezone) {
        this.timezone = timezone;
    }

    public TimeZone getTimeZone() {
        return this.timezone;
    }
}

