/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.range.html;

import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.form.html.TextEntry;
import com.sas.servlet.tbeans.html.DatePicker;
import com.sas.servlet.tbeans.models.Item;
import com.sas.servlet.tbeans.models.JavaScriptNode;
import com.sas.servlet.tbeans.range.BaseDateTimeRange;
import com.sas.servlet.tbeans.range.RB;
import com.sas.servlet.tbeans.util.validators.DateStringValidator;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.DatePeriod;
import com.sas.util.DateTypes;
import com.sas.util.validators.ValidationInterface;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;

public class DatePickerRange
extends BaseDateTimeRange {
    private DatePicker min;
    private DatePicker max;
    private DateStringValidator dateValidator = new DateStringValidator();

    public DatePickerRange() {
        this.dateValidator.setValidationOnChange(true);
    }

    @Override
    public TransformationInterface getMinimumRangeComponent() {
        if (this.min == null) {
            this.min = this.getDefaultComponent();
        }
        return this.min;
    }

    @Override
    public TransformationInterface getMaximumRangeComponent() {
        if (this.max == null) {
            this.max = this.getDefaultComponent();
        }
        return this.max;
    }

    protected DatePicker getDefaultComponent() {
        DatePicker datePicker = new DatePicker();
        datePicker.setRelativeValuesIncluded(true);
        return datePicker;
    }

    @Override
    public ValidationInterface getMinimumValidator() {
        return this.dateValidator;
    }

    @Override
    public ValidationInterface getMaximumValidator() {
        return this.dateValidator;
    }

    @Override
    protected ComboBoxModel getRangeTypeModel() {
        DefaultComboBoxModel<Item> model = new DefaultComboBoxModel<Item>();
        model.addElement(new Item(com.sas.swing.visuals.RB.getStringResource((String)"DateRangeEditor.", (String)"yearToDate.txt", (Locale)this.getLocale()), "yearToDate"));
        model.addElement(new Item(com.sas.swing.visuals.RB.getStringResource((String)"DateRangeEditor.", (String)"monthToDate.txt", (Locale)this.getLocale()), "monthToDate"));
        model.addElement(new Item(com.sas.swing.visuals.RB.getStringResource((String)"DateRangeEditor.", (String)"previousNDays.txt", (Locale)this.getLocale()), "previousNDays"));
        model.addElement(new Item(com.sas.swing.visuals.RB.getStringResource((String)"DateRangeEditor.", (String)"nextNDays.txt", (Locale)this.getLocale()), "nextNDays"));
        model.addElement(new Item(com.sas.swing.visuals.RB.getStringResource((String)"DateRangeEditor.", (String)"custom.txt", (Locale)this.getLocale()), "Custom"));
        return model;
    }

    private void updateRelativeValues(int alignment, DefaultComboBoxModel model) {
        if (model == null) {
            return;
        }
        if (model.getSize() == 7) {
            DatePeriod dp = new DatePeriod(DateTypes.DATE, DateTypes.YEAR, alignment, null, this.getLocale());
            JavaScriptNode currentYear = new JavaScriptNode();
            currentYear.setText(dp.toDisplayString(null, this.getLocale()));
            currentYear.setValue(dp.toString());
            model.insertElementAt(currentYear, 7);
            dp = new DatePeriod(DateTypes.DATE, DateTypes.MONTH, alignment, null, this.getLocale());
            JavaScriptNode currentMonth = new JavaScriptNode();
            currentMonth.setText(dp.toDisplayString(null, this.getLocale()));
            currentMonth.setValue(dp.toString());
            model.insertElementAt(currentMonth, 8);
        }
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        DatePicker minDp = (DatePicker)this.getComponent(MINIMUM_RANGE_COMPONENT);
        DatePicker maxDp = (DatePicker)this.getComponent(MAXIMUM_RANGE_COMPONENT);
        if (this.getTimeZone() != null) {
            minDp.setTimeZone(this.getTimeZone());
            maxDp.setTimeZone(this.getTimeZone());
        }
        minDp.setOnChange(this.getId() + "_Obj.pickerChanged()");
        maxDp.setOnChange(this.getId() + "_Obj.pickerChanged()");
        this.updateRelativeValues(1, (DefaultComboBoxModel)minDp.getComboModel());
        super.write(out);
    }

    @Override
    protected void writeJavaScript(PrintWriter out) {
        out.println(JavaScriptIncludeHandler.getStartScript());
        out.println(" " + this.getId() + "_Obj = new sas_DateRange({" + this.getJavaScriptParameters() + "});");
        if (this.getOnBlur() != null) {
            out.println(" " + this.getId() + "_Obj.onBlurEvent = \"" + this.getOnBlur() + "\";");
        }
        if (this.getOnChange() != null) {
            out.println(" " + this.getId() + "_Obj.onChangeEvent = \"" + this.getOnChange() + "\";");
        }
        if (this.getOnUpdate() != null) {
            out.println(" " + this.getId() + "_Obj.onUpdateEvent = \"" + this.getOnUpdate() + "\";");
        }
        if (this.getOnFocus() != null) {
            out.println(" " + this.getId() + "_Obj.onFocusEvent = \"" + this.getOnFocus() + "\";");
        }
        if (this.getErrorHandlerFunctionName() != null) {
            out.println(" " + this.getId() + "_Obj.errorHandlerFunction = \"" + this.getErrorHandlerFunctionName() + "\";");
        }
        out.println(" " + this.getId() + "_Obj.message = \"" + RB.getStringResource("BaseRange.", "invalidMinMaxValue.txt", this.getLocale()) + "\";");
        out.println(JavaScriptIncludeHandler.getEndScript(null));
    }

    @Override
    protected String getRangeType() {
        return "sas_Range.DATE";
    }

    public String getMaximumValue() {
        DatePicker dp = (DatePicker)this.getComponent(MAXIMUM_RANGE_COMPONENT);
        TextEntry te = (TextEntry)dp.getComponent("TEXT_ENTRY_COMPONENT");
        return te.getText();
    }

    public void setMaximumValue(String maximumValue) {
        DatePicker dp = (DatePicker)this.getComponent(MAXIMUM_RANGE_COMPONENT);
        TextEntry te = (TextEntry)dp.getComponent("TEXT_ENTRY_COMPONENT");
        te.setText(maximumValue);
    }

    public String getMinimumValue() {
        DatePicker dp = (DatePicker)this.getComponent(MINIMUM_RANGE_COMPONENT);
        TextEntry te = (TextEntry)dp.getComponent("TEXT_ENTRY_COMPONENT");
        return te.getText();
    }

    public void setMinimumValue(String minimumValue) {
        DatePicker dp = (DatePicker)this.getComponent(MINIMUM_RANGE_COMPONENT);
        TextEntry te = (TextEntry)dp.getComponent("TEXT_ENTRY_COMPONENT");
        te.setText(minimumValue);
    }
}

