/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.range.html;

import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.html.DateIntervalPicker;
import com.sas.servlet.tbeans.models.Item;
import com.sas.servlet.tbeans.range.BaseDateTimeRange;
import com.sas.servlet.tbeans.range.RB;
import com.sas.servlet.tbeans.util.validators.DateStringValidator;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.DateTypes;
import com.sas.util.validators.ValidationInterface;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;

public class DateIntervalPickerRange
extends BaseDateTimeRange {
    private DateIntervalPicker min;
    private DateIntervalPicker max;
    private DateTypes type;
    private DateStringValidator dateValidator = new DateStringValidator();

    public DateIntervalPickerRange() {
        this.dateValidator.setValidationOnChange(true);
        this.setType(DateTypes.WEEK);
    }

    @Override
    public TransformationInterface getMinimumRangeComponent() {
        if (this.min == null) {
            this.min = this.getDefaultComponent();
        }
        return this.min;
    }

    @Override
    public TransformationInterface getMaximumRangeComponent() {
        if (this.max == null) {
            this.max = this.getDefaultComponent();
        }
        return this.max;
    }

    protected DateIntervalPicker getDefaultComponent() {
        DateIntervalPicker datePicker = new DateIntervalPicker();
        datePicker.setRelativeValuesIncluded(true);
        if (this.getTimeZone() != null) {
            datePicker.setTimeZone(this.getTimeZone());
        }
        return datePicker;
    }

    @Override
    public ValidationInterface getMinimumValidator() {
        return this.dateValidator;
    }

    @Override
    public ValidationInterface getMaximumValidator() {
        return this.dateValidator;
    }

    @Override
    protected ComboBoxModel getRangeTypeModel() {
        DefaultComboBoxModel<Item> model = new DefaultComboBoxModel<Item>();
        if (this.getType() == DateTypes.WEEK) {
            model.addElement(new Item(com.sas.swing.visuals.RB.getStringResource((String)"DateRangeEditor.", (String)"previousNWeeks.txt", (Locale)this.getLocale()), "previousWeeks"));
            model.addElement(new Item(com.sas.swing.visuals.RB.getStringResource((String)"DateRangeEditor.", (String)"nextNWeeks.txt", (Locale)this.getLocale()), "nextWeeks"));
            model.addElement(new Item(com.sas.swing.visuals.RB.getStringResource((String)"DateRangeEditor.", (String)"custom.txt", (Locale)this.getLocale()), "Custom"));
        } else if (this.getType() == DateTypes.MONTH) {
            model.addElement(new Item(com.sas.swing.visuals.RB.getStringResource((String)"DateRangeEditor.", (String)"previousNMonths.txt", (Locale)this.getLocale()), "previousMonths"));
            model.addElement(new Item(com.sas.swing.visuals.RB.getStringResource((String)"DateRangeEditor.", (String)"nextNMonths.txt", (Locale)this.getLocale()), "nextMonths"));
            model.addElement(new Item(com.sas.swing.visuals.RB.getStringResource((String)"DateRangeEditor.", (String)"custom.txt", (Locale)this.getLocale()), "Custom"));
        } else if (this.getType() == DateTypes.QUARTER) {
            model.addElement(new Item(com.sas.swing.visuals.RB.getStringResource((String)"DateRangeEditor.", (String)"previousNQuarters.txt", (Locale)this.getLocale()), "previousQuarter"));
            model.addElement(new Item(com.sas.swing.visuals.RB.getStringResource((String)"DateRangeEditor.", (String)"nextNQuarters.txt", (Locale)this.getLocale()), "nextQuarters"));
            model.addElement(new Item(com.sas.swing.visuals.RB.getStringResource((String)"DateRangeEditor.", (String)"custom.txt", (Locale)this.getLocale()), "Custom"));
        } else if (this.getType() == DateTypes.YEAR) {
            model.addElement(new Item(com.sas.swing.visuals.RB.getStringResource((String)"DateRangeEditor.", (String)"previousNYears.txt", (Locale)this.getLocale()), "previousQuarter"));
            model.addElement(new Item(com.sas.swing.visuals.RB.getStringResource((String)"DateRangeEditor.", (String)"nextNYears.txt", (Locale)this.getLocale()), "nextQuarters"));
            model.addElement(new Item(com.sas.swing.visuals.RB.getStringResource((String)"DateRangeEditor.", (String)"custom.txt", (Locale)this.getLocale()), "Custom"));
        }
        return model;
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        DateIntervalPicker min = (DateIntervalPicker)this.getComponent(MINIMUM_RANGE_COMPONENT);
        min.setType(this.getType());
        min.setOnChange(this.getId() + "_Obj.pickerChanged()");
        DateIntervalPicker max = (DateIntervalPicker)this.getComponent(MAXIMUM_RANGE_COMPONENT);
        max.setType(this.getType());
        max.setOnChange(this.getId() + "_Obj.pickerChanged()");
        super.write(out);
    }

    @Override
    protected void writeJavaScript(PrintWriter out) {
        out.println(JavaScriptIncludeHandler.getStartScript());
        out.println(" " + this.getId() + "_Obj = new sas_DateIntervalPickerRange({" + this.getJavaScriptParameters() + "});");
        if (this.getOnBlur() != null) {
            out.println(" " + this.getId() + "_Obj.onBlurEvent = \"" + this.getOnBlur() + "\";");
        }
        if (this.getOnChange() != null) {
            out.println(" " + this.getId() + "_Obj.onChangeEvent = \"" + this.getOnChange() + "\";");
        }
        if (this.getOnUpdate() != null) {
            out.println(" " + this.getId() + "_Obj.onUpdateEvent = \"" + this.getOnUpdate() + "\";");
        }
        if (this.getErrorHandlerFunctionName() != null) {
            out.println(" " + this.getId() + "_Obj.errorHandlerFunction = \"" + this.getErrorHandlerFunctionName() + "\";");
        }
        out.println(" " + this.getId() + "_Obj.message = \"" + RB.getStringResource("BaseRange.", "invalidMinMaxValue.txt", this.getLocale()) + "\";");
        out.println(JavaScriptIncludeHandler.getEndScript(null));
    }

    @Override
    protected String getRangeType() {
        if (this.getType() == DateTypes.WEEK) {
            return "sas_Range.WEEK";
        }
        if (this.getType() == DateTypes.MONTH) {
            return "sas_Range.MONTH";
        }
        if (this.getType() == DateTypes.QUARTER) {
            return "sas_Range.QUARTER";
        }
        if (this.getType() == DateTypes.YEAR) {
            return "sas_Range.YEAR";
        }
        return "sas_Range.DATE";
    }

    public void setType(DateTypes type) {
        this.type = type;
    }

    public DateTypes getType() {
        return this.type;
    }
}

