/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.range;

import com.sas.servlet.tbeans.BaseCompositeTransformation;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.JavaScriptEventHandlerInterface;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.form.BaseFormElement;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.range.RB;
import com.sas.servlet.tbeans.util.validators.JavaScriptValidationInterface;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.MapWithDefaults;
import com.sas.util.Util;
import com.sas.util.transforms.TransformInterface;
import com.sas.util.validators.CompositeValidator;
import com.sas.util.validators.ValidationInterface;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseRange
extends BaseCompositeTransformation
implements JavaScriptEventHandlerInterface {
    private static String DEFAULT_TEMPLATE = "Range.html";
    public static String MINIMUM_RANGE_COMPONENT = "MINIMUM_RANGE_COMPONENT";
    public static String MAXIMUM_RANGE_COMPONENT = "MAXIMUM_RANGE_COMPONENT";
    public static String MINIMUM_LABEL = "MINIMUM_LABEL";
    public static String MAXIMUM_LABEL = "MAXIMUM_LABEL";
    public static String RANGE_LABEL_STYLE = "RANGE_LABEL_STYLE";
    public static final String RB_KEY = "BaseRange.";
    private static final HashMap defaultStyleMap = new HashMap();
    private static final ImmutableStyleInfo labelStyle = new ImmutableStyleInfo("sasComponentLabel");
    private String onBlur;
    private String onChange;
    private String onUpdate;
    private String onFocus;
    private Label minimumLabel;
    private Label maximumLabel;
    private Object initialValue;
    private String errorHandlerFunctionName;
    private boolean validationEnabled;

    public BaseRange() {
        this.setId(Util.getName((String)"range"));
        this.setTemplateKey("Range");
        this.addComponents();
        HashMap dictionary = this.getTemplateDictionary();
        if (dictionary == null) {
            dictionary = new HashMap();
        }
        this.setTemplateDictionary(dictionary);
        BaseRange.setupDefaultStyleMap();
        ((MapWithDefaults)this.getStyleMap()).setDefaultMap((Map)defaultStyleMap);
        this.setValidationEnabled(false);
        this.setObjectDataProperty("initialValue");
    }

    private static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0) {
            defaultStyleMap.put(RANGE_LABEL_STYLE, labelStyle);
        }
    }

    public void addComponents() {
        this.minimumLabel = new Label();
        this.maximumLabel = new Label();
        this.setComponent(MINIMUM_LABEL, this.minimumLabel);
        this.setComponent(MAXIMUM_LABEL, this.maximumLabel);
        TransformationInterface minRange = this.getMinimumRangeComponent();
        TransformationInterface maxRange = this.getMaximumRangeComponent();
        if (minRange != null) {
            minRange.setId(this.getId() + "_min");
        }
        if (maxRange != null) {
            maxRange.setId(this.getId() + "_max");
        }
        this.setComponent(MINIMUM_RANGE_COMPONENT, minRange);
        this.setComponent(MAXIMUM_RANGE_COMPONENT, maxRange);
    }

    public abstract TransformationInterface getMinimumRangeComponent();

    public abstract TransformationInterface getMaximumRangeComponent();

    public abstract ValidationInterface getMinimumValidator();

    public abstract ValidationInterface getMaximumValidator();

    protected abstract String getRangeType();

    public void setMinimumLabel(String value) {
        ((Label)this.getComponent(MINIMUM_LABEL)).setText(value);
    }

    public void setMaximumLabel(String value) {
        ((Label)this.getComponent(MAXIMUM_LABEL)).setText(value);
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        this.getTemplateDictionary().put("RANGE_ID", this.getId());
        JavaScriptIncludeHandler.writeIncludes(out, "VALIDATOR", this.getRequest());
        JavaScriptIncludeHandler.writeIncludes(out, "RANGE", this.getRequest());
        BaseTransformation minComponent = (BaseTransformation)this.getMinimumRangeComponent();
        BaseTransformation maxComponent = (BaseTransformation)this.getMaximumRangeComponent();
        if (minComponent != null) {
            minComponent.setDescription(this.getDescription());
            if (minComponent instanceof BaseFormElement) {
                ((BaseFormElement)minComponent).setOnChange(this.getId() + "_Obj.onChange(event)");
            }
        }
        if (maxComponent != null) {
            maxComponent.setDescription(this.getDescription());
            if (maxComponent instanceof BaseFormElement) {
                ((BaseFormElement)maxComponent).setOnChange(this.getId() + "_Obj.onChange(event)");
            }
        }
        this.minimumLabel = (Label)this.getComponent(MINIMUM_LABEL);
        this.maximumLabel = (Label)this.getComponent(MAXIMUM_LABEL);
        Label rangeLabel = (Label)this.getComponent("RANGE_LABEL");
        if (rangeLabel != null) {
            rangeLabel.setActionProvider(null);
        }
        if (this.minimumLabel != null) {
            this.minimumLabel.setActionProvider(null);
        }
        if (this.maximumLabel != null) {
            this.maximumLabel.setActionProvider(null);
        }
        this.writeTemplate(this, null, out);
        this.writeJavaScript(out);
    }

    protected void writeJavaScript(PrintWriter out) {
        out.println(JavaScriptIncludeHandler.getStartScript());
        out.println(" " + this.getId() + "_Obj = new sas_Range({" + this.getJavaScriptParameters() + "});");
        if (this.getOnBlur() != null) {
            out.println(" " + this.getId() + "_Obj.onBlurEvent = \"" + this.getOnBlur() + "\";");
        }
        if (this.getOnChange() != null) {
            out.println(" " + this.getId() + "_Obj.onChangeEvent = \"" + this.getOnChange() + "\";");
        }
        if (this.getOnUpdate() != null) {
            out.println(" " + this.getId() + "_Obj.onUpdateEvent = \"" + this.getOnUpdate() + "\";");
        }
        if (this.getOnFocus() != null) {
            out.println(" " + this.getId() + "_Obj.onFocusEvent = \"" + this.getOnFocus() + "\";");
        }
        if (this.getErrorHandlerFunctionName() != null) {
            out.println(" " + this.getId() + "_Obj.errorHandlerFunction = \"" + this.getErrorHandlerFunctionName() + "\";");
        }
        out.println(" " + this.getId() + "_Obj.message = \"" + RB.getStringResource(RB_KEY, "invalidMinMaxValue.txt", this.getLocale()) + "\";");
        if (this.isValidationEnabled()) {
            out.println(" " + this.getId() + "_Obj.validateRange = function() { \n" + this.getValidationFunctions() + "\n }");
        }
        out.println(JavaScriptIncludeHandler.getEndScript(null));
    }

    private String getValidationFunctions() {
        StringBuffer sb = new StringBuffer();
        ValidationInterface[] obj = new ValidationInterface[]{this.getMinimumValidator(), this.getMaximumValidator()};
        for (int j = 0; j <= 1; ++j) {
            ValidationInterface validator = obj[j];
            TransformationInterface component = j == 0 ? this.getMinimumRangeComponent() : this.getMaximumRangeComponent();
            if (validator instanceof CompositeValidator) {
                List validators = ((CompositeValidator)validator).getValidators();
                for (int i = 0; i < validators.size(); ++i) {
                    JavaScriptValidationInterface val = (JavaScriptValidationInterface)validators.get(i);
                    sb.append("if (").append(val.createValidationFunctionCall(component) + ") \n");
                }
                continue;
            }
            if (!(validator instanceof JavaScriptValidationInterface)) continue;
            sb.append("if (").append(((JavaScriptValidationInterface)validator).createValidationFunctionCall(component)).append(")\n");
        }
        sb.append("return true;");
        return sb.toString();
    }

    protected String getJavaScriptParameters() {
        StringBuffer sb = new StringBuffer();
        sb.append("id: '").append(this.getId()).append("'");
        sb.append(", minId: '").append(this.getMinimumRangeComponent().getId()).append("'");
        sb.append(", maxId: '").append(this.getMaximumRangeComponent().getId()).append("'");
        sb.append(", rangeType: ").append(this.getRangeType());
        sb.append(", validationEnabled: ").append(this.isValidationEnabled());
        return sb.toString();
    }

    @Override
    public String getOnBlur() {
        return this.onBlur;
    }

    @Override
    public void setOnBlur(String onBlur) {
        this.onBlur = onBlur;
    }

    @Override
    public String getOnChange() {
        return this.onChange;
    }

    @Override
    public void setOnChange(String onChange) {
        this.onChange = onChange;
    }

    @Override
    public void setOnFocus(String value) {
        this.onFocus = value;
    }

    @Override
    public String getOnFocus() {
        return this.onFocus;
    }

    public Object getInitialValue() {
        return this.initialValue;
    }

    public void setInitialValue(Object initialValue) {
        this.initialValue = initialValue;
        BaseTransformation min = (BaseTransformation)this.getMinimumRangeComponent();
        BaseTransformation max = (BaseTransformation)this.getMaximumRangeComponent();
        if (initialValue instanceof Object[]) {
            Object[] value = (Object[])initialValue;
            if (value.length > 1) {
                if (min != null) {
                    min.setObjectData(value[0]);
                }
                if (max != null) {
                    max.setObjectData(value[1]);
                }
            }
        } else if (initialValue == null || initialValue.toString().equals("")) {
            if (min != null) {
                min.setObjectData(null);
            }
            if (max != null) {
                max.setObjectData(null);
            }
        }
    }

    public void setErrorHandlerFunctionName(String functionName) {
        this.errorHandlerFunctionName = functionName;
    }

    public String getErrorHandlerFunctionName() {
        return this.errorHandlerFunctionName;
    }

    public String getOnUpdate() {
        return this.onUpdate;
    }

    public void setOnUpdate(String onUpdate) {
        this.onUpdate = onUpdate;
    }

    public boolean isValidationEnabled() {
        return this.validationEnabled;
    }

    public void setValidationEnabled(boolean validationEnabled) {
        this.validationEnabled = validationEnabled;
    }

    @Override
    public void setInputTransform(TransformInterface transform) {
        TransformationInterface minRange = this.getComponent(MINIMUM_RANGE_COMPONENT);
        TransformationInterface maxRange = this.getComponent(MAXIMUM_RANGE_COMPONENT);
        if (minRange != null && minRange instanceof BaseTransformation) {
            ((BaseTransformation)minRange).setInputTransform(transform);
        }
        if (maxRange != null && maxRange instanceof BaseTransformation) {
            ((BaseTransformation)maxRange).setInputTransform(transform);
        }
    }

    static {
        JavaScriptIncludeHandler.addAlias(BaseRange.class, "RANGE");
    }
}

