/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.olaptableview.html.features;

import com.sas.servlet.tbeans.features.DnDFeature;
import com.sas.servlet.tbeans.features.Feature;
import com.sas.servlet.tbeans.features.dnd.ZoneElement;
import com.sas.servlet.tbeans.features.dnd.ZoneInfo;
import com.sas.servlet.tbeans.olaptableview.html.OLAPTableView;
import com.sas.servlet.tbeans.tableview.ajax.AJAXTableController;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleElementType;
import com.sas.storage.olap.TupleInterface;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.Writer;

public class OLAPTableDnDFeature
extends DnDFeature
implements Feature {
    public static final String ROWS_ZONE = "Rows";
    public static final String COLUMNS_ZONE = "Columns";
    public static final String MEASURES_ZONE = "Measures";
    private OLAPTableView _olapTableView;
    private boolean _singleItemOnAxisDraggable = false;

    public OLAPTableDnDFeature(OLAPTableView olapTableView) {
        this._olapTableView = olapTableView;
        String[] zones = new String[]{COLUMNS_ZONE, ROWS_ZONE, MEASURES_ZONE};
        this.setDragZones(this.createZoneList(zones, true));
        this.setDropZones(this.createZoneList(zones, false));
        this.setZoneInfos(this.createZoneInfoList(zones));
        this.getDropZone(MEASURES_ZONE).setAcceptsFunction("sas_DnD_groupAccepts");
        this.initializeTypes(olapTableView.getId());
        this.setStartDragFunction("sas_DnD_dim");
        this.setEndDragFunction("sas_DnD_undim");
    }

    public void initializeTypes(String base) {
        String di = base + "_dataitem";
        String m = base + "_measure";
        String[] diZones = new String[]{COLUMNS_ZONE, ROWS_ZONE};
        String[] mZones = new String[]{MEASURES_ZONE};
        String[] dis = new String[]{"_dataitem", di, "_measure", m};
        String[] ms = new String[]{"_measure", m};
        this.setTypes(diZones, di, dis);
        this.setTypes(mZones, m, ms);
    }

    @Override
    public void write(HttpServletRequest request, Writer out) throws IOException {
        JavaScriptIncludeHandler.writeIncludes(out, "AJAX", request);
        AJAXTableController.writeFastClickProtection(out, request, false);
        OLAPDataSetInterface model = this._olapTableView.getModel();
        this.fillZones(model);
        super.write(request, out, this._olapTableView.getId());
    }

    private void fillZones(OLAPDataSetInterface model) {
        try {
            ResultSetMetadataInterface meta = model.getResultSetMetadata();
            AxisInterface[] axes = meta.getAxes(0, 2);
            this.fillZone(this.getZoneInfo(COLUMNS_ZONE), axes[0], true);
            this.fillZone(this.getZoneInfo(ROWS_ZONE), axes[1], false);
            this.fillMeasuresZone(meta);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fillZone(ZoneInfo zone, AxisInterface axis, boolean columns) throws OLAPException {
        String[] headers = axis.getDimensionNames();
        if (headers == null) {
            return;
        }
        for (int i = 0; i < headers.length; ++i) {
            ZoneElement ze = this.buildTitleZoneElement(zone, axis, headers, i, columns);
            if (headers.length == 1 && !this.isSingleItemOnAxisDraggable()) {
                ze.addProperty("dragEnabled", "false");
            }
            this.addToTitleZoneElement(ze, axis, headers, i, columns);
        }
    }

    protected ZoneElement buildTitleZoneElement(ZoneInfo zone, AxisInterface axis, String[] headers, int i, boolean columns) throws OLAPException {
        String header = headers[i];
        ZoneElement ze = this.addTitleZoneElement(zone, i, header, columns);
        int left = this.findFirstHeader(headers, header);
        int right = this.findLastHeader(headers, header);
        if (left != i || right != i) {
            ze.addProperty("extendNodeLeft", this.calculateTitleId(left, columns));
            ze.addProperty("extendNodeRight", this.calculateTitleId(right, columns));
        }
        ze.addProperty("label", axis.getAxisHeaders()[i]);
        return ze;
    }

    protected void addToTitleZoneElement(ZoneElement zoneElement, AxisInterface axis, String[] headers, int i, boolean columns) {
    }

    private int findFirstHeader(String[] headers, String header) {
        for (int i = 0; i < headers.length; ++i) {
            String newheader = headers[i];
            if (!newheader.equals(header)) continue;
            return i;
        }
        return -1;
    }

    private int findLastHeader(String[] headers, String header) {
        for (int i = headers.length - 1; i >= 0; --i) {
            String newheader = headers[i];
            if (!newheader.equals(header)) continue;
            return i;
        }
        return -1;
    }

    private void fillMeasuresZone(ResultSetMetadataInterface meta) throws OLAPException {
        this.fillMeasuresZone(meta, 0);
        this.fillMeasuresZone(meta, 1);
    }

    private void fillMeasuresZone(ResultSetMetadataInterface meta, int axis) throws OLAPException {
        ZoneInfo zone = this.getZoneInfo(MEASURES_ZONE);
        int start = axis == 0 ? this._olapTableView.getStartColumn() : this._olapTableView.getStartRow();
        int end = axis == 0 ? this._olapTableView.getEndColumn() : this._olapTableView.getEndRow();
        int count = end - start + 1;
        if (start < 0 || count <= 0) {
            return;
        }
        TupleInterface[] tuples = meta.getTuples(axis, start, count);
        if (start < 0) {
            return;
        }
        for (int i = 0; i < tuples.length; ++i) {
            TupleInterface tuple = tuples[i];
            TupleElementInterface[] tes = tuple.getElements(0, -1);
            boolean found = false;
            for (int j = 0; j < tes.length; ++j) {
                TupleElementInterface te = tes[j];
                if (te.getType() != TupleElementType.MEASURE) continue;
                ZoneElement ze = this.buildMeasureZoneElement(zone, te, axis == 0);
                this.addToMeasureZoneElement(ze, te, axis == 0);
                found = true;
            }
            if (found) continue;
            return;
        }
    }

    protected ZoneElement buildMeasureZoneElement(ZoneInfo zone, TupleElementInterface tupleElement, boolean columns) throws OLAPException {
        int i = tupleElement.getTuple().getTupleIndex();
        int j = tupleElement.getTupleElementIndex();
        ZoneElement ze = this.addHeaderZoneElement(zone, i, j, "$" + tupleElement.getLabel(), columns);
        if (j > 0) {
            TupleElementInterface parentTupleElement = tupleElement.getTuple().getElement(j - 1);
            ze.addProperty("group", Integer.toString(parentTupleElement.getMinimumCoordinate()));
        }
        ze.addProperty("label", tupleElement.getLabel());
        return ze;
    }

    protected void addToMeasureZoneElement(ZoneElement zoneElement, TupleElementInterface tupleElement, boolean columns) {
    }

    private ZoneElement addTitleZoneElement(ZoneInfo zone, int i, String header, boolean columns) {
        String orientation = this.calculateOrientation(!columns);
        String id = this.calculateTitleId(i, columns);
        String axis = columns ? "0" : "1";
        ZoneElement ze = this.createZoneElement(zone, id, axis, header, orientation);
        return ze;
    }

    private String calculateTitleId(int i, boolean columns) {
        String suffix = columns ? "_ct" : "_rt";
        String id = this._olapTableView.getId() + suffix + i;
        return id;
    }

    private ZoneElement addHeaderZoneElement(ZoneInfo zone, int i, int j, String header, boolean columns) {
        String orientation = this.calculateOrientation(columns);
        String id = this.calculateHeaderId(i, j, columns);
        String axis = columns ? "0" : "1";
        return this.createZoneElement(zone, id, axis, header, orientation);
    }

    private String calculateHeaderId(int i, int j, boolean columns) {
        String suffix = columns ? "_c" : "_r";
        String id = this._olapTableView.getId() + suffix + j + "_" + i;
        return id;
    }

    private ZoneElement createZoneElement(ZoneInfo zone, String id, String axis, String name, String orientation) {
        ZoneElement element = new ZoneElement(id, name, orientation);
        zone.addElement(element);
        element.addProperty("axis", axis);
        return element;
    }

    public OLAPTableView getOLAPTableView() {
        return this._olapTableView;
    }

    public void setOLAPTableView(OLAPTableView olapTableView) {
        this._olapTableView = olapTableView;
    }

    public boolean isSingleItemOnAxisDraggable() {
        return this._singleItemOnAxisDraggable;
    }

    public void setSingleItemOnAxisDraggable(boolean singleItemOnAxisDraggable) {
        this._singleItemOnAxisDraggable = singleItemOnAxisDraggable;
    }
}

