/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.olaptableview.html.features;

import com.sas.dataselectors.dataitems.OLAPTableRoles;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.Role;
import com.sas.servlet.tbeans.BaseTransformation2;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.olaptableview.html.features.BQOLAPDnDDataModel;
import com.sas.servlet.tbeans.olaptableview.html.features.BeanWrapper;
import com.sas.servlet.tbeans.olaptableview.html.features.ItemMatcher;
import com.sas.servlet.tbeans.olaptableview.html.features.OLAPBeanWrapper;
import com.sas.servlet.tbeans.olaptableview.html.features.OLAPDnDDataModel;
import com.sas.servlet.tbeans.olaptableview.html.features.OLAPRolesDnDDataModel;
import com.sas.servlet.tbeans.tableview.ajax.AJAXPacket;
import com.sas.storage.iquery.BusinessQueryToOLAPDataSetAdapter;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.fs.ServicesLogFactory;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class OLAPDnDAction {
    OLAPDnDDataModel _model;
    private String[] _sourceItemIds;
    private String _sourceHeader;
    private String _sourceAxis;
    private String _targetHeader;
    private String _targetAxis;
    private String _placement;
    private List _allItems;
    private List _selectedItems;
    private List _targetAxisItems;
    private Role _targetRole;

    public OLAPDnDAction(BusinessQueryToOLAPDataSetAdapter dataset) {
        this(new BQOLAPDnDDataModel(dataset));
    }

    public OLAPDnDAction(OLAPDnDDataModel model) {
        this._model = model;
    }

    public OLAPDnDDataModel update(HttpServletRequest request) throws Exception {
        this.parseParameters(request);
        return this.update();
    }

    private void parseParameters(HttpServletRequest request) {
        this._sourceItemIds = request.getParameterValues("sourceDII");
        this._sourceHeader = request.getParameter("sourceHeader");
        this._sourceAxis = request.getParameter("sourceAxis");
        this._targetHeader = request.getParameter("header");
        this._targetAxis = request.getParameter("axis");
        this._targetRole = this._targetAxis.equals("1") ? Role.ROW : Role.COLUMN;
        this._placement = request.getParameter("isBefore");
    }

    private void buildItemLists() throws MetadataException {
        this._allItems = this._model.getAvailableItems();
        this._selectedItems = this._model.getSelectedItems();
        this._targetAxisItems = this._model.getItems(this._targetRole);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OLAPDnDDataModel update() throws Exception {
        List buCols = this._model.getItems(Role.COLUMN);
        List buRows = this._model.getItems(Role.ROW);
        List buBg = this._model.getItems(Role.BACKGROUND);
        boolean completed = false;
        try {
            this.baseUpdate();
            completed = true;
        }
        finally {
            if (!completed) {
                this._model.removeItems(this._model.getSelectedItems());
                this._model.addItems(buCols, Role.COLUMN);
                this._model.addItems(buRows, Role.ROW);
                this._model.addItems(buBg, Role.BACKGROUND);
                this._model.refreshModel();
            }
        }
        return this._model;
    }

    public OLAPDnDDataModel baseUpdate() throws Exception {
        ArrayList sourceItems;
        boolean isBefore = !"false".equals(this._placement);
        this.buildItemLists();
        int targetIndex = this.findTargetIndex(isBefore);
        this._model.removeItems(this._targetAxisItems);
        if ("CENTER".equals(this._placement) && targetIndex >= 0) {
            this._targetAxisItems.remove(targetIndex);
        }
        if ((targetIndex = this.removeAllSourceItems(sourceItems = new ArrayList(), targetIndex)) >= 0) {
            this._targetAxisItems.addAll(targetIndex, sourceItems);
        } else if (!"REMOVE".equals(this._targetHeader)) {
            this._targetAxisItems.addAll(sourceItems);
        }
        this._model.addItems(this._targetAxisItems, this._targetRole);
        this._model.refreshModel();
        return this._model;
    }

    private int[] findMeasures(List sourceItems) {
        int[] loc = new int[2];
        boolean foundFirst = false;
        for (int i = 0; i < sourceItems.size(); ++i) {
            Object di = sourceItems.get(i);
            if (this._model.isMeasure(di)) {
                if (!foundFirst) {
                    foundFirst = true;
                    loc[0] = i;
                }
                loc[1] = i + 1;
                continue;
            }
            if (foundFirst) break;
        }
        if (!foundFirst) {
            return null;
        }
        return loc;
    }

    private int removeAllSourceItems(List sourceItems, int targetIndex) throws MetadataException {
        this.findSourceItemsById(sourceItems, targetIndex);
        this.findSourceItemsByHeader(sourceItems);
        for (int i = 0; i < sourceItems.size(); ++i) {
            Object item = sourceItems.get(i);
            targetIndex = this.removeSourceItem(item, targetIndex);
        }
        return targetIndex;
    }

    private void findSourceItemsById(List sourceItems, int targetIndex) {
        if (this._sourceItemIds == null) {
            return;
        }
        ArrayList<Object> measures = new ArrayList<Object>();
        int measuresPos = -1;
        for (int i = 0; i < this._sourceItemIds.length; ++i) {
            String sourceItemId = this._sourceItemIds[i];
            Object sourceItem = this._model.findItemById(sourceItemId, this._allItems);
            if (this._model.isMeasure(sourceItem)) {
                measures.add(sourceItem);
                measuresPos = sourceItems.size();
                continue;
            }
            sourceItems.add(sourceItem);
        }
        if ("REMOVE".equals(this._targetHeader)) {
            sourceItems.addAll(0, measures);
            return;
        }
        int addMeasuresAt = this.calculateMeasureAdjacency(targetIndex);
        if (addMeasuresAt == 1) {
            sourceItems.addAll(0, measures);
        } else if (addMeasuresAt == -1) {
            sourceItems.addAll(measures);
        } else if (addMeasuresAt == 2 && sourceItems.size() == 0) {
            sourceItems.addAll(measures);
        } else if (measuresPos >= 0) {
            this.insertWithAllMeasures(measures, sourceItems, measuresPos);
        }
    }

    private int calculateMeasureAdjacency(int targetIndex) {
        int[] targetMeasuresLoc = this.findMeasures(this._targetAxisItems);
        int addMeasuresAt = 0;
        if (targetMeasuresLoc != null) {
            if (targetIndex == targetMeasuresLoc[0]) {
                addMeasuresAt = -1;
            } else if (targetIndex == targetMeasuresLoc[1]) {
                addMeasuresAt = 1;
            } else if (targetIndex > targetMeasuresLoc[0] && targetIndex < targetMeasuresLoc[1]) {
                addMeasuresAt = 2;
            }
        }
        return addMeasuresAt;
    }

    private void insertWithAllMeasures(List measures, List sourceItems, int pos) {
        List allMeasures = this.findAllMeasures();
        for (int i = 0; i < allMeasures.size(); ++i) {
            Object item = allMeasures.get(i);
            measures.remove(item);
        }
        sourceItems.addAll(pos, allMeasures);
        sourceItems.addAll(pos, measures);
    }

    private void findSourceItemsByHeader(List sourceItems) {
        if (this._sourceHeader != null) {
            Object sourceItem = this.findItemByDimension(this._sourceHeader, this._selectedItems);
            if (sourceItem == null) {
                sourceItem = this.findItemByDimension(this._sourceHeader, this._allItems);
            }
            if (!"REMOVE".equals(this._targetHeader) && !this.isMeasureItem(this._targetHeader) && this._model.isMeasure(sourceItem)) {
                sourceItems.addAll(this.findAllMeasures());
            } else {
                sourceItems.add(sourceItem);
            }
        }
    }

    private List findAllMeasures() {
        ArrayList list = new ArrayList();
        for (int i = 0; i < this._selectedItems.size(); ++i) {
            Object item = this._selectedItems.get(i);
            if (!this._model.isMeasure(item)) continue;
            list.add(item);
        }
        return list;
    }

    private int removeSourceItem(Object sourceItem, int targetIndex) throws MetadataException {
        int oldIndex = this._targetAxisItems.indexOf(sourceItem);
        if (oldIndex >= 0 && targetIndex >= 0 && oldIndex < targetIndex) {
            --targetIndex;
        }
        if (oldIndex != -1) {
            this._targetAxisItems.remove(oldIndex);
        } else if (this._selectedItems.contains(sourceItem)) {
            this._model.removeItem(sourceItem);
        }
        return targetIndex;
    }

    private int findTargetIndex(boolean isBefore) throws MetadataException {
        int targetIndex = -1;
        if ("REMOVE".equals(this._targetHeader)) {
            return -1;
        }
        targetIndex = this.findItemIndex(this._targetHeader, this._targetAxisItems);
        if (targetIndex < 0) {
            targetIndex = this.findTargetOtherAxis();
        }
        if (targetIndex >= 0) {
            targetIndex = this.skipMeasures(isBefore, targetIndex);
        }
        return targetIndex;
    }

    private int skipMeasures(boolean isBefore, int targetIndex) {
        List items = this._targetAxisItems;
        if (!isBefore) {
            targetIndex = this.isMeasureDimension(this._targetHeader) ? this.skipMeasures(targetIndex, items) : ++targetIndex;
        }
        return targetIndex;
    }

    protected boolean isMeasureDimension(String header) {
        return "Measures".equals(header);
    }

    protected boolean isMeasureItem(String header) {
        return header.startsWith("$");
    }

    protected String convertMeasureItem(String header) {
        return header.substring(1);
    }

    private int skipMeasures(int i, List items) {
        Object item;
        while (++i < items.size() && this._model.isMeasure(item = items.get(i))) {
        }
        return i;
    }

    private int findTargetOtherAxis() throws MetadataException {
        Role crossRole = this._targetRole == Role.COLUMN ? Role.ROW : Role.COLUMN;
        List crossItems = this._model.getItems(crossRole);
        int targetIndex = this.findItemIndex(this._targetHeader, crossItems);
        if (targetIndex >= 0) {
            this._targetRole = crossRole;
            this._targetAxisItems = crossItems;
        }
        return targetIndex;
    }

    private Object findItemByDimension(String sourceHeader, List allItems) {
        int index = this.findItemIndex(sourceHeader, allItems);
        return allItems.get(index);
    }

    private int findItemIndex(String header, List items) {
        boolean isMeasure = this.isMeasureItem(header);
        return isMeasure ? this._model.findMeasureIndex(this.convertMeasureItem(header), items) : this._model.findDimensionIndex(header, items);
    }

    public ItemMatcher getDimensionMatcher() {
        return this._model.getDimensionMatcher();
    }

    public void setDimensionMatcher(ItemMatcher dimensionMatcher) {
        this._model.setDimensionMatcher(dimensionMatcher);
    }

    public ItemMatcher getMeasureMatcher() {
        return this._model.getMeasureMatcher();
    }

    public void setMeasureMatcher(ItemMatcher measureMatcher) {
        this._model.setMeasureMatcher(measureMatcher);
    }

    public ItemMatcher getItemByIdMatcher() {
        return this._model.getItemByIdMatcher();
    }

    public void setItemByIdMatcher(ItemMatcher itemByIdMatcher) {
        this._model.setItemByIdMatcher(itemByIdMatcher);
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("OLAPDnDAction").append(this._sourceHeader).append("/").append(this._sourceAxis);
        str.append(", [");
        for (int i = 0; i < this._sourceItemIds.length; ++i) {
            if (i != 0) {
                str.append(",");
            }
            str.append(this._sourceItemIds[i]);
        }
        str.append("] to ").append(this._placement).append(" target: ").append(this._targetHeader).append("/").append(this._targetAxis);
        return str.toString();
    }

    public String[] getSourceItemId() {
        return this._sourceItemIds;
    }

    public void setSourceItemId(String[] sourceItemIds) {
        this._sourceItemIds = sourceItemIds;
    }

    public String getSourceHeader() {
        return this._sourceHeader;
    }

    public void setSourceHeader(String sourceHeader) {
        this._sourceHeader = sourceHeader;
    }

    public String getSourceAxis() {
        return this._sourceAxis;
    }

    public void setSourceAxis(String sourceAxis) {
        this._sourceAxis = sourceAxis;
    }

    public String getTargetHeader() {
        return this._targetHeader;
    }

    public void setTargetHeader(String targetHeader) {
        this._targetHeader = targetHeader;
    }

    public String getTargetAxis() {
        return this._targetAxis;
    }

    public void setTargetAxis(String targetAxis) {
        this._targetAxis = targetAxis;
    }

    public String getPlacement() {
        return this._placement;
    }

    public void setPlacement(String placement) {
        this._placement = placement;
    }

    public OLAPDataSetInterface getDataSet() {
        if (this._model instanceof BQOLAPDnDDataModel) {
            return ((BQOLAPDnDDataModel)this._model).getDataSet();
        }
        if (this._model instanceof OLAPRolesDnDDataModel) {
            OLAPRolesDnDDataModel model = (OLAPRolesDnDDataModel)this._model;
            if (model.getModel() instanceof OLAPDataSetInterface) {
                return (OLAPDataSetInterface)model.getModel();
            }
            return model.getDataSet();
        }
        return null;
    }

    private static CommonLoggerInterface getLogger() {
        return OLAPDnDAction.getLogger(OLAPDnDAction.class);
    }

    private static CommonLoggerInterface getLogger(Class clazz) {
        CommonLoggerInterface log = LoggerRepository2.getLogger((String)clazz.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory());
        return log;
    }

    public static void servletInvocationMethod(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session;
        Object tbeanObj;
        String id = request.getParameter("id");
        if (id.endsWith("_otv")) {
            id = id.substring(0, id.length() - 4);
        }
        if ((tbeanObj = (session = request.getSession()).getAttribute(id)) == null) {
            String str = "Component with id " + id + " not found on the session";
            OLAPDnDAction.getLogger().warn(str);
            throw new NullPointerException();
        }
        OLAPDnDAction.handleAction(request, response, tbeanObj);
    }

    public static void handleAction(HttpServletRequest request, HttpServletResponse response, Object tbeanObj) throws Exception, IOException {
        OLAPBeanWrapper wrapper = (OLAPBeanWrapper)BeanWrapper.create(tbeanObj);
        BusinessQueryToOLAPDataSetAdapter model = (BusinessQueryToOLAPDataSetAdapter)wrapper.getModel();
        OLAPRolesDnDDataModel dndModel = (OLAPRolesDnDDataModel)request.getSession().getAttribute("dndmodel");
        if (dndModel == null) {
            OLAPTableRoles roles = new OLAPTableRoles(model.getBusinessQuery());
            roles.addRole("column", "Columns", "Columns", 1, 0);
            roles.addRole("row", "Rows", "Rows", 1, 0);
            BusinessQuery bq = model.getBusinessQuery();
            List items = bq.getResultItems(Role.COLUMN);
            roles.getRoles()[0].addRoleItems(items);
            items = bq.getResultItems(Role.ROW);
            roles.getRoles()[1].addRoleItems(items);
            dndModel = new OLAPRolesDnDDataModel(roles, model);
        }
        OLAPDnDAction action = new OLAPDnDAction(dndModel);
        action.update(request);
        if (action.getDataSet() != null) {
            wrapper.setModel(action.getDataSet());
        }
        wrapper.setRequest(request);
        AJAXPacket packet = new AJAXPacket();
        String html = OLAPDnDAction.generateEntireTable(wrapper.getBean());
        packet.add(html, "type", "table");
        String otvid = wrapper.getContainerId();
        packet.set("containerId", otvid);
        packet.send(response);
    }

    private static String generateEntireTable(TransformationInterface _table) throws IOException {
        StringWriter strOut = new StringWriter();
        PrintWriter strPrintWriter = new PrintWriter(strOut);
        if (_table instanceof BaseTransformation2) {
            BaseTransformation2 table2 = (BaseTransformation2)_table;
            table2.writePartialRefresh(table2.getRequest(), table2.getResponse(), strPrintWriter);
        } else {
            _table.write(strPrintWriter);
        }
        String html = strOut.toString();
        return html;
    }
}

