/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.olaptableview.html;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.BaseActionCompositeTransformation;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.dataselectors.html.RelationalMenuBar;
import com.sas.servlet.tbeans.form.html.ChoiceBox;
import com.sas.servlet.tbeans.html.Button;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.models.JavaScriptNode;
import com.sas.servlet.tbeans.olaptableview.html.RB;
import com.sas.servlet.tbeans.olaptableview.html.ShowDetailDataCompositeKeysInterface;
import com.sas.servlet.tbeans.olaptableview.html.ShowDetailDataCompositeStyleKeysInterface;
import com.sas.servlet.tbeans.tableview.html.TableView;
import com.sas.servlet.tbeans.tableview.html.TableViewComposite;
import com.sas.servlet.util.ComponentSessionManager;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.storage.jdbc.JDBCToTableModelAdapter;
import com.sas.util.MapWithDefaults;
import com.sas.util.Util;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.table.TableModel;

@SASScope(value="ALL")
public class ShowDetailDataComposite
extends BaseActionCompositeTransformation
implements ShowDetailDataCompositeKeysInterface,
ShowDetailDataCompositeStyleKeysInterface {
    static final String RB_KEY = "ShowDetailDataComposite.";
    private static final String JAVASCRIPT_INCLUDES = "JAVASCRIPT_INCLUDES";
    @SASScope
    public static final String DEFAULT_TEMPLATE_FILE_NAME = "ShowDetail.html";
    private TableModel dataModel;
    private Label titleLabel;
    private Label columnHeadersLabel;
    private ChoiceBox columnHeadersChoice;
    private boolean inErrorState;
    private static final ImmutableStyleInfo SDDLabelStyle = new ImmutableStyleInfo("selectorLabel");
    private static final ImmutableStyleInfo SDDChoiceBoxStyle = new ImmutableStyleInfo("selectorChoice");
    private static final HashMap defaultStyleMap = new HashMap();

    private static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0) {
            defaultStyleMap.put("SHOWDETAIL_TABLE_CONTAINER_STYLE", new ImmutableStyleInfo("ShowDetailTableContainer"));
            defaultStyleMap.put("SHOWDETAIL_COLUMN_HEADERS_LABEL_STYLE", SDDLabelStyle);
            defaultStyleMap.put("SHOWDETAIL_COLUMN_HEADERS_CHOICE_STYLE", SDDChoiceBoxStyle);
        }
    }

    public ShowDetailDataComposite() {
        this.setId(Util.getName((String)"sdd"));
        TableViewComposite tvc = new TableViewComposite();
        tvc.setId(this.getId() + "_tvc");
        RelationalMenuBar mb = (RelationalMenuBar)tvc.getComponent("TABLEVIEW_MENUBAR");
        mb.setVisible(true);
        TableView tv = (TableView)tvc.getComponent("TABLEVIEW_TABLEDATA");
        tv.setActionSupportType("SHOWDETAILDATA_TABLEVIEW_SUPPORT");
        tv.setRowPageSize(20);
        tv.setColumnPageSize(8);
        tv.setActionVisible("MOVE_COLUMN_LEFT_ACTION", "COLUMN_HEADER_AREA", false);
        tv.setActionVisible("MOVE_COLUMN_RIGHT_ACTION", "COLUMN_HEADER_AREA", false);
        tv.setActionVisible("SIMPLE_CALCULATED_ITEM_SELECTOR_ACTION", "COLUMN_HEADER_AREA", false);
        tv.setActionVisible("EXPORT_TO_ACTION", "COLUMN_HEADER_AREA", false);
        Map styleMap = tv.getStyleMap();
        styleMap.put("TABLEVIEW_ROW_HEADER_STYLE", new StyleInfo("showDetailTableRowHeader"));
        styleMap.put("TABLEVIEW_COLUMN_HEADER_STYLE", new StyleInfo("showDetailTableColumnHeader"));
        ShowDetailDataComposite.setupDefaultStyleMap();
        ((MapWithDefaults)this.getStyleMap()).setDefaultMap((Map)defaultStyleMap);
        this.setComponent("SHOWDETAIL_TABLEVIEW_COMPOSITE", tvc);
        this.setTemplateKey("Show_Detail");
        this.titleLabel = new Label(RB.getStringResource(RB_KEY, "windowTitle.txt", this.getLocale()));
        this.titleLabel.setId(this.getId() + "_title");
        this.setComponent("SHOWDETAIL_WINDOW_TITLE", this.titleLabel);
        this.columnHeadersLabel = new Label(RB.getStringResource(RB_KEY, "columnHeadersLabel.txt", this.getLocale()));
        this.columnHeadersLabel.setId(this.getId() + "_chl");
        this.columnHeadersLabel.setStyleInfo(SDDLabelStyle);
        this.setComponent("SHOWDETAIL_COLUMN_HEADERS_LABEL", this.columnHeadersLabel);
        this.columnHeadersChoice = new ChoiceBox();
        this.columnHeadersChoice.setId(this.getId() + "_chc");
        this.columnHeadersChoice.setStyleInfo(SDDChoiceBoxStyle);
        this.columnHeadersChoice.setModel(this.getColumnHeadersChoiceModel());
        this.columnHeadersChoice.setOnChange("sas.showdetail.columnHeadersChanged();");
        this.setComponent("SHOWDETAIL_COLUMN_HEADERS_CHOICE", this.columnHeadersChoice);
        Button closeButton = new Button();
        closeButton.setVisible(false);
        closeButton.setOnClick("window.close()");
        this.setComponent("SHOWDETAIL_ERROR_BUTTON", closeButton);
        this.addItemsToTemplateDictionaryMap();
        super.setLocaleDependentProperties(this.getLocale());
        this._setLocaleDependentProperties(this.getLocale());
    }

    @Override
    protected void setLocaleDependentProperties(Locale locale) {
        super.setLocaleDependentProperties(locale);
        this._setLocaleDependentProperties(locale);
    }

    private void _setLocaleDependentProperties(Locale currentLocale) {
        this.titleLabel = (Label)this.getComponent("SHOWDETAIL_WINDOW_TITLE");
        this.titleLabel.setText(RB.getStringResource(RB_KEY, "windowTitle.txt", currentLocale));
        Button closeButton = (Button)this.getComponent("SHOWDETAIL_ERROR_BUTTON");
        if (closeButton != null) {
            closeButton.setLabel(RB.getStringResource(RB_KEY, "closeButton.txt", currentLocale));
        }
    }

    protected ComboBoxModel getColumnHeadersChoiceModel() {
        DefaultComboBoxModel<JavaScriptNode> comboModel = new DefaultComboBoxModel<JavaScriptNode>();
        JavaScriptNode item = new JavaScriptNode();
        item.setText(RB.getStringResource(RB_KEY, "columnLabelsChoice.txt", this.getLocale()));
        item.setValue("LABEL");
        comboModel.addElement(item);
        item = new JavaScriptNode();
        item.setText(RB.getStringResource(RB_KEY, "columnNamesChoice.txt", this.getLocale()));
        item.setValue("NAME");
        comboModel.addElement(item);
        return comboModel;
    }

    protected void addItemsToTemplateDictionaryMap() {
        HashMap<String, String> dMap = this.getTemplateDictionary();
        if (dMap == null || !dMap.containsKey("SHOWDETAIL_COLUMN_HEADERS_CHOICE_DIV_STYLE")) {
            if (dMap == null) {
                dMap = new HashMap<String, String>();
            }
            if (!dMap.containsKey("SHOWDETAIL_COLUMN_HEADERS_CHOICE_DIV_STYLE")) {
                dMap.put("SHOWDETAIL_COLUMN_HEADERS_CHOICE_DIV_STYLE", "display:;");
            }
            if (dMap.size() > 0) {
                this.setTemplateDictionary(dMap);
            }
        }
    }

    public TableModel getModel() {
        return this.dataModel;
    }

    public void setModel(TableModel tableModel) {
        if (this.dataModel != tableModel) {
            this.dataModel = tableModel;
            TransformationInterface o = this.getComponent("SHOWDETAIL_TABLEVIEW_COMPOSITE");
            if (o != null && o instanceof TableViewComposite) {
                ((TableViewComposite)o).setModel(this.dataModel);
            }
        }
    }

    private void writeFastClickProtection(Writer out) throws IOException {
        out.write(JavaScriptIncludeHandler.getStartScript());
        out.write(" if ( window.sas_FastClick_createFastClickManager && typeof sas_FastClick_createFastClickManager == 'function' ) \n");
        out.write(" { ");
        out.write(" sas_FastClick_createFastClickManager();\n");
        out.write(" }\n ");
        out.write(JavaScriptIncludeHandler.getEndScript(null));
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        HashMap<String, String> dictionary;
        HttpServletRequest request = this.getRequest();
        StringWriter strWriter = new StringWriter();
        JavaScriptIncludeHandler.writeIncludes(strWriter, "AJAX", request);
        JavaScriptIncludeHandler.writeIncludes(strWriter, "FASTCLICKPROTECTION", request);
        JavaScriptIncludeHandler.writeIncludes(strWriter, "SHOWDETAIL", request);
        this.writeFastClickProtection(strWriter);
        this.setInErrorState(false);
        this.setShowDetailJSObject(strWriter, request);
        if (this.dataModel instanceof JDBCToTableModelAdapter) {
            this.columnHeadersChoice.setSelectedItem(((JDBCToTableModelAdapter)this.dataModel).getColumnInfoUsed());
        }
        if ((dictionary = this.getTemplateDictionary()) == null) {
            dictionary = new HashMap<String, String>();
        }
        dictionary.put(JAVASCRIPT_INCLUDES, strWriter.toString());
        if (this.isPartialRefreshActionsEnabled() && request != null) {
            ComponentSessionManager.getSessionManager(request).put(this.getId(), this);
        }
        super.write(out);
        this.writeTemplate(this, null, out);
    }

    private void setShowDetailJSObject(Writer out, HttpServletRequest request) throws IOException {
        TableView tv;
        out.write(JavaScriptIncludeHandler.getStartScript());
        out.write("\nsas.showdetail.url='" + this.getAJAXControllerURL() + "';");
        out.write("\nsas.showdetail.apname='" + request.getParameterValues("APNAME")[0] + "';");
        out.write("\nsas.showdetail.classParameter='" + request.getParameterValues("CLASS_PARAMETER")[0] + "';");
        TableViewComposite tvc = (TableViewComposite)this.getComponent("SHOWDETAIL_TABLEVIEW_COMPOSITE");
        if (tvc != null && (tv = (TableView)tvc.getComponent("TABLEVIEW_TABLEDATA")) != null) {
            out.write("\nsas.showdetail.containerId='" + tv.getContainerId() + "';");
        }
        out.write(JavaScriptIncludeHandler.getEndScript(null));
    }

    @SASScope
    public boolean isInErrorState() {
        return this.inErrorState;
    }

    @SASScope
    public void setInErrorState(boolean inErrorState) {
        this.inErrorState = inErrorState;
    }
}

