/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.olaptableview.html;

import com.sas.actionprovider.ActionList;
import com.sas.actionprovider.ActionProviderViewInterface;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.HttpActionProvider;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.codepolicy.SASScope;
import com.sas.entities.AttributeSetException;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemExtendedType;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.rpf.ContextInterface;
import com.sas.rpf.Rule;
import com.sas.rpf.RuleEngine;
import com.sas.rpf.TargetInterface;
import com.sas.rpf.data.DataVector;
import com.sas.rpf.data.DataVectorInterface;
import com.sas.rpf.data.MissingValue;
import com.sas.rpf.data.ValueInterface;
import com.sas.rpf.data.Variable;
import com.sas.rpf.expr.EvaluateException;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.ComplexStyleInterface;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.StyleInterface;
import com.sas.servlet.tbeans.form.BaseFormElement;
import com.sas.servlet.tbeans.form.html.Form;
import com.sas.servlet.tbeans.form.html.FormViewInterface;
import com.sas.servlet.tbeans.form.html.Hidden;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.olaptableview.BaseOLAPTableView;
import com.sas.servlet.tbeans.olaptableview.OLAPTableArea;
import com.sas.servlet.tbeans.olaptableview.html.DefaultOLAPTableDataCellRenderer;
import com.sas.servlet.tbeans.olaptableview.html.DefaultOLAPTableLabelCellRenderer;
import com.sas.servlet.tbeans.olaptableview.html.OLAPTableViewStyleKeysInterface;
import com.sas.servlet.tbeans.olaptableview.html.RB;
import com.sas.servlet.tbeans.tableview.ExportAsHyperlinkInterface;
import com.sas.servlet.tbeans.tableview.TableCellContentsRenderer;
import com.sas.servlet.tbeans.tableview.TableCellRenderer;
import com.sas.servlet.tbeans.tableview.TableViewActionSupportFilter;
import com.sas.servlet.tbeans.tableview.html.BaseTableCell;
import com.sas.servlet.tbeans.tableview.html.HtmlTableViewUtil;
import com.sas.servlet.tbeans.tableview.html.ResizingUtil;
import com.sas.servlet.tbeans.tableview.rpf.RulesUtil;
import com.sas.servlet.tbeans.tableview.rpf.html.ConditionTableCellRenderer;
import com.sas.servlet.util.BaseUtil;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.storage.iquery.BusinessQueryToOLAPDataSetAdapter;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleElementType;
import com.sas.storage.olap.TupleInterface;
import com.sas.swing.visuals.olaptableview.OLAPCellRendererManager;
import com.sas.swing.visuals.olaptableview.OLAPTableFormatArea;
import com.sas.util.MapWithDefaults;
import com.sas.util.Util;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@SASScope(value="ALL")
public class OLAPTableView
extends BaseOLAPTableView
implements ComplexStyleInterface,
OLAPTableViewStyleKeysInterface,
FormViewInterface,
ExportAsHyperlinkInterface {
    static final long serialVersionUID = -1052836188385029125L;
    static final String RB_KEY = "OLAPTableView.";
    static final String ID_LEVEL_DELIMIT = "_";
    static final String ID_DELIMIT = " ";
    private static final String baseAreaStyleClassPrefix = "OLAPTable_";
    private static final String[] areaStyleClassPrefixList = new String[5];
    private static String namePrefix = "otv";
    private boolean formEnabled;
    private DefaultOLAPTableDataCellRenderer dcr;
    private TableCellRenderer defaultHeaderRenderer;
    TableCellRenderer[] areaRenderers = new TableCellRenderer[OLAPTableArea.getAreas().length];
    @SASScope
    protected String[] rowLevelLabels;
    @SASScope
    protected TupleElementInterface[][] rowTupleElements;
    @SASScope
    protected String[] columnLevelLabels;
    @SASScope
    protected TupleElementInterface[][] columnTupleElements;
    private HashMap additionalParameters;
    private Form formObject;
    TableViewActionSupportFilter columnHeadersFilter;
    ActionSupportFilter columnTitleFilter;
    ActionSupportFilter rowTitleFilter;
    TableViewActionSupportFilter rowHeadersFilter;
    TableViewActionSupportFilter dataCellFilter;
    private Map cellRenderers;
    private OLAPCellRendererManager cellRendererManager;
    private int currentCellOrdinal;
    private String _currentAreaPrefix = null;
    private OLAPTableArea _currentArea = null;
    private TupleElementInterface _raggedTupleElement = null;
    private Map columnTupleIds;
    private Map rowTupleIds;
    private BaseTransformation _title;
    private BaseTransformation _footer;
    private int _headerIndex = -1;
    private TupleInterface _currentRowTuple = null;
    private TupleInterface _currentColumnTuple = null;
    private ResizingUtil _resizingUtil;
    private HashMap _resizedColumns = new HashMap();
    private StringBuffer smallTempBuffer;
    private CommonLoggerInterface log = null;
    protected List<String> columnHeaderDataItemsToNotEncode = null;
    protected List<String> rowHeaderDataItemsToNotEncode = null;
    protected String[] levelNames = null;
    private boolean toEncode = true;
    private static final HashMap defaultStyleMap = new HashMap();
    OLAPCellRendererManager headerCellRendererManager = new OLAPCellRendererManager();
    protected String currentMeasureUniqueName = null;
    protected Map cacheOfMeasureFormatsForExport = null;

    private static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0) {
            OLAPTableView.addDefaultStyle("OLAPTABLEVIEW_STYLE", "OLAPMainTable");
            OLAPTableView.addDefaultStyle("OLAPTABLEVIEW_COLUMN_HEADER_STYLE", "OLAPTableColumnHeader");
            OLAPTableView.addDefaultStyle("OLAPTABLEVIEW_COLUMN_MEASURE_HEADER_STYLE", "OLAPTableColumnMeasureHeader");
            OLAPTableView.addDefaultStyle("OLAPTABLEVIEW_COLUMN_TITLE_HEADER_STYLE", "OLAPTableColumnTitleHeader");
            OLAPTableView.addDefaultStyle("OLAPTABLEVIEW_ROW_HEADER_STYLE", "OLAPTableRowHeader");
            OLAPTableView.addDefaultStyle("OLAPTABLEVIEW_ROW_MEASURE_HEADER_STYLE", "OLAPTableRowMeasureHeader");
            OLAPTableView.addDefaultStyle("OLAPTABLEVIEW_ROW_TITLE_HEADER_STYLE", "OLAPTableRowTitleHeader");
            OLAPTableView.addDefaultStyle("OLAPTABLEVIEW_EMPTY_ROW_TITLE_HEADER_STYLE", "OLAPTableEmptyRowTitleHeader");
            OLAPTableView.addDefaultStyle("OLAPTABLEVIEW_RAGGED_COLUMN_HEADER_STYLE", "OLAPTableRaggedColumnHeader");
            OLAPTableView.addDefaultStyle("OLAPTABLEVIEW_RAGGED_ROW_HEADER_STYLE", "OLAPRaggedRow");
            OLAPTableView.addDefaultStyle("OLAPTABLEVIEW_RAGGED_LAST_ROW_HEADER_STYLE", "OLAPRaggedLastRow");
            OLAPTableView.addDefaultStyle("OLAPTABLEVIEW_DATA_STYLE", "OLAPTableData");
            OLAPTableView.addDefaultStyle("OLAPTABLEVIEW_EMPTY_DATA_STYLE", "emptyTableData");
            OLAPTableView.addDefaultStyle("OLAPTABLEVIEW_TOTALS_STYLE", "OLAPTableData OLAPTableTotalsData");
            OLAPTableView.addDefaultStyle("OLAPTABLEVIEW_SUBTOTALS_STYLE", "OLAPTableData OLAPTableSubtotalsData");
            OLAPTableView.addDefaultStyle("OLAPTABLEVIEW_TOTALS_ROW_HEADER_STYLE", "OLAPTableRowHeader OLAPTableTotalsHeader");
            OLAPTableView.addDefaultStyle("OLAPTABLEVIEW_SUBTOTALS_ROW_HEADER_STYLE", "OLAPTableRowHeader OLAPTableSubtotalsHeader");
            OLAPTableView.addDefaultStyle("OLAPTABLEVIEW_TOTALS_COLUMN_HEADER_STYLE", "OLAPTableColumnHeader OLAPTableTotalsHeader");
            OLAPTableView.addDefaultStyle("OLAPTABLEVIEW_SUBTOTALS_COLUMN_HEADER_STYLE", "OLAPTableColumnHeader OLAPTableSubtotalsHeader");
            OLAPTableView.addDefaultStyle("OLAPTABLEVIEW_TOTALS_FOR_EXPORT_TO_EXCEL_STYLE", "OLAPTableTotalsDataForExportToExcel");
            OLAPTableView.addDefaultStyle("OLAPTABLEVIEW_SUBTOTALS_FOR_EXPORT_TO_EXCEL_STYLE", "OLAPTableSubtotalsDataForExportToExcel");
            OLAPTableView.addDefaultStyle("OLAPTABLEVIEW_TOTALS_ROW_HEADER_FOR_EXPORT_TO_EXCEL_STYLE", "OLAPTableTotalsRowHeaderForExportToExcel");
            OLAPTableView.addDefaultStyle("OLAPTABLEVIEW_SUBTOTALS_ROW_HEADER_FOR_EXPORT_TO_EXCEL_STYLE", "OLAPTableSubtotalsRowHeaderForExportToExcel");
            OLAPTableView.addDefaultStyle("OLAPTABLEVIEW_TOTALS_COLUMN_HEADER_FOR_EXPORT_TO_EXCEL_STYLE", "OLAPTableTotalsColumnHeaderForExportToExcel");
            OLAPTableView.addDefaultStyle("OLAPTABLEVIEW_SUBTOTALS_COLUMN_HEADER_FOR_EXPORT_TO_EXCEL_STYLE", "OLAPTableSubtotalsColumnHeaderForExportToExcel");
            OLAPTableView.addDefaultStyle("OLAPTABLEVIEW_TITLE_ROW_STYLE", "OLAPTableTitleRow");
            OLAPTableView.addDefaultStyle("OLAPTABLEVIEW_FOOTER_ROW_STYLE", "OLAPTableFooterRow");
        }
    }

    private static void addDefaultStyle(String key, String classid) {
        defaultStyleMap.put(key, new ImmutableStyleInfo(classid));
    }

    public OLAPTableView() {
        this.setId(Util.getName((String)namePrefix));
        this.log = LoggerRepository2.getLogger((String)OLAPTableView.class.getPackage().getName(), null);
        OLAPTableView.setupDefaultStyleMap();
        ((MapWithDefaults)this.getStyleMap()).setDefaultMap((Map)defaultStyleMap);
        this.dcr = new DefaultOLAPTableDataCellRenderer();
        this.defaultHeaderRenderer = new DefaultOLAPTableLabelCellRenderer();
        this.formEnabled = false;
        this.additionalParameters = null;
        this.columnHeadersFilter = null;
        this.columnTitleFilter = null;
        this.rowTitleFilter = null;
        this.rowHeadersFilter = null;
        this.dataCellFilter = null;
        this.cellRenderers = new HashMap();
        this.cellRendererManager = new OLAPCellRendererManager();
        this.currentCellOrdinal = -1;
        this.rowTupleIds = new IdentityHashMap();
        this.columnTupleIds = new IdentityHashMap();
    }

    public OLAPTableView(String name, OLAPDataSetInterface model) {
        this();
        this.setId(name);
        this.setModel(model);
    }

    public OLAPTableView(String name, OLAPDataSetInterface model, HttpServletRequest request, HttpServletResponse response) {
        this(name, model);
        this.setResponse(response);
        this.setRequest(request);
    }

    @Override
    public void setModel(OLAPDataSetInterface model) {
        super.setModel(model);
        try {
            model.setLocale(this.getLocale());
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
    }

    @Override
    public void writeEmptyTable(PrintWriter out) throws IOException {
        HtmlTableViewUtil.writeEmptyTable(this, out);
    }

    @Override
    public void writeTableHeader(PrintWriter out) throws IOException {
        HtmlTableViewUtil.writeTableHeader(this, out);
        if (this.getTitleRenderer() != null) {
            this.writeSpanAll(out, this.getTitleRenderer(), this.getTitle(), "OLAPTABLEVIEW_TITLE_ROW_STYLE");
        } else if (this.getInternalTitle() != null) {
            this.writeSpanAll2(out, this.getInternalTitle());
        }
    }

    @Override
    @SASScope
    public int getColSpanAll() {
        int width = this.getColSpanAllIncludeRules();
        return width += this.rowLevelLabels.length;
    }

    private void writeSpanAll2(PrintWriter out, BaseTransformation title) {
        title.setRequest(this.getRequest());
        title.setResponse(this.getResponse());
        title.setLocale(this.getLocale());
        StringBuffer str = new StringBuffer("<tr><th colspan=\"");
        int width = this.getColSpanAllIncludeRules();
        str.append(this.rowLevelLabels.length + width);
        str.append("\"");
        StyleInfo titleStyle = this._getStyleInfo("OLAPTABLEVIEW_COLUMN_HEADER_STYLE");
        titleStyle.write(str, this.getStyleClassPrefix());
        str.append(">").append(title).append("</th></tr>");
        out.println(str);
    }

    private int getColSpanAllIncludeRules() {
        int width = this.getEndColumn() - this.getStartColumn() + 1;
        if (this.hasRules()) {
            if (!this.isMeasureOnColumns()) {
                List multiColumnRules = RulesUtil.getMultiColumnRules(this.getRulesContext());
                if (multiColumnRules.size() > 0) {
                    width *= 3;
                }
            } else {
                int colsWithMultiColumnRules = this.getMultiColumnRuleCount();
                if (colsWithMultiColumnRules > 0) {
                    int widthForMultiColumnRules = colsWithMultiColumnRules * 3;
                    int widthForOtherColumns = width - colsWithMultiColumnRules;
                    width = widthForMultiColumnRules + widthForOtherColumns;
                }
            }
        }
        return width;
    }

    private int getMultiColumnRuleCount() {
        int count = 0;
        for (int i = 0; i < this.columnTuples.length; ++i) {
            if (!this.isExtraColumnsRequiredForRules(this.columnTuples[i])) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void writeTableFooter(PrintWriter out) throws IOException {
        HashMap map;
        if (this.getFooterRenderer() != null) {
            this.writeSpanAll(out, this.getFooterRenderer(), this.getFooter(), "OLAPTABLEVIEW_FOOTER_ROW_STYLE");
        } else if (this.getInternalFooter() != null) {
            this.writeSpanAll2(out, this.getInternalFooter());
        }
        HtmlTableViewUtil.writeTableFooter(this, out);
        if (this.isFormEnabled()) {
            Form formObject = this.getFormObject();
            formObject.setRequest(this.getRequest());
            String newAction = BaseUtil.getDefaultFormAction(this);
            formObject.setAction(newAction);
            formObject.writeHeader(out);
        }
        if ((map = this.getAdditionalParameters()) != null && this.isFormEnabled()) {
            Set keys = map.keySet();
            for (String name : keys) {
                String value = (String)map.get(name);
                Hidden hidden = new Hidden(name, value);
                ((BaseFormElement)hidden).write(out);
            }
        }
        if (this.isFormEnabled()) {
            this.formObject.writeFooter(out);
        }
        if (this.isAllActionsVisible()) {
            JavaScriptIncludeHandler.writeIncludes(out, "OLAPTABLEVIEW", this.getRequest());
        }
    }

    @Override
    @SASScope
    public void setup() {
        boolean columnDebug = false;
        super.setup();
        try {
            if (this.columnTuples != null) {
                this.columnTupleElements = new TupleElementInterface[this.columnTuples.length][];
                for (int i = 0; i < this.columnTuples.length; ++i) {
                    this.columnTupleElements[i] = this.columnTuples[i].getElements(0, -1);
                }
            }
            if (this.columnAxis != null) {
                this.columnLevelLabels = this.columnAxis.getAxisHeaders();
            }
            if (columnDebug) {
                this.printColumnLevelAndTupleLabels();
            }
            if (this.rowAxis != null) {
                this.rowLevelLabels = this.rowAxis.getAxisHeaders();
            }
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
    }

    private void writeRowTitleLabels(PrintWriter out, boolean rowDebug) throws IOException {
        if (!this.isRowHeaderVisible()) {
            return;
        }
        this.updateCurrentAreaPrefix(OLAPTableArea.ROW_TITLE);
        try {
            this.initRowTitleFilter();
            HttpActionProvider ap = this.getActionProvider();
            String[] uniqueLvlNames = this.rowAxis.getUniqueLevelNames();
            this._resizingUtil = this.createResizingUtil();
            this.levelNames = this.rowAxis.getUniqueLevelNames();
            if (this.isExportToExcel() && this.rowTupleElements != null && this.mi instanceof BusinessQueryToOLAPDataSetAdapter) {
                this.cacheMeasureFormatsOnRow();
            }
            if (this.isExportToExcel() && this.isRolap() && this.rowTuples.length > 0) {
                this.rowHeaderDataItemsToNotEncode = this.getHeaderDataItemsToNotEncode(uniqueLvlNames, this.rowTuples[0]);
            }
            for (int i = 0; i < this.rowLevelLabels.length; ++i) {
                this._headerIndex = i;
                TupleElementInterface te = this.getElementAtLevel(i, this.rowTuples);
                boolean isMeasure = this.isMeasure(te);
                String rowTitleId = this.initTitleFilter(this.rowTitleFilter, true, i, uniqueLvlNames, this.rowLevelLabels, isMeasure);
                ActionList actions = this._getActions(ap, this.rowTitleFilter);
                StyleInfo si = this._getStyleInfo("OLAPTABLEVIEW_ROW_TITLE_HEADER_STYLE");
                if (isMeasure && (te.getTupleElementIndex() == te.getTuple().getTupleDepth() - 1 && te.getType() == TupleElementType.MEASURE || i == this.rowLevelLabels.length - 2 && te.getType() == TupleElementType.GROUP)) {
                    si = this._getStyleInfo("OLAPTABLEVIEW_EMPTY_ROW_TITLE_HEADER_STYLE");
                }
                TableCellRenderer lcr = this.getHeaderRenderer(OLAPTableArea.ROW_TITLE, isMeasure);
                this.resetContentsRenderer(lcr);
                boolean resetStyle = this.initHeaderRenderer(lcr, si, 1, 1);
                this.setIdsOnRenderer(lcr, rowTitleId);
                String resizeId = this.levelNames[i];
                StyleInfo resizingStyleInfo = this._resizingUtil.handleResizing(resizeId, isMeasure, this._resizedColumns, lcr);
                String title = isMeasure ? "" : this.rowLevelLabels[i];
                this.render(lcr, out, this, title, null, actions);
                if (resizingStyleInfo != null) {
                    ((StyleInterface)((Object)lcr)).setStyleInfo(resizingStyleInfo);
                }
                this.resetRendererStyle(resetStyle, lcr);
                OLAPTableView._returnActions(ap, actions);
            }
            this._resizingUtil.writeResizingScript(out, this._resizedColumns, "ROW_TITLE_AREA");
        }
        catch (OLAPException olapexcept) {
            throw new IOExceptionWithCause(olapexcept.getMessage(), (Exception)((Object)olapexcept));
        }
        this._headerIndex = -1;
        this.resetCurrentAreaPrefix();
    }

    private void initRowTitleFilter() throws IOException {
        if (this.rowTitleFilter == null) {
            this.rowTitleFilter = new ActionSupportFilter(this.getActionSupportType(), "ROW_TITLE_AREA", (ActionProviderViewInterface)this, false);
            this.rowTitleFilter.setPoolingOn(true);
        }
        try {
            this.rowTitleFilter.setAttribute("model", (Object)this.mi);
            this.rowTitleFilter.setAttribute("axis", (Object)this.rowAxis);
        }
        catch (AttributeSetException ase) {
            throw new IOException("OLAPTableView: writeRowTitleLabels(): model could not be set on filter");
        }
    }

    private String initTitleFilter(ActionSupportFilter filter, boolean isRow, int i, String[] uniqueLvlNames, String[] levelLabels, boolean isMeasure) throws IOException {
        try {
            String uln = null;
            if (uniqueLvlNames != null) {
                uln = i < uniqueLvlNames.length ? uniqueLvlNames[i] : levelLabels[i];
            }
            filter.setAttribute("uniqueLevelName", uln);
            filter.setAttribute("levelLabel", (Object)levelLabels[i]);
            filter.setAttribute("isMeasure", (Object)(isMeasure ? Boolean.TRUE : Boolean.FALSE));
            if (this.mi instanceof BusinessQueryProviderInterface) {
                BusinessQuery businessQuery = ((BusinessQueryProviderInterface)this.mi).getBusinessQuery();
                DataItem di = OLAPCellRendererManager.findDataItem((BusinessQuery)businessQuery, (OLAPDataSetInterface)this.mi, (String)uln);
                filter.setAttribute("dataItem", (Object)di);
                filter.setAttribute("availableDataItems", null);
                filter.setAttribute("availableDataItemsSameDimension", null);
            }
        }
        catch (AttributeSetException ase) {
            throw new IOException("OLAPTableView: initTitleFilter(): uniqueLevelName could not be set on filter");
        }
        String titleId = this.generateTitleId(isRow ? "_rt" : "_ct", i);
        filter.setViewerId(titleId);
        return titleId;
    }

    @Override
    public void writeColumnHeader(PrintWriter out) throws IOException {
        if (this.mi == null) {
            throw new IOException(RB.getStringResource(RB_KEY, "message2.txt", this.getLocale()));
        }
        try {
            String[] uniqueLvlNames = this.columnAxis.getUniqueLevelNames();
            if (this.isExportToExcel() && this.isRolap() && this.columnTuples.length > 0) {
                this.columnHeaderDataItemsToNotEncode = this.getHeaderDataItemsToNotEncode(uniqueLvlNames, this.columnTuples[0]);
            }
            this.initColumnHeadersFilter();
            this.initColumnTitleFilter();
            HttpActionProvider actionProvider = this.getActionProvider();
            this._resizingUtil = this.createResizingUtil();
            for (int r = 0; r < this.columnLevelLabels.length; ++r) {
                this._headerIndex = r;
                out.println("<tr>");
                this.writeColumnTitle(out, r, uniqueLvlNames, actionProvider);
                if (this.isExportToExcel() && this.isRolap() && this.columnHeaderDataItemsToNotEncode != null && uniqueLvlNames != null && uniqueLvlNames.length > r) {
                    this.toEncode = !this.columnHeaderDataItemsToNotEncode.contains(uniqueLvlNames[r]);
                }
                this.writeColumnHeaders(out, r, actionProvider);
                if (this.isExportToExcel() && this.isRolap()) {
                    this.toEncode = true;
                }
                out.println("</tr>");
            }
            this._resizingUtil.writeResizingScript(out, this._resizedColumns, "COLUMN_HEADER_AREA");
        }
        catch (OLAPException olapexcept) {
            System.out.println("Exception occurred in writeColumnHeaders: ERROR: 2");
            throw new IOExceptionWithCause(olapexcept.getMessage(), (Exception)((Object)olapexcept));
        }
        this._headerIndex = -1;
        this.resetCurrentAreaPrefix();
    }

    private void writeColumnHeaders(PrintWriter out, int r, HttpActionProvider actionProvider) throws IOException, OLAPException {
        boolean columnDebug = false;
        int correctTupleIndex = -1;
        List multiColumnRuleVars = this.getMultiColumnRuleVariableNames();
        boolean wholeRowRuleHasMulticolumns = RulesUtil.isWholeRowRuleMulticolumn(this.getRulesContext());
        for (int c = 0; c < this.columnTuples.length; ++c) {
            boolean raggedCell;
            this._currentColumnTuple = this.columnTuples[c];
            this.updateCurrentAreaPrefix(OLAPTableArea.COLUMN_HEADER);
            try {
                this.columnHeadersFilter.setAttribute("columnTuples", this.columnTuples);
                this.columnHeadersFilter.setColumn(c);
            }
            catch (AttributeSetException ase) {
                throw new IOException("OLAPTableView: writeColumnHeader(): tupleElement could not be set on filter");
            }
            int[] tupleInfo = new int[2];
            TupleElementInterface[] currentTupleElements = this.columnTupleElements[c];
            this.calculateColumnTupleInfo(r, currentTupleElements, tupleInfo);
            correctTupleIndex = tupleInfo[0];
            boolean bl = raggedCell = tupleInfo[1] > 0;
            if (correctTupleIndex < 0) continue;
            TupleElementInterface correctTupleElement = currentTupleElements[correctTupleIndex];
            boolean isMeasure = this.isMeasure(correctTupleElement);
            TableCellRenderer lcr = this.getHeaderRenderer(OLAPTableArea.COLUMN_HEADER, isMeasure);
            this.resetContentsRenderer(lcr);
            int coorDiff = this.calculateCoordinateDifference(correctTupleElement);
            int colSpan = coorDiff + 1;
            if (multiColumnRuleVars.size() > 0) {
                if (!wholeRowRuleHasMulticolumns && this.isMeasureOnColumns()) {
                    int count = 0;
                    for (int i = 0; i < colSpan; ++i) {
                        if (!this.doesTupleContainVariable(multiColumnRuleVars, this.columnTuples[c + i])) continue;
                        ++count;
                    }
                    if (count > 0) {
                        int spanForMultiColumnRules = count * 3;
                        int spanForOtherColumns = colSpan - count;
                        colSpan = spanForMultiColumnRules + spanForOtherColumns;
                    }
                } else {
                    colSpan *= 3;
                }
            }
            int spanDepth = correctTupleElement.getSpanDepth();
            int rowSpan = correctTupleElement.getSpan();
            if (spanDepth > 1) {
                rowSpan -= spanDepth - 1;
            }
            if (columnDebug) {
                this.printCoordinateInfo(correctTupleElement, rowSpan);
            }
            String id = this.generateID(this.columnTuples[c], correctTupleIndex, 0);
            if (coorDiff > 0) {
                c += coorDiff;
            }
            if (raggedCell) {
                this.writeRaggedColumnHeader(out, lcr, correctTupleElement, colSpan, spanDepth);
                continue;
            }
            StyleInfo si_ch = this.getColumnHeaderStyleInfo(correctTupleElement, isMeasure);
            this.resetContentsRenderer(lcr);
            boolean resetStyle = this.initHeaderRenderer(lcr, si_ch, colSpan, rowSpan);
            this.setIdsOnRenderer(lcr, id);
            StyleInfo resizingStyleInfo = null;
            if (correctTupleIndex == currentTupleElements.length - 1) {
                resizingStyleInfo = this._resizingUtil.handleResizing(correctTupleElement, this._resizedColumns, lcr);
            }
            this.addColumnHeadersFilterAttributes(correctTupleElement, isMeasure);
            this.columnHeadersFilter.setViewerId(id);
            ActionList actions = this._getActions(actionProvider, this.columnHeadersFilter);
            resizingStyleInfo = this.removeLastBorder(lcr, c + this.startColumn, -1, resizingStyleInfo);
            this.render(lcr, out, this, correctTupleElement, null, actions);
            if (resizingStyleInfo != MISSING_STYLEINFO) {
                ((StyleInterface)((Object)lcr)).setStyleInfo(resizingStyleInfo);
            }
            this.resetRendererStyle(resetStyle, lcr);
            OLAPTableView._returnActions(actionProvider, actions);
        }
        this._currentColumnTuple = null;
    }

    private int[] calculateColumnTupleInfo(int r, TupleElementInterface[] currentTupleElements, int[] tupleInfo) throws OLAPException {
        if (tupleInfo == null) {
            tupleInfo = new int[]{-1, -1};
        }
        int totalSpan = 0;
        for (int y = 0; y < currentTupleElements.length; ++y) {
            int elemSpan = currentTupleElements[y].getSpan();
            int elemSpanDepth = currentTupleElements[y].getSpanDepth();
            if (r >= (totalSpan += elemSpan)) continue;
            if (r == totalSpan - elemSpan) {
                tupleInfo[0] = y;
                if (elemSpanDepth <= 1) break;
                tupleInfo[1] = 1;
                break;
            }
            if (r <= totalSpan - elemSpan || elemSpanDepth <= 1 || r != totalSpan - elemSpan + elemSpanDepth - 1) break;
            tupleInfo[0] = y;
            break;
        }
        return tupleInfo;
    }

    private int calculateCoordinateDifference(TupleElementInterface correctTupleElement) throws OLAPException {
        int minCoor = correctTupleElement.getMinimumCoordinate();
        int maxCoor = correctTupleElement.getMaximumCoordinate();
        int ec = this.getEndColumn();
        int sc = this.getStartColumn();
        if (sc > minCoor) {
            minCoor = sc;
        }
        if (maxCoor > ec) {
            maxCoor = ec;
        }
        int coorDiff = maxCoor - minCoor;
        return coorDiff;
    }

    private void addColumnHeadersFilterAttributes(TupleElementInterface correctTupleElement, boolean isMeasure) throws OLAPException, IOException {
        try {
            this.columnHeadersFilter.setAttribute("tupleElement", correctTupleElement);
            this.columnHeadersFilter.setAttribute("isMeasure", isMeasure);
            if (this.mi instanceof BusinessQueryProviderInterface) {
                BusinessQuery businessQuery = ((BusinessQueryProviderInterface)this.mi).getBusinessQuery();
                DataItem di = OLAPCellRendererManager.findDataItem((BusinessQuery)businessQuery, (TupleElementInterface)correctTupleElement);
                this.cacheMeasureFormat(correctTupleElement, di);
                this.columnHeadersFilter.setAttribute("dataItem", di);
            }
        }
        catch (AttributeSetException ase) {
            throw new IOException("OLAPTableView: writeColumns(): tupleElement could not be set on filter");
        }
    }

    private StyleInfo writeRaggedColumnHeader(PrintWriter out, TableCellRenderer lcr, TupleElementInterface correctTupleElement, int colSpan, int spanDepth) throws IOException, OLAPException {
        StyleInfo si_ch;
        if (correctTupleElement.getType() == TupleElementType.MEASURE) {
            si_ch = new StyleInfo(this._getStyleInfo("OLAPTABLEVIEW_COLUMN_MEASURE_HEADER_STYLE"));
            si_ch.addStyle("border-bottom: none");
        } else {
            si_ch = this._getStyleInfo("OLAPTABLEVIEW_RAGGED_COLUMN_HEADER_STYLE");
        }
        this.resetContentsRenderer(lcr);
        boolean resetStyle = this.initHeaderRenderer(lcr, si_ch, colSpan, spanDepth - 1);
        this._raggedTupleElement = correctTupleElement;
        StyleInfo saved = this.removeLastBorder(lcr, correctTupleElement.getTuple(), null, MISSING_STYLEINFO);
        this.render(lcr, out, this, null, null, null);
        if (saved != MISSING_STYLEINFO) {
            ((StyleInterface)((Object)lcr)).setStyleInfo(saved);
        }
        this._raggedTupleElement = null;
        this.resetRendererStyle(resetStyle, lcr);
        return si_ch;
    }

    private void writeColumnTitle(PrintWriter out, int r, String[] uniqueLvlNames, HttpActionProvider actionProvider) throws OLAPException, IOException {
        if (!this.isRowHeaderVisible()) {
            return;
        }
        if (this.rowAxis != null) {
            boolean isMeasure = false;
            if (this.isMeasure(r, this.columnTuples)) {
                isMeasure = true;
            }
            String columnTitleId = this.initTitleFilter(this.columnTitleFilter, false, r, uniqueLvlNames, this.columnLevelLabels, isMeasure);
            StyleInfo si = this._getStyleInfo("OLAPTABLEVIEW_COLUMN_TITLE_HEADER_STYLE");
            TableCellRenderer lcr = this.getHeaderRenderer(OLAPTableArea.COLUMN_TITLE, isMeasure);
            this.resetContentsRenderer(lcr);
            int rowLabelColSpan = this.rowLevelLabels != null ? this.rowLevelLabels.length : 0;
            boolean resetStyle = this.initHeaderRenderer(lcr, si, rowLabelColSpan, 1);
            this.setIdsOnRenderer(lcr, columnTitleId);
            ActionList actions = this._getActions(actionProvider, this.columnTitleFilter);
            this.updateCurrentAreaPrefix(OLAPTableArea.COLUMN_TITLE);
            String title = isMeasure ? "" : this.columnLevelLabels[r];
            this.render(lcr, out, this, title, null, actions);
            this.resetRendererStyle(resetStyle, lcr);
            OLAPTableView._returnActions(actionProvider, actions);
        }
    }

    private void initColumnTitleFilter() throws IOException {
        if (this.columnTitleFilter == null) {
            this.columnTitleFilter = new ActionSupportFilter(this.getActionSupportType(), "COLUMN_TITLE_AREA", (ActionProviderViewInterface)this, false);
            this.columnTitleFilter.setPoolingOn(true);
        } else if (!this.getActionSupportType().equals(this.columnTitleFilter.getActionSupportType())) {
            this.columnTitleFilter.setActionSupportType(this.getActionSupportType());
        }
        try {
            this.columnTitleFilter.setAttribute("viewerComponent", (Object)this);
            this.columnTitleFilter.setAttribute("model", (Object)this.mi);
            this.columnTitleFilter.setAttribute("axis", (Object)this.columnAxis);
        }
        catch (AttributeSetException ase) {
            throw new IOException("OLAPTableView: writeColumnHeader(): model could not be set on filter");
        }
    }

    private void initColumnHeadersFilter() throws IOException {
        if (this.columnHeadersFilter == null) {
            this.columnHeadersFilter = new TableViewActionSupportFilter(this.getActionSupportType(), "COLUMN_HEADER_AREA", this);
            this.columnHeadersFilter.setPoolingOn(true);
            this.columnHeadersFilter.setSwing(false);
        } else if (!this.getActionSupportType().equals(this.columnHeadersFilter.getActionSupportType())) {
            this.columnHeadersFilter.setActionSupportType(this.getActionSupportType());
        }
        try {
            this.columnHeadersFilter.setAttribute("viewerComponent", this);
            this.columnHeadersFilter.setAttribute("model", this.mi);
            this.columnHeadersFilter.setAttribute("axis", this.columnAxis);
        }
        catch (AttributeSetException ase) {
            throw new IOException("OLAPTableView: writeColumnHeader(): model could not be set on filter");
        }
    }

    @SASScope
    public void setHeaderCellRenderer(OLAPTableFormatArea area, TableCellRenderer renderer) {
        this.headerCellRendererManager.setCellRenderer(area, (Object)renderer);
    }

    @Override
    public void writeRows(PrintWriter out) throws IOException {
        this.cellRendererManager.setDataSet(this.mi);
        boolean rowDebug = false;
        try {
            this.rowTupleElements = new TupleElementInterface[this.rowTuples.length][];
            for (int i = 0; i < this.rowTuples.length; ++i) {
                this.rowTupleElements[i] = this.rowTuples[i].getElements(0, this.rowTuples[i].getTupleDepth());
            }
            boolean labelsEmpty = this.checkLabelsEmpty();
            if (this.isRowHeaderVisible() && this.isColumnHeaderVisible() && !labelsEmpty) {
                out.println("<tr>");
                this.writeRowTitleLabels(out, rowDebug);
                this.writeData(0, 2, out);
                out.println("</tr>");
            }
            int colCount = this.getColumnCount();
            int[] maxes = new int[20];
            int[] mins = new int[20];
            for (int i = 0; i < 20; ++i) {
                maxes[i] = -1;
                mins[i] = -1;
            }
            this.initRowHeadersFilter();
            HttpActionProvider ap = this.getActionProvider();
            for (int i = 0; i < this.endRow - this.startRow + 1; ++i) {
                if (rowDebug) {
                    this.printScrollInformation(i, colCount);
                }
                out.println("<tr>");
                this.writeRowHeader(out, i, colCount, mins, maxes, ap);
                if (i > 0 || !this.isRowHeaderVisible() || !this.isColumnHeaderVisible() || labelsEmpty) {
                    this.writeData(i, 1, out);
                }
                out.println("</tr>");
            }
        }
        catch (OLAPException olapexcept) {
            throw new IOExceptionWithCause(olapexcept.getMessage(), (Exception)((Object)olapexcept));
        }
        this.currentCellOrdinal = -1;
        this.resetCurrentAreaPrefix();
        if (this.isExportToExcel() && this.cacheOfMeasureFormatsForExport != null) {
            this.cacheOfMeasureFormatsForExport = null;
        }
    }

    private boolean checkLabelsEmpty() {
        for (int i = 0; i < this.rowLevelLabels.length; ++i) {
            String label = this.rowLevelLabels[i];
            if (label == null || label.length() <= 0) continue;
            return false;
        }
        return true;
    }

    private void writeRowHeader(PrintWriter out, int i, int colCount, int[] mins, int[] maxes, HttpActionProvider ap) throws OLAPException, IOException {
        if (!this.isRowHeaderVisible()) {
            return;
        }
        boolean rowDebug = false;
        this._currentRowTuple = this.rowTuples[i];
        for (int j = 0; j < this.rowTupleElements[i].length; ++j) {
            this._headerIndex = j;
            TupleElementInterface currentTupleElement = this.rowTupleElements[i][j];
            int minCoor = currentTupleElement.getMinimumCoordinate();
            int maxCoor = currentTupleElement.getMaximumCoordinate();
            int span = currentTupleElement.getSpan();
            if (rowDebug) {
                this.printMinMaxInformation(minCoor, maxCoor, span);
            }
            if (span == 0) continue;
            String rLabel = currentTupleElement.getLabel();
            if (maxCoor > this.endRow) {
                maxCoor = this.endRow;
            }
            if (minCoor < this.startRow) {
                minCoor = this.startRow;
            }
            int rowSpan = maxCoor - minCoor + 1;
            if (rowDebug) {
                this.printRowSpanInformation(maxes, mins, j, minCoor, maxCoor, span, rLabel, rowSpan);
            }
            if (mins[j] == minCoor && maxes[j] == maxCoor) continue;
            int spanDepth = currentTupleElement.getSpanDepth();
            this._raggedTupleElement = currentTupleElement;
            this.writeRaggedHierarchyBlankCells(out, rowSpan, spanDepth);
            this._raggedTupleElement = null;
            boolean isMeasure = this.isMeasure(currentTupleElement);
            StyleInfo si_rh = this.getRowHeaderStyleInfo(currentTupleElement, isMeasure, span, spanDepth);
            TableCellRenderer lcr = this.getHeaderRenderer(OLAPTableArea.ROW_HEADER, isMeasure);
            this.resetContentsRenderer(lcr);
            boolean resetStyle = this.initHeaderRenderer(lcr, si_rh, spanDepth > 1 ? 1 : span, rowSpan);
            TupleInterface rTuple = currentTupleElement.getTuple();
            String id = this.generateID(rTuple, j, 1);
            this.setIdsOnRenderer(lcr, id);
            this.updateRowHeadersFilter(i, j, id, isMeasure);
            ActionList actions = this._getActions(ap, this.rowHeadersFilter);
            this.updateCurrentAreaPrefix(OLAPTableArea.ROW_HEADER);
            StyleInfo saved = this.removeLastBorder(lcr, -1, i + rowSpan - 1, MISSING_STYLEINFO);
            if (this.isExportToExcel() && this.isRolap() && this.rowHeaderDataItemsToNotEncode != null && this.levelNames != null && this.levelNames.length > j) {
                this.toEncode = !this.rowHeaderDataItemsToNotEncode.contains(this.levelNames[j]);
            }
            this.render(lcr, out, this, currentTupleElement, null, actions);
            if (this.isExportToExcel() && this.isRolap()) {
                this.toEncode = true;
            }
            if (saved != MISSING_STYLEINFO) {
                ((StyleInterface)((Object)lcr)).setStyleInfo(saved);
            }
            this.resetRendererStyle(resetStyle, lcr);
            OLAPTableView._returnActions(ap, actions);
            if (rowDebug) {
                this.printRowPosInformation(i, colCount);
            }
            if (spanDepth > 1 && spanDepth < span) {
                this._raggedTupleElement = currentTupleElement;
                for (int k = spanDepth; k < span; ++k) {
                    si_rh = k == span - 1 ? this._getStyleInfo("OLAPTABLEVIEW_RAGGED_LAST_ROW_HEADER_STYLE") : this._getStyleInfo("OLAPTABLEVIEW_RAGGED_ROW_HEADER_STYLE");
                    this.renderEmptyLabelContents(out, rowSpan, si_rh);
                }
                this._raggedTupleElement = null;
            }
            mins[j] = minCoor;
            maxes[j] = maxCoor;
        }
        this._headerIndex = -1;
        this._currentRowTuple = null;
    }

    private void setIdsOnRenderer(TableCellRenderer lcr, String id) {
        TableCellContentsRenderer ccr;
        if (lcr instanceof BaseTableCell) {
            BaseTableCell cell = (BaseTableCell)((Object)lcr);
            cell.setId(id);
        }
        if (!((ccr = lcr.getTableCellContentsRenderer()) instanceof Label)) {
            ccr.setId(id + "_ccr");
        }
    }

    private void writeRaggedHierarchyBlankCells(PrintWriter out, int rowSpan, int spanDepth) throws OLAPException, IOException {
        if (spanDepth > 1) {
            StyleInfo si_rh1;
            if (this._raggedTupleElement.getType() == TupleElementType.MEASURE) {
                si_rh1 = new StyleInfo(this._getStyleInfo("OLAPTABLEVIEW_ROW_MEASURE_HEADER_STYLE"));
                si_rh1.addStyle("border-right: none");
            } else {
                si_rh1 = this._getStyleInfo("OLAPTABLEVIEW_RAGGED_ROW_HEADER_STYLE");
            }
            for (int m = 0; m < spanDepth - 1; ++m) {
                this.renderEmptyLabelContents(out, rowSpan, si_rh1);
            }
        }
    }

    private StyleInfo getRowHeaderStyleInfo(TupleElementInterface currentTupleElement, boolean isMeasure, int span, int spanDepth) throws OLAPException {
        StyleInfo si_rh = isMeasure ? this._getStyleInfo("OLAPTABLEVIEW_ROW_MEASURE_HEADER_STYLE") : (spanDepth > 1 ? (spanDepth == span ? this._getStyleInfo("OLAPTABLEVIEW_RAGGED_LAST_ROW_HEADER_STYLE") : this._getStyleInfo("OLAPTABLEVIEW_RAGGED_ROW_HEADER_STYLE")) : (currentTupleElement.getType() == TupleElementType.TOTAL ? (this.isExportToExcel() ? this._getStyleInfo("OLAPTABLEVIEW_TOTALS_ROW_HEADER_FOR_EXPORT_TO_EXCEL_STYLE") : this._getStyleInfo("OLAPTABLEVIEW_TOTALS_ROW_HEADER_STYLE")) : (currentTupleElement.getType() == TupleElementType.SUBTOTAL ? (this.isExportToExcel() ? this._getStyleInfo("OLAPTABLEVIEW_SUBTOTALS_ROW_HEADER_FOR_EXPORT_TO_EXCEL_STYLE") : this._getStyleInfo("OLAPTABLEVIEW_SUBTOTALS_ROW_HEADER_STYLE")) : this._getStyleInfo("OLAPTABLEVIEW_ROW_HEADER_STYLE"))));
        return si_rh;
    }

    private StyleInfo _getStyleInfo(String key) {
        Object si = this.getStyleMap().get(key);
        return (StyleInfo)si;
    }

    private StyleInfo getColumnHeaderStyleInfo(TupleElementInterface currentTupleElement, boolean isMeasure) throws OLAPException {
        StyleInfo si_ch = isMeasure ? this._getStyleInfo("OLAPTABLEVIEW_COLUMN_MEASURE_HEADER_STYLE") : (currentTupleElement.getType() == TupleElementType.TOTAL ? (this.isExportToExcel() ? this._getStyleInfo("OLAPTABLEVIEW_TOTALS_COLUMN_HEADER_FOR_EXPORT_TO_EXCEL_STYLE") : this._getStyleInfo("OLAPTABLEVIEW_TOTALS_COLUMN_HEADER_STYLE")) : (currentTupleElement.getType() == TupleElementType.SUBTOTAL ? (this.isExportToExcel() ? this._getStyleInfo("OLAPTABLEVIEW_SUBTOTALS_COLUMN_HEADER_FOR_EXPORT_TO_EXCEL_STYLE") : this._getStyleInfo("OLAPTABLEVIEW_SUBTOTALS_COLUMN_HEADER_STYLE")) : this._getStyleInfo("OLAPTABLEVIEW_COLUMN_HEADER_STYLE")));
        return si_ch;
    }

    private void printColumnLevelAndTupleLabels() throws OLAPException {
        int i;
        for (i = 0; i < this.columnLevelLabels.length; ++i) {
            System.out.println("\ncolumn level label " + i + ID_DELIMIT + this.columnLevelLabels[i]);
        }
        for (i = 0; i < this.columnTuples.length; ++i) {
            TupleElementInterface[] tei = this.columnTuples[i].getElements(0, this.columnTuples[i].getTupleDepth());
            for (int j = 0; j < tei.length; ++j) {
                System.out.println("label " + j + ID_DELIMIT + tei[j].getLabel());
            }
        }
    }

    private void printCoordinateInfo(TupleElementInterface correctTupleElement, int rowSpan) throws OLAPException {
        System.out.println("/n******** Printing Column Label Info ***************");
        System.out.println("Tuple Label=" + correctTupleElement.getLabel());
        System.out.println("MaxCoor=" + correctTupleElement.getMaximumCoordinate() + " MinCoor=" + correctTupleElement.getMinimumCoordinate() + " rowSpan=" + rowSpan);
        System.out.println("****************************************************\n");
    }

    private void printScrollInformation(int i, int colCount) {
        int startPos = (this.startRow + i) * colCount + this.startColumn;
        int endPos = startPos + (this.endColumn - this.startColumn);
        System.out.println("****************Scrolling information*********************");
        System.out.println("startRow=" + this.startRow + " endRow=" + this.endRow);
        System.out.println("startColumn=" + this.startColumn + " endColumn=" + this.endColumn);
        System.out.println("startOrdinal=" + startPos + " endOrdinal=" + endPos);
        System.out.println("****************End Scrolling information*********************");
    }

    private void printMinMaxInformation(int minCoor, int maxCoor, int span) {
        System.out.println("\n************* MIN/MAX Information *********************");
        System.out.println("minCoor=" + minCoor + " maxCoor=" + maxCoor + " span=" + span);
        System.out.println("***************************************************");
    }

    private void printRowSpanInformation(int[] maxes, int[] mins, int j, int minCoor, int maxCoor, int span, String rLabel, int rowSpan) {
        System.out.println("\n************* Row Span Information *********************");
        System.out.println("testing span condition minCoor=" + minCoor + " maxCoor=" + maxCoor);
        System.out.println("mins[j]=" + mins[j] + " maxes[j]=" + maxes[j]);
        System.out.println("Row label=" + rLabel + " span=" + span + " rowSpan=" + rowSpan);
        System.out.println("************* Row Information *********************");
    }

    private void printRowPosInformation(int i, int colCount) {
        int startPos = (this.startRow + i) * colCount + this.startColumn;
        int endPos = startPos + (this.endColumn - this.startColumn);
        System.out.println("\n**********************************");
        System.out.println("column count=" + colCount + " startPos=" + startPos + " endPos=" + endPos);
        System.out.println("**********************************");
    }

    private void renderEmptyLabelContents(PrintWriter out, int rowSpan, StyleInfo si_rh) throws IOException {
        TableCellRenderer lcr = this.getHeaderRenderer(OLAPTableArea.ROW_HEADER);
        this.resetContentsRenderer(lcr);
        boolean resetStyle = this.initHeaderRenderer(lcr, si_rh, 1, rowSpan);
        this.render(lcr, out, this, null, null, null);
        this.resetRendererStyle(resetStyle, lcr);
    }

    private void initRowHeadersFilter() throws IOException {
        if (this.rowHeadersFilter == null) {
            this.rowHeadersFilter = new TableViewActionSupportFilter(this.getActionSupportType(), "ROW_HEADER_AREA", this);
            this.rowHeadersFilter.setPoolingOn(true);
            this.rowHeadersFilter.setSwing(false);
        } else if (!this.getActionSupportType().equals(this.rowHeadersFilter.getActionSupportType())) {
            this.rowHeadersFilter.setActionSupportType(this.getActionSupportType());
        }
        try {
            this.rowHeadersFilter.setAttribute("viewerComponent", this);
            this.rowHeadersFilter.setAttribute("model", this.mi);
            this.rowHeadersFilter.setAttribute("axis", this.rowAxis);
        }
        catch (AttributeSetException ase) {
            throw new IOException("OLAPTableView: writeColumns(): model could not be set on filter");
        }
    }

    private void updateRowHeadersFilter(int i, int j, String id, boolean isMeasure) throws IOException {
        try {
            this.rowHeadersFilter.setAttribute("tupleElement", this.rowTupleElements[i][j]);
            this.rowHeadersFilter.setAttribute("rowTuples", this.rowTuples);
            this.rowHeadersFilter.setAttribute("isMeasure", isMeasure ? Boolean.TRUE : Boolean.FALSE);
            this.rowHeadersFilter.setRow(i);
            this.rowHeadersFilter.setViewerId(id);
            if (this.mi instanceof BusinessQueryProviderInterface) {
                BusinessQuery businessQuery = ((BusinessQueryProviderInterface)this.mi).getBusinessQuery();
                DataItem di = OLAPCellRendererManager.findDataItem((BusinessQuery)businessQuery, (TupleElementInterface)this.rowTupleElements[i][j]);
                this.rowHeadersFilter.setAttribute("dataItem", di);
            }
        }
        catch (AttributeSetException ase) {
            throw new IOException("OLAPTableView: writeRows(): tupleElement(s) could not be set on filter");
        }
    }

    private void writeData(int rowNumber, int rowSpan, PrintWriter out) throws IOException {
        this.updateCurrentAreaPrefix(OLAPTableArea.TABLE_DATA);
        try {
            int colCount = this.getColumnCount();
            int startPos = (this.startRow + rowNumber) * colCount + this.startColumn;
            int endPos = startPos + (this.endColumn - this.startColumn);
            String[] dataCells = this.mi.getFormattedCells((long)startPos, (long)endPos);
            TupleElementInterface measureTupleElement = null;
            TupleElementInterface exportMeasureTupleElement = null;
            TupleElementInterface exportRowMeasureTupleElement = null;
            TupleElementInterface[] rTuples = this.rowTupleElements[rowNumber];
            TupleElementInterface rowMeasureTupleElement = this.findMeasure(rTuples);
            if (this.isExportToExcel()) {
                exportRowMeasureTupleElement = rowMeasureTupleElement != null ? rowMeasureTupleElement : this.findMeasureForExport(rTuples);
            }
            this.initDataCellFilter(rowNumber);
            for (int k = 0; k < dataCells.length; ++k) {
                this.currentCellOrdinal = k + startPos;
                String cellId = this.updateDataCellFilter(rowNumber, dataCells, k);
                TupleElementInterface[] cTuples = this.columnTupleElements[k];
                TupleElementInterface tupleElementInterface = measureTupleElement = rowMeasureTupleElement != null ? rowMeasureTupleElement : this.findMeasure(cTuples);
                if (this.isExportToExcel()) {
                    exportMeasureTupleElement = exportRowMeasureTupleElement != null ? exportRowMeasureTupleElement : (measureTupleElement != null ? measureTupleElement : this.findMeasureForExport(cTuples));
                }
                try {
                    TableCellRenderer tempRenderer = null;
                    String tempID = null;
                    if (this.cellRenderers.size() > 0) {
                        DataItem dataItem = this.getMeasureDataItem(measureTupleElement);
                        if (dataItem != null) {
                            tempID = dataItem.getID();
                            tempRenderer = this.getCellRenderer(tempID);
                        } else {
                            tempRenderer = this.getCellRenderer("DEFAULT_COLOR_MAP_ID");
                        }
                    }
                    if (tempRenderer == null && (tempRenderer = (TableCellRenderer)this.cellRendererManager.getCellRenderer(this.columnTupleElements[k], this.rowTupleElements[rowNumber])) instanceof TargetInterface && this.hasRules()) {
                        this.handleRules(tempRenderer, rTuples, cTuples, this.startRow + rowNumber, this.startColumn + k);
                    }
                    if (this.isExportToExcel() && exportMeasureTupleElement != null) {
                        this.currentMeasureUniqueName = exportMeasureTupleElement.getName();
                    }
                    if (tempRenderer == null) {
                        tempRenderer = this.dcr;
                        tempID = null;
                    }
                    this.renderData(out, tempRenderer, rowNumber, rowSpan, k, dataCells, cellId, tempID);
                    continue;
                }
                catch (InvalidIDException e) {
                    System.out.println("caught an inValidIDException");
                    this.resetContentsRenderer(this.dcr);
                    this.renderData(out, this.dcr, rowNumber, rowSpan, k, dataCells, cellId, null);
                }
            }
        }
        catch (OLAPException oe) {
            throw new IOExceptionWithCause(oe.getMessage(), (Exception)((Object)oe));
        }
        this.resetCurrentAreaPrefix();
    }

    @SASScope
    public String getCurrentMeasureUniqueName() {
        return this.currentMeasureUniqueName;
    }

    private void handleRules(TableCellRenderer renderer, TupleElementInterface[] rowTuples, TupleElementInterface[] columnTuples, int row, int col) {
        try {
            if (renderer instanceof ConditionTableCellRenderer) {
                ((ConditionTableCellRenderer)renderer).prepare();
            }
            DataVector dataVector = new DataVector();
            RulesUtil.addLevels(dataVector, rowTuples, this.cellRendererManager.getMatchingMeasureTupleElement());
            RulesUtil.addLevels(dataVector, columnTuples, this.cellRendererManager.getMatchingMeasureTupleElement());
            RulesUtil.addLevels(dataVector, this.cellRendererManager.getSlicer(), this.cellRendererManager.getMatchingMeasureTupleElement());
            boolean foundMultipleVarRule = this.targetHasMultipleVariables(renderer);
            if (!foundMultipleVarRule) {
                this.addOnlyMeasureToDataVector(dataVector, row, col);
            } else {
                this.addMeasuresToDataVector(dataVector, row, col);
            }
            RulesUtil.addMembers(dataVector, columnTuples, rowTuples, this.cellRendererManager);
            RuleEngine.evaluateRules((ContextInterface)this.getRulesContext(), (DataVectorInterface)dataVector);
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private boolean targetHasMultipleVariables(TableCellRenderer renderer) throws EvaluateException {
        boolean foundMultipleVarRule = false;
        Collection rules = this.getRulesContext().getRules();
        for (Rule rule : rules) {
            TargetInterface[] targets = rule.getTargets();
            boolean foundTarget = false;
            for (int ti = 0; ti < targets.length; ++ti) {
                TargetInterface target = targets[ti];
                if (target != renderer) continue;
                foundTarget = true;
                break;
            }
            if (!foundTarget || rule.extractVariables().size() <= 1) continue;
            foundMultipleVarRule = true;
            break;
        }
        return foundMultipleVarRule;
    }

    private void addOnlyMeasureToDataVector(DataVector dataVector, int row, int col) throws OLAPException, EvaluateException {
        TupleElementInterface tupleElem = this.cellRendererManager.getMatchingMeasureTupleElement();
        String measure = null;
        if (tupleElem != null) {
            measure = this.getMeasureName(tupleElem);
        }
        int ordinal = row * this.columnCount + col;
        for (Variable var : RuleEngine.extractVariables((ContextInterface)this.getRulesContext())) {
            if (var.getName().equals(measure)) {
                this.addToDataVector(dataVector, measure, ordinal);
                continue;
            }
            dataVector.setValue(var.toString(), (ValueInterface)new MissingValue());
        }
    }

    private void addMeasuresToDataVector(DataVector dataVector, int row, int col) throws OLAPException {
        TupleElementInterface tupleElem = this.cellRendererManager.getMatchingMeasureTupleElement();
        int ordinal = row * this.columnCount;
        if (this.cellRendererManager.getMatchingMeasureLocation() == -1) {
            String measure = this.getMeasureName(tupleElem);
            this.addToDataVector(dataVector, measure, ordinal + col);
            return;
        }
        TupleInterface tuple = tupleElem.getTuple();
        AxisInterface axis = tuple.getAxis();
        TupleInterface[] tuples = axis.getTuples(0, axis.getTupleCount());
        TupleElementInterface[] tupleElements = tuple.getElements(0, tuple.getTupleDepth());
        int inc = 1;
        if (this.cellRendererManager.getMatchingMeasureLocation() == 1) {
            inc = this.columnCount;
            ordinal = col;
        }
        for (int i = 0; i < tuples.length; ++i) {
            TupleInterface curTuple = tuples[i];
            TupleElementInterface[] curTupleElements = curTuple.getElements(0, curTuple.getTupleDepth());
            String measure = this.findMeasureInTuples(curTupleElements, tupleElements, tupleElem);
            if (measure != null) {
                this.addToDataVector(dataVector, measure, ordinal);
            }
            ordinal += inc;
        }
    }

    private void addToDataVector(DataVector dataVector, String measure, int ordinal) throws OLAPException {
        Object valObj = this.mi.getCells((long)ordinal, (long)ordinal)[0];
        MissingValue value = ".".equals(valObj) ? new MissingValue() : RulesUtil.getValue(valObj);
        dataVector.setValue(measure, (ValueInterface)value);
    }

    private String findMeasureInTuples(TupleElementInterface[] curTupleElements, TupleElementInterface[] tupleElements, TupleElementInterface matchingTupleElement) {
        String measure = null;
        int i = 0;
        for (int j = 0; i < curTupleElements.length && j < tupleElements.length; ++i, ++j) {
            try {
                i = this.nextNonContextual(curTupleElements, i);
                j = this.nextNonContextual(tupleElements, j);
                if (i >= curTupleElements.length || j >= tupleElements.length) break;
                TupleElementInterface curTupleElem = curTupleElements[i];
                TupleElementInterface tupleElem = tupleElements[j];
                if (tupleElem == matchingTupleElement) {
                    measure = this.getMeasureName(curTupleElem);
                    continue;
                }
                if (tupleElem.getName().equals(curTupleElem.getName())) continue;
                return null;
            }
            catch (OLAPException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return measure;
    }

    private int nextNonContextual(TupleElementInterface[] tupleElements, int i) throws OLAPException {
        for (int j = i; j < tupleElements.length; ++j) {
            TupleElementInterface tupleElem = tupleElements[j];
            if (tupleElem.isContextual()) continue;
            return j;
        }
        return Integer.MAX_VALUE;
    }

    private String getMeasureName(TupleElementInterface curTupleElem) throws OLAPException {
        return this.cellRendererManager.getMeasureName(curTupleElem);
    }

    private String updateDataCellFilter(int rowNumber, String[] dataCells, int k) throws IOException {
        try {
            this.dataCellFilter.setAttribute("dataValue", dataCells[k]);
            this.dataCellFilter.setColumn(k);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        String cellId = this.generateDataCellId(rowNumber, k);
        this.dataCellFilter.setViewerId(cellId);
        return cellId;
    }

    private DataItem getMeasureDataItem(TupleElementInterface measureTupleElement) throws OLAPException {
        DataItem dataItem = null;
        if (this.mi instanceof BusinessQueryProviderInterface) {
            BusinessQuery businessQuery = ((BusinessQueryProviderInterface)this.mi).getBusinessQuery();
            BusinessModel businessModel = businessQuery.getBusinessModel();
            if (businessModel != null && businessModel.getStructure().isOLAP()) {
                dataItem = measureTupleElement != null ? BusinessQueryToOLAPDataSetAdapter.findDataItem((BusinessQuery)businessQuery, (OLAPDataSetInterface)this.mi, (Object)measureTupleElement, (int)1) : this.getBackgroundMeasureDataItem(businessQuery);
            } else if (businessQuery != null && measureTupleElement != null) {
                dataItem = OLAPCellRendererManager.findDataItem((BusinessQuery)businessQuery, (TupleElementInterface)measureTupleElement);
            }
        }
        return dataItem;
    }

    private DataItem getBackgroundMeasureDataItem(BusinessQuery businessQuery) {
        DataItem dataItem = null;
        try {
            if (businessQuery != null) {
                List l = businessQuery.getResultItems();
                for (int i = 0; i < l.size(); ++i) {
                    dataItem = (DataItem)l.get(i);
                    Role brole = businessQuery.getResultItemRole(dataItem);
                    if (brole != Role.BACKGROUND || dataItem.getStructure() != StructureOfDataItem.STRUCTURE_MEASURE) continue;
                    return dataItem;
                }
                dataItem = null;
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return dataItem;
    }

    private void renderData(PrintWriter out, TableCellRenderer renderer, int rowNumber, int rowSpan, int k, String[] dataCells, String cellId, String name) throws IOException {
        ConditionTableCellRenderer conditionRenderer;
        HttpActionProvider ap = this.getActionProvider();
        ActionList cellActions = this._getActions(ap, this.dataCellFilter);
        TupleInterface rowTuple = this.rowTuples[rowNumber];
        TupleInterface colTuple = this.columnTuples[k];
        this._currentRowTuple = rowTuple;
        this._currentColumnTuple = colTuple;
        StyleInfo savedStyle = this.initializeRendererToWriteData(renderer, rowSpan, cellId, rowTuple, colTuple);
        StyleInfo savedStyleForBackup = MISSING_STYLEINFO;
        TableCellRenderer backup = null;
        if (renderer instanceof ConditionTableCellRenderer && (backup = (conditionRenderer = (ConditionTableCellRenderer)renderer).getBackupRenderer()) != null) {
            savedStyleForBackup = this.initializeRendererToWriteData(backup, rowSpan, cellId, rowTuple, colTuple);
        }
        String dataCell = dataCells[k].trim();
        RulesUtil.updateActionsForConditions(renderer, cellActions, dataCell);
        if (!this.hasRules()) {
            this.render(renderer, out, this, dataCell, name, cellActions);
        } else if (renderer instanceof ConditionTableCellRenderer) {
            ConditionTableCellRenderer conditionRenderer2 = (ConditionTableCellRenderer)renderer;
            boolean isExtraColumnsRequired = this.isExtraColumnsRequiredForRules(colTuple);
            if (!this.isExportToExcel()) {
                this.addMoveMenu(conditionRenderer2, cellActions);
                if (isExtraColumnsRequired) {
                    conditionRenderer2.writeWithExtraColumns(out, this, cellActions, name, dataCell);
                } else {
                    conditionRenderer2.writeCenterComponent(out, this, cellActions, name, dataCell, false);
                }
            } else if (isExtraColumnsRequired) {
                conditionRenderer2.writeWithExtraColumnsForExcel(out, this, cellActions, name, dataCell);
            } else {
                conditionRenderer2.writeCenterComponent(out, this, cellActions, name, dataCell, true);
            }
        } else {
            boolean isExtraColumnsRequired = this.isExtraColumnsRequiredForRules(colTuple);
            if (!this.isExportToExcel()) {
                if (isExtraColumnsRequired) {
                    this.writeWithExtraColumns(out, renderer, rowSpan, dataCell, cellActions, name);
                } else {
                    this.render(renderer, out, this, dataCell, name, cellActions);
                }
            } else if (isExtraColumnsRequired) {
                this.writeWithExtraColumnsForExcel(out, renderer, rowSpan, dataCell, cellActions, name);
            } else {
                this.render(renderer, out, this, dataCell, name, cellActions);
            }
        }
        if (savedStyle != MISSING_STYLEINFO) {
            ((StyleInterface)((Object)renderer)).setStyleInfo(savedStyle);
        }
        if (savedStyleForBackup != MISSING_STYLEINFO) {
            ((StyleInterface)((Object)backup)).setStyleInfo(savedStyleForBackup);
        }
        OLAPTableView._returnActions(ap, cellActions);
        this._currentRowTuple = null;
        this._currentColumnTuple = null;
    }

    private void writeWithExtraColumns(PrintWriter out, TableCellRenderer renderer, int rowSpan, String dataCell, ActionList cellActions, String name) throws IOException {
        StyleInfo originalRendererStyleInfo = ((StyleInterface)((Object)renderer)).getStyleInfo();
        StyleInfo originalDCRStyleInfo = this.dcr.getStyleInfo();
        Label label = (Label)((Object)this.dcr.getTableCellContentsRenderer());
        String origNull = label.getNullTextString();
        label.setNullTextString("<span style=\"font-size:1px\">&#160;</span>");
        this.dcr.setRowSpan(rowSpan);
        StyleInfo modifiedRendererStyleInfo = new StyleInfo(originalRendererStyleInfo.getClassid());
        modifiedRendererStyleInfo.setStyle("border-right: none; width: 0%; padding: 0px;" + originalRendererStyleInfo.getStyle());
        this.dcr.setStyleInfo(modifiedRendererStyleInfo);
        this.render(this.dcr, out, this, "", name, null);
        modifiedRendererStyleInfo = new StyleInfo(originalRendererStyleInfo.getClassid());
        modifiedRendererStyleInfo.setStyle("border-right: none; padding-right: 0px;" + originalRendererStyleInfo.getStyle());
        ((StyleInterface)((Object)renderer)).setStyleInfo(modifiedRendererStyleInfo);
        this.render(renderer, out, this, dataCell, name, cellActions);
        modifiedRendererStyleInfo = new StyleInfo(originalRendererStyleInfo.getClassid());
        modifiedRendererStyleInfo.setStyle("width: 0%; padding: 0px;" + originalRendererStyleInfo.getStyle());
        this.dcr.setStyleInfo(modifiedRendererStyleInfo);
        this.render(this.dcr, out, this, "", name, null);
        label.setNullTextString(origNull);
        ((StyleInterface)((Object)renderer)).setStyleInfo(originalRendererStyleInfo);
        this.dcr.setStyleInfo(originalDCRStyleInfo);
    }

    private void writeWithExtraColumnsForExcel(PrintWriter out, TableCellRenderer renderer, int rowSpan, String dataCell, ActionList cellActions, String name) throws IOException {
        StyleInfo originalRendererStyleInfo = ((StyleInterface)((Object)renderer)).getStyleInfo();
        int origWidth = this.dcr.getWidth();
        int noSpaceWidth = 1;
        Label label = (Label)((Object)this.dcr.getTableCellContentsRenderer());
        String origNull = label.getNullTextString();
        label.setNullTextString("<span style=\"font-size:1px\">&#160;</span>");
        this.dcr.setRowSpan(rowSpan);
        StyleInfo modifiedRendererStyleInfo = new StyleInfo(originalRendererStyleInfo.getClassid());
        modifiedRendererStyleInfo.setStyle("BORDER-RIGHT: none; BORDER-LEFT:none; PADDING-RIGHT: 0px;" + originalRendererStyleInfo.getStyle());
        String origId = null;
        origId = this.dcr.getId();
        this.dcr.setId(com.sas.servlet.commands.jdbc.export.Util.CHARSET_FOR_HTML_EXPORT_TO_EXCEL);
        this.dcr.setWidth(noSpaceWidth);
        this.dcr.setStyleInfo(modifiedRendererStyleInfo);
        this.render(this.dcr, out, this, "", name, null);
        this.dcr.setId(origId);
        this.dcr.setWidth(0);
        ((StyleInterface)((Object)renderer)).setStyleInfo(modifiedRendererStyleInfo);
        this.render(renderer, out, this, dataCell, name, cellActions);
        this.dcr.setWidth(noSpaceWidth);
        modifiedRendererStyleInfo = new StyleInfo(originalRendererStyleInfo.getClassid());
        modifiedRendererStyleInfo.setStyle("BORDER-LEFT:none; PADDING-RIGHT: 0px;" + originalRendererStyleInfo.getStyle());
        this.dcr.setStyleInfo(modifiedRendererStyleInfo);
        origId = this.dcr.getId();
        this.dcr.setId(com.sas.servlet.commands.jdbc.export.Util.CHARSET_FOR_HTML_EXPORT_TO_EXCEL);
        this.render(this.dcr, out, this, "", name, null);
        this.dcr.setStyleInfo(originalRendererStyleInfo);
        label.setNullTextString(origNull);
        this.dcr.setWidth(origWidth);
        this.dcr.setId(origId);
    }

    private boolean hasRules() {
        return this.getRulesContext() != null && this.getRulesContext().getRules().size() != 0;
    }

    private boolean isExtraColumnsRequiredForRules(TupleInterface tuple) {
        Rule wholeRowRule = RulesUtil.findWholeRowRule(this.getRulesContext());
        if (wholeRowRule != null && RulesUtil.isMultiColumnRule(wholeRowRule)) {
            return true;
        }
        List ruleVariables = this.getMultiColumnRuleVariableNames();
        if (ruleVariables.size() > 0) {
            if (this.isMeasureOnColumns()) {
                return this.doesTupleContainVariable(ruleVariables, tuple);
            }
            return true;
        }
        return false;
    }

    private List getMultiColumnRuleVariableNames() {
        ArrayList<String> variableList = new ArrayList<String>();
        List rules = RulesUtil.getMultiColumnRules(this.getRulesContext());
        if (rules.size() > 0) {
            for (Rule rule : rules) {
                try {
                    Set vars = rule.extractVariables();
                    Iterator ruleVarsIterator = vars.iterator();
                    if (!ruleVarsIterator.hasNext()) continue;
                    variableList.add(((Variable)ruleVarsIterator.next()).getName());
                }
                catch (EvaluateException e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return variableList;
    }

    private boolean doesTupleContainVariable(List vars, TupleInterface tuple) {
        if (vars != null && vars.size() > 0 && tuple != null) {
            try {
                BusinessQuery businessQuery;
                DataItem di;
                TupleElementInterface measure = this.findMeasure(tuple.getElements(0, tuple.getTupleDepth()));
                if (measure != null && this.mi instanceof BusinessQueryProviderInterface && (di = OLAPCellRendererManager.findDataItem((BusinessQuery)(businessQuery = ((BusinessQueryProviderInterface)this.mi).getBusinessQuery()), (TupleElementInterface)measure)) != null) {
                    String di_resultSetID = di.getResultSetID();
                    return vars.contains(di_resultSetID);
                }
            }
            catch (OLAPException e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    private boolean isMeasureOnColumns() {
        if (this.columnTupleElements.length > 0) {
            TupleElementInterface[] tuplesElement = this.columnTupleElements[0];
            for (int i = 0; i < tuplesElement.length; ++i) {
                try {
                    if (tuplesElement[i].getType() == TupleElementType.MEASURE) {
                        return true;
                    }
                    continue;
                }
                catch (OLAPException e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return false;
    }

    private StyleInfo initializeRendererToWriteData(TableCellRenderer renderer, int rowSpan, String cellId, TupleInterface rowTuple, TupleInterface colTuple) {
        TableCellContentsRenderer ccr;
        if (renderer instanceof BaseTableCell) {
            BaseTableCell btc = (BaseTableCell)((Object)renderer);
            btc.setHeaders(this.getHeaders(rowTuple, colTuple));
            btc.setRowSpan(rowSpan);
            btc.setColSpan(1);
            btc.setStyleClassPrefix(this.getStyleClassPrefix());
            btc.setId(cellId + "_cr");
        }
        if (!((ccr = renderer.getTableCellContentsRenderer()) instanceof Label)) {
            ccr.setId(cellId + "_ccr");
        }
        StyleInfo savedStyle = this.saveStyle(renderer, rowTuple, colTuple);
        savedStyle = this.removeLastBorder(renderer, colTuple, rowTuple, savedStyle);
        return savedStyle;
    }

    private StyleInfo removeLastBorder(TableCellRenderer renderer, TupleInterface colTuple, TupleInterface rowTuple, StyleInfo savedStyle) {
        try {
            int row = rowTuple != null ? rowTuple.getTupleIndex() : -1;
            int col = colTuple != null ? colTuple.getTupleIndex() : -1;
            return this.removeLastBorder(renderer, col, row, savedStyle);
        }
        catch (OLAPException e) {
            e.printStackTrace();
            return savedStyle;
        }
    }

    private StyleInfo saveStyle(TableCellRenderer renderer, TupleInterface rowTuple, TupleInterface colTuple) {
        StyleInfo savedStyle = MISSING_STYLEINFO;
        if (renderer instanceof StyleInterface) {
            StyleInfo si_td;
            ConditionTableCellRenderer ctcr;
            if (renderer instanceof ConditionTableCellRenderer && (ctcr = (ConditionTableCellRenderer)renderer).isDeepestBackupJustForStyle()) {
                return savedStyle;
            }
            StyleInterface si = (StyleInterface)((Object)renderer);
            if (si.getStyleInfo() == null && (si_td = this.getStyleKey(rowTuple, colTuple)) != null) {
                savedStyle = si.getStyleInfo();
                si.setStyleInfo(si_td);
            }
        }
        return savedStyle;
    }

    private StyleInfo getStyleKey(TupleInterface rowTuple, TupleInterface colTuple) {
        Map sMap = this.getStyleMap();
        String key = "OLAPTABLEVIEW_DATA_STYLE";
        if (this.tupleIsTotals(rowTuple) || this.tupleIsTotals(colTuple)) {
            key = this.isExportToExcel() ? "OLAPTABLEVIEW_TOTALS_FOR_EXPORT_TO_EXCEL_STYLE" : "OLAPTABLEVIEW_TOTALS_STYLE";
        } else if (this.tupleIsSubtotals(rowTuple) || this.tupleIsSubtotals(colTuple)) {
            key = this.isExportToExcel() ? "OLAPTABLEVIEW_SUBTOTALS_FOR_EXPORT_TO_EXCEL_STYLE" : "OLAPTABLEVIEW_SUBTOTALS_STYLE";
        }
        StyleInfo si_td = (StyleInfo)sMap.get(key);
        return si_td;
    }

    private boolean tupleIsTotals(TupleInterface tuple) {
        return this.tupleIsType(tuple, TupleElementType.TOTAL);
    }

    private boolean tupleIsSubtotals(TupleInterface tuple) {
        return this.tupleIsType(tuple, TupleElementType.SUBTOTAL);
    }

    private boolean tupleIsType(TupleInterface tuple, TupleElementType type) {
        try {
            TupleElementInterface[] tuples = tuple.getElements(0, tuple.getTupleDepth());
            for (int i = 0; i < tuples.length; ++i) {
                TupleElementInterface tupleElem = tuples[i];
                if (tupleElem.getType() != type) continue;
                return true;
            }
        }
        catch (OLAPException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private TupleElementInterface findMeasure(TupleElementInterface[] tuples) {
        for (int ct = 0; ct < tuples.length; ++ct) {
            try {
                TupleElementInterface tupleElem = tuples[ct];
                if (tupleElem.getType() == TupleElementType.TOTAL || tupleElem.getType() == TupleElementType.SUBTOTAL) {
                    return null;
                }
                if (tupleElem.getType() != TupleElementType.MEASURE) continue;
                return tupleElem;
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return null;
    }

    private TupleElementInterface findMeasureForExport(TupleElementInterface[] tuples) {
        if (tuples != null) {
            TupleElementInterface tupleElem = null;
            for (int ct = 0; ct < tuples.length; ++ct) {
                tupleElem = tuples[ct];
                if (tupleElem == null) continue;
                try {
                    if (tupleElem.getType() == TupleElementType.MEASURE) {
                        return tupleElem;
                    }
                    continue;
                }
                catch (OLAPException ex) {
                    this.log.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
        return null;
    }

    private void initDataCellFilter(int rowNumber) throws IOException {
        if (this.dataCellFilter == null) {
            this.dataCellFilter = new TableViewActionSupportFilter(this.getActionSupportType(), "DATA_CELL_AREA", this);
            this.dataCellFilter.setPoolingOn(true);
            this.dataCellFilter.setSwing(false);
        } else if (!this.getActionSupportType().equals(this.dataCellFilter.getActionSupportType())) {
            this.dataCellFilter.setActionSupportType(this.getActionSupportType());
        }
        try {
            this.dataCellFilter.setAttribute("viewerComponent", this);
            this.dataCellFilter.setAttribute("model", this.mi);
            this.dataCellFilter.setAttribute("rowTuples", this.rowTuples);
            this.dataCellFilter.setAttribute("columnTuples", this.columnTuples);
            this.dataCellFilter.setAttribute("rowAxis", this.rowAxis);
            this.dataCellFilter.setAttribute("columnAxis", this.columnAxis);
            this.dataCellFilter.setRow(rowNumber);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @SASScope
    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.defaultInputPropertyName = "text";
        ebi.defaultOutputPropertyName = "text";
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    private String getHeaders(TupleInterface rowTuple, TupleInterface columnTuple) {
        StringBuffer sb = this.getSmallBuffer();
        String rowTupleId = (String)this.rowTupleIds.get(rowTuple);
        if (rowTupleId == null) {
            this.rowTupleIds.put(rowTuple, this.getHeader(rowTuple, sb, 1));
        } else {
            sb.append(rowTupleId);
        }
        sb.append(ID_DELIMIT);
        String columnTupleId = (String)this.columnTupleIds.get(columnTuple);
        if (columnTupleId == null) {
            String temp = this.getHeader(columnTuple, sb, 0);
            this.columnTupleIds.put(columnTuple, temp);
        } else {
            sb.append(columnTupleId);
        }
        return sb.toString();
    }

    private String getHeader(TupleInterface tuple, StringBuffer sb, int type) {
        int beginningPosition;
        int lowCoordinate = -1;
        String rowcol = null;
        String[][] tupleElementIds = null;
        if (type == 1) {
            tupleElementIds = this.rowTupleElementIds;
            rowcol = "_r";
            lowCoordinate = this.lowestRowCoordinate;
        } else {
            tupleElementIds = this.columnTupleElementIds;
            rowcol = "_c";
            lowCoordinate = this.lowestColumnCoordinate;
        }
        int lastPosition = beginningPosition = sb.length();
        TupleElementInterface[] elements = null;
        try {
            int depth = tuple.getTupleDepth();
            elements = tuple.getElements(0, -1);
            for (int i = 0; i < depth; ++i) {
                String tupleElementId;
                int minCoord = elements[i].getMinimumCoordinate();
                if (lowCoordinate > minCoord) {
                    minCoord = lowCoordinate;
                }
                if ((tupleElementId = tupleElementIds[i][minCoord - lowCoordinate]) == null) {
                    String temp;
                    sb.append(this.getId());
                    sb.append(rowcol);
                    sb.append(i);
                    sb.append(ID_LEVEL_DELIMIT);
                    sb.append(minCoord);
                    tupleElementIds[i][minCoord - lowCoordinate] = temp = sb.substring(lastPosition);
                } else {
                    sb.append(tupleElementId);
                }
                if (i != depth - 1) {
                    sb.append(ID_DELIMIT);
                }
                lastPosition = sb.length();
            }
        }
        catch (OLAPException oe) {
            return null;
        }
        String temp2 = sb.substring(beginningPosition, lastPosition);
        return temp2;
    }

    private String generateID(TupleInterface tuple, int depth, int type) {
        String rowcol;
        TupleElementInterface tupleElement = null;
        try {
            TupleElementInterface[] elements = tuple.getElements(depth, 1);
            tupleElement = elements[0];
        }
        catch (OLAPException ioe) {
            return null;
        }
        int minCoord = 0;
        try {
            minCoord = tupleElement.getMinimumCoordinate();
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        String id = null;
        if (type == 1) {
            rowcol = "_r";
            if (this.lowestRowCoordinate > minCoord) {
                minCoord = this.lowestRowCoordinate;
            }
            id = this.rowTupleElementIds[depth][minCoord - this.lowestRowCoordinate];
        } else {
            rowcol = "_c";
            id = this.columnTupleElementIds[depth][minCoord - this.lowestColumnCoordinate];
        }
        if (id == null) {
            StringBuffer sb = this.getSmallBuffer();
            sb.append(this.getId());
            sb.append(rowcol);
            sb.append(depth);
            sb.append(ID_LEVEL_DELIMIT);
            sb.append(minCoord);
            id = sb.toString();
            if (type == 1) {
                this.rowTupleElementIds[depth][minCoord - this.lowestRowCoordinate] = id;
            } else {
                this.columnTupleElementIds[depth][minCoord - this.lowestColumnCoordinate] = id;
            }
        }
        return id;
    }

    private String generateTitleId(String type, int titleLevel) {
        StringBuffer sb = this.getSmallBuffer();
        sb.append(this.getId());
        sb.append(type);
        sb.append(String.valueOf(titleLevel));
        return sb.toString();
    }

    private String generateDataCellId(int rowNumber, int columnNumber) {
        StringBuffer sb = this.getSmallBuffer();
        sb.append(this.getId());
        sb.append("_r");
        sb.append(String.valueOf(rowNumber));
        sb.append("_c");
        sb.append(String.valueOf(columnNumber));
        return sb.toString();
    }

    private void resetContentsRenderer(TableCellRenderer renderer) {
        if (renderer instanceof BaseTableCell) {
            BaseTableCell cell = (BaseTableCell)((Object)renderer);
            cell.setBgColor(null);
            cell.setCustomAttributes(null);
            cell.setColSpan(1);
            cell.setHeaders(null);
            cell.setHeight(0);
            cell.setHeightPercentage(0);
            cell.setHorizontalAlignment(99);
            cell.setId(null);
            cell.setNoWrap(false);
            cell.setRowSpan(1);
            cell.setStyleClassPrefix(null);
            cell.setVerticalAlignment(99);
            cell.setWidth(0);
            cell.setWidthPercentage(0);
        }
        renderer.getTableCellContentsRenderer().setId(null);
    }

    private boolean initHeaderRenderer(TableCellRenderer renderer, StyleInfo styleInfo, int colSpan, int rowSpan) {
        if (renderer instanceof BaseTableCell) {
            BaseTableCell cell = (BaseTableCell)((Object)renderer);
            cell.setColSpan(colSpan);
            cell.setRowSpan(rowSpan);
            cell.setHeader(true);
            cell.setStyleClassPrefix(this.getStyleClassPrefix());
            if (cell.getStyleInfo() == null && styleInfo != null) {
                cell.setStyleInfo(styleInfo);
                return true;
            }
        }
        return false;
    }

    private void resetRendererStyle(boolean resetStyle, TableCellRenderer renderer) {
        if (!resetStyle) {
            return;
        }
        if (renderer instanceof BaseTableCell) {
            BaseTableCell cell = (BaseTableCell)((Object)renderer);
            cell.setStyleInfo(null);
        }
    }

    @Override
    public Form getDefaultFormObject() {
        this.formObject = BaseUtil.getDefaultFormObject(this, this.getRequest(), this.getResponse());
        this.formObject.setMethod("post");
        return this.formObject;
    }

    @Override
    public Form getFormObject() {
        if (this.formObject == null) {
            return this.getDefaultFormObject();
        }
        return this.formObject;
    }

    @Override
    public void setFormObject(Form formObject) {
        this.formObject = formObject;
    }

    @Override
    public HashMap getAdditionalParameters() {
        return this.additionalParameters;
    }

    @Override
    public void setAdditionalParameters(HashMap map) {
        this.additionalParameters = map;
    }

    @Override
    public void setAdditionalParameter(String name, String value) {
        if (this.additionalParameters == null) {
            this.additionalParameters = new HashMap();
        }
        this.additionalParameters.put(name, value);
    }

    @Override
    public boolean isFormEnabled() {
        return this.formEnabled;
    }

    @Override
    public void setFormEnabled(boolean value) {
        this.formEnabled = value;
    }

    @SASScope
    public void setCellRenderer(Object itemID, TableCellRenderer renderer) {
        this.cellRenderers.put(itemID, renderer);
    }

    @SASScope
    public TableCellRenderer getCellRenderer(Object itemID) {
        return (TableCellRenderer)this.cellRenderers.get(itemID);
    }

    @SASScope
    public void removeAllCellRenderers() {
        this.removeCellRenderers();
    }

    @SASScope
    public void removeCellRenderers() {
        this.cellRenderers.clear();
        this.cellRendererManager.removeAll();
    }

    @SASScope
    public void setCellRenderer(String[][] area, String measure, TableCellRenderer renderer) {
        this.cellRendererManager.setCellRenderer(area, measure, (Object)renderer);
    }

    public void setCellRenderer(OLAPTableFormatArea cellArea, TableCellRenderer renderer) {
        this.cellRendererManager.setCellRenderer(cellArea, (Object)renderer);
    }

    @Override
    @SASScope
    public void removeCellRenderers(Collection collection) {
        this.cellRenderers.clear();
        this.cellRendererManager.remove(collection);
    }

    @SASScope
    public OLAPTableFormatArea[] getCellRendererAreas(Object renderer) {
        return this.cellRendererManager.getCellRendererAreas(renderer);
    }

    @SASScope
    public int getCurrentCellOrdinal() {
        return this.currentCellOrdinal;
    }

    private boolean isMeasure(int index, TupleInterface[] tuples) throws OLAPException {
        TupleElementInterface te = this.getElementAtLevel(index, tuples);
        return this.isMeasure(te);
    }

    private boolean isMeasure(TupleElementInterface te) throws OLAPException {
        if (te == null) {
            return false;
        }
        TupleElementType teType = te.getType();
        return teType == TupleElementType.MEASURE || teType == TupleElementType.GROUP;
    }

    private TupleElementInterface getElementAtLevel(int index, TupleInterface[] tuples) throws OLAPException {
        TupleInterface tuple = tuples[0];
        int pos = 0;
        for (int i = 0; i < tuple.getTupleDepth(); ++i) {
            TupleElementInterface te = tuple.getElement(i);
            if ((pos += te.getSpan()) <= index) continue;
            return te;
        }
        return null;
    }

    @Override
    @SASScope
    public void cleanUpResources() {
        super.cleanUpResources();
        this.rowTupleIds.clear();
        this.columnTupleIds.clear();
        this._resizingUtil = null;
    }

    private StringBuffer getSmallBuffer() {
        if (this.smallTempBuffer == null) {
            this.smallTempBuffer = new StringBuffer(64);
        }
        this.smallTempBuffer.setLength(0);
        return this.smallTempBuffer;
    }

    @SASScope
    public TableCellRenderer getDefaultHeaderRenderer() {
        return this.defaultHeaderRenderer;
    }

    @SASScope
    public void setDefaultHeaderRenderer(TableCellRenderer defaultHeaderRenderer) {
        this.defaultHeaderRenderer = defaultHeaderRenderer;
    }

    private TableCellRenderer getHeaderRenderer(OLAPTableArea area, boolean isMeasure) {
        TableCellRenderer renderer = null;
        if (isMeasure) {
            OLAPTableArea measureArea = OLAPTableArea.MEASURE_HEADER;
            if (area == OLAPTableArea.COLUMN_TITLE || area == OLAPTableArea.ROW_TITLE) {
                measureArea = OLAPTableArea.MEASURE_TITLE;
            }
            if ((renderer = this.getRenderer(measureArea)) != null) {
                return renderer;
            }
        }
        return this.getHeaderRenderer(area);
    }

    private TableCellRenderer getHeaderRenderer(OLAPTableArea area) {
        TableCellRenderer renderer = this.getRenderer(area);
        if (renderer != null) {
            return renderer;
        }
        return this.defaultHeaderRenderer;
    }

    @SASScope
    public TableCellRenderer getRenderer(OLAPTableArea area) {
        return this.areaRenderers[area.getIndex()];
    }

    @SASScope
    public void setRenderer(OLAPTableArea area, TableCellRenderer renderer) {
        this.areaRenderers[area.getIndex()] = renderer;
    }

    @SASScope
    public void removeAreaRenderers() {
        OLAPTableArea[] areas = OLAPTableArea.getAreas();
        for (int i = 0; i < areas.length; ++i) {
            this.areaRenderers[i] = null;
        }
    }

    private String updateCurrentAreaPrefix(OLAPTableArea area) {
        this._currentArea = area;
        this._currentAreaPrefix = areaStyleClassPrefixList[area.getIndex()];
        if (this._currentAreaPrefix == null) {
            this._currentAreaPrefix = baseAreaStyleClassPrefix + area.getDefaultPrefix() + ID_LEVEL_DELIMIT;
        }
        return this._currentAreaPrefix;
    }

    private void resetCurrentAreaPrefix() {
        this._currentArea = null;
        this._currentAreaPrefix = null;
    }

    @SASScope
    public String getCurrentAreaPrefix() {
        return this._currentAreaPrefix;
    }

    @SASScope
    public OLAPTableArea getCurrentArea() {
        return this._currentArea;
    }

    TupleElementInterface getRaggedTupleInterface() {
        return this._raggedTupleElement;
    }

    @SASScope
    public BaseTransformation getInternalTitle() {
        return this._title;
    }

    @SASScope
    public void setInternalTitle(BaseTransformation title) {
        this._title = title;
    }

    @SASScope
    public BaseTransformation getInternalFooter() {
        return this._footer;
    }

    @SASScope
    public void setInternalFooter(BaseTransformation footer) {
        this._footer = footer;
    }

    public int getCurrentHeaderIndex() {
        return this._headerIndex;
    }

    @SASScope
    public TupleInterface getCurrentRowTuple() {
        return this._currentRowTuple;
    }

    @SASScope
    public TupleInterface getCurrentColumnTuple() {
        return this._currentColumnTuple;
    }

    @SASScope
    public HashMap getResizedColumns() {
        return this._resizedColumns;
    }

    private ResizingUtil createResizingUtil() {
        if (this._resizingUtil == null) {
            this._resizingUtil = new ResizingUtil(this);
        } else {
            this._resizingUtil.clear();
        }
        return this._resizingUtil;
    }

    private ActionList _getActions(HttpActionProvider ap, ActionSupportFilter filter) {
        if (ap != null && this.isAllActionsVisible()) {
            filter.setHiddenActionsMap(this.getViewerSupport().getHiddenActionsMap());
            return ap.getActions(filter);
        }
        return null;
    }

    @SASScope
    public Object getCurrentCellRawValue() {
        Object rawValue = null;
        int cellOrdinal = this.getCurrentCellOrdinal();
        OLAPDataSetInterface model = this.getModel();
        if (model != null) {
            Object cell;
            Object[] cells = null;
            try {
                cells = model.getCells((long)cellOrdinal, (long)cellOrdinal);
            }
            catch (Exception e) {
                return rawValue;
            }
            if (cells.length == 1 && (cell = cells[0]) != null) {
                rawValue = cell;
            }
        }
        return rawValue;
    }

    @SASScope
    public Map getCacheOfMeasureFormatsForExportToExcel() {
        return this.cacheOfMeasureFormatsForExport;
    }

    private void cacheMeasureFormatsOnRow() throws OLAPException {
        int nr = this.rowTupleElements.length;
        int nt = 0;
        TupleElementInterface[] ar = null;
        TupleElementInterface t2 = null;
        DataItem di = null;
        BusinessQuery businessQuery = null;
        if (this.isRolap() && this.mi instanceof BusinessQueryProviderInterface) {
            businessQuery = ((BusinessQueryProviderInterface)this.mi).getBusinessQuery();
        }
        for (int a = 0; a < nr; ++a) {
            for (TupleElementInterface t2 : this.rowTupleElements[a]) {
                String format;
                if (t2.getType() != TupleElementType.MEASURE) continue;
                String measureUniqueName = t2.getName();
                if (this.cacheOfMeasureFormatsForExport == null) {
                    this.cacheOfMeasureFormatsForExport = new HashMap(4);
                }
                if (this.cacheOfMeasureFormatsForExport.containsKey(measureUniqueName)) continue;
                if (this.isRolap() && businessQuery != null) {
                    di = OLAPCellRendererManager.findDataItem((BusinessQuery)businessQuery, (TupleElementInterface)t2);
                }
                if ((format = this.getFormat(((BusinessQueryToOLAPDataSetAdapter)this.mi).getModel(), t2, di)) == null) continue;
                this.cacheOfMeasureFormatsForExport.put(measureUniqueName, format);
            }
        }
    }

    private void cacheMeasureFormat(TupleElementInterface correctTupleElement, DataItem di) throws OLAPException {
        if (this.isExportToExcel() && correctTupleElement.getType() == TupleElementType.MEASURE && this.mi instanceof BusinessQueryToOLAPDataSetAdapter) {
            String format;
            String measureUniqueName = correctTupleElement.getName();
            if (this.cacheOfMeasureFormatsForExport == null) {
                this.cacheOfMeasureFormatsForExport = new HashMap(4);
            }
            if (!this.cacheOfMeasureFormatsForExport.containsKey(measureUniqueName) && (format = this.getFormat(((BusinessQueryToOLAPDataSetAdapter)this.mi).getModel(), correctTupleElement, di)) != null) {
                this.cacheOfMeasureFormatsForExport.put(measureUniqueName, format);
            }
        }
    }

    private String getFormat(BusinessQuery businessQuery, TupleElementInterface tupleElement, DataItem di) {
        String format;
        block6: {
            format = null;
            if (this.isRolap()) {
                if (di != null) {
                    format = di.getFormat();
                }
            } else if (businessQuery != null && tupleElement != null) {
                try {
                    format = BusinessQueryToOLAPDataSetAdapter.getFormat((BusinessQuery)businessQuery, (TupleElementInterface)tupleElement);
                }
                catch (OLAPException e) {
                    if (!this.log.isErrorEnabled()) break block6;
                    this.log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return format;
    }

    @SASScope
    public String getCurrentCellFormat() {
        Object oFormat;
        String format = null;
        String currentMeasureUniqueName = this.getCurrentMeasureUniqueName();
        Map cacheOfMeasureFormatsForExportToExcel = this.getCacheOfMeasureFormatsForExportToExcel();
        if (currentMeasureUniqueName != null && cacheOfMeasureFormatsForExportToExcel != null && cacheOfMeasureFormatsForExportToExcel.containsKey(currentMeasureUniqueName) && (oFormat = cacheOfMeasureFormatsForExportToExcel.get(currentMeasureUniqueName)) != null) {
            format = oFormat.toString();
        }
        return format;
    }

    private static void _returnActions(HttpActionProvider ap, ActionList actions) {
        if (ap != null) {
            ap.returnActionList(actions);
        }
    }

    @Override
    public boolean isCurrentValueToEncode() {
        return this.toEncode;
    }

    public List<String> getHeaderDataItemsToNotEncode(String[] uniqueLvlNames, TupleInterface tuple) {
        ArrayList<String> list;
        block7: {
            list = new ArrayList<String>();
            if (uniqueLvlNames != null && tuple != null && this.mi != null) {
                try {
                    BusinessQuery businessQuery = ((BusinessQueryProviderInterface)this.mi).getBusinessQuery();
                    if (businessQuery != null) {
                        boolean isMeasure = true;
                        String uniqueLvlName = null;
                        DataItem di = null;
                        ArrayList<TupleInterface> tuples = new ArrayList<TupleInterface>();
                        tuples.add(tuple);
                        for (int i = 0; i < uniqueLvlNames.length; ++i) {
                            TupleElementInterface te = this.getElementAtLevel(i, tuples.toArray(new TupleInterface[0]));
                            if (te != null) {
                                isMeasure = this.isMeasure(te);
                                if (isMeasure || list.contains(uniqueLvlName = uniqueLvlNames[i]) || (di = OLAPCellRendererManager.findDataItem((BusinessQuery)businessQuery, (TupleElementInterface)te)) == null || di.getExtendedType() != DataItemExtendedType.HTML) continue;
                                list.add(uniqueLvlName);
                                continue;
                            }
                            this.log.warn("One of the TupleElementInterface is null in getHeaderDataItemsToNotEncode()");
                        }
                        break block7;
                    }
                    this.log.warn("The BusinessQuery is null in getHeaderDataItemsToNotEncode()");
                }
                catch (OLAPException e) {
                    this.log.warn(e.getMessage(), (Throwable)e);
                }
            } else {
                this.log.warn("Either one of the received parameters is null or the OLAPDataSetInterface 'mi' is null in getHeaderDataItemsToNotEncode()");
            }
        }
        return list;
    }

    static {
        JavaScriptIncludeHandler.addAlias(OLAPTableView.class, "OLAPTABLEVIEW");
    }

    @SASScope
    public static class IOExceptionWithCause
    extends IOException {
        public IOExceptionWithCause(String message) {
        }

        public IOExceptionWithCause(String message, Exception cause) {
            super(message);
            this.initCause(cause);
        }

        public IOExceptionWithCause(Exception cause) {
            this.initCause(cause);
        }
    }
}

