/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.olaptableview.html;

import com.sas.actionprovider.ActionList;
import com.sas.actionprovider.ActionProviderMapPool;
import com.sas.actionprovider.ActionProviderViewInterface;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.HttpActionProvider;
import com.sas.actionprovider.Util;
import com.sas.codepolicy.SASScope;
import com.sas.entities.AttributeSetException;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.servlet.tbeans.ComplexStyleInterface;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.StyleMap;
import com.sas.servlet.tbeans.olaptableview.BaseOLAPDrillState;
import com.sas.servlet.tbeans.olaptableview.DrillStateInfo;
import com.sas.servlet.tbeans.olaptableview.DrillStateProvider;
import com.sas.servlet.tbeans.olaptableview.html.OLAPDrillStateStyleKeysInterface;
import com.sas.servlet.util.ComponentSessionManager;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.swing.visuals.olaptableview.OLAPCellRendererManager;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

@SASScope(value="ALL")
public class OLAPDrillState
extends BaseOLAPDrillState
implements ComplexStyleInterface,
OLAPDrillStateStyleKeysInterface {
    private static final long serialVersionUID = 5771523081969081406L;
    private static final Map _defaultStyleMap;
    private StyleMap styleMap;
    private ActionSupportFilter filter = new ActionSupportFilter();
    @SASScope
    public static final String RB_KEY = "OLAPDrillState.";

    public OLAPDrillState() {
        this.styleMap = new StyleMap(_defaultStyleMap);
    }

    @SASScope
    protected void writeHeader(PrintWriter out) throws IOException {
        StringBuffer sb = new StringBuffer();
        if (this.getTagProlog() != null) {
            sb.append(this.getTagProlog());
        }
        sb.append("<table");
        switch (this.getHorizontalAlignment()) {
            case 2: {
                sb.append(" align=\"left\"");
                break;
            }
            case 4: {
                sb.append(" align=\"right\"");
                break;
            }
            case 0: {
                sb.append(" align=\"center\"");
                break;
            }
        }
        sb.append(" id=\"");
        sb.append(this.getId());
        sb.append("\"");
        if (this.getCellSpacing() != 2) {
            sb.append(" cellspacing=\"");
            sb.append(this.getCellSpacing());
            sb.append("\"");
        }
        if (this.getCellPadding() != 1) {
            sb.append(" cellpadding=\"");
            sb.append(this.getCellPadding());
            sb.append("\"");
        }
        StyleInfo si = (StyleInfo)this.getStyleMap().get("OLAPDRILLSTATE_STYLE");
        si.write(sb, this.getStyleClassPrefix());
        if (this.getCustomAttributes() != null) {
            sb.append(" ");
            sb.append(this.getCustomAttributes());
        }
        sb.append(" >");
        out.println(sb.toString());
    }

    @SASScope
    protected void writeDimensionsDrillState(PrintWriter out) throws IOException {
        if (this.drillState != null) {
            DrillStateProvider drillStateProvider = this.getDrillStateProvider();
            String titleString = this.getTitle();
            boolean isFirstDrillState = true;
            int i = 0;
            for (DrillStateInfo dimensionDrillInfo : this.drillState) {
                try {
                    this.filter.setPoolingOn(true);
                    this.filter.setSwing(false);
                    this.filter.setActionSupportType(this.getActionSupportType());
                    this.filter.setViewer((ActionProviderViewInterface)this);
                    this.filter.setAreaType("DRILL_STATE_AREA");
                    this.filter.setViewerId(this.getId() + i);
                    this.filter.setHiddenActionsMap(this.getViewerSupport().getHiddenActionsMap());
                    TupleElementInterface tupleElement = dimensionDrillInfo.getTupleElement();
                    this.filter.setAttribute("tupleElement", (Object)tupleElement);
                    this.filter.setAttribute("isAllLevel", (Object)(dimensionDrillInfo.isAllLevel() ? Boolean.TRUE : Boolean.FALSE));
                    this.filter.setAttribute("drillStateLabels", (Object)dimensionDrillInfo.getDrillStateLabels());
                    this.filter.setAttribute("drillStateUniqueNames", (Object)dimensionDrillInfo.getDrillStateUniqueNames());
                    this.filter.setAttribute("drillStateProvider", (Object)drillStateProvider);
                    BusinessQueryProviderInterface bqProvider = dimensionDrillInfo.getBusinessQueryProvider();
                    this.filter.setAttribute("model", (Object)bqProvider);
                    if (bqProvider != null) {
                        DataItem dataItem = OLAPCellRendererManager.findDataItem((BusinessQuery)bqProvider.getBusinessQuery(), (TupleElementInterface)tupleElement);
                        this.filter.setAttribute("dataItem", (Object)dataItem);
                    }
                    this.filter.setAttribute("includeAllLevel", (Object)(dimensionDrillInfo.isIncludeMembersFromAllLevel() ? Boolean.TRUE : Boolean.FALSE));
                }
                catch (AttributeSetException ase) {
                    throw new IOException(ase.getMessage());
                }
                ActionList actions = null;
                HttpActionProvider actionProvider = this.getActionProvider();
                if (actionProvider != null) {
                    actions = actionProvider.getActions(this.filter);
                }
                if (actions != null && !actions.isEmpty()) {
                    if (this.getTitleDisplayed() != 2 && isFirstDrillState && titleString != null && titleString.length() > 0) {
                        this.writeTitle(out, titleString);
                        isFirstDrillState = false;
                        this.writeCloseTitle(out);
                    }
                    out.print("<tr><td><table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"");
                    StyleInfo si = (StyleInfo)this.getStyleMap().get("OLAPDRILLSTATE_ITEM");
                    out.print(si.write(new StringBuffer(), this.getStyleClassPrefix()));
                    out.print("><tr>");
                    String label = null;
                    if (this.getLabelType() == 1) {
                        label = dimensionDrillInfo.getDimensionLabel();
                    } else if (this.getLabelType() == 2) {
                        label = dimensionDrillInfo.getHierarchyLabel();
                    }
                    if (label != null && label.length() > 0) {
                        out.print("<td");
                        si = (StyleInfo)this.getStyleMap().get("OLAPDRILLSTATE_LABEL");
                        out.print(si.write(new StringBuffer(), this.getStyleClassPrefix()));
                        out.print(">");
                        out.print(label + ": ");
                        out.print("</td>");
                    }
                    out.print("<td>");
                    HashMap argumentMap = ActionProviderMapPool.getMap();
                    argumentMap.put("REQUEST", this.getRequest());
                    argumentMap.put("SEPARATOR_IMAGE", this.getSeparatorImage());
                    argumentMap.put("SEPARATOR", this.getSeparator());
                    String styleClassPrefix = this.getStyleClassPrefix();
                    argumentMap.put("STYLE_CLASS_PREFIX", styleClassPrefix == null ? "olapDrillState" : styleClassPrefix + "olapDrillState");
                    argumentMap.put("ENCODE_TEXT", Boolean.TRUE);
                    Util.writeActionList(actions, out, argumentMap);
                    ActionProviderMapPool.returnMap((Map)argumentMap);
                    out.print("</td></tr></table></td></tr>");
                }
                if (actionProvider != null) {
                    actionProvider.returnActionList(actions);
                }
                ++i;
            }
            if (this.getTitleDisplayed() == 0 && isFirstDrillState && titleString != null && titleString.length() > 0) {
                this.writeTitle(out, titleString);
                this.writeNoDrillState(out);
                this.writeCloseTitle(out);
            }
        }
    }

    private void writeTitle(PrintWriter out, String titleString) {
        out.print("<tr><td><span ");
        out.print("class=\"olapDrillStateTitle\"");
        out.print(">");
        out.print(titleString);
        out.print("&#160;");
        out.println("</span>");
    }

    private void writeCloseTitle(PrintWriter out) {
        out.print("</td></tr>");
    }

    private void writeNoDrillState(PrintWriter out) {
        String noDrillState = this.getNoDrillStateText();
        if (this.isNoDrillStateTextDisplayed() && noDrillState != null && noDrillState.length() > 0) {
            out.print("<span ");
            out.print("class=\"olapDrillStateLabel\"");
            out.print(">");
            out.print(noDrillState);
            out.print("</span>");
        }
    }

    @Override
    public Map getStyleMap() {
        return this.styleMap;
    }

    @Override
    protected void writeContent(PrintWriter out) throws IOException {
        if (this.getDrillStateProvider() == null) {
            this.cleanUpResources();
            throw new IllegalStateException("OLAPDrillState component could not be written. No drill state provider set.");
        }
        if (this.isDrillStateDirty()) {
            this.captureDrillState();
        }
        this.flushActionProvider();
        this.setDefaultFormAction();
        if (this.isPartialRefreshActionsEnabled()) {
            HttpServletRequest request;
            JavaScriptIncludeHandler.writeIncludes(out, "AJAX", this.getRequest());
            if (this.getPartialRefreshProxy() == null && (request = this.getRequest()) != null) {
                ComponentSessionManager.getSessionManager(request).put(this.getId(), this);
            }
        }
        if (this.drillState != null && !this.drillState.isEmpty()) {
            this.writeHeader(out);
            this.writeDimensionsDrillState(out);
            out.println("</table>");
            if (this.getTagEpilog() != null) {
                out.println(this.getTagEpilog());
            }
        }
    }

    static {
        HashMap<String, ImmutableStyleInfo> defaultStyleMap = new HashMap<String, ImmutableStyleInfo>();
        defaultStyleMap.put("OLAPDRILLSTATE_STYLE", new ImmutableStyleInfo("olapDrillState"));
        defaultStyleMap.put("OLAPDRILLSTATE_ITEM", new ImmutableStyleInfo("olapDrillStateItem"));
        defaultStyleMap.put("OLAPDRILLSTATE_LABEL", new ImmutableStyleInfo("olapDrillStateLabel"));
        _defaultStyleMap = defaultStyleMap;
    }
}

