/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.olaptableview.html;

import com.sas.actionprovider.ActionList;
import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.GraphStyle;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMap;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.olaptableview.html.DefaultOLAPTableDataCellRenderer;
import com.sas.servlet.tbeans.olaptableview.html.OLAPTableView;
import com.sas.servlet.tbeans.tableview.AbstractBaseTableView;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.transforms.IntegerToHexStringTransform;
import jakarta.servlet.http.HttpServletRequest;
import java.awt.Color;
import java.io.IOException;
import java.io.PrintWriter;

@SASScope(value="ALL")
public class OLAPColorMapTableCellRenderer
extends DefaultOLAPTableDataCellRenderer {
    private ContinuousRangeToColorMap colorMap;
    static final String HEXZERO = "00";
    private IntegerToHexStringTransform intToHex;
    private GraphStyle graphStyle;
    private double[] colorRampValues;
    private Color[] colorRampColors;
    private CommonLoggerInterface log = LoggerRepository2.getLogger((String)OLAPColorMapTableCellRenderer.class.getPackage().getName(), null);

    public OLAPColorMapTableCellRenderer() {
        this.colorMap = new ContinuousRangeToColorMap();
        this.intToHex = new IntegerToHexStringTransform();
    }

    @Override
    public void write(PrintWriter out, AbstractBaseTableView tableview, Object value, String name, ActionList actions) throws IOException {
        StyleInfo oldStyleInfo = this.getStyleInfo();
        this.colorMap = this.updateColorRange(tableview.getRequest());
        this.colorMap.init(new AInitAction((Object)this.colorMap));
        StringBuffer rgb = null;
        try {
            OLAPTableView olapTableView = (OLAPTableView)tableview;
            OLAPDataSetInterface model = olapTableView.getModel();
            Object[] cell = model.getCells((long)olapTableView.getCurrentCellOrdinal(), (long)olapTableView.getCurrentCellOrdinal());
            Color c = null;
            if (cell[0] instanceof Double) {
                double d = (Double)cell[0];
                c = this.colorMap.getValue(d);
            } else {
                c = Color.LIGHT_GRAY;
            }
            if (c != null) {
                rgb = new StringBuffer();
                int red = c.getRed();
                int green = c.getGreen();
                int blue = c.getBlue();
                if (red != 0) {
                    rgb.append((String)this.intToHex.transform((Object)new Integer(red)));
                } else {
                    rgb.append(HEXZERO);
                }
                if (green != 0) {
                    rgb.append((String)this.intToHex.transform((Object)new Integer(green)));
                } else {
                    rgb.append(HEXZERO);
                }
                if (blue != 0) {
                    rgb.append((String)this.intToHex.transform((Object)new Integer(blue)));
                } else {
                    rgb.append(HEXZERO);
                }
            }
        }
        catch (OLAPException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        String cid = this.getStyleInfo().getClassid();
        if (cid != null && rgb != null) {
            StyleInfo newStyleInfo = new StyleInfo(cid, "background-color: #" + rgb);
            this.setStyleInfo(newStyleInfo);
        }
        super.write(out, tableview, value, name, actions);
        this.setStyleInfo(oldStyleInfo);
    }

    public int getGraphStyleType() {
        return this.graphStyle.getName();
    }

    public void setGraphStyleType(int gStyle) {
        this.graphStyle = new GraphStyle(gStyle);
        this.colorRampColors = new Color[]{this.graphStyle.getDataElementStyles().getContinuousContrastThreeColorStartColor(), this.graphStyle.getDataElementStyles().getContinuousContrastThreeColorNeutralColor(), this.graphStyle.getDataElementStyles().getContinuousContrastThreeColorEndColor()};
        this.colorMap.setColorSpectrumColors(this.colorRampColors);
    }

    public double[] getColorRampValues() {
        return this.colorRampValues;
    }

    public void setColorRampValues(double min, double midpoint, double max) {
        this.colorRampValues = new double[]{min, midpoint, max};
        this.colorMap.setColorSpectrumValues(this.colorRampValues);
    }

    protected ContinuousRangeToColorMap updateColorRange(HttpServletRequest request) {
        ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(request);
        this.graphStyle = cpm.getGraphStyle();
        this.colorRampColors = new Color[]{this.graphStyle.getDataElementStyles().getContinuousFillThreeColorStartColor(), this.graphStyle.getDataElementStyles().getContinuousFillThreeColorNeutralColor(), this.graphStyle.getDataElementStyles().getContinuousFillThreeColorEndColor()};
        this.colorMap.setColorSpectrumColors(this.colorRampColors);
        return this.colorMap;
    }
}

