/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.olaptableview.html;

import com.sas.actionprovider.ActionList;
import com.sas.codepolicy.SASScope;
import com.sas.servlet.commands.jdbc.export.Util;
import com.sas.servlet.tbeans.BaseLabel;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.StyleInterface;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.olaptableview.html.ColorGradientUtil;
import com.sas.servlet.tbeans.olaptableview.html.DefaultOLAPTableLabelCellContentsRenderer;
import com.sas.servlet.tbeans.olaptableview.html.MemberPropertiesUtil;
import com.sas.servlet.tbeans.tableview.AbstractBaseTableView;
import com.sas.servlet.tbeans.tableview.ExportAsHyperlinkInterface;
import com.sas.servlet.tbeans.tableview.TableCellContentsRenderer;
import com.sas.servlet.tbeans.tableview.TableCellRenderer;
import com.sas.servlet.tbeans.tableview.html.BaseTableCell;
import com.sas.servlet.tbeans.tableview.html.ResizingUtil;
import com.sas.storage.jdbc.export.SAStoExcelUtil;
import com.sas.storage.olap.OLAPException;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import java.awt.Color;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;

@SASScope(value="ALL")
public class DefaultOLAPTableLabelCellRenderer
extends BaseTableCell
implements TableCellRenderer {
    private TableCellContentsRenderer tableCellContentsRenderer;
    private Color baseGradientColor = null;
    static final StyleInfo NO_SAVED_STYLE = new StyleInfo();
    private String extraStyle = null;
    private HashMap _levelDepthMap;
    CommonLoggerInterface log = LoggerRepository2.getLogger((String)DefaultOLAPTableLabelCellRenderer.class.getPackage().getName(), null);

    public DefaultOLAPTableLabelCellRenderer() {
        this.setHeader(true);
        this.setTableCellContentsRenderer(new DefaultOLAPTableLabelCellContentsRenderer());
    }

    @Override
    public void setTableCellContentsRenderer(TableCellContentsRenderer contentsRenderer) {
        this.tableCellContentsRenderer = contentsRenderer;
    }

    @Override
    public TableCellContentsRenderer getTableCellContentsRenderer() {
        return this.tableCellContentsRenderer;
    }

    @Override
    public void write(PrintWriter out, AbstractBaseTableView tableview, Object value, String name, ActionList actions) throws IOException {
        StyleInfo savedStyle = this.updateAndSaveStyle(tableview, value, actions);
        if (tableview.isExportToExcel() && value != null && this.isHeader()) {
            Util.addFormatDirective(this, SAStoExcelUtil.getMicrosoftOfficeNumberFormatXMLDirective((String)SAStoExcelUtil.EXCEL_TEXT_FORMAT));
        }
        ResizingUtil.writeBeginCell(out, tableview, this);
        TransformationInterface tbean = this.tableCellContentsRenderer.getCellContentsRendererComponent(tableview, value, actions);
        tbean.setRequest(tableview.getRequest());
        tbean.setResponse(tableview.getResponse());
        this.setLocale(tableview.getLocale());
        tbean.setLocale(this.getLocale());
        boolean encodeText = false;
        String text = null;
        boolean toEncode = true;
        if (tableview.isExportToExcel() && value != null && tbean instanceof BaseLabel) {
            if (tableview instanceof ExportAsHyperlinkInterface) {
                toEncode = ((ExportAsHyperlinkInterface)((Object)tableview)).isCurrentValueToEncode();
            }
            if (toEncode) {
                encodeText = ((BaseLabel)tbean).isEncodeText();
                ((BaseLabel)tbean).setEncodeText(false);
                text = ((BaseLabel)tbean).getText();
                ((BaseLabel)tbean).setText(Util.encodeForExcel(text));
            }
        }
        tbean.write(out);
        this.restoreStyleInfo(this, savedStyle);
        this.displayMemberProperties(out, tableview, value, actions);
        if (tableview.isExportToExcel() && value != null && tbean instanceof BaseLabel && toEncode) {
            ((BaseLabel)tbean).setEncodeText(encodeText);
            if (text != null) {
                ((BaseLabel)tbean).setText(text);
            }
        }
        toEncode = true;
        this.writeEndCell(out);
    }

    private void displayMemberProperties(PrintWriter out, AbstractBaseTableView tableview, Object value, ActionList actions) {
        try {
            MemberPropertiesUtil.displayMemberProperties(out, tableview, value, actions, this.getStyleClassPrefix());
        }
        catch (OLAPException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    private StyleInfo updateAndSaveStyle(Object tbean, Object value, ActionList actionList) {
        StyleInfo styleInfo = ColorGradientUtil.applyGradientAndSaveStyle(this, tbean, value, actionList);
        if ((styleInfo == null || styleInfo == NO_SAVED_STYLE) && this.extraStyle != null) {
            styleInfo = this.saveStyle(this, this.extraStyle);
        }
        return styleInfo;
    }

    HashMap getLevelDepthMap() {
        if (this._levelDepthMap == null) {
            this._levelDepthMap = new HashMap();
        }
        return this._levelDepthMap;
    }

    private void restoreStyleInfo(Object tbean, StyleInfo savedStyle) {
        if (savedStyle != NO_SAVED_STYLE) {
            StyleInterface si = (StyleInterface)tbean;
            si.setStyleInfo(savedStyle);
        }
    }

    StyleInfo saveStyle(StyleInterface tbean, String add) {
        StyleInfo oldStyle = tbean.getStyleInfo();
        StyleInfo newStyleInfo = this.addToStyle(oldStyle, add);
        tbean.setStyleInfo(newStyleInfo);
        return oldStyle;
    }

    private StyleInfo addToStyle(StyleInfo oldStyle, String add) {
        String style = oldStyle.getStyle();
        style = style == null || style.length() == 0 ? "" : style + "; ";
        style = style + add;
        StyleInfo newStyleInfo = new StyleInfo(oldStyle.getClassid(), style);
        return newStyleInfo;
    }

    @SASScope
    public Color getBaseGradientColor() {
        return this.baseGradientColor;
    }

    @SASScope
    public void setBaseGradientColor(Color baseGradientColor) {
        this.baseGradientColor = baseGradientColor;
    }

    @SASScope
    public String getExtraStyle() {
        return this.extraStyle;
    }

    @SASScope
    public void setExtraStyle(String extraStyle) {
        this.extraStyle = extraStyle;
    }
}

