/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.olaptableview;

import com.sas.actionprovider.ActionList;
import com.sas.actionprovider.ActionProviderViewInterface;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.HttpActionProvider;
import com.sas.codepolicy.SASScope;
import com.sas.entities.AttributeSetException;
import com.sas.servlet.tbeans.olaptableview.html.OLAPTableView;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.OLAPUtil;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.PrintWriter;

@SASScope
public class PopMenuServlet
extends HttpServlet {
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String VName = request.getParameter("VIEWERNAME");
        if (VName == null || VName.length() > 0) {
            return;
        }
        HttpSession session = request.getSession();
        OLAPTableView olapTable = (OLAPTableView)session.getAttribute(VName);
        OLAPDataSetInterface olapModel = null;
        ResultSetMetadataInterface resultSetMetadata = null;
        if (olapTable == null) {
            return;
        }
        olapModel = olapTable.getModel();
        try {
            resultSetMetadata = olapModel.getResultSetMetadata();
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        if (olapModel == null) {
            return;
        }
        HttpActionProvider actionProvider = olapTable.getActionProvider();
        int axisIndex = -1;
        int tupleIndex = -1;
        int tupleElementIndex = -1;
        try {
            axisIndex = Integer.parseInt(request.getParameter("axisIndex"));
            tupleIndex = Integer.parseInt(request.getParameter("tupleIndex"));
            tupleElementIndex = Integer.parseInt(request.getParameter("tupleElementIndex"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (axisIndex > -1 && tupleIndex > -1 && tupleElementIndex > -1) {
            ActionSupportFilter titleFilter = new ActionSupportFilter("OLAP_TABLEVIEW_SUPPORT", "TITLE_AREA", (ActionProviderViewInterface)olapTable, false);
            titleFilter.setViewerId(olapTable.getId());
            try {
                titleFilter.setAttribute("model", (Object)olapModel);
            }
            catch (AttributeSetException ase) {
                throw new IOException("OLAPTableView: writeColumns(): model could not be set on filter");
            }
            int startColumn = olapTable.getStartColumn();
            int endColumn = olapTable.getEndColumn();
            int startRow = olapTable.getStartRow();
            int endRow = olapTable.getEndRow();
            try {
                AxisInterface axis = null;
                TupleInterface[] tuples = null;
                if (axisIndex == 0) {
                    axis = resultSetMetadata.getAxes(0, 1)[0];
                    tuples = axis.getTuples(startColumn, endColumn - startColumn + 1);
                } else if (axisIndex == 1) {
                    axis = resultSetMetadata.getAxes(1, 1)[0];
                    tuples = axis.getTuples(startRow, endRow - startRow + 1);
                }
                int maxTupleDepth = OLAPUtil.getMaximumTupleDepth(tuples);
                TupleInterface longestTuple = null;
                int longestTupleIndex = 0;
                for (int i = 0; i < tuples.length; ++i) {
                    if (tuples[i].getTupleDepth() != maxTupleDepth) continue;
                    longestTuple = tuples[i];
                    longestTupleIndex = i;
                    break;
                }
                TupleElementInterface[] tupleElements = longestTuple.getElements(0, longestTuple.getTupleDepth());
                TupleElementInterface tupleElement = tupleElements[tupleElementIndex];
                try {
                    titleFilter.setAttribute("tupleElement", (Object)tupleElement);
                }
                catch (AttributeSetException attributeSetException) {
                    // empty catch block
                }
                ActionList actionList = actionProvider.getActions(titleFilter);
                System.out.println("****Printing list of Actions for axis=" + axis + " tupleIndex=" + tupleIndex + " tupleElementIndex=" + tupleElementIndex + "****");
                System.out.println("***********************************************************\n");
            }
            catch (OLAPException oLAPException) {}
        } else {
            return;
        }
        PrintWriter out = response.getWriter();
    }
}

