/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.olaptableview;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.servlet.tbeans.olaptableview.DefaultDrillStateInfo;
import com.sas.servlet.tbeans.olaptableview.DrillStateInfo;
import com.sas.servlet.tbeans.olaptableview.DrillStateProvider;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.swing.visuals.olaptableview.OLAPDrillStateUtil;
import com.sas.util.ListFactory;
import java.util.List;

@SASScope
public class OLAPDataSetDrillStateProvider
implements DrillStateProvider {
    private OLAPDataSetInterface _dataSet = null;
    private BusinessQueryProviderInterface _businessQueryProvider = null;

    public OLAPDataSetDrillStateProvider(OLAPDataSetInterface dataSet) {
        this(dataSet, null);
    }

    public OLAPDataSetDrillStateProvider(OLAPDataSetInterface dataSet, BusinessQueryProviderInterface businessQueryProvider) {
        this._dataSet = dataSet;
        this._businessQueryProvider = businessQueryProvider;
    }

    public OLAPDataSetInterface getDataSet() {
        return this._dataSet;
    }

    public List getDrillStateInfo(boolean includeAllMember) {
        return this.getDrillStateInfo(includeAllMember, false);
    }

    @Override
    public List getDrillStateInfo(boolean includeAllMember, boolean useCachedTuples) {
        List utilInfos = OLAPDrillStateUtil.getOLAPDrillStateInfo((OLAPDataSetInterface)this._dataSet, (boolean)includeAllMember, (boolean)useCachedTuples);
        if (utilInfos == null) {
            return null;
        }
        BusinessQueryProviderInterface bqProvider = this.getBusinessQueryProvider();
        List outInfos = ListFactory.newList((int)utilInfos.size());
        for (List utilInfo : utilInfos) {
            DrillStateInfo drillStateInfo = OLAPDataSetDrillStateProvider.toDrillStateInfo(utilInfo, bqProvider);
            outInfos.add(drillStateInfo);
        }
        return outInfos;
    }

    private BusinessQueryProviderInterface getBusinessQueryProvider() {
        return this._businessQueryProvider;
    }

    private static DrillStateInfo toDrillStateInfo(List drillStateInfoList, BusinessQueryProviderInterface businessQueryProvider) {
        if (drillStateInfoList == null || drillStateInfoList.size() != 7) {
            return null;
        }
        DefaultDrillStateInfo drillInfo = new DefaultDrillStateInfo();
        drillInfo.setBusinessQueryProvider(businessQueryProvider);
        drillInfo.setDimensionLabel((String)drillStateInfoList.get(0));
        drillInfo.setHierarchyLabel((String)drillStateInfoList.get(1));
        drillInfo.setAllLevel((Boolean)drillStateInfoList.get(2));
        drillInfo.setDrillStateLabels((List)drillStateInfoList.get(3));
        drillInfo.setDrillStateUniqueNames((List)drillStateInfoList.get(4));
        drillInfo.setTupleElement((TupleElementInterface)drillStateInfoList.get(5));
        drillInfo.setIncludeMembersFromAllLevel((Boolean)drillStateInfoList.get(6));
        return drillInfo;
    }
}

