/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.olaptableview;

import com.sas.actionprovider.ActionProviderEvent;
import com.sas.actionprovider.HttpActionProvider;
import com.sas.beans.Util;
import com.sas.codepolicy.SASScope;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.StructureOfData;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.servlet.tbeans.navigationbar.BaseNavigationInterface;
import com.sas.servlet.tbeans.olaptableview.RB;
import com.sas.servlet.tbeans.tableview.AbstractBaseTableView;
import com.sas.servlet.tbeans.tableview.rpf.RulesUtil;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;

@SASScope(value="ALL")
public abstract class BaseOLAPTableView
extends AbstractBaseTableView
implements ContentsChangedListener,
BaseNavigationInterface {
    static final String RB_KEY = "BaseOLAPTableView.";
    static final long serialVersionUID = -4054726421808290462L;
    private boolean deferInitialize = false;
    private boolean debug1 = false;
    @SASScope
    protected OLAPDataSetInterface mi;
    @SASScope
    protected ResultSetMetadataInterface resultSetMetadata;
    @SASScope
    protected AxisInterface rowAxis;
    @SASScope
    protected TupleInterface[] rowTuples;
    @SASScope
    protected AxisInterface columnAxis;
    @SASScope
    protected TupleInterface[] columnTuples;
    private String writeFailureMessage;
    @SASScope
    protected int lowestRowCoordinate;
    @SASScope
    protected int lowestColumnCoordinate;
    @SASScope
    protected String[][] rowTupleElementIds;
    @SASScope
    protected String[][] columnTupleElementIds;
    @SASScope
    protected int setupStartRow;
    @SASScope
    protected int setupEndRow;
    @SASScope
    protected int setupStartColumn;
    @SASScope
    protected int setupEndColumn;
    private boolean gradientHeaderColors = false;
    protected boolean rolap = false;

    public BaseOLAPTableView() {
        this.setActionSupportType("OLAP_TABLEVIEW_SUPPORT");
        this.setupStartRow = -1;
        this.setupEndRow = -1;
        this.setupStartColumn = -1;
        this.setupEndColumn = -1;
    }

    public void setModel(OLAPDataSetInterface model) {
        if (this.mi != model) {
            StructureOfData structure;
            BusinessModel businessModel;
            BusinessQuery businessQuery;
            this.mi = model;
            this.initialize();
            if (this.mi instanceof BusinessQueryProviderInterface && (businessQuery = ((BusinessQueryProviderInterface)this.mi).getBusinessQuery()) != null && (businessModel = businessQuery.getBusinessModel()) != null && (structure = businessModel.getStructure()) != null && structure.isRelational()) {
                this.rolap = true;
            }
        }
    }

    @SASScope
    public void setup() {
        if (this.mi != null) {
            try {
                if (!this.rowNumbersAreValid() || !this.columnNumbersAreValid()) {
                    this.initializeRowNumbers();
                    this.initializeColumnNumbers();
                }
                if (this.resultSetMetadata == null) {
                    this.resultSetMetadata = this.mi.getResultSetMetadata();
                }
                AxisInterface[] axes = null;
                if (this.resultSetMetadata != null) {
                    axes = this.resultSetMetadata.getAxes(1, 1);
                }
                if (axes != null && this.rowAxis == null) {
                    this.rowAxis = axes[0];
                }
                if (this.rowAxis != null && this.getRowCount() > 0 && (this.rowTuples == null || this.setupStartRow != this.startRow || this.setupEndRow != this.endRow)) {
                    this.rowTuples = this.rowAxis.getTuples(this.startRow, this.endRow - this.startRow + 1);
                }
                axes = null;
                if (this.resultSetMetadata != null) {
                    axes = this.resultSetMetadata.getAxes(0, 1);
                }
                if (axes == null || this.columnAxis == null) {
                    // empty if block
                }
                this.columnAxis = axes[0];
                if (this.columnAxis != null && this.getColumnCount() > 0 && (this.columnTuples == null || this.setupStartColumn != this.startColumn || this.setupEndColumn != this.endColumn)) {
                    this.columnTuples = this.columnAxis.getTuples(this.startColumn, this.endColumn - this.startColumn + 1);
                }
                this.setupStartRow = this.startRow;
                this.setupEndRow = this.endRow;
                this.setupStartColumn = this.startColumn;
                this.setupEndColumn = this.endColumn;
                if (this.rowAxis != null && this.columnAxis != null) {
                    this.setupIDCaches(this.rowTuples, this.columnTuples, this.rowAxis.getMaximumTupleDepth(), this.columnAxis.getMaximumTupleDepth());
                }
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
    }

    private void setupIDCaches(TupleInterface[] rowTuples, TupleInterface[] columnTuples, int maxRowDepth, int maxColumnDepth) {
        this.lowestRowCoordinate = -1;
        this.lowestColumnCoordinate = -1;
        if (rowTuples == null || columnTuples == null) {
            return;
        }
        int highestRowCoordinate = 0;
        int highestColumnCoordinate = 0;
        try {
            int max;
            int min;
            int i;
            int length;
            TupleElementInterface[] elements = rowTuples[0].getElements(0, -1);
            if (elements != null) {
                this.lowestRowCoordinate = elements[0].getMinimumCoordinate();
                length = elements.length;
                for (i = 1; i < length; ++i) {
                    min = elements[i].getMinimumCoordinate();
                    if (min >= this.lowestRowCoordinate) continue;
                    this.lowestRowCoordinate = min;
                }
            }
            if ((elements = rowTuples[rowTuples.length - 1].getElements(0, -1)) != null) {
                highestRowCoordinate = elements[0].getMinimumCoordinate();
                length = elements.length;
                for (i = 1; i < length; ++i) {
                    max = elements[i].getMinimumCoordinate();
                    if (max <= highestRowCoordinate) continue;
                    highestRowCoordinate = max;
                }
            }
            if ((elements = columnTuples[0].getElements(0, -1)) != null) {
                this.lowestColumnCoordinate = elements[0].getMinimumCoordinate();
                length = elements.length;
                for (i = 1; i < length; ++i) {
                    min = elements[i].getMinimumCoordinate();
                    if (min >= this.lowestColumnCoordinate) continue;
                    this.lowestColumnCoordinate = min;
                }
            }
            if ((elements = columnTuples[columnTuples.length - 1].getElements(0, -1)) != null) {
                highestColumnCoordinate = elements[0].getMinimumCoordinate();
                length = elements.length;
                for (i = 1; i < length; ++i) {
                    max = elements[i].getMinimumCoordinate();
                    if (max <= highestColumnCoordinate) continue;
                    highestColumnCoordinate = max;
                }
            }
            this.rowTupleElementIds = new String[maxRowDepth + 1][highestRowCoordinate - this.lowestRowCoordinate + 1];
            this.columnTupleElementIds = new String[maxColumnDepth + 1][highestColumnCoordinate - this.lowestColumnCoordinate + 1];
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
    }

    public OLAPDataSetInterface getModel() {
        return this.mi;
    }

    public void contentsChanged(ContentsChangedEvent cce) {
        if (cce != null && cce instanceof ActionProviderEvent) {
            try {
                if (this.mi == null) {
                    return;
                }
                this.resultSetMetadata = this.mi.getResultSetMetadata();
                ActionProviderEvent ape = (ActionProviderEvent)cce;
                Map eventInfo = ape.getEventInfo();
                if (eventInfo == null || ape.getSource() != this.mi) {
                    return;
                }
                String axis = null;
                String changeType = null;
                if (eventInfo.containsKey("ROW")) {
                    axis = "ROW";
                    changeType = (String)eventInfo.get("ROW");
                } else if (eventInfo.containsKey("COLUMN")) {
                    axis = "COLUMN";
                    changeType = (String)eventInfo.get("COLUMN");
                }
                if (eventInfo.containsKey("ROW_COLUMN")) {
                    axis = "ROW_COLUMN";
                    changeType = (String)eventInfo.get("ROW_COLUMN");
                }
                TupleElementInterface te = (TupleElementInterface)eventInfo.get("tupleElement");
                if (axis != null && axis.equals("ROW")) {
                    if (changeType.equals("INITIALIZE")) {
                        this.initializeRowNumbers();
                        this.refreshColumnNumbers();
                    } else if (changeType.equals("REFRESH")) {
                        List tupleList = null;
                        if (eventInfo.containsKey("TUPLE")) {
                            tupleList = (List)eventInfo.get("TUPLE");
                        }
                        if (tupleList != null) {
                            AxisInterface rAxis = this.resultSetMetadata.getAxes(1, 1)[0];
                            int rownum = this.findTuple(rAxis, tupleList);
                            if (rownum > -1) {
                                if (rownum > this.endRow || rownum < this.startRow) {
                                    this.gotoRow(rownum + 1);
                                } else {
                                    this.refreshRowNumbers();
                                }
                            } else {
                                this.initializeRowNumbers();
                            }
                        } else {
                            this.initializeRowNumbers();
                        }
                    } else if (changeType.equals("GOTO")) {
                        Object rowNumber = eventInfo.get("ROW_NUMBER");
                        this.gotoRow((Integer)rowNumber);
                    } else {
                        this.initializeRowNumbers();
                    }
                } else if (axis != null && axis.equals("COLUMN")) {
                    if (changeType.equals("INITIALIZE")) {
                        this.initializeColumnNumbers();
                        this.refreshRowNumbers();
                    } else if (changeType.equals("REFRESH")) {
                        List tupleList = null;
                        if (eventInfo.containsKey("TUPLE")) {
                            tupleList = (List)eventInfo.get("TUPLE");
                        }
                        if (tupleList != null) {
                            AxisInterface cAxis = this.resultSetMetadata.getAxes(0, 1)[0];
                            int colnum = this.findTuple(cAxis, tupleList);
                            if (colnum > -1) {
                                if (colnum > this.endColumn || colnum < this.startColumn) {
                                    this.gotoColumn(colnum + 1);
                                } else {
                                    this.refreshColumnNumbers();
                                }
                            } else {
                                this.initializeColumnNumbers();
                            }
                        } else {
                            this.initializeColumnNumbers();
                        }
                    } else if (changeType.equals("GOTO")) {
                        Object columnNumber = eventInfo.get("COLUMN_NUMBER");
                        this.gotoColumn((Integer)columnNumber);
                    } else {
                        this.initializeColumnNumbers();
                    }
                } else if (axis != null && axis.equals("ROW_COLUMN")) {
                    if (changeType.equals("INITIALIZE")) {
                        this.initializeRowNumbers();
                        this.initializeColumnNumbers();
                    } else if (changeType.equals("REFRESH")) {
                        this.initializeRowNumbers();
                        this.initializeColumnNumbers();
                    } else if (changeType.equals("EXCHANGE")) {
                        int sr = this.getStartRow();
                        int er = this.getEndRow();
                        int sc = this.getStartColumn();
                        int ec = this.getEndColumn();
                        int rps = this.getRowPageSize();
                        int cps = this.getColumnPageSize();
                        int colCnt = this.getColumnCount();
                        int rowCnt = this.getRowCount();
                        this.setStartRow(sc);
                        ec = sc + rps > rowCnt ? rowCnt - 1 : sc + rps - 1;
                        this.setEndRow(ec);
                        this.setStartColumn(sr);
                        er = sr + cps > colCnt ? colCnt - 1 : sr + cps - 1;
                        this.setEndColumn(er);
                    } else if (changeType.equals("GOTO")) {
                        Object columnNumber;
                        Object rowNumber = eventInfo.get("ROW_NUMBER");
                        if (rowNumber != null) {
                            this.gotoRow((Integer)rowNumber);
                        }
                        if ((columnNumber = eventInfo.get("COLUMN_NUMBER")) != null) {
                            this.gotoColumn((Integer)columnNumber);
                        }
                    }
                } else {
                    this.initialize();
                }
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
    }

    public boolean rowNumbersAreValid() throws OLAPException {
        int eRow;
        int nRows = this.getRowCount();
        int sRow = this.getStartRow();
        if (sRow <= (eRow = this.getEndRow()) && nRows > 0 && nRows > this.endRow) {
            return sRow >= 0 && sRow < nRows && eRow >= 0;
        }
        return false;
    }

    public boolean columnNumbersAreValid() throws OLAPException {
        int eCol;
        int nCols = this.getColumnCount();
        int sCol = this.getStartColumn();
        if (sCol <= (eCol = this.getEndColumn()) && nCols > 0 && nCols > eCol) {
            return sCol >= 0 && sCol < nCols && eCol >= 0;
        }
        return false;
    }

    @Override
    public String toString() {
        if (Util.isDesignTime()) {
            return RB.getStringResource(RB_KEY, "message1.txt", this.getLocale());
        }
        return super.toString();
    }

    @Override
    public void initialize() {
        if (this.debug1) {
            System.out.println("BaseTable:initialize()");
        }
        try {
            if (this.mi == null) {
                this.deferInitialize = true;
            } else {
                this.resultSetMetadata = this.mi.getResultSetMetadata();
                if (this.resultSetMetadata != null && this.resultSetMetadata.getAxes(0, 2).length < 2) {
                    this.deferInitialize = true;
                } else {
                    this.initializeRowNumbers();
                    this.initializeColumnNumbers();
                }
            }
        }
        catch (OLAPException oe) {
            System.out.println(RB.getStringResource(RB_KEY, "message2.txt", this.getLocale()));
        }
    }

    @SASScope
    public void setDeferInitializeToFalse() {
        this.deferInitialize = false;
    }

    @Override
    @SASScope
    public void cleanUpResources() {
        super.cleanUpResources();
        this.rowAxis = null;
        this.rowTuples = null;
        this.columnAxis = null;
        this.columnTuples = null;
        this.rowTupleElementIds = null;
        this.columnTupleElementIds = null;
    }

    public void initializeRowNumbers() {
        this.setStartRow(-1);
        this.setEndRow(-1);
        int rowCnt = 0;
        rowCnt = this.getRowCount();
        if (this.rowCount == 0) {
            return;
        }
        if (this.rowPageSize == -1) {
            this.setStartRow(0);
            this.setEndRow(rowCnt - 1);
        } else if (this.rowPageSize > 0) {
            this.setStartRow(0);
            if (this.rowPageSize > this.rowCount) {
                this.setEndRow(rowCnt - 1);
            } else {
                this.setEndRow(this.rowPageSize - 1);
            }
        } else {
            this.setStartRow(0);
            this.setEndRow(0);
        }
        if (this.debug1) {
            System.out.println("initializeRowNumbers(): rowPageSize is " + this.rowPageSize);
            System.out.println("initializeRowNumbers(): getRowCount() returned " + rowCnt);
            System.out.println("initializeRowNumbers(): startRow is " + this.startRow + " and endRow is " + this.endRow);
        }
    }

    @SASScope
    protected void refreshRowNumbers() {
        int rCnt = this.getRowCount();
        this.endRow = this.startRow + this.rowPageSize >= rCnt ? rCnt - 1 : this.startRow + this.rowPageSize - 1;
    }

    @SASScope
    protected void refreshColumnNumbers() {
        int cCnt = this.getColumnCount();
        this.endColumn = this.startColumn + this.columnPageSize >= cCnt ? cCnt - 1 : this.startColumn + this.columnPageSize - 1;
    }

    public void initializeColumnNumbers() {
        this.setStartColumn(-1);
        this.setEndColumn(-1);
        int colCnt = 0;
        colCnt = this.getColumnCount();
        if (this.columnCount == 0) {
            return;
        }
        if (this.columnPageSize == -1) {
            this.startColumn = 0;
            this.endColumn = colCnt - 1;
        } else if (this.columnPageSize > 0) {
            this.startColumn = 0;
            this.endColumn = this.columnPageSize > colCnt ? colCnt - 1 : this.columnPageSize - 1;
        } else {
            this.startRow = 0;
            this.endRow = 0;
        }
        if (this.debug1) {
            System.out.println("initializeColumnNumbers(): max columns is " + this.columnPageSize);
            System.out.println("initializeColumnNumbers(): getColumnCount() returned " + colCnt);
            System.out.println("initializeColumnNumbers():  startColumn is " + this.startColumn + " and endColumn is " + this.endColumn);
        }
    }

    @Override
    public int getColumnCount() {
        block5: {
            if (this.mi != null) {
                try {
                    int axisCount = this.resultSetMetadata.getAxes(0, 2).length;
                    if (axisCount > 1) {
                        AxisInterface axis = this.resultSetMetadata.getAxes(0, 1)[0];
                        this.columnCount = axis != null ? axis.getTupleCount() : 0;
                        break block5;
                    }
                    this.columnCount = 0;
                }
                catch (OLAPException ote) {
                    this.columnCount = 0;
                }
            } else {
                this.columnCount = 0;
            }
        }
        return this.columnCount;
    }

    @Override
    public int getRowCount() {
        block5: {
            if (this.mi != null) {
                try {
                    int axisCount = this.resultSetMetadata.getAxes(0, 2).length;
                    if (axisCount > 1) {
                        AxisInterface axis;
                        AxisInterface[] axes = this.resultSetMetadata.getAxes(1, 1);
                        this.rowCount = axes != null ? ((axis = axes[0]) != null ? axis.getTupleCount() : 0) : 1;
                        break block5;
                    }
                    this.rowCount = 0;
                }
                catch (OLAPException ote) {
                    this.rowCount = 0;
                }
            } else {
                this.rowCount = 0;
            }
        }
        return this.rowCount;
    }

    @Override
    public boolean isAccurateRowCountAvailable() {
        return true;
    }

    @Override
    public void setActionProvider(HttpActionProvider actionProvider) {
        if (actionProvider != this.getActionProvider()) {
            HttpActionProvider old = this.getActionProvider();
            if (old != null) {
                old.removeContentsChangedListener(this);
            }
            super.setActionProvider(actionProvider);
            if (actionProvider != null) {
                actionProvider.addContentsChangedListener(this);
            }
        }
    }

    @Override
    public boolean isGotoRowSupported() {
        return this.isPageForwardRowsSupported() || this.isPageBackwardRowsSupported();
    }

    @Override
    public void gotoRow(int row) {
        int rCnt = this.getRowCount();
        if (!this.isGotoRowSupported()) {
            // empty if block
        }
        if (row <= 0) {
            row = 1;
        } else if (row > rCnt) {
            row = rCnt;
        }
        this.startRow = row - 1;
        this.endRow = this.rowPageSize == -1 ? rCnt - 1 : (this.startRow + this.rowPageSize >= rCnt ? rCnt - 1 : this.startRow + this.rowPageSize - 1);
    }

    @Override
    public boolean isGotoColumnSupported() {
        return this.isPageForwardColumnsSupported() || this.isPageBackwardColumnsSupported();
    }

    @Override
    public void gotoColumn(int column) {
        int cCnt = this.getColumnCount();
        if (!this.isGotoColumnSupported()) {
            // empty if block
        }
        if (column <= 0) {
            column = 1;
        } else if (column > cCnt) {
            column = cCnt;
        }
        this.startColumn = column - 1;
        this.endColumn = this.columnPageSize == -1 ? cCnt - 1 : (this.startColumn + this.columnPageSize >= cCnt ? cCnt - 1 : this.startColumn + this.columnPageSize - 1);
    }

    private int findTuple(AxisInterface a, List elementList) {
        int indexFound = -1;
        if (this.mi != null) {
            try {
                int increment = 100;
                int tupleCount = a.getTupleCount();
                boolean foundit = false;
                int tIndex = -1;
                int start = 0;
                while (!foundit) {
                    if (start + increment - 1 >= tupleCount - 1) {
                        increment = tupleCount - start;
                        foundit = true;
                    } else {
                        increment = 100;
                    }
                    TupleInterface[] tuples = a.getTuples(start, increment);
                    boolean found = false;
                    for (int i = 0; i < tuples.length; ++i) {
                        found = true;
                        TupleElementInterface[] tplElements = tuples[i].getElements(0, -1);
                        String tupleString = "";
                        for (int k = 0; k < tplElements.length; ++k) {
                            tupleString = tupleString + tplElements[k].getName();
                        }
                        for (int j = 0; j < elementList.size(); ++j) {
                            if (tupleString.indexOf((String)elementList.get(j)) > -1) {
                                found = found;
                                continue;
                            }
                            if (found) {
                                // empty if block
                            }
                            found = false;
                        }
                        if (!found) continue;
                        indexFound = start + i;
                        foundit = true;
                        break;
                    }
                    start += increment;
                }
            }
            catch (OLAPException oe) {
                System.out.println("Exception in find tuple.");
            }
        }
        return indexFound;
    }

    @SASScope
    public String getWriteFailureMessage() {
        return this.writeFailureMessage;
    }

    @SASScope
    public void setWriteFailureMessage(String msg) {
        this.writeFailureMessage = msg;
    }

    @SASScope
    public boolean isGradientHeaderColors() {
        return this.gradientHeaderColors;
    }

    @SASScope
    public void setGradientHeaderColors(boolean gradientHeaderColors) {
        this.gradientHeaderColors = gradientHeaderColors;
    }

    @Override
    @SASScope
    public void writeContent(PrintWriter out) throws IOException {
        if (this.mi == null) {
            this.writeEmptyTable(out, "message3.txt");
            return;
        }
        if (this.columnPageSize == 0) {
            this.cleanUpResources();
            return;
        }
        if (this.deferInitialize) {
            this.initialize();
            this.deferInitialize = false;
        }
        this.setup();
        if (this.rowAxis == null) {
            this.writeEmptyTable(out, "noRowDimension.txt");
            return;
        }
        if (this.rowAxis != null && this.getRowCount() == 0) {
            this.writeEmptyTable(out, "noRows.txt");
            return;
        }
        if (this.columnAxis != null && this.getColumnCount() == 0) {
            this.writeEmptyTable(out, "noColumns.txt");
            return;
        }
        try {
            if (!this.rowNumbersAreValid()) {
                this.initializeRowNumbers();
                this.initializeColumnNumbers();
            }
            if (!this.columnNumbersAreValid()) {
                this.initializeColumnNumbers();
                this.initializeRowNumbers();
            }
        }
        catch (OLAPException oe) {
            System.out.println("olapexception occurred in BaseOLAPTableView.write");
        }
        if (this.getRulesContext() != null) {
            RulesUtil.validateRules(this);
        }
        super.writeContent(out);
    }

    private void writeEmptyTable(PrintWriter out, String key) throws IOException {
        this.setWriteFailureMessage(RB.getStringResource(RB_KEY, key, this.getLocale()));
        this.writeEmptyTable(out);
        this.setWriteFailureMessage(null);
        this.writeFeatures(this.getRequest(), out);
        this.cleanUpResources();
    }

    @SASScope
    public boolean isRolap() {
        return this.rolap;
    }
}

