/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.olapgraphics.html;

import com.sas.actionprovider.ActionProviderViewInterface;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.HttpAction;
import com.sas.actionprovider.HttpActionProvider;
import com.sas.actionprovider.Util;
import com.sas.codepolicy.SASScope;
import com.sas.entities.AttributeSetException;
import com.sas.graphics.components.ChartImageMapInfo;
import com.sas.graphics.components.DataZone;
import com.sas.graphics.components.GraphOLAPDataSet;
import com.sas.graphics.components.LabelZoneList;
import com.sas.graphics.components.PlotImageMapInfo;
import com.sas.graphics.components.VariableList;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.servlet.tbeans.graphics.BaseGraph;
import com.sas.servlet.tbeans.graphics.html.BaseGraphSupport;
import com.sas.servlet.tbeans.graphics.html.HtmlGraphUtil;
import com.sas.servlet.tbeans.menus.model.PopupMenuItem;
import com.sas.servlet.tbeans.menus.popupmenu.html.PopupMenu;
import com.sas.servlet.tbeans.olapgraphics.html.OLAPScatterPlot;
import com.sas.servlet.tbeans.olapgraphics.html.OLAPTileChart;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleElementType;
import com.sas.storage.olap.TupleInterface;
import com.sas.swing.util.Action;
import com.sas.swing.util.ActionList;
import com.sas.swing.util.ActionUtils;
import com.sas.swing.visuals.olaptableview.OLAPCellRendererManager;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@SASScope(value="DEFAULT")
public class OLAPGraphSupport
extends BaseGraphSupport {
    private BaseGraph baseGraph;
    private ActionSupportFilter analysisFilter;
    private ActionSupportFilter categorizationFilter;
    private ActionSupportFilter categorizationLabelFilter;
    private ActionSupportFilter datavalueFilter;
    protected ResultSetMetadataInterface resultSetMetadata;
    protected OLAPDataSetInterface mi;
    private ChartImageMapInfo bcimi;
    private PlotImageMapInfo pimi;
    private HttpActionProvider actionProvider;
    private List classificationPopupMenuList = new ArrayList();
    private List actionInfoList = new ArrayList();
    private List actionAreaList = new ArrayList();
    private int areaCounter = 0;
    protected static final int SUBGROUP = 1;
    protected static final int CATEGORY = 2;
    protected static final int RESPONSE = 3;
    protected static final int RESPONSE2 = 4;
    protected static final int COLUMN = 5;
    protected static final int ROW = 6;
    private static int LABEL = 1;
    private static int VALUE = 2;
    private CommonLoggerInterface log = LoggerRepository2.getLogger((String)OLAPGraphSupport.class.getPackage().getName(), null);

    public OLAPGraphSupport(BaseGraph baseGraph) {
        super(baseGraph);
        this.baseGraph = baseGraph;
        baseGraph.setActionSupportType("OLAP_GRAPH_SUPPORT");
        this.analysisFilter = new ActionSupportFilter(baseGraph.getActionSupportType(), "ANALYSIS_LABEL_AREA", (ActionProviderViewInterface)baseGraph, false);
        this.categorizationFilter = new ActionSupportFilter(baseGraph.getActionSupportType(), "CATEGORIZATION_VALUE_AREA", (ActionProviderViewInterface)baseGraph, false);
        this.categorizationLabelFilter = new ActionSupportFilter(baseGraph.getActionSupportType(), "CATEGORIZATION_LABEL_AREA", (ActionProviderViewInterface)baseGraph, false);
        this.datavalueFilter = new ActionSupportFilter(baseGraph.getActionSupportType(), "DATA_VALUE_AREA", (ActionProviderViewInterface)baseGraph);
    }

    public void setModel(OLAPDataSetInterface model) {
        this.mi = model != null && model instanceof GraphOLAPDataSet ? ((GraphOLAPDataSet)model).getDelegateModel() : model;
    }

    public OLAPDataSetInterface getModel() {
        return this.mi;
    }

    protected void setActions(Object imageMapInfo) {
        this.actionAreaList.clear();
        this.actionInfoList.clear();
        this.classificationPopupMenuList.clear();
        if (!this.baseGraph.isAllActionsVisible() || this.baseGraph.getActionProvider() == null || this.getModel() == null) {
            return;
        }
        this.actionProvider = this.baseGraph.getActionProvider();
        if (this.baseGraph.isFlushEnabled()) {
            this.actionProvider.flushViewerCommands(this.baseGraph);
        }
        this.bcimi = null;
        this.pimi = null;
        if (imageMapInfo instanceof ChartImageMapInfo) {
            this.bcimi = (ChartImageMapInfo)imageMapInfo;
        } else if (imageMapInfo instanceof PlotImageMapInfo) {
            this.pimi = (PlotImageMapInfo)imageMapInfo;
        } else {
            return;
        }
        if (this.bcimi == null && this.pimi == null) {
            return;
        }
        try {
            this.analysisFilter.setAttribute("model", (Object)this.getModel());
            this.analysisFilter.setViewerId(this.baseGraph.getId());
            this.categorizationFilter.setAttribute("model", (Object)this.getModel());
            this.categorizationFilter.setViewerId(this.baseGraph.getId());
            this.categorizationLabelFilter.setAttribute("model", (Object)this.getModel());
            this.categorizationLabelFilter.setViewerId(this.baseGraph.getId());
        }
        catch (AttributeSetException ase) {
            System.out.println(ase.getMessage());
        }
        try {
            this.resultSetMetadata = this.getModel().getResultSetMetadata();
            AxisInterface[] axes = this.resultSetMetadata.getAxes(0, -1);
            for (int axisIndex = 0; axisIndex < axes.length; ++axisIndex) {
                AxisInterface axis = axes[axisIndex];
                this.setActions(axis.getAxisNumber());
            }
        }
        catch (OLAPException olapexcept) {
            System.out.println(olapexcept.getMessage());
        }
        if (this.getCategoryLabelZoneList() != null && !(this.baseGraph instanceof OLAPScatterPlot)) {
            this.setLabelZoneActions(this.getCategoryLabelZoneList(), 2);
            this.setValueZoneActions(this.getCategoryValueZones(), 2);
        }
        if (this.getColumnLabelZoneList() != null) {
            this.setLabelZoneActions(this.getColumnLabelZoneList(), 5);
            this.setValueZoneActions(this.getColumnValueZones(), 5);
        }
        if (this.getRowLabelZoneList() != null) {
            this.setLabelZoneActions(this.getRowLabelZoneList(), 6);
            this.setValueZoneActions(this.getRowValueZones(), 6);
        }
        if (this.getSubgroupLabelZoneList() != null) {
            this.setLabelZoneActions(this.getSubgroupLabelZoneList(), 1);
            this.setValueZoneActions(this.getSubgroupValueZones(), 1);
        }
        if (this.getCategoryLabelZoneList() != null && this.baseGraph instanceof OLAPScatterPlot) {
            this.setVariableListActions(this.getXVariableList(), 3, this.classificationPopupMenuList);
        }
        if (this.getResponseVariableList() != null) {
            this.setVariableListActions(this.getResponseVariableList(), 3, this.classificationPopupMenuList);
        }
        if (this.getResponse2VariableList() != null) {
            this.setVariableListActions(this.getResponse2VariableList(), 4, this.classificationPopupMenuList);
        }
    }

    private void setLabelZoneActions(LabelZoneList labelZoneList, int actionArea) {
        while (labelZoneList != null) {
            com.sas.actionprovider.ActionList actionList = this.getLabelAction(labelZoneList.getLabel());
            this.setLabelActions(labelZoneList.getShape(), actionList, new ActionArea(actionArea, LABEL), null, labelZoneList.getLabel());
            labelZoneList = labelZoneList.getNext();
        }
    }

    private void setValueZoneActions(DataZone[] dz, int actionArea) {
        if (dz == null) {
            return;
        }
        for (int i = 0; i < dz.length; ++i) {
            this.setClassificationValueActions2(dz[i].getShape(), dz[i].getTupleElement(), new ActionArea(actionArea, VALUE));
        }
    }

    private void setVariableListActions(VariableList variableList, int actionArea, List popupMenuList) {
        while (variableList != null) {
            com.sas.actionprovider.ActionList actionList = this.getAnalysisLabelAction(variableList.getLabel());
            this.setLabelActions(null, actionList, new ActionArea(actionArea, LABEL), popupMenuList, variableList.getLabel());
            variableList = variableList.getNext();
        }
    }

    private DataZone[] getCategoryValueZones() {
        if (this.bcimi != null) {
            return this.bcimi.getCategoryValueZones();
        }
        if (this.pimi != null) {
            return this.pimi.getXValueZones();
        }
        return null;
    }

    private DataZone[] getColumnValueZones() {
        if (this.bcimi != null) {
            return this.bcimi.getColumnValueZones();
        }
        if (this.pimi != null) {
            return this.pimi.getColumnValueZones();
        }
        return null;
    }

    private DataZone[] getRowValueZones() {
        if (this.bcimi != null) {
            return this.bcimi.getRowValueZones();
        }
        if (this.pimi != null) {
            return this.pimi.getRowValueZones();
        }
        return null;
    }

    private DataZone[] getSubgroupValueZones() {
        if (this.bcimi != null) {
            return this.bcimi.getSubgroupValueZones();
        }
        if (this.pimi != null) {
            return this.pimi.getGroupValueZones();
        }
        return null;
    }

    private LabelZoneList getColumnLabelZoneList() {
        if (this.bcimi != null) {
            return this.bcimi.getColumnLabelZoneList();
        }
        if (this.pimi != null) {
            return this.pimi.getColumnLabelZoneList();
        }
        return null;
    }

    private LabelZoneList getRowLabelZoneList() {
        if (this.bcimi != null) {
            return this.bcimi.getRowLabelZoneList();
        }
        if (this.pimi != null) {
            return this.pimi.getRowLabelZoneList();
        }
        return null;
    }

    private LabelZoneList getResponseLabelZoneList() {
        if (this.bcimi != null) {
            return this.bcimi.getResponseLabelZoneList();
        }
        if (this.pimi != null) {
            return this.pimi.getYLabelZoneList();
        }
        return null;
    }

    private LabelZoneList getResponse2LabelZoneList() {
        if (this.bcimi != null) {
            return this.bcimi.getResponse2LabelZoneList();
        }
        if (this.pimi != null) {
            return this.pimi.getY2LabelZoneList();
        }
        return null;
    }

    private LabelZoneList getSubgroupLabelZoneList() {
        if (this.bcimi != null) {
            return this.bcimi.getSubgroupLabelZoneList();
        }
        if (this.pimi != null) {
            return this.pimi.getGroupLabelZoneList();
        }
        return null;
    }

    private LabelZoneList getCategoryLabelZoneList() {
        if (this.bcimi != null) {
            return this.bcimi.getCategoryLabelZoneList();
        }
        if (this.pimi != null) {
            return this.pimi.getXLabelZoneList();
        }
        return null;
    }

    private VariableList getXVariableList() {
        if (this.bcimi != null) {
            return null;
        }
        if (this.pimi != null) {
            return this.pimi.getXVariableList();
        }
        return null;
    }

    private VariableList getResponseVariableList() {
        if (this.bcimi != null) {
            return this.bcimi.getResponseVariableList();
        }
        if (this.pimi != null) {
            return this.pimi.getYVariableList();
        }
        return null;
    }

    private VariableList getResponse2VariableList() {
        if (this.bcimi != null) {
            return this.bcimi.getResponse2VariableList();
        }
        if (this.pimi != null) {
            return this.pimi.getY2VariableList();
        }
        return null;
    }

    private void setLabelActions(Shape shape, com.sas.actionprovider.ActionList aList, ActionArea actionArea, List popupMenuList, String label) {
        if (aList == null || popupMenuList == null && shape == null) {
            return;
        }
        PopupMenu popupMenu = null;
        if (popupMenuList == null) {
            popupMenu = new PopupMenu();
            popupMenu.setRequest(this.baseGraph.getRequest());
            popupMenu.setResponse(this.baseGraph.getResponse());
            popupMenu.setModel(new ArrayList());
        }
        String altText = (String)aList.getValue("ShortDescription");
        Iterator iter = ActionUtils.iterator((ActionList)aList);
        boolean addSeparator = true;
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof HttpAction)) continue;
            HttpAction action = (HttpAction)((Object)o);
            PopupMenuItem menuItem = new PopupMenuItem();
            String text = (String)action.getValue("ShortDescription");
            if (text == null) {
                text = Util.getLabel((Action)action);
            }
            menuItem.setText(text);
            menuItem.setDisabled(!action.isEnabled());
            menuItem.setAlternateText((String)action.getValue("AlternateText"));
            menuItem.setImage((String)action.getValue("SmallIconName"));
            menuItem.setDisabledImage((String)action.getValue("SmallDisabledIconName"));
            menuItem.setUrl((String)action.getValue("URL"));
            String url = (String)action.getValue("URL");
            if (url != null && url.startsWith("javascript:")) {
                menuItem.setJavascript(url.replaceFirst("javascript:", ""));
            } else {
                menuItem.setUrl(url);
            }
            if (popupMenuList != null) {
                popupMenu = null;
                for (int i = 0; i < popupMenuList.size(); ++i) {
                    popupMenu = (PopupMenu)popupMenuList.get(i);
                    if (addSeparator) {
                        PopupMenuItem separator = new PopupMenuItem();
                        separator.setSeparator(true);
                        popupMenu.getModel().add(separator);
                    }
                    popupMenu.getModel().add(menuItem);
                }
                addSeparator = false;
                continue;
            }
            popupMenu.getModel().add(menuItem);
        }
        if (popupMenu != null && popupMenu.getModel() != null && !popupMenu.getModel().isEmpty() && popupMenuList == null) {
            actionArea.setPopupMenu(popupMenu);
            actionArea.setAltText(altText);
            actionArea.setHref(null);
            actionArea.setRect(shape.getBounds());
            this.actionAreaList.add(actionArea);
            this.classificationPopupMenuList.add(popupMenu);
        }
    }

    private void setClassificationValueActions2(Shape shape, TupleElementInterface tuple, ActionArea actionArea) {
        if (tuple == null || shape == null) {
            return;
        }
        PopupMenu popupMenu = new PopupMenu();
        popupMenu.setRequest(this.baseGraph.getRequest());
        popupMenu.setResponse(this.baseGraph.getResponse());
        popupMenu.setModel(new ArrayList());
        String altText = null;
        com.sas.actionprovider.ActionList actionList = null;
        try {
            this.categorizationFilter.setAttribute("tupleElement", (Object)tuple);
            if (this.getModel() instanceof BusinessQueryProviderInterface) {
                this.categorizationFilter.setAttribute("dataItem", (Object)OLAPCellRendererManager.findDataItem((BusinessQuery)((BusinessQueryProviderInterface)this.getModel()).getBusinessQuery(), (TupleElementInterface)tuple));
            }
        }
        catch (AttributeSetException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        actionList = this.actionProvider.getActions(this.categorizationFilter);
        if (actionList != null) {
            Iterator iter = ActionUtils.iterator((ActionList)actionList);
            while (iter.hasNext()) {
                Object o = iter.next();
                if (!(o instanceof HttpAction)) continue;
                HttpAction action = (HttpAction)((Object)o);
                PopupMenuItem menuItem = new PopupMenuItem();
                menuItem.setText((String)action.getValue("AlternateText"));
                menuItem.setDisabled(!action.isEnabled());
                String url = (String)action.getValue("URL");
                if (url != null && url.startsWith("javascript:")) {
                    menuItem.setJavascript(url.replaceFirst("javascript:", ""));
                } else {
                    menuItem.setUrl(url);
                }
                popupMenu.getModel().add(menuItem);
            }
        }
        if (actionList != null) {
            altText = (String)actionList.getValue("ShortDescription");
        }
        if (!popupMenu.getModel().isEmpty()) {
            actionArea.setPopupMenu(popupMenu);
            actionArea.setAltText(altText);
            actionArea.setHref(null);
            actionArea.setRect(shape.getBounds());
            actionArea.setValueAction(true);
            this.actionAreaList.add(actionArea);
        }
    }

    private LevelInfo getLevelIndex(String label) {
        LevelInfo levelInfo = new LevelInfo();
        try {
            AxisInterface[] axes = this.resultSetMetadata.getAxes(0, -1);
            for (int axisIndex = 0; axisIndex < axes.length; ++axisIndex) {
                AxisInterface axis = axes[axisIndex];
                String[] labels = this.useDimensionNames() ? axis.getDimensionNames() : axis.getAxisHeaders();
                String[] uniqueLevelNames = axis.getUniqueLevelNames();
                for (int i = 0; i < labels.length; ++i) {
                    if (!labels[i].equals(label) && (!label.equalsIgnoreCase("MeasuresLevel") || !this.isMeasureLevel(axis, uniqueLevelNames[i]))) continue;
                    levelInfo.setHeaderIndex(i);
                    levelInfo.setAxisNumber(axis.getAxisNumber());
                    return levelInfo;
                }
            }
        }
        catch (OLAPException olapexcept) {
            System.out.println(olapexcept.getMessage());
        }
        return levelInfo;
    }

    private boolean isMeasureLevel(AxisInterface axis, String uniqueLevelName) throws OLAPException {
        boolean result = false;
        for (int i = 0; i < axis.getTupleCount(); ++i) {
            TupleInterface t = axis.getTuple(i);
            TupleElementInterface[] tes = t.getElements(0, -1);
            for (int j = 0; j < tes.length; ++j) {
                TupleElementInterface te = tes[j];
                if (!te.getUniqueLevelName().equals(uniqueLevelName)) continue;
                return te.getType() == TupleElementType.MEASURE;
            }
        }
        return result;
    }

    private com.sas.actionprovider.ActionList getLabelAction(String label) {
        if (label == null) {
            return null;
        }
        LevelInfo levelInfo = this.getLevelIndex(label);
        if (levelInfo == null) {
            return null;
        }
        ActionInfo actionInfo = this.getActionInfo(levelInfo.getAxisNumber());
        if (actionInfo != null) {
            com.sas.actionprovider.ActionList[] actions = actionInfo.getLevelActions();
            return actions[levelInfo.getHeaderIndex()];
        }
        return null;
    }

    private com.sas.actionprovider.ActionList getAnalysisLabelAction(String label) {
        LevelInfo levelInfo = this.getLevelIndex("MeasuresLevel");
        ActionInfo actionInfo = this.getActionInfo(levelInfo.getAxisNumber());
        if (actionInfo == null) {
            return null;
        }
        TupleInterface[] tuples = actionInfo.getTuples();
        TupleElementInterface[][] tupleElements = actionInfo.getTupleElements();
        try {
            for (int i = 0; i < tuples.length; ++i) {
                TupleElementInterface[] tei = tuples[i].getElements(0, tuples[i].getTupleDepth());
                for (int j = 0; j < tei.length; ++j) {
                    if (!tei[j].getLabel().trim().equalsIgnoreCase(label)) continue;
                    this.analysisFilter.setAttribute("tupleElement", (Object)tupleElements[i][j]);
                    if (this.getModel() instanceof BusinessQueryProviderInterface) {
                        this.analysisFilter.setAttribute("dataItem", (Object)OLAPCellRendererManager.findDataItem((BusinessQuery)((BusinessQueryProviderInterface)this.getModel()).getBusinessQuery(), (TupleElementInterface)tupleElements[i][j]));
                    }
                    com.sas.actionprovider.ActionList actionList = this.actionProvider.getActions(this.analysisFilter);
                    return actionList;
                }
            }
        }
        catch (AttributeSetException ase) {
            System.out.println(ase.getMessage());
        }
        catch (OLAPException olapexcept) {
            System.out.println(olapexcept.getMessage());
        }
        return null;
    }

    public void writeClientMap(PrintWriter out, Object imageMapInfo) throws IOException {
        this.bcimi = null;
        this.pimi = null;
        if (imageMapInfo instanceof ChartImageMapInfo) {
            this.bcimi = (ChartImageMapInfo)imageMapInfo;
        } else if (imageMapInfo instanceof PlotImageMapInfo) {
            this.pimi = (PlotImageMapInfo)imageMapInfo;
        }
        out.println("<script type=\"text/javascript\">\nvar " + this.baseGraph.getId() + "_selectedArea = null;\n" + this.baseGraph.getId() + "_activate = function(element,hasFocus) {\n  " + this.baseGraph.getId() + "_selectedArea = hasFocus ? element : null;\n}\n" + this.baseGraph.getId() + "_menu = function(event) {\n  var newEventObject = document.createEventObject();\n  if (" + this.baseGraph.getId() + "_selectedArea && ((event.keyCode == 121 && event.shiftKey) || event.keyCode == 93)) {\n    event.returnValue = false;\n    newEventObject.keyCode = 221;\n    " + this.baseGraph.getId() + "_selectedArea.fireEvent('onkeyup', newEventObject);\n    return false;\n  }\n  return true;\n}\n</script>");
        out.println("<map id=\"" + this.baseGraph.getId() + "_map\" name=\"" + this.baseGraph.getId() + "\">");
        if (imageMapInfo != null) {
            ActionArea actionArea;
            boolean writeActions;
            this.areaCounter = 0;
            boolean bl = writeActions = this.baseGraph.isAllActionsVisible() && this.baseGraph.getActionProvider() != null && this.getModel() != null;
            if (writeActions) {
                for (int i = 0; i < this.actionAreaList.size(); ++i) {
                    actionArea = (ActionArea)this.actionAreaList.get(i);
                    if (actionArea.getPopupMenu() == null || actionArea.getRect() == null) continue;
                    this.writePopup(out, actionArea.getPopupMenu(), actionArea.getAltText(), actionArea.getHref(), actionArea.getRect());
                }
                try {
                    this.datavalueFilter.setAttribute("model", (Object)this.getModel());
                }
                catch (AttributeSetException e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                }
            }
            HtmlGraphUtil.writeTooltip(out, this.baseGraph, imageMapInfo, this.baseGraph.isToolTipEnabled(), writeActions ? this.datavalueFilter : null);
            out.println("</map>");
            if (writeActions) {
                for (int i = 0; i < this.actionAreaList.size(); ++i) {
                    actionArea = (ActionArea)this.actionAreaList.get(i);
                    if (actionArea.getPopupMenu() == null) continue;
                    actionArea.getPopupMenu().write(out);
                }
                this.actionAreaList.clear();
                this.actionInfoList.clear();
                this.classificationPopupMenuList.clear();
            }
        } else {
            out.println("</map>");
        }
        this.baseGraph.writeFeatures(out);
    }

    private void writePopup(PrintWriter out, PopupMenu popupMenu, String altText, String href, Rectangle rect) {
        String areaId = this.baseGraph.getId() + "_area" + this.areaCounter++;
        out.print("<area id=\"" + areaId + "\" onfocus=\"" + this.baseGraph.getId() + "_activate(this,true)\" onblur=\"" + this.baseGraph.getId() + "_activate(this,false)\" shape=\"rect\" ");
        if (altText != null) {
            out.print(" title=\"");
            out.print(altText + "\" ");
        }
        if (href != null) {
            out.print("href=\"" + href + "\"");
        } else {
            out.print("href=\"javascript: void 0;\" ");
        }
        if (popupMenu != null) {
            ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(this.baseGraph.getRequest());
            String launchEvent = cpm.getContextMenuLaunchEvent();
            if (launchEvent.equalsIgnoreCase("oncontextmenu")) {
                launchEvent = "onrightclick";
            }
            popupMenu.attachTo(areaId, null, launchEvent);
        }
        out.print(" coords=\"");
        out.print((int)rect.getX() + "," + (int)rect.getY() + "," + (int)(rect.getX() + rect.getWidth()) + "," + (int)(rect.getY() + rect.getHeight()));
        out.println("\">");
    }

    protected boolean isActionAreaVisible(int area) {
        for (int i = 0; i < this.actionAreaList.size(); ++i) {
            ActionArea actionArea = (ActionArea)this.actionAreaList.get(i);
            if (actionArea.getArea() != area || !actionArea.isValueAction() || actionArea.getPopupMenu() == null) continue;
            return true;
        }
        return false;
    }

    private void setActions(int axisNumber) {
        boolean debug = false;
        try {
            int i;
            AxisInterface axis = this.resultSetMetadata.getAxes(axisNumber, 1)[0];
            TupleInterface[] tuples = axis.getTuples(0, axis.getTupleCount());
            TupleElementInterface[][] tupleElements = new TupleElementInterface[tuples.length][];
            String[] labels = this.useDimensionNames() ? axis.getDimensionNames() : axis.getAxisHeaders();
            String[] uniqueLvlNames = axis.getUniqueLevelNames();
            if (debug) {
                for (i = 0; i < labels.length; ++i) {
                    System.out.println("\nlevel label " + i + " " + labels[i]);
                }
            }
            if (debug) {
                for (i = 0; i < tuples.length; ++i) {
                    TupleElementInterface[] tei = tuples[i].getElements(0, tuples[i].getTupleDepth());
                    for (int j = 0; j < tei.length; ++j) {
                        System.out.println("label " + j + " " + tei[j].getLabel());
                    }
                }
            }
            com.sas.actionprovider.ActionList[] levelActions = new com.sas.actionprovider.ActionList[labels.length];
            for (i = 0; i < tuples.length; ++i) {
                tupleElements[i] = tuples[i].getElements(0, tuples[i].getTupleDepth());
            }
            for (i = 0; i < uniqueLvlNames.length; ++i) {
                if (uniqueLvlNames[i] == null) continue;
                this.categorizationLabelFilter.setAttribute("uniqueLevelName", (Object)uniqueLvlNames[i]);
                if (i < labels.length) {
                    this.categorizationLabelFilter.setAttribute("areaValue", (Object)labels[i]);
                }
                if (this.getModel() instanceof BusinessQueryProviderInterface) {
                    this.categorizationLabelFilter.setAttribute("dataItem", (Object)OLAPCellRendererManager.findDataItem((BusinessQuery)((BusinessQueryProviderInterface)this.getModel()).getBusinessQuery(), (OLAPDataSetInterface)this.getModel(), (String)uniqueLvlNames[i]));
                }
                levelActions[i] = this.actionProvider.getActions(this.categorizationLabelFilter);
            }
            ActionInfo actionInfo = new ActionInfo();
            actionInfo.setAxis(axis);
            actionInfo.setLevelActions(levelActions);
            actionInfo.setLevelLabels(labels);
            actionInfo.setTupleElements(tupleElements);
            actionInfo.setTuples(tuples);
            this.actionInfoList.add(actionInfo);
        }
        catch (AttributeSetException ase) {
            System.out.println(ase.getMessage());
        }
        catch (OLAPException olapexcept) {
            System.out.println(olapexcept.getMessage());
        }
    }

    private ActionInfo getActionInfo(int axisNumber) {
        try {
            for (int i = 0; i < this.actionInfoList.size(); ++i) {
                ActionInfo actionInfo = (ActionInfo)this.actionInfoList.get(i);
                if (actionInfo.getAxis().getAxisNumber() != axisNumber) continue;
                return actionInfo;
            }
        }
        catch (OLAPException olapexcept) {
            System.out.println(olapexcept.getMessage());
        }
        return null;
    }

    private boolean useDimensionNames() {
        return this.baseGraph instanceof OLAPTileChart;
    }

    @SASScope
    private class ActionArea {
        PopupMenu popupMenu = null;
        String altText = null;
        String href = null;
        Rectangle rect = null;
        int area = -1;
        boolean valueAction = false;
        int type = -1;

        public ActionArea(int area, int type) {
            this.setArea(area);
            this.setType(type);
        }

        public String getAltText() {
            return this.altText;
        }

        public String getHref() {
            return this.href;
        }

        public PopupMenu getPopupMenu() {
            return this.popupMenu;
        }

        public Rectangle getRect() {
            return this.rect;
        }

        public void setAltText(String string) {
            this.altText = string;
        }

        public void setHref(String string) {
            this.href = string;
        }

        public void setPopupMenu(PopupMenu popup) {
            this.popupMenu = popup;
        }

        public void setRect(Rectangle rectangle) {
            this.rect = rectangle;
        }

        public int getArea() {
            return this.area;
        }

        public void setArea(int area) {
            this.area = area;
        }

        public boolean isValueAction() {
            return this.valueAction;
        }

        public void setValueAction(boolean b) {
            this.valueAction = b;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int i) {
            this.type = i;
        }
    }

    @SASScope
    private class LevelInfo {
        private int axisNumber;
        private int headerIndex;

        private LevelInfo() {
        }

        public int getAxisNumber() {
            return this.axisNumber;
        }

        public void setAxisNumber(int i) {
            this.axisNumber = i;
        }

        public int getHeaderIndex() {
            return this.headerIndex;
        }

        public void setHeaderIndex(int i) {
            this.headerIndex = i;
        }
    }

    @SASScope
    private class ActionInfo {
        private AxisInterface axis;
        private String[] levelLabels;
        private TupleInterface[] tuples;
        private TupleElementInterface[][] tupleElements;
        private com.sas.actionprovider.ActionList[][] actions;
        private com.sas.actionprovider.ActionList[] levelActions;

        private ActionInfo() {
        }

        public AxisInterface getAxis() {
            return this.axis;
        }

        public void setAxis(AxisInterface interface1) {
            this.axis = interface1;
        }

        public String[] getLevelLabels() {
            return this.levelLabels;
        }

        public void setLevelLabels(String[] strings) {
            this.levelLabels = strings;
        }

        public TupleInterface[] getTuples() {
            return this.tuples;
        }

        public void setTuples(TupleInterface[] interfaces) {
            this.tuples = interfaces;
        }

        public TupleElementInterface[][] getTupleElements() {
            return this.tupleElements;
        }

        public void setTupleElements(TupleElementInterface[][] interfaces) {
            this.tupleElements = interfaces;
        }

        public com.sas.actionprovider.ActionList[][] getActions() {
            return this.actions;
        }

        public void setActions(com.sas.actionprovider.ActionList[][] lists) {
            this.actions = lists;
        }

        public com.sas.actionprovider.ActionList[] getLevelActions() {
            return this.levelActions;
        }

        public void setLevelActions(com.sas.actionprovider.ActionList[] lists) {
            this.levelActions = lists;
        }
    }
}

