/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.olapgraphics.html;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.GraphOLAPDataSet;
import com.sas.servlet.tbeans.BaseActionCompositeTransformation;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.dataselectors.html.ActionProviderMenuBar;
import com.sas.servlet.tbeans.dataselectors.html.OLAPMenuBar;
import com.sas.servlet.tbeans.html.AppliedFilters;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.olapgraphics.html.OLAPGraphCompositeKeysInterface;
import com.sas.servlet.tbeans.olapgraphics.html.OLAPGraphCompositeStyleKeysInterface;
import com.sas.servlet.tbeans.olaptableview.html.OLAPDrillState;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.util.MapWithDefaults;
import com.sas.util.Util;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

@SASScope(value="DEFAULT")
public abstract class OLAPGraphComposite
extends BaseActionCompositeTransformation
implements OLAPGraphCompositeKeysInterface,
OLAPGraphCompositeStyleKeysInterface {
    private OLAPDataSetInterface model;
    private static final HashMap defaultStyleMap = new HashMap();

    public OLAPGraphComposite(HttpServletRequest request, HttpServletResponse response) {
        this.setId(Util.getName((String)"ogvc"));
        OLAPGraphComposite.setupDefaultStyleMap();
        ((MapWithDefaults)this.getStyleMap()).setDefaultMap((Map)defaultStyleMap);
        this.setComponent("OLAPGRAPH_MENUBAR", this.getDefaultMenuBar());
        this.setComponent("OLAPGRAPH_TITLE", this.getDefaultTitle());
        this.setComponent("OLAPGRAPH_FOOTER", this.getDefaultFooter());
        this.setComponent("OLAPGRAPH_DRILLSTATE", this.getDefaultOLAPDrillState());
        this.setComponent("OLAPGRAPH_APPLIEDFILTERS", this.getDefaultAppliedFilters());
        this.setTemplateKey("OLAP_Graph");
        this.setResponse(response);
        this.setRequest(request);
    }

    private static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0) {
            defaultStyleMap.put("OLAPGRAPH_CONTAINER_STYLE", new ImmutableStyleInfo("OLAPGraphContainer"));
            defaultStyleMap.put("OLAPGRAPH_CONTENT_STYLE", new ImmutableStyleInfo("OLAPGraphContent"));
            defaultStyleMap.put("OLAPGRAPH_TITLE_STYLE", new ImmutableStyleInfo("OLAPGraphTitle"));
            defaultStyleMap.put("OLAPGRAPH_FOOTER_STYLE", new ImmutableStyleInfo("OLAPGraphFooter"));
            defaultStyleMap.put("OLAPGRAPH_TOOLBAR_STYLE", new ImmutableStyleInfo("OLAPGraphToolBar"));
        }
    }

    public Label getDefaultTitle() {
        Label title = new Label("OLAPGRAPH TITLE");
        title.setVisible(false);
        title.setId(this.getId() + "_title");
        return title;
    }

    public Label getDefaultFooter() {
        Label footer = new Label("OLAPGRAPH FOOTER");
        footer.setVisible(false);
        footer.setId(this.getId() + "_footer");
        return footer;
    }

    public ActionProviderMenuBar getDefaultMenuBar() {
        OLAPMenuBar mb = new OLAPMenuBar();
        mb.setActionSupportType("GRAPH_RELATIONAL_MENUBAR_SUPPORT");
        mb.setModel(this.getModel());
        mb.setId(this.getId() + "_mb");
        return mb;
    }

    public AppliedFilters getDefaultAppliedFilters() {
        AppliedFilters af = new AppliedFilters();
        af.setModel(this.getModel());
        af.setId(this.getId() + "_af");
        af.setTitleDisplayed(4);
        af.setNoFilterTextDisplayed(false);
        return af;
    }

    public OLAPDrillState getDefaultOLAPDrillState() {
        OLAPDrillState drillState = new OLAPDrillState();
        drillState.setSeparator(">");
        drillState.setSeparatorImage(null);
        drillState.setId(this.getId() + "_ds");
        return drillState;
    }

    public OLAPDataSetInterface getModel() {
        return this.model;
    }

    public void setModel(OLAPDataSetInterface model) {
        if (this.getModel() != model) {
            this.model = model;
            OLAPDataSetInterface mi = model != null && model instanceof GraphOLAPDataSet ? ((GraphOLAPDataSet)model).getDelegateModel() : model;
            TransformationInterface o = this.getComponent("OLAPGRAPH_MENUBAR");
            if (o != null && o instanceof OLAPMenuBar) {
                ((OLAPMenuBar)o).setModel(mi);
            }
            if ((o = this.getComponent("OLAPGRAPH_DRILLSTATE")) != null && o instanceof OLAPDrillState) {
                ((OLAPDrillState)o).setModel(mi);
            }
            if ((o = this.getComponent("OLAPGRAPH_APPLIEDFILTERS")) != null && o instanceof AppliedFilters) {
                ((AppliedFilters)o).setModel(mi);
            }
        }
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        out.println(this.applyTemplate(this));
        this.cleanUpResources();
    }
}

