/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.navigationbar.html;

import com.sas.actionprovider.URLTemplateViewInterface;
import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.ComplexStyleInterface;
import com.sas.servlet.tbeans.HttpConstants;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.StyleMap;
import com.sas.servlet.tbeans.navigationbar.BaseNavigationBarElement;
import com.sas.servlet.tbeans.navigationbar.BaseNavigationInterface;
import com.sas.servlet.tbeans.navigationbar.html.NavigationBarScrollingElementStyleKeysInterface;
import com.sas.servlet.tbeans.navigationbar.html.RB;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.MapWithDefaults;
import com.sas.util.SimpleTemplate;
import com.sas.util.Util;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

@SASScope(value="ALL")
public abstract class NavigationBarScrollingElement
extends BaseNavigationBarElement
implements HttpConstants,
ComplexStyleInterface,
NavigationBarScrollingElementStyleKeysInterface {
    @SASScope
    public static final String RB_KEY = "NavigationBarScrollingElement.";
    private static final String NAME_PREFIX = "se";
    @SASScope
    protected MapWithDefaults styleMap;
    private static final HashMap defaultStyleMap = new HashMap();
    private int messageOrientation;
    private String gotoFieldLabel;
    private boolean gotoFieldInMessage;
    private SimpleTemplate messageTemplate;

    private static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0) {
            defaultStyleMap.put("NAVIGATIONBAR_MESSAGE_STYLE", new ImmutableStyleInfo("navigationText"));
            defaultStyleMap.put("NAVIGATIONBAR_INPUT_STYLE", new ImmutableStyleInfo("navbarInput"));
        }
    }

    public NavigationBarScrollingElement() {
        this(null);
    }

    public NavigationBarScrollingElement(BaseNavigationInterface model) {
        this.setModel(model);
        this.setId(Util.getName((String)NAME_PREFIX));
        this.messageOrientation = 0;
        this.gotoFieldInMessage = true;
        NavigationBarScrollingElement.setupDefaultStyleMap();
        this.styleMap = new StyleMap(defaultStyleMap);
    }

    public int getMessageOrientation() {
        return this.messageOrientation;
    }

    public void setMessageOrientation(int orientation) {
        switch (orientation) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.messageOrientation = orientation;
                break;
            }
            default: {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidOrientation.txt", this.getLocale()));
            }
        }
    }

    public SimpleTemplate getMessageTemplate() {
        if (this.messageTemplate == null) {
            return this.getDefaultMessageTemplate();
        }
        return this.messageTemplate;
    }

    public abstract SimpleTemplate getDefaultMessageTemplate();

    public void setMessageTemplate(SimpleTemplate template) {
        this.messageTemplate = template;
    }

    public abstract String getMessage();

    public abstract void setGotoFieldVisible(boolean var1);

    public String getGotoFieldLabel() {
        return this.gotoFieldLabel;
    }

    public void setGotoFieldLabel(String label) {
        this.gotoFieldLabel = label;
    }

    public boolean isGotoFieldInMessage() {
        return this.gotoFieldInMessage;
    }

    public void setGotoFieldInMessage(boolean inMessage) {
        this.gotoFieldInMessage = inMessage;
    }

    public abstract void setFirstVisible(boolean var1);

    public abstract void setPageBackwardVisible(boolean var1);

    public abstract void setPreviousVisible(boolean var1);

    public abstract void setNextVisible(boolean var1);

    public abstract void setPageForwardVisible(boolean var1);

    public abstract void setLastVisible(boolean var1);

    public void setImageVisible(boolean firstVisible, boolean pageBackwardVisible, boolean previousVisible, boolean nextVisible, boolean pageForwardVisible, boolean lastVisible) {
        this.setFirstVisible(firstVisible);
        this.setPageBackwardVisible(pageBackwardVisible);
        this.setPreviousVisible(previousVisible);
        this.setNextVisible(nextVisible);
        this.setPageForwardVisible(pageForwardVisible);
        this.setLastVisible(lastVisible);
    }

    @Override
    protected void writeContent(PrintWriter out) throws IOException {
        if (this.getModel() == null) {
            this.cleanUpResources();
            throw new IOException(RB.getStringResource(RB_KEY, "noModel.txt", this.getLocale()));
        }
        this.flushActionProvider();
        this.setDefaultFormAction();
        out.println("<table>");
        if (this.messageOrientation == 0) {
            out.println("<tr><td align=\"center\" nowrap=\"nowrap\">");
            this.writeBackwardScrollers(out);
            out.println("</td>");
            out.println("<td nowrap=\"nowrap\">");
            this.writeMessage(out);
            if (!this.isGotoFieldInMessage()) {
                this.writeGotoField(out);
            }
            out.println("</td>");
            out.println("<td align=\"center\" nowrap=\"nowrap\">");
            this.writeForwardScrollers(out);
            out.println("</td></tr>");
        } else if (this.messageOrientation == 1) {
            out.print("<tr><td align=\"center\" nowrap=\"nowrap\" colspan=\"");
            if (!this.isGotoFieldInMessage()) {
                out.println("3\">");
            } else {
                out.println("2\">");
            }
            this.writeMessage(out);
            out.println("</td></tr>");
            out.print("<tr><td align=\"center\" nowrap=\"nowrap\">");
            this.writeBackwardScrollers(out);
            if (!this.isGotoFieldInMessage()) {
                out.println("</td>");
                out.println("<td align=\"center\" nowrap=\"nowrap\">");
                this.writeGotoField(out);
            }
            out.println("</td>");
            out.println("<td align=\"center\" nowrap=\"nowrap\">");
            this.writeForwardScrollers(out);
            out.println("</td></tr>");
        } else if (this.messageOrientation == 3) {
            out.println("<tr><td align=\"center\" nowrap=\"nowrap\">");
            this.writeBackwardScrollers(out);
            if (!this.isGotoFieldInMessage()) {
                out.println("</td>");
                out.println("<td align=\"center\" nowrap=\"nowrap\">");
                this.writeGotoField(out);
            }
            out.println("</td>");
            out.println("<td align=\"center\" nowrap=\"nowrap\">");
            this.writeForwardScrollers(out);
            out.println("</td></tr>");
            out.print("<tr><td align=\"center\" nowrap=\"nowrap\" colspan=\"");
            if (!this.isGotoFieldInMessage()) {
                out.println("3\">");
            } else {
                out.println("2\">");
            }
            this.writeMessage(out);
            out.println("</td></tr>");
        } else if (this.messageOrientation == 4) {
            out.println("<tr><td align=\"center\" nowrap=\"nowrap\">");
            this.writeBackwardScrollers(out);
            if (!this.isGotoFieldInMessage()) {
                out.println("</td>");
                out.println("<td align=\"center\" nowrap=\"nowrap\">");
                this.writeGotoField(out);
            }
            out.println("</td>");
            out.println("<td align=\"center\" nowrap=\"nowrap\">");
            this.writeForwardScrollers(out);
            out.println("</td>");
            out.println("<td align=\"center\" nowrap=\"nowrap\">");
            this.writeMessage(out);
            out.println("</td></tr>");
        } else if (this.messageOrientation == 2) {
            out.println("<tr><td align=\"center\" nowrap=\"nowrap\">");
            this.writeMessage(out);
            out.println("</td>");
            out.println("<td align=\"center\" nowrap=\"nowrap\">");
            this.writeBackwardScrollers(out);
            if (!this.isGotoFieldInMessage()) {
                out.println("</td>");
                out.println("<td align=\"center\" nowrap=\"nowrap\">");
                this.writeGotoField(out);
            }
            out.println("</td>");
            out.println("<td align=\"center\" nowrap=\"nowrap\">");
            this.writeForwardScrollers(out);
            out.println("</td></tr>");
        }
        out.println("</table>");
        JavaScriptIncludeHandler.writeIncludes(out, "NAVIGATIONBAR", this.getRequest());
    }

    public void writeMessage(OutputStream out) throws IOException {
        PrintWriter o = new PrintWriter(out);
        this.writeMessage(o);
        o.flush();
    }

    public void writeMessage(Writer out) throws IOException {
        PrintWriter o = new PrintWriter(out);
        this.writeMessage(o);
        o.flush();
    }

    public abstract void writeMessage(PrintWriter var1) throws IOException;

    public void writeBackwardScrollers(OutputStream out) throws IOException {
        PrintWriter o = new PrintWriter(out);
        this.writeBackwardScrollers(o);
        o.flush();
    }

    public void writeBackwardScrollers(Writer out) throws IOException {
        PrintWriter o = new PrintWriter(out);
        this.writeBackwardScrollers(o);
        o.flush();
    }

    public abstract void writeBackwardScrollers(PrintWriter var1) throws IOException;

    public void writeForwardScrollers(OutputStream out) throws IOException {
        PrintWriter o = new PrintWriter(out);
        this.writeForwardScrollers(o);
        o.flush();
    }

    public void writeForwardScrollers(Writer out) throws IOException {
        PrintWriter o = new PrintWriter(out);
        this.writeForwardScrollers(o);
        o.flush();
    }

    public abstract void writeForwardScrollers(PrintWriter var1) throws IOException;

    public void writeGotoField(OutputStream out) throws IOException {
        PrintWriter o = new PrintWriter(out);
        this.writeGotoField(o);
        o.flush();
    }

    public void writeGotoField(Writer out) throws IOException {
        PrintWriter o = new PrintWriter(out);
        this.writeGotoField(o);
        o.flush();
    }

    public abstract void writeGotoField(PrintWriter var1) throws IOException;

    @Override
    public SimpleTemplate getURLTemplate() {
        SimpleTemplate template = super.getURLTemplate();
        if (template == null && this.getModel() != null && this.getModel() instanceof URLTemplateViewInterface) {
            BaseNavigationInterface model = this.getModel();
            template = model.getURLTemplate();
        }
        return template;
    }

    @Override
    public Map getStyleMap() {
        return this.styleMap;
    }

    static {
        JavaScriptIncludeHandler.addAlias(NavigationBarScrollingElement.class, "NAVIGATIONBAR");
    }
}

