/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.navigationbar.html;

import com.sas.actionprovider.ActionList;
import com.sas.actionprovider.ActionProviderMapPool;
import com.sas.actionprovider.ActionProviderViewInterface;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.HttpAction;
import com.sas.actionprovider.HttpActionProvider;
import com.sas.actionprovider.Util;
import com.sas.codepolicy.SASScope;
import com.sas.entities.AttributeSetException;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.form.html.Form;
import com.sas.servlet.tbeans.form.html.FormViewInterface;
import com.sas.servlet.tbeans.navigationbar.BaseNavigationInterface;
import com.sas.servlet.tbeans.navigationbar.EditNavigationInterface;
import com.sas.servlet.tbeans.navigationbar.RowNavigationInterface;
import com.sas.servlet.tbeans.navigationbar.html.NavigationBarScrollingElement;
import com.sas.servlet.tbeans.navigationbar.html.RB;
import com.sas.util.SimpleTemplate;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

@SASScope(value="ALL")
public class NavigationBarRowScrollingElement
extends NavigationBarScrollingElement {
    @SASScope
    public static final String RB_KEY = "NavigationBarRowScrollingElement.";
    private static final String NAME_PREFIX = "rse";
    private SimpleTemplate defaultMessageTemplate;
    private HashMap valueDictionary;
    private String scrollForwardArea;
    private String scrollBackwardArea;
    private String gotoArea;
    private boolean gotoFieldVisible;
    private boolean firstVisible;
    private boolean pageBackwardVisible;
    private boolean previousVisible;
    private boolean nextVisible;
    private boolean pageForwardVisible;
    private boolean lastVisible;

    public NavigationBarRowScrollingElement() {
        this(null);
    }

    public NavigationBarRowScrollingElement(BaseNavigationInterface model) {
        super(model);
        this.setId(com.sas.util.Util.getName((String)NAME_PREFIX));
        this.defaultMessageTemplate = new SimpleTemplate();
        this.valueDictionary = new HashMap(3);
        this.scrollForwardArea = "ROW_SCROLL_FORWARD_AREA";
        this.scrollBackwardArea = "ROW_SCROLL_BACKWARD_AREA";
        this.gotoArea = "ROW_GOTO_AREA";
        this.gotoFieldVisible = true;
        this.firstVisible = true;
        this.pageBackwardVisible = true;
        this.previousVisible = true;
        this.nextVisible = true;
        this.pageForwardVisible = true;
        this.lastVisible = true;
    }

    @Override
    public void setModel(BaseNavigationInterface navigationBarModel) {
        if (!(navigationBarModel instanceof RowNavigationInterface) && navigationBarModel != null) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "notRowModel.txt", this.getLocale()));
        }
        super.setModel(navigationBarModel);
    }

    @Override
    public String getMessage() {
        String startRow = null;
        RowNavigationInterface model = (RowNavigationInterface)this.getModel();
        if (model != null) {
            if (this.isGotoFieldInMessage() && this.isActionVisible("GOTO_ROW_ACTION", this.gotoArea)) {
                ActionList gotoActions = null;
                try {
                    gotoActions = this.getActions("ROW_GOTO_AREA");
                    if (gotoActions != null) {
                        HttpAction gotoRowAction = (HttpAction)gotoActions.get("GOTO_ROW_ACTION");
                        if (gotoRowAction != null) {
                            startRow = this.getGotoFieldTextEntry(gotoRowAction);
                        } else {
                            gotoRowAction = (HttpAction)gotoActions.get("GOTO_ROW_EDIT_ENABLED_ACTION");
                            if (gotoRowAction != null) {
                                startRow = this.getGotoFieldTextEntry(gotoRowAction);
                            }
                        }
                    }
                }
                catch (IOException gotoRowAction) {
                    // empty catch block
                }
                HttpActionProvider actionProvider = this.getActionProvider();
                if (actionProvider != null) {
                    actionProvider.returnActionList(gotoActions);
                }
            }
            if (startRow == null) {
                startRow = Integer.toString(model.getStartRow() + 1);
            }
            this.valueDictionary.put("STARTROW", startRow);
            this.valueDictionary.put("ENDROW", Integer.toString(model.getEndRow() + 1));
            this.valueDictionary.put("ROWCOUNT", Integer.toString(model.getRowCount()));
            this.getMessageTemplate().setValueDictionary((Map)this.valueDictionary);
        }
        return this.getMessageTemplate().format();
    }

    @Override
    public SimpleTemplate getDefaultMessageTemplate() {
        RowNavigationInterface rowModel = (RowNavigationInterface)this.getModel();
        if (rowModel != null) {
            int startRow = rowModel.getStartRow();
            int endRow = rowModel.getEndRow();
            if (rowModel.isAccurateRowCountAvailable()) {
                if (startRow != endRow) {
                    this.defaultMessageTemplate.setTemplate(RB.getStringResource(RB_KEY, "rowMessage1.txt", this.getLocale()));
                } else if (startRow > -1) {
                    this.defaultMessageTemplate.setTemplate(RB.getStringResource(RB_KEY, "rowMessage2.txt", this.getLocale()));
                }
            } else if (startRow != endRow) {
                this.defaultMessageTemplate.setTemplate(RB.getStringResource(RB_KEY, "rowMessage3.txt", this.getLocale()));
            } else if (startRow > -1) {
                this.defaultMessageTemplate.setTemplate(RB.getStringResource(RB_KEY, "rowMessage4.txt", this.getLocale()));
            }
        }
        return this.defaultMessageTemplate;
    }

    @Override
    public void writeMessage(PrintWriter out) throws IOException {
        if (this.isVisible()) {
            out.print("<span");
            String prefix = this.getStyleClassPrefix();
            StyleInfo styleinfo = (StyleInfo)this.getStyleMap().get("NAVIGATIONBAR_MESSAGE_STYLE");
            if (styleinfo.getClassid() != null) {
                out.print(" class=\"");
                if (prefix != null) {
                    out.print(prefix);
                }
                out.print(styleinfo.getClassid());
                out.print("\"");
            }
            if (styleinfo.getStyle() != null) {
                out.print(" style=\"");
                out.print(styleinfo.getStyle());
                out.print("\"");
            }
            out.print(">");
            out.print(this.getMessage());
            out.println("</span>");
        }
    }

    @Override
    public void writeBackwardScrollers(PrintWriter out) throws IOException {
        if (this.isVisible()) {
            ActionList actions = this.getActions("ROW_SCROLL_BACKWARD_AREA");
            HashMap argumentMap = ActionProviderMapPool.getMap();
            argumentMap.put("REQUEST", this.getRequest());
            argumentMap.put("STYLE_CLASS_PREFIX", "navbar");
            Util.writeActionList(actions, out, argumentMap);
            ActionProviderMapPool.returnMap((Map)argumentMap);
            HttpActionProvider actionProvider = this.getActionProvider();
            if (actionProvider != null) {
                actionProvider.returnActionList(actions);
            }
        }
    }

    @Override
    public void writeForwardScrollers(PrintWriter out) throws IOException {
        if (this.isVisible()) {
            ActionList actions = this.getActions("ROW_SCROLL_FORWARD_AREA");
            HashMap argumentMap = ActionProviderMapPool.getMap();
            argumentMap.put("REQUEST", this.getRequest());
            argumentMap.put("STYLE_CLASS_PREFIX", "navbar");
            Util.writeActionList(actions, out, argumentMap);
            ActionProviderMapPool.returnMap((Map)argumentMap);
            HttpActionProvider actionProvider = this.getActionProvider();
            if (actionProvider != null) {
                actionProvider.returnActionList(actions);
            }
        }
    }

    @Override
    public void writeGotoField(PrintWriter out) throws IOException {
        ActionList gotoActions;
        if (!this.isGotoFieldInMessage() && this.isActionVisible("GOTO_ROW_ACTION", this.gotoArea) && (gotoActions = this.getActions("ROW_GOTO_AREA")) != null) {
            HttpAction gotoRowAction = (HttpAction)gotoActions.get("GOTO_ROW_ACTION");
            if (gotoRowAction != null) {
                out.println(this.getGotoFieldTextEntry(gotoRowAction));
            } else {
                gotoRowAction = (HttpAction)gotoActions.get("GOTO_ROW_EDIT_ENABLED_ACTION");
                if (gotoRowAction != null) {
                    out.println(this.getGotoFieldTextEntry(gotoRowAction));
                }
            }
            HttpActionProvider actionProvider = this.getActionProvider();
            if (actionProvider != null) {
                actionProvider.returnActionList(gotoActions);
            }
        }
    }

    private ActionList getActions(String area) throws IOException {
        BaseNavigationInterface model = this.getModel();
        if (model != null) {
            ActionSupportFilter rowsFilter = new ActionSupportFilter(this.getActionSupportType(), area, (ActionProviderViewInterface)this, false);
            rowsFilter.setPoolingOn(true);
            rowsFilter.setViewerId(this.getId());
            rowsFilter.setHiddenActionsMap(this.getViewerSupport().getHiddenActionsMap());
            try {
                rowsFilter.setAttribute("model", (Object)model);
                if (model instanceof EditNavigationInterface) {
                    EditNavigationInterface eni = (EditNavigationInterface)model;
                    rowsFilter.setAttribute("row", (Object)new Integer(eni.getCurrentRow()));
                    rowsFilter.setAttribute("autoCommit", (Object)new Boolean(eni.isAutoCommit()));
                    if (model instanceof FormViewInterface) {
                        rowsFilter.setAttribute("formName", (Object)((FormViewInterface)((Object)model)).getFormObject().getName());
                    } else if (model instanceof Form) {
                        rowsFilter.setAttribute("formName", (Object)((Form)((Object)model)).getName());
                    }
                }
            }
            catch (AttributeSetException ase) {
                throw new IOException(ase.getMessage());
            }
            HttpActionProvider actionProvider = this.getActionProvider();
            if (actionProvider != null && rowsFilter != null) {
                return actionProvider.getActions(rowsFilter);
            }
        }
        return null;
    }

    private String getGotoFieldTextEntry(HttpAction action) {
        StringBuffer sb = new StringBuffer();
        RowNavigationInterface rni = (RowNavigationInterface)this.getModel();
        HttpActionProvider ap = this.getActionProvider();
        if (rni.getFormName() != null) {
            if (this.getGotoFieldLabel() != null && !this.isGotoFieldInMessage()) {
                sb.append("<label for=\"gotoRow\">");
                sb.append(this.getGotoFieldLabel());
                sb.append("</label>");
            }
            sb.append("<input type=\"TEXT\"");
            String prefix = this.getStyleClassPrefix();
            StyleInfo styleinfo = (StyleInfo)this.getStyleMap().get("NAVIGATIONBAR_INPUT_STYLE");
            if (styleinfo.getClassid() != null) {
                sb.append(" class=\"");
                if (prefix != null) {
                    sb.append(prefix);
                }
                sb.append(styleinfo.getClassid());
                sb.append("\"");
            }
            if (styleinfo.getStyle() != null) {
                sb.append(" style=\"");
                sb.append(styleinfo.getStyle());
                sb.append("\"");
            }
            sb.append(" size=\"5\" id=\"");
            sb.append(this.getId());
            sb.append("_GotoRow\" value=\"");
            sb.append(rni.getStartRow() + 1);
            sb.append("\" ONKEYDOWN=\"javascript:sas_NavigationBar_executeGoto(event,this,'");
            sb.append(rni.getFormName());
            sb.append("', '");
            sb.append(ap.getParameterPrefix());
            sb.append("gotoRow', '");
            sb.append(action.getCmdId());
            sb.append("','");
            sb.append(ap.getName());
            sb.append("')\" >\n");
        }
        return sb.toString();
    }

    @Override
    public void setGotoFieldVisible(boolean visible) {
        this.gotoFieldVisible = visible;
        if (this.getActionProvider() != null) {
            this.setActionVisible("GOTO_ROW_ACTION", this.gotoArea, visible);
        }
    }

    @Override
    public void setFirstVisible(boolean visible) {
        this.firstVisible = visible;
        if (this.getActionProvider() != null) {
            this.setActionVisible("FIRST_ROW_ACTION", this.scrollBackwardArea, visible);
        }
    }

    @Override
    public void setPageBackwardVisible(boolean visible) {
        this.pageBackwardVisible = visible;
        if (this.getActionProvider() != null) {
            this.setActionVisible("PAGE_BACKWARD_ROWS_ACTION", this.scrollBackwardArea, visible);
        }
    }

    @Override
    public void setPreviousVisible(boolean visible) {
        this.previousVisible = visible;
        if (this.getActionProvider() != null) {
            this.setActionVisible("PREVIOUS_ROW_ACTION", this.scrollBackwardArea, visible);
        }
    }

    @Override
    public void setNextVisible(boolean visible) {
        this.nextVisible = visible;
        if (this.getActionProvider() != null) {
            this.setActionVisible("NEXT_ROW_ACTION", this.scrollForwardArea, visible);
        }
    }

    @Override
    public void setPageForwardVisible(boolean visible) {
        this.pageForwardVisible = visible;
        if (this.getActionProvider() != null) {
            this.setActionVisible("PAGE_FORWARD_ROWS_ACTION", this.scrollForwardArea, visible);
        }
    }

    @Override
    public void setLastVisible(boolean visible) {
        this.lastVisible = visible;
        if (this.getActionProvider() != null) {
            this.setActionVisible("LAST_ROW_ACTION", this.scrollForwardArea, visible);
        }
    }

    @Override
    public void setActionProvider(HttpActionProvider provider) {
        super.setActionProvider(provider);
        if (provider != null) {
            if (!this.gotoFieldVisible) {
                this.setActionVisible("GOTO_ROW_ACTION", this.gotoArea, false);
            }
            if (!this.firstVisible) {
                this.setActionVisible("FIRST_ROW_ACTION", this.scrollBackwardArea, false);
            }
            if (!this.pageBackwardVisible) {
                this.setActionVisible("PAGE_BACKWARD_ROWS_ACTION", this.scrollBackwardArea, false);
            }
            if (!this.previousVisible) {
                this.setActionVisible("PREVIOUS_ROW_ACTION", this.scrollBackwardArea, false);
            }
            if (!this.nextVisible) {
                this.setActionVisible("NEXT_ROW_ACTION", this.scrollForwardArea, false);
            }
            if (!this.pageForwardVisible) {
                this.setActionVisible("PAGE_FORWARD_ROWS_ACTION", this.scrollForwardArea, false);
            }
            if (!this.lastVisible) {
                this.setActionVisible("LAST_ROW_ACTION", this.scrollForwardArea, false);
            }
        }
    }

    @Override
    public boolean isVisible() {
        if (!super.isVisible()) {
            return false;
        }
        RowNavigationInterface model = (RowNavigationInterface)this.getModel();
        return model != null && (this.isActionVisible("LAST_ROW_ACTION", this.scrollForwardArea) && model.isLastRowSupported() || this.isActionVisible("PAGE_FORWARD_ROWS_ACTION", this.scrollForwardArea) && model.isPageForwardRowsSupported() || this.isActionVisible("NEXT_ROW_ACTION", this.scrollForwardArea) && model.isNextRowSupported() || this.isActionVisible("PREVIOUS_ROW_ACTION", this.scrollBackwardArea) && model.isPreviousRowSupported() || this.isActionVisible("PAGE_BACKWARD_ROWS_ACTION", this.scrollBackwardArea) && model.isPageBackwardRowsSupported() || this.isActionVisible("FIRST_ROW_ACTION", this.scrollBackwardArea) && model.isFirstRowSupported() || this.isActionVisible("GOTO_ROW_ACTION", this.gotoArea) && model.isGotoRowSupported());
    }

    @Override
    public void setActionVisible(String actionType, String areaType, boolean visible) {
        super.setActionVisible(actionType, areaType, visible);
        if (actionType == "LAST_ROW_ACTION") {
            super.setActionVisible("LAST_ROW_EDIT_ENABLED_ACTION", areaType, visible);
        } else if (actionType == "PAGE_FORWARD_ROWS_ACTION") {
            super.setActionVisible("PAGE_FORWARD_ROWS_EDIT_ENABLED_ACTION", areaType, visible);
        } else if (actionType == "NEXT_ROW_ACTION") {
            super.setActionVisible("NEXT_ROW_EDIT_ENABLED_ACTION", areaType, visible);
        } else if (actionType == "PREVIOUS_ROW_ACTION") {
            super.setActionVisible("PREVIOUS_ROW_EDIT_ENABLED_ACTION", areaType, visible);
        } else if (actionType == "PAGE_BACKWARD_ROWS_ACTION") {
            super.setActionVisible("PAGE_BACKWARD_ROWS_EDIT_ENABLED_ACTION", areaType, visible);
        } else if (actionType == "FIRST_ROW_ACTION") {
            super.setActionVisible("FIRST_ROW_EDIT_ENABLED_ACTION", areaType, visible);
        } else if (actionType == "GOTO_ROW_ACTION") {
            super.setActionVisible("GOTO_ROW_EDIT_ENABLED_ACTION", areaType, visible);
        }
    }
}

