/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.models;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.StyleMap;
import com.sas.servlet.tbeans.models.Item;
import com.sas.servlet.tbeans.models.JavaScriptNodeInterface;
import com.sas.servlet.tbeans.models.JavaScriptNodeStyleKeysInterface;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.MapWithDefaults;
import com.sas.util.Strings;
import com.sas.util.Util;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@SASScope(value="ALL")
public class JavaScriptNode
extends Item
implements JavaScriptNodeInterface,
JavaScriptNodeStyleKeysInterface {
    private static final String NAME_PREFIX = "JavaScriptNode";
    private String parentId;
    private String image;
    private String disabledImage;
    private String imageURI;
    private String disabledImageURI;
    private String imageLocation;
    private String alt;
    private String styleClassPrefix;
    private String imageStyleClass;
    private String textStyleClass;
    private String selectedTextStyleClass;
    private String selectNodeFunctionName;
    private String deselectNodeFunctionName;
    private String cloneNodeFunctionName;
    private String nodeConstructorName;
    private String renderNodeFunctionName;
    private String preSelectFunctionName;
    private String postSelectFunctionName;
    private String launchUrl;
    private String windowFeatures;
    private String windowName;
    private boolean imagesOnly;
    private Boolean nowrap;
    Map parameters = null;
    Field[] nodeFields = null;
    private boolean escapeSpecialCharacters;
    private MapWithDefaults componentStyleMap;
    private static final HashMap defaultStyleMap = new HashMap();
    private static final ImmutableStyleInfo JavaScriptNodeIndentStyle = new ImmutableStyleInfo("javaScriptNodeIndentStyle");
    private static final ImmutableStyleInfo JavaScriptNodeImageStyle = new ImmutableStyleInfo();
    private static final ImmutableStyleInfo JavaScriptNodeTextStyle = new ImmutableStyleInfo("javaScriptNodeText");
    private static final ImmutableStyleInfo JavaScriptNodeSelectedTextStyle = new ImmutableStyleInfo("javaScriptNodeSelectedText");

    private static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0) {
            defaultStyleMap.put("JAVASCRIPTNODE_INDENT", JavaScriptNodeIndentStyle);
            defaultStyleMap.put("JAVASCRIPTNODE_IMAGE", JavaScriptNodeImageStyle);
            defaultStyleMap.put("JAVASCRIPTNODE_TEXT", JavaScriptNodeTextStyle);
            defaultStyleMap.put("JAVASCRIPTNODE_SELECTED_TEXT", JavaScriptNodeSelectedTextStyle);
        }
    }

    public JavaScriptNode() {
        this.setName(Util.getName((String)NAME_PREFIX));
        JavaScriptNode.setupDefaultStyleMap();
        this.componentStyleMap = new StyleMap(defaultStyleMap);
        this.setNodeConstructorName("sas_Node_BaseNode");
        this.setRenderNodeFunctionName("sas_Node_nodeRender");
        this.imagesOnly = false;
        this.nowrap = new Boolean(false);
        this.setEscapeSpecialCharacters(true);
        this.launchUrl = "";
        this.windowFeatures = "";
        this.windowName = "";
    }

    @Override
    public Map getStyleMap() {
        return this.componentStyleMap;
    }

    public void setImagesOnly(boolean value) {
        this.imagesOnly = value;
    }

    public boolean isImagesOnly() {
        return this.imagesOnly;
    }

    @Override
    public void setNoWrap(boolean value) {
        this.nowrap = new Boolean(value);
    }

    @Override
    public boolean isNoWrap() {
        return this.nowrap;
    }

    @Override
    public void setImage(String value) {
        this.image = value;
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public void setDisabledImage(String value) {
        this.disabledImage = value;
    }

    @Override
    public String getDisabledImage() {
        return this.disabledImage;
    }

    @Override
    public void setImageLocation(String imageLocation) {
        this.imageLocation = imageLocation;
    }

    @Override
    public String getImageLocation() {
        return this.imageLocation;
    }

    public void setAlternateText(String value) {
        this.alt = value;
    }

    public String getAlternateText() {
        return this.alt;
    }

    @Override
    public void setStyleClassPrefix(String value) {
        this.styleClassPrefix = value;
    }

    @Override
    public String getStyleClassPrefix() {
        return this.styleClassPrefix;
    }

    @Override
    public void setCloneNodeFunctionName(String value) {
        this.cloneNodeFunctionName = value;
    }

    @Override
    public String getCloneNodeFunctionName() {
        return this.cloneNodeFunctionName;
    }

    @Override
    public void setSelectNodeFunctionName(String value) {
        this.selectNodeFunctionName = value;
    }

    @Override
    public String getSelectNodeFunctionName() {
        return this.selectNodeFunctionName;
    }

    @Override
    public void setDeselectNodeFunctionName(String value) {
        this.deselectNodeFunctionName = value;
    }

    @Override
    public String getDeselectNodeFunctionName() {
        return this.deselectNodeFunctionName;
    }

    @SASScope
    public String getPreSelectNodeFunctionName() {
        return this.preSelectFunctionName;
    }

    @SASScope
    public void setPreSelectNodeFunctionName(String preSelectFunctionName) {
        this.preSelectFunctionName = preSelectFunctionName;
    }

    @SASScope
    public String getPostSelectNodeFunctionName() {
        return this.postSelectFunctionName;
    }

    @SASScope
    public void setPostSelectNodeFunctionName(String postSelectFunctionName) {
        this.postSelectFunctionName = postSelectFunctionName;
    }

    @Override
    public void setNodeConstructorName(String value) {
        this.nodeConstructorName = value;
    }

    @Override
    public String getNodeConstructorName() {
        return this.nodeConstructorName;
    }

    @SASScope
    public void setParentId(String value) {
        this.parentId = value;
    }

    @SASScope
    public String getParentId() {
        return this.parentId;
    }

    @SASScope
    public void setWindowFeatures(String features) {
        this.windowFeatures = features;
    }

    @SASScope
    public String getWindowFeatures() {
        return this.windowFeatures;
    }

    @SASScope
    public void setWindowName(String name) {
        this.windowName = name;
    }

    @SASScope
    public String getWindowName() {
        return this.windowName;
    }

    @SASScope
    public void setLaunchURL(String url) {
        this.launchUrl = url;
    }

    @SASScope
    public String getLaunchURL() {
        return this.launchUrl;
    }

    protected static String escapeNodeText(String nText) {
        if (nText == null) {
            return null;
        }
        String val = nText;
        val = Strings.quoteForXML((String)val);
        val = Strings.escapeForJavaScript((String)val, (boolean)true);
        return val;
    }

    @Override
    public Map getNodeConstructorParameters() {
        String postSelectFuncName;
        String preSelectFuncName;
        String onKeyPress;
        String onKeyUp;
        String onKeyDown;
        String onMouseUp;
        String onMouseDown;
        String onMouseOver;
        String onMouseOut;
        String onFocus;
        String onClick;
        String onChange;
        String onBlur;
        String tempDeselect;
        String tempSelect;
        String tempName;
        String tempClone;
        StyleInfo selTxtSI;
        StyleInfo txtSI;
        StyleInfo imgSI;
        String tempStylePrefix;
        String tempImageLoc;
        String tempRenderer;
        int tempIndentLevel;
        String windowName;
        String tempFeatures;
        String tempValue;
        String tmpVal;
        String tempText;
        this.parameters = new HashMap();
        Map nodeStyles = this.getStyleMap();
        Boolean tempSelected = new Boolean(this.isSelected());
        this.parameters.put("selected", tempSelected.toString());
        Boolean tempNoWrap = new Boolean(this.isNoWrap());
        this.parameters.put("noWrap", tempNoWrap.toString());
        Boolean tempEsc = new Boolean(this.isEscapeSpecialCharacters());
        this.parameters.put("escaped", tempEsc.toString());
        Boolean tempSeparator = new Boolean(this.isUseAsSeparator());
        this.parameters.put("isSeparator", tempSeparator.toString());
        String tempParentId = this.getParentId();
        if (tempParentId != null && tempParentId.length() > 0) {
            tempParentId = Strings.escapeForJavaScript((String)tempParentId);
            this.parameters.put("parentId", tempParentId);
        }
        if ((tempText = this.getText()) != null && tempText.length() > 0) {
            if (this.isEscapeSpecialCharacters()) {
                tempText = JavaScriptNode.escapeNodeText(tempText);
            }
            this.parameters.put("text", tempText);
        } else if (!this.isImagesOnly() && (tmpVal = this.getValue()) != null && tmpVal.length() > 0) {
            tmpVal = JavaScriptNode.escapeNodeText(tmpVal);
            this.parameters.put("text", tmpVal);
        }
        String tempImage = this.getImage();
        if (tempImage != null && tempImage.length() > 0) {
            tempImage = Strings.escapeForJavaScript((String)tempImage);
            this.parameters.put("image", tempImage);
        } else {
            String tempImageURI = this.getImageURI();
            if (tempImageURI != null && tempImageURI.length() > 0) {
                tempImageURI = Strings.escapeForJavaScript((String)tempImageURI);
                this.parameters.put("imageURI", tempImageURI);
            }
        }
        String tempDisabledImage = this.getDisabledImage();
        if (tempDisabledImage != null && tempDisabledImage.length() > 0) {
            tempDisabledImage = Strings.escapeForJavaScript((String)tempDisabledImage);
            this.parameters.put("disabledImage", tempDisabledImage);
        } else {
            String tempImageURI = this.getDisabledImageURI();
            if (tempImageURI != null && tempImageURI.length() > 0) {
                tempImageURI = Strings.escapeForJavaScript((String)tempImageURI);
                this.parameters.put("disabledImageURI", tempImageURI);
            }
        }
        String tempAltText = this.getAlternateText();
        if (tempAltText != null && tempAltText.length() > 0) {
            tempAltText = Strings.escapeForJavaScript((String)tempAltText);
            this.parameters.put("altText", tempAltText);
        }
        if ((tempValue = this.getValue()) != null && tempValue.length() > 0) {
            tempValue = JavaScriptNode.escapeNodeText(tempValue);
            this.parameters.put("value", tempValue);
        } else {
            String tmpTxt = this.getText();
            if (tmpTxt != null && tmpTxt.length() > 0) {
                tmpTxt = JavaScriptNode.escapeNodeText(tmpTxt);
                this.parameters.put("value", tmpTxt);
            }
        }
        ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(null);
        this.parameters.put("blankImageName", cpm.getImageName("Blank"));
        String tempUrl = this.getLaunchURL();
        if (tempUrl != null && tempUrl.length() > 0) {
            this.parameters.put("url", tempUrl);
        }
        if ((tempFeatures = this.getWindowFeatures()) != null && tempFeatures.length() > 0) {
            this.parameters.put("windowFeatures", tempFeatures);
        }
        if ((windowName = this.getWindowName()) != null && windowName.length() > 0) {
            this.parameters.put("windowName", windowName);
        }
        if ((tempIndentLevel = this.getIndentionLevel()) != -1) {
            String indentStyleClass;
            Integer indentionLevel = new Integer(tempIndentLevel);
            this.parameters.put("indentionLevel", indentionLevel.toString());
            StyleInfo indSI = (StyleInfo)nodeStyles.get("JAVASCRIPTNODE_INDENT");
            if (indSI != null && (indentStyleClass = indSI.getClassid()) != null && indentStyleClass.length() > 0) {
                indentStyleClass = Strings.escapeForJavaScript((String)indentStyleClass);
                this.parameters.put("indentStyleClass", indentStyleClass);
            }
        }
        if ((tempRenderer = this.getRenderNodeFunctionName()) != null && tempRenderer.length() > 0) {
            this.parameters.put("rendererFunctionName", tempRenderer);
        }
        if ((tempImageLoc = this.getImageLocation()) != null) {
            tempImageLoc = Strings.escapeForJavaScript((String)tempImageLoc);
            this.parameters.put("imageLocation", tempImageLoc);
        }
        if ((tempStylePrefix = this.getStyleClassPrefix()) != null && tempStylePrefix.length() > 0) {
            tempStylePrefix = Strings.escapeForJavaScript((String)tempStylePrefix);
            this.parameters.put("styleClassPrefix", tempStylePrefix);
        }
        if ((imgSI = (StyleInfo)nodeStyles.get("JAVASCRIPTNODE_IMAGE")) != null) {
            String imgStyle;
            String imgStyleClass = imgSI.getClassid();
            if (imgStyleClass != null && imgStyleClass.length() > 0) {
                imgStyleClass = Strings.escapeForJavaScript((String)imgStyleClass);
                this.parameters.put("imageStyleClass", imgStyleClass);
            }
            if ((imgStyle = imgSI.getStyle()) != null && imgStyle.length() > 0) {
                imgStyle = Strings.escapeForJavaScript((String)imgStyle);
                this.parameters.put("imageStyle", imgStyle);
            }
        }
        if ((txtSI = (StyleInfo)nodeStyles.get("JAVASCRIPTNODE_TEXT")) != null) {
            String textStyle;
            String textStyleClass = txtSI.getClassid();
            if (textStyleClass != null && textStyleClass.length() > 0) {
                textStyleClass = Strings.escapeForJavaScript((String)textStyleClass);
                this.parameters.put("textStyleClass", textStyleClass);
            }
            if ((textStyle = txtSI.getStyle()) != null && textStyle.length() > 0) {
                textStyle = Strings.escapeForJavaScript((String)textStyle);
                this.parameters.put("textStyle", textStyle);
            }
        }
        if ((selTxtSI = (StyleInfo)nodeStyles.get("JAVASCRIPTNODE_SELECTED_TEXT")) != null) {
            String selectedTextStyle;
            String selectedTextStyleClass = selTxtSI.getClassid();
            if (selectedTextStyleClass != null && selectedTextStyleClass.length() > 0) {
                selectedTextStyleClass = Strings.escapeForJavaScript((String)selectedTextStyleClass);
                this.parameters.put("selectedStyleClass", selectedTextStyleClass);
            }
            if ((selectedTextStyle = selTxtSI.getStyle()) != null && selectedTextStyle.length() > 0) {
                selectedTextStyle = Strings.escapeForJavaScript((String)selectedTextStyle);
                this.parameters.put("selectedStyle", selectedTextStyle);
            }
        }
        if ((tempClone = this.getCloneNodeFunctionName()) != null && tempClone.length() > 0) {
            this.parameters.put("cloneFUNCTIONNAME", tempClone);
        }
        if ((tempName = this.getName()) != null && tempName.length() > 0) {
            tempName = Strings.escapeForJavaScript((String)tempName);
            this.parameters.put("name", tempName);
        }
        if ((tempSelect = this.getSelectNodeFunctionName()) != null && tempSelect.length() > 0) {
            this.parameters.put("selectNodeFunctionName", tempSelect);
        }
        if ((tempDeselect = this.getDeselectNodeFunctionName()) != null && tempDeselect.length() > 0) {
            this.parameters.put("deselectNodeFunctionName", tempDeselect);
        }
        if ((onBlur = this.getOnBlur()) != null && onBlur.length() > 0) {
            this.parameters.put("onBlurFunctionName", onBlur);
        }
        if ((onChange = this.getOnChange()) != null && onChange.length() > 0) {
            this.parameters.put("onChangeFunctionName", onChange);
        }
        if ((onClick = this.getOnClick()) != null && onClick.length() > 0) {
            this.parameters.put("onClickFunctionName", onClick);
        }
        if ((onFocus = this.getOnFocus()) != null && onFocus.length() > 0) {
            this.parameters.put("onFocusFunctionName", onFocus);
        }
        if ((onMouseOut = this.getOnMouseOut()) != null && onMouseOut.length() > 0) {
            this.parameters.put("onMouseOutFunctionName", onMouseOut);
        }
        if ((onMouseOver = this.getOnMouseOver()) != null && onMouseOver.length() > 0) {
            this.parameters.put("onMouseOverFunctionName", onMouseOver);
        }
        if ((onMouseDown = this.getOnMouseDown()) != null && onMouseDown.length() > 0) {
            this.parameters.put("onMouseDownFunctionName", onMouseDown);
        }
        if ((onMouseUp = this.getOnMouseUp()) != null && onMouseUp.length() > 0) {
            this.parameters.put("onMouseUpFunctionName", onMouseUp);
        }
        if ((onKeyDown = this.getOnKeyDown()) != null && onKeyDown.length() > 0) {
            this.parameters.put("onKeyDownFunctionName", onKeyDown);
        }
        if ((onKeyUp = this.getOnKeyUp()) != null && onKeyUp.length() > 0) {
            this.parameters.put("onKeyUpFunctionName", onKeyUp);
        }
        if ((onKeyPress = this.getOnKeyPress()) != null && onKeyPress.length() > 0) {
            this.parameters.put("onKeyPressFunctionName", onKeyPress);
        }
        if ((preSelectFuncName = this.getPreSelectNodeFunctionName()) != null && preSelectFuncName.length() > 0) {
            this.parameters.put("preselectNodeFunction", preSelectFuncName);
        }
        if ((postSelectFuncName = this.getPostSelectNodeFunctionName()) != null && postSelectFuncName.length() > 0) {
            this.parameters.put("postselectNodeFunction", postSelectFuncName);
        }
        return this.parameters;
    }

    @Override
    public String createNodeParameterString(Map params) {
        if (params == null) {
            params = this.getNodeConstructorParameters();
        }
        StringBuffer sb = new StringBuffer();
        String paramString = "";
        Set keys = params.keySet();
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            String value = (String)params.get(name);
            String copyOfName = name;
            boolean isEvent = false;
            if ((copyOfName = copyOfName.toLowerCase()).endsWith("functionname")) {
                int pos = copyOfName.indexOf("functionname");
                String newName = name.substring(0, pos);
                sb.append(newName);
                sb.append(":");
                String tempNewName = newName;
                if (tempNewName.toLowerCase().startsWith("on")) {
                    isEvent = true;
                    sb.append("function(event){");
                }
                sb.append(value);
                if (isEvent) {
                    if (!value.endsWith(";")) {
                        sb.append(";");
                    }
                    sb.append("}");
                }
                sb.append("");
            } else {
                sb.append(name);
                if (name.equalsIgnoreCase("selected") || name.equalsIgnoreCase("escaped") || name.equalsIgnoreCase("isSeparator") || name.endsWith("Function")) {
                    sb.append(":");
                } else {
                    sb.append(":\"");
                }
                ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(null);
                if (name == "image" && value == null) {
                    value = cpm.getImageName("Blank");
                }
                if (name == "imageURI" && value == null) {
                    value = cpm.getImageName("Blank");
                }
                if (name.endsWith("Function")) {
                    sb.append("function(event){ return ");
                }
                sb.append(value);
                if (name.endsWith("Function")) {
                    sb.append("}");
                }
                if (!(name.equalsIgnoreCase("selected") || name.equalsIgnoreCase("escaped") || name.equalsIgnoreCase("isSeparator") || name.endsWith("Function"))) {
                    sb.append("\"");
                }
            }
            if (!i.hasNext()) continue;
            sb.append(",");
        }
        paramString = sb.toString();
        return paramString;
    }

    @Override
    public void setRenderNodeFunctionName(String value) {
        this.renderNodeFunctionName = value;
    }

    @Override
    public String getRenderNodeFunctionName() {
        return this.renderNodeFunctionName;
    }

    @SASScope
    public boolean isEscapeSpecialCharacters() {
        return this.escapeSpecialCharacters;
    }

    @SASScope
    public void setEscapeSpecialCharacters(boolean escapeSpecialCharacters) {
        this.escapeSpecialCharacters = escapeSpecialCharacters;
    }

    @SASScope
    public String getDisabledImageURI() {
        return this.disabledImageURI;
    }

    @SASScope
    public void setDisabledImageURI(String disabledImageURI) {
        this.disabledImageURI = disabledImageURI;
    }

    @SASScope
    public String getImageURI() {
        return this.imageURI;
    }

    @SASScope
    public void setImageURI(String imageURI) {
        this.imageURI = imageURI;
    }

    static {
        JavaScriptIncludeHandler.addAlias(JavaScriptNode.class, "NODE");
    }
}

