/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.models;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.models.FontPickerModelInterface;
import com.sas.servlet.tbeans.models.Item;
import com.sas.servlet.tbeans.models.ItemInterface;
import com.sas.servlet.tbeans.models.RB;
import java.util.Locale;

@SASScope
public class FontPickerModel
implements FontPickerModelInterface {
    public static final String RB_KEY = "FontPicker.";
    private ItemInterface[] fontNames;
    private ItemInterface[] fontSizes;
    private String textAlignment;
    private String fontSize;
    private String fontName;
    private String fontForegroundColor;
    private String fontBackgroundColor;
    private boolean boldSelected;
    private boolean italicSelected;
    private boolean underlineSelected;
    private ItemInterface[] foregroundColorChoices;
    private ItemInterface[] backgroundColorChoices;
    private Locale locale;
    private boolean includeAutomatic;
    private String automaticFontChoiceValue;

    public FontPickerModel() {
        this(null, null, null, null);
    }

    public FontPickerModel(ItemInterface[] fontNames, ItemInterface[] fontSizes, ItemInterface[] backgroundColors, ItemInterface[] foregroundColors) {
        if (fontNames != null) {
            this.setFontNames(fontNames);
        }
        if (fontSizes != null) {
            this.setFontSizes(fontSizes);
        }
        if (backgroundColors != null) {
            this.setBackgroundColors(backgroundColors);
        }
        if (foregroundColors != null) {
            this.setForegroundColors(foregroundColors);
        }
        this.setAutomaticFontChoice(false);
    }

    public void setFontNames(ItemInterface[] fontNameNodes) {
        this.fontNames = fontNameNodes;
    }

    @Override
    public ItemInterface[] getFontNames() {
        return this.fontNames;
    }

    public void setFontName(String name) {
        this.fontName = name;
    }

    @Override
    public String getFontName() {
        return this.fontName;
    }

    public void setFontSizes(ItemInterface[] fontSizeNodes) {
        this.fontSizes = fontSizeNodes;
    }

    @Override
    public ItemInterface[] getFontSizes() {
        return this.fontSizes;
    }

    public void setFontSize(String size) {
        this.fontSize = size;
    }

    @Override
    public String getFontSize() {
        return this.fontSize;
    }

    public void setTextAlign(String alignment) {
        this.textAlignment = alignment;
    }

    @Override
    public String getTextAlign() {
        return this.textAlignment;
    }

    public void setBold(boolean selected) {
        this.boldSelected = selected;
    }

    @Override
    public boolean isBold() {
        return this.boldSelected;
    }

    public void setItalic(boolean selected) {
        this.italicSelected = selected;
    }

    @Override
    public boolean isItalic() {
        return this.italicSelected;
    }

    public void setUnderline(boolean selected) {
        this.underlineSelected = selected;
    }

    @Override
    public boolean isUnderline() {
        return this.underlineSelected;
    }

    public void setForegroundColors(ItemInterface[] colors) {
        this.foregroundColorChoices = colors;
    }

    @Override
    public ItemInterface[] getForegroundColors() {
        return this.foregroundColorChoices;
    }

    public void setForegroundColor(String color) {
        this.fontForegroundColor = color;
    }

    @Override
    public String getForegroundColor() {
        return this.fontForegroundColor;
    }

    public void setBackgroundColors(ItemInterface[] colors) {
        this.backgroundColorChoices = colors;
    }

    @Override
    public ItemInterface[] getBackgroundColors() {
        return this.backgroundColorChoices;
    }

    public void setBackgroundColor(String color) {
        this.fontBackgroundColor = color;
    }

    @Override
    public String getBackgroundColor() {
        return this.fontBackgroundColor;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ItemInterface[] getDefaultFontSizes() {
        Locale locale = this.getLocale();
        if (this.getAutomaticFontChoice()) {
            ItemInterface[] defaultFontSizes = new ItemInterface[]{new Item(RB.getStringResource(RB_KEY, "Font_Automatic.txt", locale), this.getAutomaticFontChoiceValue()), new Item(RB.getStringResource(RB_KEY, "FontSize_8.txt", locale), "8pt"), new Item(RB.getStringResource(RB_KEY, "FontSize_9.txt", locale), "9pt"), new Item(RB.getStringResource(RB_KEY, "FontSize_10.txt", locale), "10pt"), new Item(RB.getStringResource(RB_KEY, "FontSize_11.txt", locale), "11pt"), new Item(RB.getStringResource(RB_KEY, "FontSize_12.txt", locale), "12pt"), new Item(RB.getStringResource(RB_KEY, "FontSize_14.txt", locale), "14pt"), new Item(RB.getStringResource(RB_KEY, "FontSize_16.txt", locale), "16pt"), new Item(RB.getStringResource(RB_KEY, "FontSize_18.txt", locale), "18pt"), new Item(RB.getStringResource(RB_KEY, "FontSize_20.txt", locale), "20pt"), new Item(RB.getStringResource(RB_KEY, "FontSize_22.txt", locale), "22pt"), new Item(RB.getStringResource(RB_KEY, "FontSize_24.txt", locale), "24pt"), new Item(RB.getStringResource(RB_KEY, "FontSize_26.txt", locale), "26pt"), new Item(RB.getStringResource(RB_KEY, "FontSize_28.txt", locale), "28pt"), new Item(RB.getStringResource(RB_KEY, "FontSize_36.txt", locale), "36pt"), new Item(RB.getStringResource(RB_KEY, "FontSize_48.txt", locale), "48pt"), new Item(RB.getStringResource(RB_KEY, "FontSize_72.txt", locale), "72pt")};
            return defaultFontSizes;
        }
        ItemInterface[] defaultFontSizes = new ItemInterface[]{new Item(RB.getStringResource(RB_KEY, "FontSize_8.txt", locale), "8pt"), new Item(RB.getStringResource(RB_KEY, "FontSize_9.txt", locale), "9pt"), new Item(RB.getStringResource(RB_KEY, "FontSize_10.txt", locale), "10pt"), new Item(RB.getStringResource(RB_KEY, "FontSize_11.txt", locale), "11pt"), new Item(RB.getStringResource(RB_KEY, "FontSize_12.txt", locale), "12pt"), new Item(RB.getStringResource(RB_KEY, "FontSize_14.txt", locale), "14pt"), new Item(RB.getStringResource(RB_KEY, "FontSize_16.txt", locale), "16pt"), new Item(RB.getStringResource(RB_KEY, "FontSize_18.txt", locale), "18pt"), new Item(RB.getStringResource(RB_KEY, "FontSize_20.txt", locale), "20pt"), new Item(RB.getStringResource(RB_KEY, "FontSize_22.txt", locale), "22pt"), new Item(RB.getStringResource(RB_KEY, "FontSize_24.txt", locale), "24pt"), new Item(RB.getStringResource(RB_KEY, "FontSize_26.txt", locale), "26pt"), new Item(RB.getStringResource(RB_KEY, "FontSize_28.txt", locale), "28pt"), new Item(RB.getStringResource(RB_KEY, "FontSize_36.txt", locale), "36pt"), new Item(RB.getStringResource(RB_KEY, "FontSize_48.txt", locale), "48pt"), new Item(RB.getStringResource(RB_KEY, "FontSize_72.txt", locale), "72pt")};
        return defaultFontSizes;
    }

    public ItemInterface[] getDefaultFontNames() {
        Locale locale = this.getLocale();
        if (this.getAutomaticFontChoice()) {
            ItemInterface[] defaultFontNames = new ItemInterface[]{new Item(RB.getStringResource(RB_KEY, "Font_Automatic.txt", locale), this.getAutomaticFontChoiceValue()), new Item(RB.getStringResource(RB_KEY, "FontName_Arial.txt", locale), "Arial"), new Item(RB.getStringResource(RB_KEY, "FontName_ArialBlack.txt", locale), "Arial Black"), new Item(RB.getStringResource(RB_KEY, "FontName_ArialNarrow.txt", locale), "Arial Narrow"), new Item(RB.getStringResource(RB_KEY, "FontName_ArialUnicodeMS.txt", locale), "Arial Unicode MS"), new Item(RB.getStringResource(RB_KEY, "FontName_Batang.txt", locale), "Batang"), new Item(RB.getStringResource(RB_KEY, "FontName_BookmanAntiqua.txt", locale), "Bookman Antiqua"), new Item(RB.getStringResource(RB_KEY, "FontName_Century.txt", locale), "Century"), new Item(RB.getStringResource(RB_KEY, "FontName_CenturyGothic.txt", locale), "Century Gothic"), new Item(RB.getStringResource(RB_KEY, "FontName_ComicSansMS.txt", locale), "Comic Sans MS"), new Item(RB.getStringResource(RB_KEY, "FontName_CourierNew.txt", locale), "Courier New"), new Item(RB.getStringResource(RB_KEY, "FontName_FranklinGothicMedium.txt", locale), "Franklin Gothic Medium"), new Item(RB.getStringResource(RB_KEY, "FontName_Garamond.txt", locale), "Garamond"), new Item(RB.getStringResource(RB_KEY, "FontName_Impact.txt", locale), "Impact"), new Item(RB.getStringResource(RB_KEY, "FontName_LucidaSansUnicode.txt", locale), "Lucida Sans Unicode"), new Item(RB.getStringResource(RB_KEY, "FontName_MicrosoftSansSerif.txt", locale), "Microsoft Sans Serif"), new Item(RB.getStringResource(RB_KEY, "FontName_PalatinoLinotype.txt", locale), "Palatino Linotype"), new Item(RB.getStringResource(RB_KEY, "FontName_Tahoma.txt", locale), "Tahoma"), new Item(RB.getStringResource(RB_KEY, "FontName_TimesNewRoman.txt", locale), "Times New Roman"), new Item(RB.getStringResource(RB_KEY, "FontName_TrebuchetMS.txt", locale), "Trebuchet MS"), new Item(RB.getStringResource(RB_KEY, "FontName_Verdana.txt", locale), "Verdana")};
            return defaultFontNames;
        }
        ItemInterface[] defaultFontNames = new ItemInterface[]{new Item(RB.getStringResource(RB_KEY, "FontName_Arial.txt", locale), "Arial"), new Item(RB.getStringResource(RB_KEY, "FontName_ArialBlack.txt", locale), "Arial Black"), new Item(RB.getStringResource(RB_KEY, "FontName_ArialNarrow.txt", locale), "Arial Narrow"), new Item(RB.getStringResource(RB_KEY, "FontName_ArialUnicodeMS.txt", locale), "Arial Unicode MS"), new Item(RB.getStringResource(RB_KEY, "FontName_Batang.txt", locale), "Batang"), new Item(RB.getStringResource(RB_KEY, "FontName_BookmanAntiqua.txt", locale), "Bookman Antiqua"), new Item(RB.getStringResource(RB_KEY, "FontName_Century.txt", locale), "Century"), new Item(RB.getStringResource(RB_KEY, "FontName_CenturyGothic.txt", locale), "Century Gothic"), new Item(RB.getStringResource(RB_KEY, "FontName_ComicSansMS.txt", locale), "Comic Sans MS"), new Item(RB.getStringResource(RB_KEY, "FontName_CourierNew.txt", locale), "Courier New"), new Item(RB.getStringResource(RB_KEY, "FontName_FranklinGothicMedium.txt", locale), "Franklin Gothic Medium"), new Item(RB.getStringResource(RB_KEY, "FontName_Garamond.txt", locale), "Garamond"), new Item(RB.getStringResource(RB_KEY, "FontName_Impact.txt", locale), "Impact"), new Item(RB.getStringResource(RB_KEY, "FontName_LucidaSansUnicode.txt", locale), "Lucida Sans Unicode"), new Item(RB.getStringResource(RB_KEY, "FontName_MicrosoftSansSerif.txt", locale), "Microsoft Sans Serif"), new Item(RB.getStringResource(RB_KEY, "FontName_PalatinoLinotype.txt", locale), "Palatino Linotype"), new Item(RB.getStringResource(RB_KEY, "FontName_Tahoma.txt", locale), "Tahoma"), new Item(RB.getStringResource(RB_KEY, "FontName_TimesNewRoman.txt", locale), "Times New Roman"), new Item(RB.getStringResource(RB_KEY, "FontName_TrebuchetMS.txt", locale), "Trebuchet MS"), new Item(RB.getStringResource(RB_KEY, "FontName_Verdana.txt", locale), "Verdana")};
        return defaultFontNames;
    }

    public void setFontWeight(String fontWeight) {
        if ("BOLD".equalsIgnoreCase(fontWeight)) {
            this.setBold(true);
        } else {
            this.setBold(false);
        }
    }

    public void setFontStyle(String fontStyle) {
        if ("ITALIC".equalsIgnoreCase(fontStyle)) {
            this.setItalic(true);
        } else {
            this.setItalic(false);
        }
    }

    public void setTextDecoration(String textDecoration) {
        if ("UNDERLINE".equalsIgnoreCase(textDecoration)) {
            this.setUnderline(true);
        } else {
            this.setUnderline(false);
        }
    }

    @Override
    public void setAutomaticFontChoice(boolean automatic) {
        this.includeAutomatic = automatic;
    }

    @Override
    public boolean getAutomaticFontChoice() {
        return this.includeAutomatic;
    }

    public void setAutomaticFontChoiceValue(String value) {
        this.automaticFontChoiceValue = value;
    }

    @Override
    public String getAutomaticFontChoiceValue() {
        if (this.automaticFontChoiceValue == null) {
            return "AUTOMATIC";
        }
        return this.automaticFontChoiceValue;
    }
}

