/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.menus.popupmenu.html;

import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.menus.model.PopupMenuItemInterface;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.servlet.util.ComponentSessionManager;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.Util;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PopupMenu
extends BaseTransformation {
    protected List menuItems = null;
    protected List attachTo = new ArrayList();
    protected String positionRelativeTo = null;
    protected String imageLocation = null;
    protected boolean delayedLoad = false;

    public PopupMenu() {
        this(Util.getName((String)"pmenu"));
    }

    public PopupMenu(String id) {
        if (id != null) {
            this.setId(id);
        }
    }

    public void setModel(List menuItems) {
        this.menuItems = menuItems;
    }

    public List getModel() {
        return this.menuItems;
    }

    public void attachTo(String domId) {
        this.attachTo(domId, null, null);
    }

    public void attachTo(String domId, String eventName) {
        this.attachTo(domId, null, eventName);
    }

    public void attachTo(String domId, String context, String eventName) {
        this.attachToAncestor(domId, null, context, eventName);
    }

    public void attachToAncestor(String domId, String ancestorType, String context, String eventName) {
        this.attachTo.add(new AttachTo(domId, context, eventName, ancestorType));
    }

    public String getPositionRelativeTo() {
        return this.positionRelativeTo;
    }

    public void setPositionRelativeTo(String positionRelativeTo) {
        this.positionRelativeTo = positionRelativeTo;
    }

    public String getImageLocation() {
        return this.imageLocation;
    }

    public void setImageLocation(String imageLocation) {
        this.imageLocation = imageLocation;
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        if (this.getModel() != null && this.getModel().size() > 0) {
            JavaScriptIncludeHandler.writeIncludes(out, "POPUPMENU", this.getRequest());
            this.writeJavaScript(out);
        }
    }

    public void writeJavaScriptCustomScriptBlock(PrintWriter out) {
        if (this.getModel() != null && this.getModel().size() > 0) {
            out.println(this.getId() + " = new sas.menu.PopupMenu('" + this.getId() + "');\n");
            if (this.isDelayedLoad()) {
                String callbackURI = this.getRequest().getContextPath() + "/MethodInvocationServlet?CLASS_PARAMETER=com.sas.servlet.tbeans.menus.popupmenu.html.PopupMenu&METHOD=fetchModel";
                out.println(this.getId() + ".setDelayedLoad(true,'" + callbackURI + "');");
                PopupMenu.getDelayedLoadModelSessionStore(this.getRequest()).put(this.getId(), this.getModelAsJSON(false));
            } else {
                out.println(this.getId() + ".setJSONModel(" + this.getModelAsJSON(false) + ");");
            }
            if (this.getPositionRelativeTo() != null) {
                out.println(this.getId() + ".setPositionRelativeTo('" + this.getPositionRelativeTo() + "');");
            }
            this.writeJavaScriptAttachMenus(out);
        }
    }

    private void writeJavaScript(PrintWriter out) {
        out.println(JavaScriptIncludeHandler.getStartScript());
        out.println(this.getId() + " = new sas.menu.PopupMenu('" + this.getId() + "');\n");
        if (this.isDelayedLoad()) {
            String callbackURI = this.getRequest().getContextPath() + "/MethodInvocationServlet?CLASS_PARAMETER=com.sas.servlet.tbeans.menus.popupmenu.html.PopupMenu&METHOD=fetchModel";
            out.println(this.getId() + ".setDelayedLoad(true,'" + callbackURI + "');");
            PopupMenu.getDelayedLoadModelSessionStore(this.getRequest()).put(this.getId(), this.getModelAsJSON(false));
        } else {
            out.println(this.getId() + ".setJSONModel(" + this.getModelAsJSON(false) + ");");
        }
        if (this.getPositionRelativeTo() != null) {
            out.println(this.getId() + ".setPositionRelativeTo('" + this.getPositionRelativeTo() + "');");
        }
        this.writeJavaScriptAttachMenus(out);
        out.println(JavaScriptIncludeHandler.getEndScript(null));
    }

    private void writeJavaScriptAttachMenus(PrintWriter out) {
        AttachTo attachToItem2 = null;
        for (AttachTo attachToItem2 : this.attachTo) {
            if (attachToItem2.getDomId() == null) continue;
            if (attachToItem2.getAncestorType() != null) {
                out.print(this.getId() + ".attachToAncestor('" + attachToItem2.getDomId() + "'");
                out.print(",'" + attachToItem2.getAncestorType() + "'");
                if (attachToItem2.getContext() != null) {
                    out.print(",'" + attachToItem2.getContext() + "'");
                } else {
                    out.print(",null");
                }
                if (attachToItem2.getEvent() != null) {
                    out.print(",'" + attachToItem2.getEvent() + "'");
                }
                out.println(");");
                continue;
            }
            out.print(this.getId() + ".attachTo('" + attachToItem2.getDomId() + "'");
            if (attachToItem2.getContext() != null) {
                out.print("," + attachToItem2.getContext());
            } else {
                out.print(",null");
            }
            if (attachToItem2.getEvent() != null) {
                out.print(",'" + attachToItem2.getEvent() + "'");
            } else {
                out.print(",null");
            }
            out.println(");");
        }
    }

    public String getModelAsJSON(boolean format) {
        ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(this.getRequest());
        JSONObject jsonMenu = new JSONObject();
        try {
            jsonMenu.put("id", (Object)this.getId());
            if (this.getImageLocation() != null) {
                jsonMenu.put("imageLocation", (Object)this.getImageLocation());
            }
            jsonMenu.put("stockImageLocation", (Object)cpm.getImageLocation());
            JSONObject jsonMenuImages = new JSONObject();
            jsonMenuImages.put("menuRightArrow", (Object)cpm.getImageName("Menu_Right_Arrow", this.imageLocation));
            jsonMenuImages.put("menuRightArrowDisabled", (Object)cpm.getImageName("Menu_Right_Arrow_Disabled", this.imageLocation));
            jsonMenuImages.put("spacer", (Object)cpm.getImageName("Spacer", this.imageLocation));
            jsonMenu.put("images", (Object)jsonMenuImages);
            JSONArray jsonMenuItems = this.convertMenuItemsToJSON(this.menuItems);
            if (jsonMenuItems.length() > 0) {
                jsonMenu.put("items", (Object)jsonMenuItems);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (!format) {
            return jsonMenu.toString();
        }
        String jsonString = null;
        try {
            jsonString = jsonMenu.toString(3);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonString;
    }

    private JSONArray convertMenuItemsToJSON(List menuItemsToConvert) {
        JSONArray jsonMenuItems = new JSONArray();
        if (menuItemsToConvert == null || menuItemsToConvert.size() == 0) {
            return jsonMenuItems;
        }
        JSONObject jsonMenuItem = null;
        PopupMenuItemInterface menuItem = null;
        for (Object o : menuItemsToConvert) {
            if (!(o instanceof PopupMenuItemInterface)) continue;
            menuItem = (PopupMenuItemInterface)o;
            try {
                jsonMenuItem = new JSONObject();
                if (this.isValidProperty(menuItem.getHandle())) {
                    jsonMenuItem.put("handle", (Object)menuItem.getHandle());
                }
                if (menuItem.isSeparator()) {
                    jsonMenuItem.put("separator", true);
                } else {
                    jsonMenuItem.put("text", (Object)menuItem.getText());
                    if (this.isValidProperty(menuItem.getImage())) {
                        jsonMenuItem.put("image", (Object)menuItem.getImage());
                        if (this.isValidProperty(menuItem.getAlternateText())) {
                            jsonMenuItem.put("alttext", (Object)menuItem.getAlternateText());
                        }
                    }
                    if (this.isValidProperty(menuItem.getTitle())) {
                        jsonMenuItem.put("title", (Object)menuItem.getTitle());
                    }
                    if (menuItem.isDisabled()) {
                        jsonMenuItem.put("disabled", true);
                        if (menuItem.getDisabledImage() != null) {
                            jsonMenuItem.put("disabledImage", (Object)menuItem.getDisabledImage());
                        }
                    }
                    if (this.isValidProperty(menuItem.getUrl())) {
                        jsonMenuItem.put("url", (Object)menuItem.getUrl());
                    } else if (this.isValidProperty(menuItem.getJavascript())) {
                        jsonMenuItem.put("javascript", (Object)menuItem.getJavascript());
                    } else if (menuItem.getCascadingMenu() != null) {
                        JSONObject cascadingMenuJSON = new JSONObject();
                        cascadingMenuJSON.put("items", (Object)this.convertMenuItemsToJSON(menuItem.getCascadingMenu()));
                        jsonMenuItem.put("submenu", (Object)cascadingMenuJSON);
                    }
                }
                jsonMenuItems.put((Object)jsonMenuItem);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return jsonMenuItems;
    }

    private boolean isValidProperty(String property) {
        return property != null && !"".equals(property);
    }

    public boolean isDelayedLoad() {
        return this.delayedLoad;
    }

    public void setDelayedLoad(boolean delayedLoad) {
        this.delayedLoad = delayedLoad;
    }

    public static void clearDelayedLoadModels(HttpServletRequest request, HttpServletResponse response) {
        PopupMenu.getDelayedLoadModelSessionStore(request).clear();
    }

    public static void fetchModel(HttpServletRequest request, HttpServletResponse response) {
        if (request == null || response == null) {
            return;
        }
        String popupMenuId = request.getParameter("popupMenuId");
        String jsonModel = (String)PopupMenu.getDelayedLoadModelSessionStore(request).get(popupMenuId);
        try {
            response.getWriter().println(jsonModel);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Map getDelayedLoadModelSessionStore(HttpServletRequest request) {
        Map sessionSpace = ComponentSessionManager.getSessionManager(request);
        Map modelsOnSession = null;
        if (sessionSpace.get("PopupMenuModels") != null) {
            modelsOnSession = (Map)sessionSpace.get("PopupMenuModels");
        } else {
            modelsOnSession = new HashMap();
            sessionSpace.put("PopupMenuModels", modelsOnSession);
        }
        return modelsOnSession;
    }

    public void displayModelInConsole() {
        System.out.println(this.getModelAsJSON(true));
    }

    static {
        JavaScriptIncludeHandler.addAlias(PopupMenu.class, "POPUPMENU");
    }

    private class AttachTo {
        private String domId = null;
        private String context = null;
        private String event = null;
        private String ancestorType = null;

        public AttachTo(String domId, String context, String event, String ancestorType) {
            this.domId = domId;
            this.context = context;
            this.event = event;
            this.ancestorType = ancestorType;
        }

        public String getAncestorType() {
            return this.ancestorType;
        }

        public void setAncestorType(String ancestorType) {
            this.ancestorType = ancestorType;
        }

        public String getContext() {
            return this.context;
        }

        public void setContext(String context) {
            this.context = context;
        }

        public String getDomId() {
            return this.domId;
        }

        public void setDomId(String domId) {
            this.domId = domId;
        }

        public String getEvent() {
            return this.event;
        }

        public void setEvent(String event) {
            this.event = event;
        }
    }
}

