/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.menus.menubar.html;

import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.html.RB;
import com.sas.servlet.tbeans.menus.model.MenuBarItemInterface;
import com.sas.servlet.tbeans.menus.popupmenu.html.PopupMenu;
import com.sas.servlet.util.BaseUtil;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.MapWithDefaults;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SimpleMenuBar
extends BaseTransformation {
    public static final String DEFAULT_LOOK = "Default_Look";
    public static final String BANNER_GLOBALMENU_LOOK = "Banner_GlobalMenu_Look";
    protected List menuItems = null;
    protected String imageLocation = null;
    private String look = "Default_Look";
    public static final String MENUBAR_CONTAINER_STYLEKEY = "MENUBAR";
    protected static final ImmutableStyleInfo MenuBarContainerStyle = new ImmutableStyleInfo("SimpleMenuBar");
    public static final String MENUBAR_MENUITEM_STYLEKEY = "MENUITEM";
    protected static final ImmutableStyleInfo MenuBarItemStyle = new ImmutableStyleInfo("SimpleMenuBarItem");
    public static final String MENUBAR_MENUITEM_DISABLED_STYLEKEY = "MENUITEM_DISABLED";
    protected static final ImmutableStyleInfo MenuBarItemDisabledStyle = new ImmutableStyleInfo("SimpleMenuBarItemDisabled");
    public static final String MENUBAR_MENUITEM_ICON_STYLEKEY = "MENUITEM_ICON";
    protected static final ImmutableStyleInfo MenuBarItemIconStyle = new ImmutableStyleInfo("SimpleMenuBarIcon");
    public static final String MENUBAR_MENUITEM_HIGHLIGHT_STYLEKEY = "MENUITEM_HIGHLIGHT";
    protected static final ImmutableStyleInfo MenuBarItemHighlightStyle = new ImmutableStyleInfo("SimpleMenuBarItem SimpleMenuBarItemHighlight");
    public static final String MENUBAR_SEPARATOR_STYLEKEY = "SEPARATOR";
    protected static final ImmutableStyleInfo MenuBarSeparatorStyle = new ImmutableStyleInfo("SimpleMenuBarSeparator");
    public static final String MENUBAR_SUBMENU_IMAGE_STYLEKEY = "SUBMENU_INDICATOR";
    protected static final ImmutableStyleInfo MenuBarSubMenuImageStyle = new ImmutableStyleInfo("SimpleMenuBarSubMenuIndicator");
    public static final String MENUBAR_MENUITEM_SELECTED_STYLEKEY = "MENUITEM_SELECTED";
    protected static final ImmutableStyleInfo MenuBarItemSelectedStyle = new ImmutableStyleInfo("SimpleMenuBarItemSelected");
    public static final String MENUBAR_MENUITEM_DISABLED_SELECTED_STYLEKEY = "MENUITEM_DISABLED_SELECTED";
    protected static final ImmutableStyleInfo MenuBarItemDisabledSelectedStyle = new ImmutableStyleInfo("SimpleMenuBarItemDisabled SimpleMenuBarItemSelected");
    public static final String MENUBAR_MENUITEM_SPACER_STYLEKEY = "MENUITEM_SPACER";
    protected static final ImmutableStyleInfo MenuBarItemSpacerStyle = new ImmutableStyleInfo("SimpleMenuBarItemSpacer");
    private Map componentStyleMap;
    protected static final HashMap defaultStyleMap = new HashMap();
    private static final String RB_KEY = "SimpleMenuBar.";

    protected static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0) {
            defaultStyleMap.put(MENUBAR_CONTAINER_STYLEKEY, MenuBarContainerStyle);
            defaultStyleMap.put(MENUBAR_MENUITEM_STYLEKEY, MenuBarItemStyle);
            defaultStyleMap.put(MENUBAR_MENUITEM_DISABLED_STYLEKEY, MenuBarItemDisabledStyle);
            defaultStyleMap.put(MENUBAR_MENUITEM_ICON_STYLEKEY, MenuBarItemIconStyle);
            defaultStyleMap.put(MENUBAR_MENUITEM_HIGHLIGHT_STYLEKEY, MenuBarItemHighlightStyle);
            defaultStyleMap.put(MENUBAR_SEPARATOR_STYLEKEY, MenuBarSeparatorStyle);
            defaultStyleMap.put(MENUBAR_SUBMENU_IMAGE_STYLEKEY, MenuBarSubMenuImageStyle);
            defaultStyleMap.put(MENUBAR_MENUITEM_SPACER_STYLEKEY, MenuBarItemSpacerStyle);
            defaultStyleMap.put(MENUBAR_MENUITEM_SELECTED_STYLEKEY, MenuBarItemSelectedStyle);
            defaultStyleMap.put(MENUBAR_MENUITEM_DISABLED_SELECTED_STYLEKEY, MenuBarItemDisabledSelectedStyle);
        }
    }

    public SimpleMenuBar() {
        this(null);
    }

    public SimpleMenuBar(String id) {
        if (id != null) {
            this.setId(id);
        }
        SimpleMenuBar.setupDefaultStyleMap();
        this.setStyleMap((Map)new MapWithDefaults((Map)defaultStyleMap));
    }

    public void setModel(List menuItems) {
        this.menuItems = menuItems;
    }

    public List getModel() {
        return this.menuItems;
    }

    public String getImageLocation() {
        return this.imageLocation;
    }

    public void setImageLocation(String imageLocation) {
        this.imageLocation = imageLocation;
    }

    public String getLook() {
        return this.look;
    }

    public void setLook(String look) {
        this.look = look;
        if (!look.equalsIgnoreCase(DEFAULT_LOOK)) {
            String styleKey2 = null;
            for (String styleKey2 : defaultStyleMap.keySet()) {
                this.addClassToStyleInfo(styleKey2, ((StyleInfo)defaultStyleMap.get(styleKey2)).getClassid() + "_" + look);
            }
        }
    }

    public Map getStyleMap() {
        return this.componentStyleMap;
    }

    public void setStyleMap(Map styleMap) {
        this.componentStyleMap = styleMap;
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        if (this.getModel() != null) {
            String title = RB.getStringResource(RB_KEY, "skipMenuBar.txt", this.getLocale());
            String skipLinkHref = this.getId() + "_skipMenuBar";
            out.println(BaseUtil.getSkipLinkAnchor(skipLinkHref, title));
            JavaScriptIncludeHandler.writeIncludes(out, "SIMPLEMENUBAR", this.getRequest());
            this.writeJavaScript(out);
            this.writeSubMenus(out);
            out.println(BaseUtil.getSkipLinkAnchorTarget(skipLinkHref));
        }
    }

    protected void writeJavaScript(PrintWriter out) {
        StringBuffer sb = new StringBuffer();
        sb.append(JavaScriptIncludeHandler.getStartScript());
        sb.append(this.getId()).append(" = new sas.menu.SimpleMenuBar('" + this.getId() + "');\n");
        sb.append(this.getId()).append(".setModel(").append(this.getModelAsJSON(false)).append(");\n");
        sb.append(this.getId()).append(".setStyles(").append(this.getStyleMapAsJSON(false)).append(");\n");
        if (this.getLook() != DEFAULT_LOOK) {
            sb.append(this.getId()).append(".setLook('").append(this.getLook()).append("');\n");
        }
        sb.append(this.getId()).append(".render();\n");
        sb.append(JavaScriptIncludeHandler.getEndScript(null));
        out.println(sb.toString());
    }

    protected void writeSubMenus(PrintWriter out) {
        Object o = null;
        MenuBarItemInterface menuItem = null;
        PopupMenu pmenu = null;
        int index = -1;
        Iterator iter = this.getModel().iterator();
        while (iter.hasNext()) {
            ++index;
            o = iter.next();
            if (!(o instanceof MenuBarItemInterface) || (menuItem = (MenuBarItemInterface)o).getSubMenu() == null) continue;
            pmenu = new PopupMenu(this.getId() + "_" + index + "_SubMenu");
            pmenu.setImageLocation(this.getImageLocation());
            pmenu.setRequest(this.getRequest());
            pmenu.setResponse(this.getResponse());
            pmenu.setModel(menuItem.getSubMenu());
            if (!menuItem.isDisabled()) {
                pmenu.attachTo(this.getId() + "_" + index + "_anchor", null, "onclick");
            }
            pmenu.setPositionRelativeTo(this.getId() + "_" + index + "_anchor");
            try {
                pmenu.write(out);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String getStyleMapAsJSON(boolean format) {
        JSONObject jsonStyleMap = new JSONObject();
        try {
            jsonStyleMap.put(MENUBAR_CONTAINER_STYLEKEY, (Object)this.styleInfoToString(MENUBAR_CONTAINER_STYLEKEY));
            jsonStyleMap.put(MENUBAR_MENUITEM_STYLEKEY, (Object)this.styleInfoToString(MENUBAR_MENUITEM_STYLEKEY));
            jsonStyleMap.put(MENUBAR_MENUITEM_DISABLED_STYLEKEY, (Object)this.styleInfoToString(MENUBAR_MENUITEM_DISABLED_STYLEKEY));
            jsonStyleMap.put(MENUBAR_MENUITEM_ICON_STYLEKEY, (Object)this.styleInfoToString(MENUBAR_MENUITEM_ICON_STYLEKEY));
            jsonStyleMap.put(MENUBAR_MENUITEM_HIGHLIGHT_STYLEKEY, (Object)((StyleInfo)this.getStyleMap().get(MENUBAR_MENUITEM_HIGHLIGHT_STYLEKEY)).getClassid());
            jsonStyleMap.put(MENUBAR_SEPARATOR_STYLEKEY, (Object)this.styleInfoToString(MENUBAR_SEPARATOR_STYLEKEY));
            jsonStyleMap.put(MENUBAR_SUBMENU_IMAGE_STYLEKEY, (Object)this.styleInfoToString(MENUBAR_SUBMENU_IMAGE_STYLEKEY));
            jsonStyleMap.put(MENUBAR_MENUITEM_SPACER_STYLEKEY, (Object)this.styleInfoToString(MENUBAR_MENUITEM_SPACER_STYLEKEY));
            jsonStyleMap.put(MENUBAR_MENUITEM_SELECTED_STYLEKEY, (Object)this.styleInfoToString(MENUBAR_MENUITEM_SELECTED_STYLEKEY));
            jsonStyleMap.put(MENUBAR_MENUITEM_DISABLED_SELECTED_STYLEKEY, (Object)this.styleInfoToString(MENUBAR_MENUITEM_DISABLED_SELECTED_STYLEKEY));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (!format) {
            return jsonStyleMap.toString();
        }
        String jsonString = null;
        try {
            jsonString = jsonStyleMap.toString(3);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonString;
    }

    private String getModelAsJSON(boolean format) {
        ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(this.getRequest());
        JSONObject jsonMenu = new JSONObject();
        try {
            jsonMenu.put("id", (Object)this.getId());
            if (this.getImageLocation() != null) {
                jsonMenu.put("imageLocation", (Object)this.getImageLocation());
            }
            jsonMenu.put("stockImageLocation", (Object)cpm.getImageLocation());
            JSONObject jsonMenuImages = new JSONObject();
            jsonMenuImages.put("menuDownArrow", (Object)cpm.getImageName("Menu_Down_Arrow", this.imageLocation));
            jsonMenuImages.put("menuDownArrowDisabled", (Object)cpm.getImageName("Menu_Down_Arrow_Disabled", this.imageLocation));
            jsonMenuImages.put("menuDownArrow_White", (Object)cpm.getImageName("Menu_Down_Arrow_Banner", this.imageLocation));
            jsonMenuImages.put("spacer", (Object)cpm.getImageName("Spacer", this.imageLocation));
            jsonMenu.put("images", (Object)jsonMenuImages);
            JSONArray jsonMenuItems = this.convertMenuItemsToJSON(this.menuItems);
            if (jsonMenuItems.length() > 0) {
                jsonMenu.put("items", (Object)jsonMenuItems);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (!format) {
            return jsonMenu.toString();
        }
        String jsonString = null;
        try {
            jsonString = jsonMenu.toString(3);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonString;
    }

    private JSONArray convertMenuItemsToJSON(List menuItemsToConvert) {
        JSONArray jsonMenuItems = new JSONArray();
        if (menuItemsToConvert == null || menuItemsToConvert.size() == 0) {
            return jsonMenuItems;
        }
        JSONObject jsonMenuItem = null;
        Object o2 = null;
        MenuBarItemInterface menuItem = null;
        for (Object o2 : menuItemsToConvert) {
            if (!(o2 instanceof MenuBarItemInterface)) continue;
            menuItem = o2;
            try {
                jsonMenuItem = new JSONObject();
                if (menuItem.isSeparator()) {
                    jsonMenuItem.put("separator", true);
                } else {
                    if (this.isValidProperty(menuItem.getId())) {
                        jsonMenuItem.put("id", (Object)menuItem.getId());
                    }
                    jsonMenuItem.put("text", (Object)menuItem.getText());
                    if (this.isValidProperty(menuItem.getImage())) {
                        jsonMenuItem.put("image", (Object)menuItem.getImage());
                        if (this.isValidProperty(menuItem.getAlternateText())) {
                            jsonMenuItem.put("alttext", (Object)menuItem.getAlternateText());
                        }
                    }
                    if (this.isValidProperty(menuItem.getTitle())) {
                        jsonMenuItem.put("title", (Object)menuItem.getTitle());
                    }
                    if (menuItem.getDisabledImage() != null) {
                        jsonMenuItem.put("disabledImage", (Object)menuItem.getDisabledImage());
                    }
                    if (menuItem.isDisabled()) {
                        jsonMenuItem.put("disabled", (Object)"true");
                    }
                    if (menuItem.isSelected()) {
                        jsonMenuItem.put("selected", (Object)"true");
                    }
                    if (this.isValidProperty(menuItem.getUrl())) {
                        jsonMenuItem.put("url", (Object)menuItem.getUrl());
                    } else if (this.isValidProperty(menuItem.getJavascript())) {
                        jsonMenuItem.put("javascript", (Object)menuItem.getJavascript());
                    } else if (menuItem.getSubMenu() != null) {
                        jsonMenuItem.put("submenu", (Object)"true");
                    }
                }
                jsonMenuItems.put((Object)jsonMenuItem);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return jsonMenuItems;
    }

    private boolean isValidProperty(String property) {
        return property != null && !"".equals(property);
    }

    private void displayModelInConsole() {
        System.out.println(this.getModelAsJSON(true));
    }

    private String styleInfoToString(String styleKey) {
        return ((StyleInfo)this.getStyleMap().get(styleKey)).write(new StringBuffer(), null).toString();
    }

    private StyleInfo addClassToStyleInfo(String styleInfoKey, String styleClass) {
        StyleInfo currentStyleInfo = (StyleInfo)this.getStyleMap().get(styleInfoKey);
        StyleInfo modifiedStyleInfo = null;
        modifiedStyleInfo = currentStyleInfo != null ? new StyleInfo(currentStyleInfo.getClassid() + " " + styleClass, currentStyleInfo.getStyle()) : new StyleInfo(styleClass, currentStyleInfo.getStyle());
        this.getStyleMap().put(styleInfoKey, modifiedStyleInfo);
        return modifiedStyleInfo;
    }

    static {
        JavaScriptIncludeHandler.addAlias(SimpleMenuBar.class, "SIMPLEMENUBAR");
    }
}

