/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.menubar.html;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.menubar.html.BaseHTMLMenuBar;
import com.sas.servlet.tbeans.menubar.html.Menu;
import com.sas.servlet.tbeans.menubar.html.SelectorMenuItem;
import com.sas.util.Util;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;

@SASScope(value="ALL")
public class SelectorMenuBar
extends BaseHTMLMenuBar {
    public SelectorMenuBar() {
        this.setId(Util.getName((String)"mb"));
        this.setMenuType(3);
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        if (this.getMenus() == null) {
            return;
        }
        this.assignId();
        this.disablePopupMenuIndicators();
        this.writeHeader(out);
        this.writeMenu(out);
        this.writeFooter(out);
        this.writeSelectorMenuItems(out);
        this.writeMenuItems(out);
        this.cleanUpResources();
    }

    protected void disablePopupMenuIndicators() {
        ArrayList menus = this.getMenus();
        for (int j = 0; j < menus.size(); ++j) {
            Menu menu = (Menu)menus.get(j);
            menu.setPopupMenuIndicatorVisible(false);
        }
    }

    @SASScope
    protected void writeSelectorMenuItems(PrintWriter out) throws IOException {
        int i = 1;
        ArrayList menus = this.getMenus();
        for (int j = 0; j < menus.size(); ++j) {
            Menu menu = (Menu)menus.get(j);
            if (menu.getMenuType() == 3) {
                menu.setMenuBar(this);
                SelectorMenuItem menuItem = (SelectorMenuItem)menu.getSelectorMenuItem();
                menuItem.setRequest(this.getRequest());
                menuItem.setResponse(this.getResponse());
                menuItem.setLocale(this.getLocale());
                if (menuItem == null && menu.count() > 0 && menu.getMenuItems().get(0) instanceof SelectorMenuItem) {
                    menuItem = (SelectorMenuItem)menu.getMenuItems().get(0);
                }
                if (menuItem != null) {
                    menuItem.setMenu(menu);
                    menuItem.write(out);
                }
            }
            ++i;
        }
    }
}

