/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.menubar.html;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.ComplexStyleInterface;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.TemplateSupport;
import com.sas.servlet.tbeans.html.Button;
import com.sas.servlet.tbeans.html.HTMLConstantsInterface;
import com.sas.servlet.tbeans.menubar.BaseMenuItem;
import com.sas.servlet.tbeans.menubar.html.HtmlUtilMenu;
import com.sas.servlet.tbeans.menubar.html.Menu;
import com.sas.servlet.tbeans.menubar.html.MenuBarStyleAreaKeysInterface;
import com.sas.util.MapWithDefaults;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@SASScope(value="ALL")
public class MenuItem
extends BaseMenuItem
implements MenuBarStyleAreaKeysInterface,
ComplexStyleInterface,
HTMLConstantsInterface {
    private static final ImmutableStyleInfo MenuItemStyle = new ImmutableStyleInfo("menuItem");
    private static final ImmutableStyleInfo MenuItemDisabledStyle = new ImmutableStyleInfo("menuItemDisabled");
    private static final ImmutableStyleInfo MenuItemLinkStyle = new ImmutableStyleInfo("menuItemLink");
    private static final ImmutableStyleInfo MenuItemLinkDisabledStyle = new ImmutableStyleInfo("menuItemLinkDisabled");
    private static final ImmutableStyleInfo MenuItemContainerStyle = new ImmutableStyleInfo("menuItemContainer");
    private static final ImmutableStyleInfo MenuItemDividerStyle = new ImmutableStyleInfo("menuItemDivider");
    private static final ImmutableStyleInfo MenuItemArrowStyle = new ImmutableStyleInfo("menuItemArrow");
    private Map componentStyleMap;
    private static final HashMap defaultStyleMap = new HashMap();

    private static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0) {
            defaultStyleMap.put("MENU_ITEM", MenuItemStyle);
            defaultStyleMap.put("MENU_ITEM_DISABLED", MenuItemDisabledStyle);
            defaultStyleMap.put("MENU_ITEM_LINK", MenuItemLinkStyle);
            defaultStyleMap.put("MENU_ITEM_LINK_DISABLED", MenuItemLinkDisabledStyle);
            defaultStyleMap.put("MENU_ITEM_CONTAINER", MenuItemContainerStyle);
            defaultStyleMap.put("MENU_ITEM_DIVIDER", MenuItemDividerStyle);
            defaultStyleMap.put("MENU_ITEM_ARROW", MenuItemArrowStyle);
        }
    }

    public MenuItem() {
        this(null, null, null);
    }

    public MenuItem(String label, String image, String url) {
        this.setLabel(label);
        this.setImage(image);
        this.setURL(url);
        this.setWrap(false);
        this.setEnabled(true);
        this.setStyleClassPrefix("");
        this.setSelected(false);
        this.setTabIndex(-1);
        this.submenu = false;
        this.setDefaultURLSuppressed(false);
        this.setImagePosition(512);
    }

    public MenuItem(String label, String image) {
        this(label, image, null);
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        out.println("<tr>");
        if (!this.isSimpleMenu()) {
            out.println("   <td>");
        }
        if (this.getTemplate() != null || this.getTemplateFileName() != null || this.getTemplateKey() != null) {
            if (this.getTemplateDictionary() == null) {
                this.setTemplateDictionary(this.getDefaultTemplateDictionary());
            }
            TemplateSupport.writeTemplate(this, null, out);
            out.println();
        } else {
            String menuItemStyleClass = this.getMenuItemStyleClass();
            if (this.isDivider()) {
                if (this.getMenu() != null && this.getMenu().hasSubMenus()) {
                    HtmlUtilMenu.writeDivider(out, this.getMenu().getDividerImage(), this.getStyleClassPrefix(), this.getStyleMap(), null, this.isEnabled(), "2");
                } else {
                    HtmlUtilMenu.writeDivider(out, this.getMenu().getDividerImage(), this.getStyleClassPrefix(), this.getStyleMap(), null, this.isEnabled());
                }
                out.println();
            } else if (this.isSimpleMenu()) {
                HtmlUtilMenu.writeItem(out, this, this.getDefaultComponentStyleMap(), this.getCurrentURL(), true);
            } else {
                Button button = new Button();
                button.setButtonType(4);
                button.setRequest(this.getRequest());
                button.setResponse(this.getResponse());
                button.setLocale(this.getLocale());
                button = (Button)this.setButtonProperties(button);
                button.setId(this.getId());
                button.setURL(this.getCurrentURL());
                button.setImage(this.getImage());
                button.setImageKey(this.getImageKey());
                button.setImageLocation(this.getImageLocation());
                button.setDisabledImage(this.getDisabledImage());
                button.setDisabledImageKey(this.getDisabledImageKey());
                button.setLabel(this.getLabel());
                Map styleMap = button.getStyleMap();
                styleMap.put("BUTTON_CENTER", new StyleInfo(menuItemStyleClass));
                button.write(out);
            }
        }
        if (!this.isSimpleMenu()) {
            out.println("   </td>");
        }
        out.println("</tr>");
        this.cleanUpResources();
    }

    @SASScope
    protected HashMap getDefaultTemplateDictionary() {
        HashMap<String, Object> dictionary = new HashMap<String, Object>();
        String label = this.getLabel();
        dictionary.put("LABEL", label);
        dictionary.put("URL", this.getCurrentURL());
        dictionary.put("IMAGE", this.getImage());
        dictionary.put("IMAGE_LOCATION", this.getImageLocation());
        dictionary.put("DISABLEDIMAGE", this.getDisabledImage());
        dictionary.put("ALTERNATETEXT", this.getAlternateText());
        dictionary.put("TITLE", this.getTitle());
        dictionary.put("TARGET", this.getTarget());
        dictionary.put("ACCESSKEY", this.getAccessKey());
        dictionary.put("TABINDEX", new Integer(this.getTabIndex()));
        Map styleMap = this.getStyleMap();
        Set set = styleMap.keySet();
        for (String key : set) {
            StyleInfo styleinfo = (StyleInfo)styleMap.get(key);
            dictionary.put(key, styleinfo.getClassid());
        }
        StringBuffer custom = new StringBuffer();
        if (this.submenu) {
            custom.append("onmouseover=\"MenuBar_showPop('").append(this.getId()).append("_sub','").append(this.getId()).append("',false,true,event);\"");
        } else {
            custom.append("onmouseover=\"MenuBar_showPop('").append(this.getId()).append("_sub','").append(this.getId()).append("',false,true,event);\"");
            custom.append("onkeydown=\"sas_MenuBar_navigateMenu(event,'");
            if (this.getPreviousMenuItem() != null) {
                custom.append(this.getPreviousMenuItem().getId());
            }
            custom.append("','");
            if (this.getNextMenuItem() != null) {
                custom.append(this.getNextMenuItem().getId());
            }
            custom.append("','");
            if (this.getPreviousMenu() != null) {
                custom.append(this.getPreviousMenu().getId());
            }
            custom.append("','");
            if (this.getNextMenu() != null) {
                custom.append(this.getNextMenu().getId());
            }
            custom.append("','')\"");
        }
        custom.append("id=").append(this.getId());
        dictionary.put("ACTION", custom.toString());
        return dictionary;
    }

    private boolean isAnchorNeeded() {
        if (!this.isEnabled()) {
            return false;
        }
        return this.getTabIndex() > 0 || this.getAccessKey() != null || this.getURL() != null || this.getOnClick() != null || this.getOnKeyDown() != null;
    }

    @SASScope
    protected String getMenuItemStyleClass() {
        StringBuffer style = new StringBuffer();
        style.append(this.getStyleClassPrefix());
        if (!this.isEnabled()) {
            if (this.getURL() == null) {
                style.append(this.getStyle("MENU_ITEM_DISABLED").getClassid());
            } else {
                style.append(this.getStyle("MENU_ITEM_LINK_DISABLED").getClassid());
            }
            return style.toString();
        }
        if (this.getURL() == null) {
            style.append(this.getStyle("MENU_ITEM").getClassid());
        } else {
            style.append(this.getStyle("MENU_ITEM_LINK").getClassid());
        }
        return style.toString();
    }

    @Override
    public Map getStyleMap() {
        if (this.componentStyleMap == null) {
            MenuItem.setupDefaultStyleMap();
            this.componentStyleMap = new MapWithDefaults((Map)defaultStyleMap);
        }
        return this.componentStyleMap;
    }

    public void setStyleMap(Map styleMap) {
        this.componentStyleMap = styleMap;
    }

    private Map getDefaultComponentStyleMap() {
        if (this.componentStyleMap == null && this.getMenu() != null && this.getMenu().getMenuBar() != null) {
            this.componentStyleMap = new MapWithDefaults(((Menu)this.getMenu()).getStyleMap());
        }
        return this.componentStyleMap;
    }

    @SASScope
    public StyleInfo getStyle(String value) {
        Map defaultMap = this.getDefaultComponentStyleMap();
        if (defaultMap.get(value) != null) {
            return (StyleInfo)defaultMap.get(value);
        }
        MenuItem.setupDefaultStyleMap();
        return (StyleInfo)defaultStyleMap.get(value);
    }
}

