/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.menubar.html;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.menubar.BaseMenuItem;
import com.sas.servlet.tbeans.menubar.html.BaseHTMLMenuBar;
import com.sas.servlet.tbeans.menubar.html.Menu;
import com.sas.servlet.tbeans.menubar.html.MenuItem;
import com.sas.servlet.tbeans.models.MenuBarNodeInterface;
import com.sas.servlet.tbeans.models.MenuItemNode;
import com.sas.servlet.tbeans.models.MenuItemNodeInterface;
import com.sas.servlet.tbeans.models.MenuNode;
import com.sas.util.Util;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.PrintWriter;

@SASScope(value="ALL")
public class MenuBar
extends BaseHTMLMenuBar {
    public MenuBar() {
        this(Util.getName((String)"mb"), null);
    }

    public MenuBar(String name) {
        this(name, null);
    }

    public MenuBar(String name, HttpServletRequest request) {
        this.setId(name);
        this.setRequest(request);
        this.setMenuType(2);
    }

    public MenuBar(HttpServletRequest request) {
        this(Util.getName((String)"mb"), request);
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        MenuBarNodeInterface model = this.getModel();
        if (model != null && model.getChildCount() > 0) {
            this.processModel();
        }
        if (this.getMenus() == null) {
            return;
        }
        this.assignId();
        this.writeHeader(out);
        this.writeMenu(out);
        this.writeFooter(out);
        if (this.getMenuType() == 1 || this.getMenuType() == 5) {
            this.writeMenuItems(out);
        }
        this.cleanUpResources();
    }

    @SASScope
    protected Menu processSubMenuNode(Menu menu, MenuNode mnode) {
        for (int i = 0; i < mnode.getChildCount(); ++i) {
            if (mnode.getChildAt(i) instanceof MenuNode) {
                Menu newMenu = new Menu();
                newMenu.setRequest(this.getRequest());
                newMenu.setResponse(this.getResponse());
                newMenu.setLocale(this.getLocale());
                MenuNode menuNode = (MenuNode)mnode.getChildAt(i);
                newMenu = this.processSubMenuNode(newMenu, menuNode);
                newMenu.setLabel(menuNode.getLabel());
                menu.add(newMenu);
                continue;
            }
            if (!(mnode.getChildAt(i) instanceof MenuItemNode)) continue;
            MenuItemNode menuItemNode = (MenuItemNode)mnode.getChildAt(i);
            MenuItem newMenuItem = new MenuItem();
            newMenuItem.setRequest(this.getRequest());
            newMenuItem.setResponse(this.getResponse());
            newMenuItem.setLocale(this.getLocale());
            newMenuItem = (MenuItem)this.processNodeProperties(newMenuItem, menuItemNode);
            menu.add(newMenuItem);
        }
        return menu;
    }

    @SASScope
    protected void processModel() {
        MenuBarNodeInterface root = this.getModel();
        if (root == null) {
            return;
        }
        if (this.getMenus() != null) {
            this.getMenus().clear();
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            MenuNode menuNode = (MenuNode)root.getChildAt(i);
            Menu newMenu = new Menu();
            newMenu = (Menu)this.processNodeProperties(newMenu, menuNode);
            newMenu.setMenuBar(this);
            if (menuNode.getChildCount() > 0) {
                for (int j = 0; j < menuNode.getChildCount(); ++j) {
                    if (menuNode.getChildAt(j) instanceof MenuNode) {
                        MenuNode subMenuNode = (MenuNode)menuNode.getChildAt(j);
                        Menu newSubMenu = new Menu();
                        newSubMenu.setRequest(this.getRequest());
                        newSubMenu.setResponse(this.getResponse());
                        newSubMenu.setLocale(this.getLocale());
                        newSubMenu.setLabel(subMenuNode.getLabel());
                        newSubMenu = this.processSubMenuNode(newSubMenu, subMenuNode);
                        newMenu.add(newSubMenu);
                        continue;
                    }
                    if (!(menuNode.getChildAt(j) instanceof MenuItemNode)) continue;
                    MenuItemNode menuItemNode = (MenuItemNode)menuNode.getChildAt(j);
                    MenuItem newMenuItem = new MenuItem();
                    newMenuItem.setRequest(this.getRequest());
                    newMenuItem.setResponse(this.getResponse());
                    newMenuItem.setLocale(this.getLocale());
                    newMenuItem = (MenuItem)this.processNodeProperties(newMenuItem, menuItemNode);
                    newMenuItem.setMenu(newMenu);
                    newMenu.add(newMenuItem);
                }
            }
            this.add(newMenu);
        }
    }

    private BaseMenuItem processNodeProperties(BaseMenuItem menuitem, MenuItemNodeInterface node) {
        menuitem.setLabel(node.getLabel());
        menuitem.setURL(node.getURL());
        menuitem.setTarget(node.getTarget());
        menuitem.setImage(node.getImage());
        menuitem.setDisabledImage(node.getDisabledImage());
        menuitem.setAlternateText(node.getAlternateText());
        menuitem.setEnabled(node.isEnabled());
        menuitem.setStyleClassPrefix(node.getStyleClassPrefix());
        menuitem.setWrap(node.isWrapped());
        menuitem.setTitle(node.getTitle());
        menuitem.setTabIndex(node.getTabIndex());
        menuitem.setAccessKey(node.getAccessKey());
        menuitem.setHeight(node.getHeight());
        menuitem.setHeightPercentage(node.getHeightPercentage());
        menuitem.setWidth(node.getWidth());
        menuitem.setWidthPercentage(node.getWidthPercentage());
        if (node.getImagePosition() == 1) {
            menuitem.setImagePosition(4096);
        } else if (node.getImagePosition() == 2) {
            menuitem.setImagePosition(512);
        } else if (node.getImagePosition() > 0) {
            menuitem.setImagePosition(node.getImagePosition());
        }
        menuitem.setOnClick(node.getOnClick());
        menuitem.setOnFocus(node.getOnFocus());
        return menuitem;
    }
}

