/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.itemlistmanager;

import com.sas.models.itemlistmanager.ILMTreeToTableModelAdapter;
import com.sas.models.itemlistmanager.tree.ILMTreeInterface;
import com.sas.models.itemlistmanager.tree.ILMTreeNode;
import com.sas.servlet.tbeans.BaseActionTransformation2;
import com.sas.servlet.tbeans.BaseButton;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.itemlistmanager.AbstractItemListManager;
import com.sas.servlet.tbeans.itemlistmanager.TreeItemListManagerKeysInterface;
import com.sas.servlet.tbeans.models.JavaScriptNode;
import com.sas.servlet.tbeans.tableview.html.CellContentsChoiceBoxEditor;
import com.sas.servlet.tbeans.tableview.html.DefaultTableCellEditor;
import com.sas.servlet.tbeans.tableview.html.TableView;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.swing.visuals.itemlistmanager.RB;
import com.sas.swing.visuals.tableview.TableViewUtil;
import com.sas.util.Util;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.Dimension;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.table.TableModel;

public class TreeItemListManager
extends AbstractItemListManager
implements TreeItemListManagerKeysInterface {
    public static final String RB_KEY = "TreeItemListManager.";
    public static Object BUTTON_GROUP;
    public static Object BUTTON_UNGROUP;
    public static Object BUTTON_UNGROUP_ALL;
    protected BaseButton groupButton;
    protected BaseButton unGroupButton;
    protected BaseButton unGroupAllButton;
    protected ILMTreeInterface treeModel;
    protected ILMTreeToTableModelAdapter adapter;

    public TreeItemListManager() {
        this(null);
    }

    public TreeItemListManager(ILMTreeInterface model) {
        this.setModel(model);
    }

    @Override
    protected void createComponents() {
        super.createComponents();
        this.groupButton = this.createBaseButton();
        this.groupButton.setId(this.getId() + "_Group");
        this.unGroupButton = this.createBaseButton();
        this.unGroupButton.setId(this.getId() + "_UnGroup");
        this.unGroupAllButton = this.createBaseButton();
        this.unGroupAllButton.setId(this.getId() + "_UnGroupAll");
        this.setComponent("TREEITEMLISTMANAGER_GROUP_BUTTON", this.groupButton);
        this.setComponent("TREEITEMLISTMANAGER_UNGROUP_BUTTON", this.unGroupButton);
        this.setComponent("TREEITEMLISTMANAGER_UNGROUP_ALL_BUTTON", this.unGroupAllButton);
    }

    @Override
    protected void addPredefinedButtons() {
        super.addPredefinedButtons();
        this.addButton(this.getPredefinedButton(BUTTON_GROUP), 1, 0);
        this.addButton(this.getPredefinedButton(BUTTON_UNGROUP), 1, 1);
        this.addButton(this.getPredefinedButton(BUTTON_UNGROUP_ALL), 1, 2);
        this.addButton(this.getPredefinedButton(BUTTON_DIVIDER), 1, 3);
        this.removeButton(this.getPredefinedButton(BUTTON_MOVE_UP));
        this.removeButton(this.getPredefinedButton(BUTTON_MOVE_DOWN));
        this.addButton(this.getPredefinedButton(BUTTON_MOVE_UP), 1, 4);
        this.addButton(this.getPredefinedButton(BUTTON_MOVE_DOWN), 1, 5);
    }

    @Override
    public Object getPredefinedButton(Object button) {
        if (button == BUTTON_GROUP) {
            return this.groupButton;
        }
        if (button == BUTTON_UNGROUP) {
            return this.unGroupButton;
        }
        if (button == BUTTON_UNGROUP_ALL) {
            return this.unGroupAllButton;
        }
        return super.getPredefinedButton(button);
    }

    @Override
    protected void setLocaleDependentProperties(Locale locale) {
        this.setLocaleDependentProperties(BUTTON_GROUP, locale);
        this.setLocaleDependentProperties(BUTTON_UNGROUP, locale);
        this.setLocaleDependentProperties(BUTTON_UNGROUP_ALL, locale);
        super.setLocaleDependentProperties(locale);
    }

    @Override
    protected String getButtonTitle(Object button, Locale locale) {
        if (button == BUTTON_GROUP) {
            return RB.getStringResource((String)"TreeItemListManagerPanel.", (String)"groupToolTip.txt", (Locale)locale);
        }
        if (button == BUTTON_UNGROUP) {
            return RB.getStringResource((String)"TreeItemListManagerPanel.", (String)"ungroupToolTip.txt", (Locale)locale);
        }
        if (button == BUTTON_UNGROUP_ALL) {
            return RB.getStringResource((String)"TreeItemListManagerPanel.", (String)"ungroupAllToolTip.txt", (Locale)locale);
        }
        return super.getButtonTitle(button, locale);
    }

    @Override
    protected String getButtonImage(Object button, Locale locale) {
        return super.getButtonImage(button, locale);
    }

    @Override
    protected String getButtonImageKey(Object button) {
        if (button == BUTTON_GROUP) {
            return "Group";
        }
        if (button == BUTTON_UNGROUP) {
            return "Ungroup";
        }
        if (button == BUTTON_UNGROUP_ALL) {
            return "Ungroup_All";
        }
        return super.getButtonImageKey(button);
    }

    @Override
    protected String getButtonDisabledImage(Object button, Locale locale) {
        return super.getButtonDisabledImage(button, locale);
    }

    @Override
    protected String getButtonDisabledImageKey(Object button) {
        if (button == BUTTON_GROUP) {
            return "Group_Disabled";
        }
        if (button == BUTTON_UNGROUP) {
            return "Ungroup_Disabled";
        }
        if (button == BUTTON_UNGROUP_ALL) {
            return "Ungroup_All_Disabled";
        }
        return super.getButtonDisabledImageKey(button);
    }

    public ILMTreeNode getTreeNode(int index) {
        return this.adapter.getTreeNodeFromRowIndex(index);
    }

    public ILMTreeNode getSelectedRow() {
        int[] rows = this.getSelectedRowIndices();
        if (rows.length > 0) {
            int row = rows[0];
            return this.adapter.getTreeNodeFromRowIndex(row);
        }
        return null;
    }

    public List getSelectedRows() {
        int[] rows = this.getSelectedRowIndices();
        ArrayList<ILMTreeNode> list = new ArrayList<ILMTreeNode>(rows.length);
        for (int i = 0; i < rows.length; ++i) {
            ILMTreeNode node = this.adapter.getTreeNodeFromRowIndex(rows[i]);
            if (node == null) continue;
            list.add(node);
        }
        return list;
    }

    public void setSelectedRow(ILMTreeNode node) {
        int row = this.adapter.getRowIndexFromTreeNode(node);
        if (row == -1) {
            return;
        }
        this.setRowSelectionInterval(row, row);
    }

    public void setSelectedRows(List selectedRows) {
        this.clearSelectedRows();
        for (int i = 0; i < selectedRows.size(); ++i) {
            ILMTreeNode node = (ILMTreeNode)selectedRows.get(i);
            int row = this.adapter.getRowIndexFromTreeNode(node);
            if (row == -1) continue;
            this.addRowSelectionInterval(row, row);
        }
    }

    @Override
    protected String getButtonJavascriptFunction(Object predefinedButton) {
        String function = null;
        function = predefinedButton == BUTTON_GROUP ? "group" : (predefinedButton == BUTTON_UNGROUP ? "ungroup" : (predefinedButton == BUTTON_UNGROUP_ALL ? "ungroupAll" : super.getButtonJavascriptFunction(predefinedButton)));
        return function;
    }

    @Override
    public Object getModel() {
        return this.treeModel;
    }

    public void setModel(ILMTreeInterface model) {
        if (this.treeModel != model) {
            this.treeModel = model;
            this.adapter = new ILMTreeToTableModelAdapter(model);
            TransformationInterface o = this.getComponent("ITEMLISTMANAGER_TABLE");
            if (o != null && o instanceof TableView) {
                ((TableView)o).setModel((TableModel)this.adapter);
                this.createEditors();
            }
        }
    }

    protected void createEditors() {
        if (this.treeModel != null) {
            Map logicalConditionObjectMap = this.createObjectMap(this.treeModel.getLogicalConditionList());
            DefaultComboBoxModel logicalConditionComboBoxModel = this.populateComboBoxModel(logicalConditionObjectMap);
            CellContentsChoiceBoxEditor logicConditionChoiceBoxEditor = new CellContentsChoiceBoxEditor();
            logicConditionChoiceBoxEditor.setInputTransform(new ObjectMapInputTransform(logicalConditionObjectMap));
            logicConditionChoiceBoxEditor.setOutputTransform(new ObjectMapOutputTransform(logicalConditionObjectMap));
            logicConditionChoiceBoxEditor.setModel(logicalConditionComboBoxModel);
            this.setCellEditor("Condition", new DefaultTableCellEditor(logicConditionChoiceBoxEditor));
        }
    }

    private Map createObjectMap(List objectList) {
        LinkedHashMap map = new LinkedHashMap();
        for (Object value : objectList) {
            String id = String.valueOf(Util.getNumber());
            map.put(id, value);
        }
        return map;
    }

    private DefaultComboBoxModel populateComboBoxModel(Map values) {
        DefaultComboBoxModel<JavaScriptNode> comboBoxModel = new DefaultComboBoxModel<JavaScriptNode>();
        if (values != null) {
            for (Map.Entry entry : values.entrySet()) {
                String uniqueID = (String)entry.getKey();
                Object value = entry.getValue();
                JavaScriptNode node = new JavaScriptNode();
                node.setValue(uniqueID);
                String displayText = value != null ? value.toString() : "";
                node.setText(displayText);
                comboBoxModel.addElement(node);
            }
        }
        return comboBoxModel;
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        this.groupButton.setOnClick(this.getButtonOnClick(BUTTON_GROUP));
        this.unGroupButton.setOnClick(this.getButtonOnClick(BUTTON_UNGROUP));
        this.unGroupAllButton.setOnClick(this.getButtonOnClick(BUTTON_UNGROUP_ALL));
        super.write(out);
    }

    @Override
    protected void writeJavaScriptIncludes(PrintWriter out) throws IOException {
        super.writeJavaScriptIncludes(out);
        JavaScriptIncludeHandler.writeIncludes(out, "TREEITEMLISTMANAGER", this.getRequest());
    }

    @Override
    protected void writeConstructorJavaScript(PrintWriter out) {
        BaseActionTransformation2 tableView = (BaseActionTransformation2)this.getComponent("ITEMLISTMANAGER_TABLE");
        out.println("var " + this.getId() + " = new sas_TreeItemListManager('" + this.getId() + "', '" + tableView.getContainerId() + "');");
    }

    public static void ajax_GroupSelectedRows(HttpServletRequest request, HttpServletResponse response) {
        if (request == null || response == null) {
            return;
        }
        AbstractItemListManager obj = TreeItemListManager.getItemListManager(request);
        if (obj instanceof TreeItemListManager && ((TreeItemListManager)obj).getModel() != null) {
            TreeItemListManager ilm = (TreeItemListManager)obj;
            ILMTreeToTableModelAdapter tableModel = null;
            TransformationInterface tableObj = ilm.getComponent("ITEMLISTMANAGER_TABLE");
            if (tableObj != null && tableObj instanceof TableView) {
                TreeItemListManager.commitUncommittedValues(ilm, request);
                TableView tableView = (TableView)tableObj;
                tableModel = (ILMTreeToTableModelAdapter)tableView.getModel();
                int[] selectedRows = ilm.getSelectedRowIndices();
                Object[] selectedRowGroups = TableViewUtil.getSelectedRowGroups((int[])selectedRows);
                TreeItemListManager.groupSelectedRows(selectedRowGroups, tableModel);
                try {
                    response.setContentType("text/xml");
                    String tableHTML = TreeItemListManager.getTableHTML(request, response, tableView);
                    StringBuffer sb = new StringBuffer();
                    sb.append(JavaScriptIncludeHandler.getStartScript());
                    sb.append(ilm.getTableControllerJavaScript());
                    sb.append(JavaScriptIncludeHandler.getEndScript(null));
                    String script = sb.toString();
                    String xml = TreeItemListManager.writeAJAXResponseXML(new String[]{TreeItemListManager.getTableXML(tableHTML), TreeItemListManager.getButtonState(ilm), script});
                    PrintWriter out = response.getWriter();
                    out.println(xml);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void ajax_UngroupAll(HttpServletRequest request, HttpServletResponse response) {
        TreeItemListManager ilm;
        TableModel tableModel;
        if (request == null || response == null) {
            return;
        }
        AbstractItemListManager obj = TreeItemListManager.getItemListManager(request);
        if (obj instanceof TreeItemListManager && ((TreeItemListManager)obj).getModel() != null && (tableModel = TreeItemListManager.getILMTableModel(ilm = (TreeItemListManager)obj)) instanceof ILMTreeToTableModelAdapter) {
            TreeItemListManager.commitUncommittedValues(ilm, request);
            TreeItemListManager.ungroupAllRows((ILMTreeToTableModelAdapter)tableModel);
            try {
                response.setContentType("text/xml");
                TableView tableView = (TableView)ilm.getComponent("ITEMLISTMANAGER_TABLE");
                String tableHTML = TreeItemListManager.getTableHTML(request, response, tableView);
                StringBuffer sb = new StringBuffer();
                sb.append(JavaScriptIncludeHandler.getStartScript());
                sb.append(ilm.getTableControllerJavaScript());
                sb.append(JavaScriptIncludeHandler.getEndScript(null));
                String script = sb.toString();
                String xml = TreeItemListManager.writeAJAXResponseXML(new String[]{TreeItemListManager.getTableXML(tableHTML), TreeItemListManager.getButtonState(ilm), script});
                PrintWriter out = response.getWriter();
                out.println(xml);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void ajax_UngroupSelectedRows(HttpServletRequest request, HttpServletResponse response) {
        TreeItemListManager ilm;
        TableModel tableModel;
        if (request == null || response == null) {
            return;
        }
        AbstractItemListManager obj = TreeItemListManager.getItemListManager(request);
        if (obj instanceof TreeItemListManager && ((TreeItemListManager)obj).getModel() != null && (tableModel = TreeItemListManager.getILMTableModel(ilm = (TreeItemListManager)obj)) instanceof ILMTreeToTableModelAdapter) {
            TreeItemListManager.commitUncommittedValues(ilm, request);
            int[] selectedRows = ilm.getSelectedRowIndices();
            if (selectedRows.length > 0) {
                int selectedRow = selectedRows[0];
                TreeItemListManager.ungroupSelectedRow(selectedRow, (ILMTreeToTableModelAdapter)tableModel);
                try {
                    response.setContentType("text/xml");
                    TableView tableView = (TableView)ilm.getComponent("ITEMLISTMANAGER_TABLE");
                    String tableHTML = TreeItemListManager.getTableHTML(request, response, tableView);
                    StringBuffer sb = new StringBuffer();
                    sb.append(JavaScriptIncludeHandler.getStartScript());
                    sb.append(ilm.getTableControllerJavaScript());
                    sb.append(JavaScriptIncludeHandler.getEndScript(null));
                    String script = sb.toString();
                    String xml = TreeItemListManager.writeAJAXResponseXML(new String[]{TreeItemListManager.getTableXML(tableHTML), TreeItemListManager.getButtonState(ilm), script});
                    PrintWriter out = response.getWriter();
                    out.println(xml);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected static void groupSelectedRows(Object[] selectedRowGroups, ILMTreeToTableModelAdapter tableModel) {
        if (tableModel == null || selectedRowGroups == null || selectedRowGroups.length == 0) {
            return;
        }
        int startRowIndex = ((Dimension)selectedRowGroups[0]).width;
        int endRowIndex = ((Dimension)selectedRowGroups[0]).height;
        if (selectedRowGroups.length == 2) {
            endRowIndex = ((Dimension)selectedRowGroups[1]).width;
        }
        if (tableModel.canGroupRow(startRowIndex, endRowIndex)) {
            tableModel.groupRow(startRowIndex, endRowIndex);
        }
    }

    protected static void ungroupAllRows(ILMTreeToTableModelAdapter tableModel) {
        if (tableModel != null) {
            tableModel.ungroupAll();
        }
    }

    protected static void ungroupSelectedRow(int selectedRow, ILMTreeToTableModelAdapter tableModelAdapter) {
        tableModelAdapter.ungroupRow(selectedRow);
    }

    public static String getButtonEnabledStateXML(AbstractItemListManager ilm) {
        String buttonsEnabledState = AbstractItemListManager.getButtonEnabledStateXML(ilm);
        boolean isGroupEnabled = false;
        boolean isUnGroupEnabled = false;
        boolean isUnGroupAllEnabled = false;
        if (ilm != null && ilm.getModel() != null) {
            TableView tableView;
            TableModel model;
            int[] selectedRows = ilm.getSelectedRowIndices();
            ILMTreeToTableModelAdapter treeToTableModelAdapter = null;
            TransformationInterface tableObj = ilm.getComponent("ITEMLISTMANAGER_TABLE");
            if (tableObj != null && tableObj instanceof TableView && (model = (tableView = (TableView)tableObj).getModel()) instanceof ILMTreeToTableModelAdapter) {
                treeToTableModelAdapter = (ILMTreeToTableModelAdapter)model;
                Object[] selectedRowGroups = TableViewUtil.getSelectedRowGroups((int[])selectedRows);
                if (selectedRowGroups.length == 1) {
                    int startIndex = ((Dimension)selectedRowGroups[0]).width;
                    int endIndex = ((Dimension)selectedRowGroups[0]).height;
                    if (startIndex != endIndex && treeToTableModelAdapter.canGroupRow(startIndex, endIndex)) {
                        isGroupEnabled = true;
                    }
                } else if (selectedRowGroups.length == 2) {
                    int startIndex1 = ((Dimension)selectedRowGroups[0]).width;
                    int endIndex1 = ((Dimension)selectedRowGroups[0]).height;
                    int startIndex2 = ((Dimension)selectedRowGroups[1]).width;
                    int endIndex2 = ((Dimension)selectedRowGroups[1]).height;
                    if (startIndex1 == endIndex1 && startIndex2 == endIndex2 && treeToTableModelAdapter.canGroupRow(startIndex1, endIndex2)) {
                        isGroupEnabled = true;
                    }
                }
                isUnGroupEnabled = selectedRows.length == 1 && treeToTableModelAdapter.canUngroupRow(selectedRows[0]);
                isUnGroupAllEnabled = treeToTableModelAdapter.isGrouped();
            }
        }
        if (buttonsEnabledState == null) {
            buttonsEnabledState = "";
        }
        buttonsEnabledState = buttonsEnabledState + TreeItemListManager.writeButtonXML("GROUP_Button", Boolean.toString(isGroupEnabled));
        buttonsEnabledState = buttonsEnabledState + TreeItemListManager.writeButtonXML("UNGROUP_Button", Boolean.toString(isUnGroupEnabled));
        buttonsEnabledState = buttonsEnabledState + TreeItemListManager.writeButtonXML("UNGROUP_ALL_Button", Boolean.toString(isUnGroupAllEnabled));
        return buttonsEnabledState;
    }

    static {
        JavaScriptIncludeHandler.addAlias(TreeItemListManager.class, "TREEITEMLISTMANAGER");
        BUTTON_GROUP = new Object();
        BUTTON_UNGROUP = new Object();
        BUTTON_UNGROUP_ALL = new Object();
    }

    class ObjectMapInputTransform
    implements TransformInterface {
        Map map;

        public ObjectMapInputTransform(Map objectMap) {
            this.map = objectMap;
        }

        public Object transform(Object value) throws TransformException {
            Object transformedValue = null;
            Set set = this.map.entrySet();
            for (Map.Entry entry : set) {
                if (!entry.getValue().equals(value)) continue;
                transformedValue = entry.getKey();
                break;
            }
            return transformedValue != null ? transformedValue : value;
        }
    }

    class ObjectMapOutputTransform
    implements TransformInterface {
        Map map;

        public ObjectMapOutputTransform(Map objectMap) {
            this.map = objectMap;
        }

        public Object transform(Object value) throws TransformException {
            Object transformedValue = this.map.get(value);
            return transformedValue != null ? transformedValue : value;
        }
    }
}

