/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.itemlistmanager;

import com.sas.models.itemlistmanager.DataClassificationInterface;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.tableview.TableCellEditor;
import com.sas.servlet.tbeans.tableview.TableCellRenderer;
import com.sas.servlet.tbeans.tableview.html.TableView;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import java.util.Map;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;

public class ItemListManagerTableView
extends TableView {
    protected Map cellEditorMap;
    protected Map cellRendererMap;

    public void setCellEditorClassificationMap(Map map) {
        this.cellEditorMap = map;
    }

    public void setCellRendererClassificationMap(Map map) {
        this.cellRendererMap = map;
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        TableModel model = this.getModel();
        TableCellEditor editor = null;
        if (model instanceof DataClassificationInterface) {
            Object editorObject;
            DataClassificationInterface classificationModel = (DataClassificationInterface)model;
            String classification = classificationModel.getClassification(row - 1, column - 1);
            if (this.cellEditorMap != null && (editorObject = this.cellEditorMap.get(classification)) instanceof TableCellEditor) {
                editor = (TableCellEditor)editorObject;
            }
        }
        if (editor == null) {
            editor = super.getCellEditor(row, column);
        }
        return editor;
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        TableModel model = this.getModel();
        TableCellRenderer renderer = null;
        if (model instanceof DataClassificationInterface) {
            Object rendererObject;
            DataClassificationInterface classificationModel = (DataClassificationInterface)model;
            String classification = classificationModel.getClassification(row - 1, column - 1);
            if (this.cellRendererMap != null && (rendererObject = this.cellRendererMap.get(classification)) instanceof TableCellRenderer) {
                renderer = (TableCellRenderer)rendererObject;
            }
        }
        if (renderer == null) {
            renderer = super.getCellRenderer(row, column);
        }
        return renderer;
    }

    @Override
    public Object transformCommitString(String value, int col, int row) throws TransformException {
        TransformInterface editTransform = null;
        TableCellEditor editor = this.getCellEditor(row + 1, col + 1);
        if (editor != null && editor.getTableCellContentsEditor() instanceof BaseTransformation) {
            BaseTransformation tbean = (BaseTransformation)((Object)editor.getTableCellContentsEditor());
            editTransform = tbean.getOutputTransform();
        }
        Object transformedValue = null;
        try {
            transformedValue = editTransform != null ? editTransform.transform((Object)value) : super.transformCommitString(value, col, row);
        }
        catch (Exception e) {
            transformedValue = value;
        }
        return transformedValue;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e != null && this.getModel() != null) {
            int updatedRow = e.getFirstRow();
            if (e.getFirstRow() == -1 || e.getType() != 0 || e.getType() == 0 && updatedRow != 0) {
                super.tableChanged(e);
            }
        } else {
            super.tableChanged(e);
        }
    }
}

