/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.ipage.iform;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.servlet.tbeans.form.wml.Radio;
import com.sas.servlet.tbeans.ipage.iform.BaseIFormElement;
import com.sas.servlet.tbeans.ipage.iform.IForm;
import com.sas.servlet.util.BaseUtil;
import com.sas.util.Util;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;

@SASScope(value="ALL")
public class IFormRadio
extends BaseIFormElement {
    private ListModel descriptionModel;
    private ListModel model;

    public IFormRadio() {
        this(Util.getName((String)"IFormRadio"), new DefaultListModel());
    }

    public IFormRadio(String name, String prompt) {
        this(name, prompt, new DefaultListModel());
    }

    public IFormRadio(String name, ListModel model) {
        this(name, "", model);
    }

    public IFormRadio(String name, String prompt, ListModel model) {
        this.setName(name);
        this.setPrompt(prompt);
        this.setModel(model);
    }

    public void setModel(ListModel model) {
        this.model = model;
    }

    public ListModel getModel() {
        return this.model;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public void setDescriptionModel(ListModel descriptionModel) {
        this.descriptionModel = descriptionModel;
    }

    @SASScope(value="ALL")
    @SubjectToChange
    public ListModel getDescriptionModel() {
        return this.descriptionModel;
    }

    @Override
    public void writeHeader(PrintWriter out) throws IOException {
        if (this.getBrowserType() == 3) {
            out.write("<choice");
        }
        super.writeHeader(out);
    }

    @Override
    public void writeBase(PrintWriter out) throws IOException {
        super.writeBase(out);
        if (this.getBrowserType() == 1 || this.getBrowserType() == 2) {
            Radio radio = new Radio();
            radio.setName(this.getName());
            radio.setTitle(this.getTitle());
            radio.setModel(this.getModel());
            radio.setRequest(this.getRequest());
            radio.setResponse(this.getResponse());
            radio.setLocale(this.getLocale());
            ListModel descModel = this.getDescriptionModel();
            if (descModel != null && descModel.getSize() > 0) {
                radio.setDescriptionModel(descModel);
            }
            radio.write(out);
            out.write("\n</p>\n");
        } else if (this.getBrowserType() == 3) {
            ListModel m1 = this.getModel();
            if (m1 == null) {
                throw new IOException("Model not set");
            }
            ListModel m2 = this.getDescriptionModel();
            if (m2 == null || m2.getSize() == 0) {
                m2 = m1;
            }
            int m1Size = m1.getSize();
            for (int m2Size = m2.getSize(); m1Size >= 0 && m2Size >= 0; --m1Size, --m2Size) {
                String s = BaseUtil.replaceSpecialCharacters("" + m1.getElementAt(m1Size), this.getBrowserType());
                String desc = BaseUtil.replaceSpecialCharacters("" + m2.getElementAt(m2Size), this.getBrowserType());
                out.write("<ce value=\"");
                out.write(s);
                out.write("\">");
                out.write(desc);
                out.write("\n");
            }
        } else {
            IForm f;
            com.sas.servlet.tbeans.form.html.Radio radio = new com.sas.servlet.tbeans.form.html.Radio();
            radio.setName(this.getName());
            radio.setId(this.getId());
            radio.setModel(this.getModel());
            radio.setRequest(this.getRequest());
            radio.setResponse(this.getResponse());
            radio.setLocale(this.getLocale());
            ListModel descModel = this.getDescriptionModel();
            if (descModel != null && descModel.getSize() > 0) {
                radio.setDescriptionModel(descModel);
            }
            if ((f = this.getParentIForm()) != null) {
                f.setHTMLTableRow(this.getPrompt(), radio, this.getOptionLabel(), this.getOptionURL());
            }
        }
    }

    @Override
    public void writeFooter(PrintWriter out) throws IOException {
        if (this.getBrowserType() == 3) {
            out.write("</choice>\n");
        } else {
            super.writeFooter(out);
        }
    }
}

