/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.ipage.iform;

import com.sas.servlet.tbeans.form.html.Hidden;
import com.sas.servlet.tbeans.ipage.iform.BaseIFormElement;
import com.sas.servlet.util.BaseUtil;
import com.sas.util.Util;
import java.io.IOException;
import java.io.PrintWriter;

public class IFormHidden
extends BaseIFormElement {
    private String value;
    private boolean resolveSpecialCharacters;

    public IFormHidden() {
        this(Util.getName((String)"IFormHidden"), "");
    }

    public IFormHidden(String name, String value) {
        this(name, value, true);
    }

    public IFormHidden(String name, String value, boolean resolveSpecialCharacters) {
        this.setName(name);
        this.setValue(value);
        this.setResolveSpecialCharacters(resolveSpecialCharacters);
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setResolveSpecialCharacters(boolean resolveSpecialCharacters) {
        this.resolveSpecialCharacters = resolveSpecialCharacters;
    }

    public boolean isResolveSpecialCharacters() {
        return this.resolveSpecialCharacters;
    }

    @Override
    public void writeHeader(PrintWriter out) throws IOException {
    }

    @Override
    public void writeBase(PrintWriter out) throws IOException {
        String name = this.getName();
        String val = this.getValue();
        if (this.isResolveSpecialCharacters() && val != null) {
            val = BaseUtil.replaceSpecialCharacters(val, this.getBrowserType());
        }
        if (name != null && val != null) {
            if (this.getBrowserType() == 1 || this.getBrowserType() == 2) {
                out.write("<postfield name=\"");
                out.write(name);
                out.write("\" value=\"");
                out.write(val);
                out.write("\"/>\n");
            } else if (this.getBrowserType() == 3) {
                out.write(name);
                out.write("=");
                out.write(val);
            } else {
                Hidden hidden = new Hidden(name, val);
                hidden.setRequest(this.getRequest());
                hidden.setResponse(this.getResponse());
                hidden.setLocale(this.getLocale());
                hidden.write(out);
            }
        }
    }

    @Override
    public void writeFooter(PrintWriter out) throws IOException {
    }
}

