/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.ipage.iform;

import com.sas.servlet.tbeans.ipage.BaseIPage;
import com.sas.servlet.tbeans.ipage.iform.IForm;
import java.io.IOException;
import java.io.PrintWriter;

public abstract class BaseIFormElement
extends BaseIPage {
    private IForm parentIForm;
    private String prompt;
    private String shortPrompt;
    private String acceptURL;
    private String acceptLabel;
    private boolean writeHiddenElements;

    public void setParentIForm(IForm parentIForm) {
        this.parentIForm = parentIForm;
    }

    public IForm getParentIForm() {
        return this.parentIForm;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setShortPrompt(String shortPrompt) {
        this.shortPrompt = shortPrompt;
    }

    public String getShortPrompt() {
        return this.shortPrompt;
    }

    public void setAcceptURL(String acceptURL) {
        this.acceptURL = acceptURL;
    }

    public void setAcceptLabel(String acceptLabel) {
        this.acceptLabel = acceptLabel;
    }

    public String getAcceptURL() {
        return this.acceptURL;
    }

    public String getAcceptLabel() {
        return this.acceptLabel;
    }

    public void write(PrintWriter out, boolean writeHiddenElements) throws IOException {
        this.writeHiddenElements = writeHiddenElements;
        this.write(out);
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        this.writeHeader(out);
        this.writeBase(out);
        this.writeFooter(out);
        this.cleanUpResources();
    }

    @Override
    public void writeHeader(PrintWriter out) throws IOException {
        int bType = this.getBrowserType();
        if (bType == 1 || bType == 2) {
            out.write("<card");
            out.write(" id=\"");
            out.write(this.getName());
            out.write("\"");
            if (this.getTitle() != null) {
                out.write(" title=\"");
                out.write(this.getTitle());
                out.write("\"");
            }
            out.write(">\n");
        } else if (bType == 3) {
            out.write(" name=");
            out.write(this.getName());
            out.write(" key=");
            out.write(this.getName());
            if (this.getTitle() != null) {
                out.write(" title=\"");
                out.write(this.getTitle());
                out.write("\"");
            }
            out.write(">\n");
        }
    }

    @Override
    public void writeBase(PrintWriter out) throws IOException {
        super.writeBase(out);
        String title = this.getTitle();
        String prm = this.getPrompt();
        String optionLabel = this.getOptionLabel();
        String optionURL = this.getOptionURL();
        int bType = this.getBrowserType();
        if (bType == 1 || bType == 2) {
            if (this.getShortPrompt() != null && this.getShortPrompt().length() > 0) {
                prm = this.getShortPrompt();
            }
            if (optionLabel != null && optionLabel.length() > 0) {
                out.write("<do type=\"options\" label=\"");
                out.write(optionLabel);
                out.write("\" name=\"");
                out.write(optionLabel);
                out.write("\">\n");
                if (optionURL != null && optionURL.length() > 0) {
                    out.write("<go href=\"");
                    out.write(optionURL);
                    out.write("\"/>\n");
                }
                out.write("</do>\n");
            }
            out.write("<do type=\"accept\"");
            if (this.getAcceptLabel() != null && this.getAcceptLabel().length() > 0) {
                out.write(" label=\"");
                out.write(this.getAcceptLabel());
                out.write("\"");
            }
            out.write(">\n");
            out.write("<go href=\"");
            out.write(this.getAcceptURL());
            if (this.writeHiddenElements) {
                out.write("\" method=\"");
                IForm form = this.getParentIForm();
                if (form != null) {
                    out.write(form.getMethod());
                    out.write("\">\n");
                    form.writeHiddenElements(out);
                } else {
                    out.write("\">\n");
                }
            } else {
                out.write("\">\n");
            }
            out.write("</go>\n</do>\n");
            if (bType == 1 && title != null) {
                out.write("<p align=\"center\">\n");
                out.write(title);
                out.write("</p>\n");
                out.write("<p align=\"left\">\n");
            } else {
                out.write("<p>\n");
            }
            if (prm != null && prm.length() > 0) {
                out.write(this.resolveNewLine(prm, "\n"));
            }
        } else if (bType == 3) {
            IForm f;
            if (this.getShortPrompt() != null && this.getShortPrompt().length() > 0) {
                prm = this.getShortPrompt();
            }
            if (optionLabel != null && optionLabel.length() > 0) {
                out.write("<action type=\"soft1\" task=\"go\" label=\"");
                out.write(optionLabel);
                if (optionURL != null && optionURL.length() > 0) {
                    out.write("\" dest=\"");
                    out.write(optionURL);
                }
                out.write("\">\n");
            }
            out.write("<action type=accept task=go dest=");
            out.write(this.getAcceptURL());
            if (this.getAcceptLabel() != null && this.getAcceptLabel().length() > 0) {
                out.write(" label=");
                out.write(this.getAcceptLabel());
            }
            if (this.writeHiddenElements && (f = this.getParentIForm()) != null) {
                out.write(" method=");
                out.write(f.getMethod());
                out.write(" postdata=");
                f.writeHiddenElements(out);
            }
            out.write(">\n");
            if (title != null) {
                out.write("<center>");
                out.write(title);
                out.write("\n");
            }
            if (prm != null && prm.length() > 0) {
                if (title != null) {
                    out.write("<wrap>");
                }
                out.write(this.resolveNewLine(prm, "\n"));
            }
        }
    }

    @Override
    public void writeFooter(PrintWriter out) throws IOException {
        int bType = this.getBrowserType();
        if (bType == 1 || bType == 2) {
            out.write("</card>\n");
        }
    }
}

