/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.ipage;

import com.sas.servlet.tbeans.ipage.BaseIPage;
import com.sas.servlet.util.BaseUtil;
import com.sas.util.Util;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

public class IText
extends BaseIPage {
    private String textData = "";
    private int align = 2;
    private String acceptURL;
    private String acceptLabel;

    public IText() {
        this(Util.getName((String)"IText"), null, null);
    }

    public IText(String text) {
        this(Util.getName((String)"IText"), null, null);
        this.setText(text);
    }

    public IText(HttpServletRequest request, HttpServletResponse response) {
        this(Util.getName((String)"IText"), request, response);
    }

    public IText(String name, HttpServletRequest request, HttpServletResponse response) {
        if (request != null) {
            this.setRequest(request);
        }
        if (response != null) {
            this.setResponse(response);
        }
        this.setName(name);
    }

    public void setAlignment(int value) {
        switch (value) {
            case 0: 
            case 2: 
            case 4: {
                this.align = value;
                break;
            }
            default: {
                this.align = 2;
            }
        }
    }

    public int getAlignment() {
        return this.align;
    }

    public void setAcceptURL(String acceptURL) {
        this.acceptURL = acceptURL;
    }

    public void setAcceptLabel(String acceptLabel) {
        this.acceptLabel = acceptLabel;
    }

    public String getAcceptURL() {
        return this.acceptURL;
    }

    public String getAcceptLabel() {
        return this.acceptLabel;
    }

    @Override
    public void writeBase(PrintWriter out) throws IOException {
        super.writeBase(out);
        int bType = this.getBrowserType();
        if (this.getText() != null) {
            this.setText(BaseUtil.replaceSpecialCharacters(this.getText(), bType));
        }
        int alignment = this.getAlignment();
        if (bType == 1 || bType == 2) {
            out.write("<card");
            if (this.getName() != null) {
                out.write(" id=\"");
                out.write(this.getName());
                out.write("\"");
            }
            if (this.getTitle() != null) {
                out.write(" title=\"");
                out.write(this.getTitle());
                out.write("\"");
            }
            out.write(">\n");
            if (this.acceptURL != null && this.acceptURL.length() > 0) {
                out.write("<do type=\"accept\"");
                if (this.acceptLabel != null && this.acceptLabel.length() > 0) {
                    out.write(" label=\"");
                    out.write(this.acceptLabel);
                    out.write("\"");
                }
                out.write(">\n");
                out.write("<go href=\"");
                out.write(this.acceptURL);
                out.write("\"/>\n</do>\n");
            }
            if (bType == 1 && this.getTitle() != null) {
                out.write("<p align=\"center\">\n");
                out.write(this.getTitle());
                out.write("</p>\n");
            }
            if (alignment == 0) {
                out.write("<p align=\"center\">\n");
            } else if (alignment == 4) {
                out.write("<p align=\"right\">\n");
            } else if (bType == 1 && this.getTitle() != null) {
                out.write("<p align=\"left\">\n");
            } else {
                out.write("<p>\n");
            }
            out.write(this.resolveNewLine(this.getText(), "\n"));
            out.write("\n</p>\n</card>\n");
        } else if (bType == 3) {
            out.write("<display");
            if (this.getName() != null) {
                out.write(" name=\"");
                out.write(this.getName());
                out.write("\"");
            }
            if (this.getTitle() != null) {
                out.write(" title=\"");
                out.write(this.getTitle());
                out.write("\"");
            }
            out.write(">\n");
            if (this.acceptURL != null && this.acceptURL.length() > 0) {
                out.write("<action type=\"accept\" task=\"go\"");
                if (this.acceptLabel != null && this.acceptLabel.length() > 0) {
                    out.write(" label=\"");
                    out.write(this.acceptLabel);
                    out.write("\"");
                }
                out.write("dest=\"");
                out.write(this.acceptURL);
                out.write("\">");
            }
            if (this.getTitle() != null) {
                out.write("<center>");
                out.write(this.getTitle());
                out.write("\n");
                if (alignment == 0) {
                    out.write("<wrap><center>");
                } else if (alignment == 4) {
                    out.write("<wrap><right>");
                } else {
                    out.write("<wrap>");
                }
            } else if (alignment == 0) {
                out.write("<center>");
            } else if (alignment == 4) {
                out.write("<right>");
            }
            out.write(this.resolveNewLine(this.getText(), "\n"));
            out.write("\n</display>\n");
        } else {
            if (alignment == 0) {
                out.write("<p align=\"center\">\n");
            } else if (alignment == 4) {
                out.write("<p align=\"right\">\n");
            } else {
                out.write("<p>\n");
            }
            out.write(this.resolveNewLine(this.getText(), "\n"));
            out.write("\n</p>\n");
            boolean acceptWritten = false;
            if (this.acceptURL != null && this.acceptURL.length() > 0) {
                acceptWritten = true;
                out.write("<a href=\"");
                out.write(this.acceptURL);
                out.write("\">");
                if (this.acceptLabel != null && this.acceptLabel.length() > 0) {
                    out.write(this.acceptLabel);
                } else {
                    out.write(this.acceptURL);
                }
                out.write("</a>\n");
            }
            if (this.getOptionLabel() != null && this.getOptionLabel().length() > 0 && this.getOptionURL() != null && this.getOptionURL().length() > 0) {
                if (acceptWritten) {
                    out.write("&#160;");
                }
                out.write("<a href=\"" + this.getOptionURL() + "\">" + this.getOptionLabel() + "</a>");
            }
        }
    }

    public void setText(String value) {
        this.textData = value;
    }

    public String getText() {
        return this.textData;
    }
}

