/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.html.features;

import com.sas.servlet.tbeans.features.DnDFeature;
import com.sas.servlet.tbeans.html.TreeView;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.Writer;

public class TreeDnDFeature
extends DnDFeature {
    private String _treeId;
    private String _zoneFunction;
    private String _initializeElementFunction;

    public TreeDnDFeature(TreeView treeView) {
        this(treeView.getId());
    }

    public TreeDnDFeature(String id) {
        this._treeId = id;
        this.createZones();
        this.setDropHandler("sas_DnD_Tree_handleDrop");
        this.setConfigureDnDFunction("sas_DnD_Tree_build");
    }

    private void createZones() {
        String[] zones = new String[]{"Folders", "Leaves"};
        this.setDragZones(this.createZoneList(zones, true));
        this.setDropZones(this.createZoneList(zones, false));
        this.setZoneInfos(this.createZoneInfoList(zones));
        this.getDropZone("Leaves").setHighlightFunction(null);
        this.getDropZone("Folders").setHighlightFunction(null);
    }

    public void write(HttpServletRequest request, Writer out) throws IOException {
        super.write(request, out, this._treeId);
    }

    @Override
    protected void addExtraParameters(StringBuffer str) {
        this.js.addStringProperty("zoneFunction", this.getZoneFunction());
        this.js.addStringProperty("initFunction", this.getInitializeElementFunction());
    }

    public String getZoneFunction() {
        return this._zoneFunction;
    }

    public void setZoneFunction(String zoneFunction) {
        this._zoneFunction = zoneFunction;
    }

    public String getInitializeElementFunction() {
        return this._initializeElementFunction;
    }

    public void setInitializeElementFunction(String initializeElementFunction) {
        this._initializeElementFunction = initializeElementFunction;
    }
}

