/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.html.features;

import com.sas.servlet.tbeans.html.AjaxTreeView;
import com.sas.servlet.tbeans.html.TreeView;
import com.sas.servlet.tbeans.models.TreeNodeInterface;
import com.sas.servlet.tbeans.olaptableview.html.features.OLAPDnDAction;
import com.sas.servlet.util.BaseUtil;
import com.sas.util.Strings;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.fs.ServicesLogFactory;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import javax.swing.tree.DefaultMutableTreeNode;

public class TreeDnDAction {
    private TreeView _targetTreeView;
    private TreeView _sourceTreeView;
    private String[] _sourceIds;
    private String _targetId;
    private String _placement;
    private boolean _targetChildrenCreated;
    public static final String RB_KEY = "TreeDnDAction.";

    public TreeDnDAction(TreeView targetTreeView, TreeView sourceTreeView) {
        this.setTargetTreeView(targetTreeView);
        this.setSourceTreeView(sourceTreeView);
    }

    public static void servletInvocationMethod(HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType(BaseUtil.TEXT_PLAIN_MIME_TYPE);
        String tid = request.getParameter("tid");
        String sid = request.getParameter("sid");
        HttpSession session = request.getSession();
        Object targetObj = session.getAttribute(tid);
        Object sourceObj = session.getAttribute(sid);
        if (targetObj == null) {
            String str = "Component with id " + tid + " not found on the session";
            TreeDnDAction.getLogger().warn(str);
            throw new NullPointerException();
        }
        if (sourceObj == null) {
            String str = "Component with id " + sid + " not found on the session";
            TreeDnDAction.getLogger().warn(str);
            throw new NullPointerException();
        }
        TreeDnDAction.handleAction(request, response, targetObj, sourceObj);
    }

    private static void handleAction(HttpServletRequest request, HttpServletResponse response, Object targetObj, Object sourceObj) throws Exception {
        TreeView ttv = null;
        TreeView stv = null;
        if (targetObj instanceof TreeView) {
            ttv = (TreeView)targetObj;
        } else if (targetObj instanceof AjaxTreeView) {
            ttv = ((AjaxTreeView)targetObj).getTreeView();
        } else {
            return;
        }
        if (sourceObj instanceof TreeView) {
            stv = (TreeView)sourceObj;
        } else if (sourceObj instanceof AjaxTreeView) {
            stv = ((AjaxTreeView)sourceObj).getTreeView();
        } else {
            return;
        }
        TreeDnDAction action = new TreeDnDAction(ttv, stv);
        action.update(request);
    }

    public void update(HttpServletRequest request) {
        this.parseParameters(request);
        TreeNodeInterface tNode = TreeView.findNode(this.getTargetId(), this.getTargetTreeView().getRoot());
        DefaultMutableTreeNode tparent = (DefaultMutableTreeNode)tNode.getParent();
        int childIndex = tparent.getIndex(tNode);
        TreeNodeInterface sNode = null;
        String[] sids = this.getSourceIds();
        if (this.getSourceTreeView().getId().equals(this.getTargetTreeView().getId()) && Strings.indexOf((String)this.getTargetId(), (String[])sids) >= 0) {
            return;
        }
        for (int i = 0; i < sids.length; ++i) {
            sNode = TreeView.findNode(sids[i], this.getSourceTreeView().getRoot());
            sNode.removeFromParent();
            if ("CENTER".equals(this.getPlacement())) {
                if (!this.isTargetChildrenCreated()) {
                    sNode.setExpanded(false);
                }
                ((DefaultMutableTreeNode)((Object)tNode)).add((DefaultMutableTreeNode)((Object)sNode));
                continue;
            }
            tparent.insert(sNode, childIndex + i);
        }
    }

    private void parseParameters(HttpServletRequest request) {
        this._sourceIds = request.getParameterValues("sourceIds");
        this._targetId = request.getParameter("targetId");
        this._placement = request.getParameter("isBefore");
        this._targetChildrenCreated = "true".equalsIgnoreCase(request.getParameter("tChildrenCreated"));
    }

    private static CommonLoggerInterface getLogger() {
        return TreeDnDAction.getLogger(OLAPDnDAction.class);
    }

    private static CommonLoggerInterface getLogger(Class clazz) {
        return LoggerRepository2.getLogger((String)clazz.getPackage().getName(), (LoggerFactoryInterface)new ServicesLogFactory());
    }

    public String[] getSourceIds() {
        return this._sourceIds;
    }

    public void setSourceIds(String[] sourceIds) {
        this._sourceIds = sourceIds;
    }

    public String getTargetId() {
        return this._targetId;
    }

    public void setTargetId(String targetId) {
        this._targetId = targetId;
    }

    public String getPlacement() {
        return this._placement;
    }

    public void setPlacement(String placement) {
        this._placement = placement;
    }

    public TreeView getTargetTreeView() {
        return this._targetTreeView;
    }

    public void setTargetTreeView(TreeView treeView) {
        this._targetTreeView = treeView;
    }

    public TreeView getSourceTreeView() {
        return this._sourceTreeView;
    }

    public void setSourceTreeView(TreeView treeView) {
        this._sourceTreeView = treeView;
    }

    public boolean isTargetChildrenCreated() {
        return this._targetChildrenCreated;
    }

    private void dumpTree(TreeView tree) {
        System.out.print("\n" + tree.getId() + "  -----------------------");
        this.dumpSubtree(tree.getRoot());
    }

    private void dumpSubtree(TreeNodeInterface node) {
        System.out.print("\n");
        TreeNodeInterface cur = node;
        while (cur.getParent() != null) {
            System.out.print("\t");
            cur = (TreeNodeInterface)cur.getParent();
        }
        System.out.print(node.getText() + " (" + node.getName() + ")");
        int nKids = node.getChildCount();
        for (int i = 0; i < nKids; ++i) {
            this.dumpSubtree((TreeNodeInterface)node.getChildAt(i));
        }
    }
}

