/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.html;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.BaseTreeView;
import com.sas.servlet.tbeans.ComplexStyleInterface;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.JavaScriptEventHandlerInterface;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.form.html.Form;
import com.sas.servlet.tbeans.form.html.FormViewInterface;
import com.sas.servlet.tbeans.html.RB;
import com.sas.servlet.tbeans.html.TreeExpandAction;
import com.sas.servlet.tbeans.html.TreeViewFull;
import com.sas.servlet.tbeans.html.TreeViewStyleKeysInterface;
import com.sas.servlet.tbeans.models.NodeInterface;
import com.sas.servlet.tbeans.models.TreeNodeInterface;
import com.sas.servlet.util.BaseUtil;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.MapWithDefaults;
import com.sas.util.Strings;
import com.sas.util.Util;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

@SASScope(value="ALL")
public class TreeView
extends BaseTreeView
implements ComplexStyleInterface,
TreeViewStyleKeysInterface,
FormViewInterface,
JavaScriptEventHandlerInterface {
    @SASScope
    public static final int FULL = 1;
    @SASScope
    public static final int PROGRESSIVE = 0;
    @SASScope
    public static final int FULLYEXPANDED = 1;
    @SASScope
    public static final int FULLYCOLLAPSED = 0;
    public static final int IFRAME = 1;
    public static final int AJAX = 0;
    private final String START_TABLE = "<table ";
    private final String END_TABLE = "</table>";
    private final String START_SPAN = "<span class=\"";
    private final String END_SPAN = "</span>";
    private final String START_ROW = "<tr>";
    private final String END_ROW = "</tr>";
    private final String START_DATA = "<td";
    private final String START_DATA_DEFAULT = "<td>";
    private final String START_DATA_NOWRAP = "<td nowrap=\"nowrap\"";
    private final String START_DATA_COLSPAN = "<td colspan=\"";
    private final String END_DATA = "</td>";
    private final String QUOTE = "\"";
    private final String END_TAG = ">";
    private final String START_IMG = "<img src=\"";
    private final String VALIGN_TOP = " valign=\"top\"";
    private final String VALIGN_MIDDLE = " valign=\"middle\"";
    private final String ALIGN_CENTER = " align=\"center\"";
    private final String CLASS = " class=\"";
    private final String TABLE_DEFAULT_ATTR = " cellspacing=\"0\" cellpadding=\"0\" border=\"0\" height=\"1\" summary=\"\"";
    private final String START_TABLE_DEFAULT = "<table  cellspacing=\"0\" cellpadding=\"0\" border=\"0\" height=\"1\" summary=\"\">";
    private final String START_ROW_VALIGN_MIDDLE = "<tr  valign=\"middle\">";
    private final String START_ANCHOR_HREF = "<a href=\"";
    private final String HREF = " href=\"";
    private final String START_ANCHOR = "<a ";
    private final String END_ANCHOR = "</a>";
    private TreeNodeInterface rootNode;
    private Form formObject;
    private boolean formEnabled;
    private HashMap additionalParameters;
    private String JSType;
    private String onChange = null;
    private String onFocus = null;
    private String onBlur = null;
    private boolean delayExecutionEnabled;
    private boolean renderUsingDivs;
    private int remote_script_state;
    private final String QSPACE = "\" ";
    private StringBuffer nodeHTMLCode;
    private boolean nodeMultiRow;
    private static final String RB_KEY = "TreeView.";
    private static final HashMap defaultStyleMap = new HashMap();
    private Map componentStyleMap;
    private static ThreadLocal _threadLocalTrimURL = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new Boolean(true);
        }
    };
    HashMap nodeMap;
    private Form rsForm;
    @SASScope
    public TreeNodeTransform transform = new DefaultTreeNodeTransform();

    public TreeView() {
        this(Util.getName((String)"TreeView"), true, true, false, 0, 1, true, "");
    }

    public TreeView(String name) {
        this(name, true, true, false, 0, 1, true, "");
    }

    public TreeView(String name, boolean urlLinks, boolean usePlusMinus, boolean nodeSelection, int expansionLevel, int nodeLoading, boolean imageVisible, String styleClassPrefix) {
        TreeView.setupDefaultStyleMap();
        this.componentStyleMap = new MapWithDefaults((Map)defaultStyleMap);
        this.setId(name);
        this.setUsingURLLinks(urlLinks);
        this.setUsePlusMinus(usePlusMinus);
        this.setExpansionLevel(expansionLevel);
        this.setNodeLoading(nodeLoading);
        this.setImageVisible(imageVisible);
        this.setStyleClassPrefix(styleClassPrefix);
        this.setLineStyle(3);
        this.setAutoChildrenVerify(true);
        this.setTarget("_blank");
        this.setJSType("TreeView");
        this.setDelayExecutionEnabled(false);
        this.setRenderUsingDivs(false);
        this.setSelectionMode(nodeSelection ? 1 : 0);
        this.setRemoteScripting(1);
        this.setFormEnabled(true);
        this.setImageLocation(null);
        this.setUsePlusMinusLines(true);
    }

    public static void setThreadLocalTrimURL(boolean value) {
        _threadLocalTrimURL.set(new Boolean(value));
    }

    public static boolean getThreadLocalTrimURL() {
        Boolean rval = (Boolean)_threadLocalTrimURL.get();
        if (rval == null) {
            rval = new Boolean(true);
        }
        return rval;
    }

    static String reformatTreeText(String tText) {
        char[] quote1 = new char[]{'\"', '\\'};
        String[] quote2 = new String[]{"&quot;", "\\\\"};
        String val = Strings.replace((String)tText, (char[])quote1, (String[])quote2);
        return val;
    }

    String getStyle(TreeNodeInterface node, String key) {
        String val;
        String prefix = node.getStyleClassPrefix();
        if (prefix == null) {
            prefix = this.getStyleClassPrefix();
        }
        if ((val = this.getStyleClass(node, key)) == null) {
            val = this.getStyleClass(key);
        }
        if (val == null) {
            return null;
        }
        return prefix + val;
    }

    String getStyleClass(ComplexStyleInterface csi, String key) {
        Map map = csi.getStyleMap();
        StyleInfo si = (StyleInfo)map.get(key);
        if (si == null) {
            return null;
        }
        return si.getClassid();
    }

    String getStyleClass(String key) {
        return this.getStyleClass(this, key);
    }

    private String getLinkStyle(TreeNodeInterface node, String stylekey) {
        String style = this.getStyle(node, stylekey);
        if (style == null) {
            style = stylekey == "TREEVIEW_LINK" ? this.getStyle(node, "TREEVIEW_TEXT") : this.getStyle(node, "TREEVIEW_SELECTED");
        }
        return style;
    }

    private boolean hasChildren(TreeNodeInterface node) {
        return !this.isAutoChildrenVerify() || !node.isLeaf();
    }

    @SASScope
    public void setRoot(TreeNodeInterface rootNode) {
        this.rootNode = rootNode;
    }

    @SASScope
    public TreeNodeInterface getRoot() {
        return this.rootNode;
    }

    @Override
    @SASScope
    public void setModel(TreeModel model) {
        super.setModel(model);
        if (model == null && this.nodeMap != null) {
            this.nodeMap.clear();
        }
        this.setRoot(null);
    }

    @Override
    @SASScope
    public void setOnChange(String value) {
        this.onChange = value;
    }

    @Override
    @SASScope
    public String getOnChange() {
        return this.onChange;
    }

    @Override
    @SASScope
    public void setOnFocus(String value) {
        this.onFocus = value;
    }

    @Override
    @SASScope
    public String getOnFocus() {
        return this.onFocus;
    }

    @Override
    @SASScope
    public void setOnBlur(String value) {
        this.onBlur = value;
    }

    @Override
    @SASScope
    public String getOnBlur() {
        return this.onBlur;
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        JavaScriptIncludeHandler.writeIncludes(out, "TREEVIEW", this.getRequest());
        out.println("<div id=\"" + this.getId() + "_Div\"></div>");
        if (this.getModel() != null) {
            this.getRootFromModel();
            if (this.getNodeLoading() == 0) {
                this.writeHTML(out);
            } else if (this.getRoot() != null) {
                this.writeJavaScript(out, this.getRoot());
            }
        }
        this.cleanUpResources();
    }

    private void writeJavaScript(PrintWriter out, TreeNodeInterface modelRoot) throws IOException {
        TreeViewFull tvf = new TreeViewFull(this);
        tvf.writeJavaScript(out, modelRoot);
    }

    private void writeHTML(PrintWriter out) throws IOException {
        if (this.getRequest() == null) {
            out.print("<b> The request object must be set using the setRequest() method. </b>");
            return;
        }
        if (this.formEnabled) {
            this.getFormObject().setRequest(this.getRequest());
            this.getFormObject().writeHeader(out);
        }
        ArrayList htmloc = new ArrayList();
        this.getHTMLTreeNodes(htmloc, this.getRoot(), this.getRoot(), "", null, true);
        int n = htmloc.size();
        for (int i = 0; i < n; ++i) {
            String parse = (String)htmloc.get(i);
            if (parse == null) continue;
            out.println(parse);
        }
        this.writeHTMLSelectionJS(out);
        this.writeFormAdditionalParameters(out);
        if (this.formEnabled) {
            if (this.isCheckboxSelectionMode()) {
                out.write("<input type=\"submit\"/>");
            }
            this.getFormObject().writeFooter(out);
        }
    }

    TreeNodeInterface getRootFromModel() {
        TreeModel model = this.getModel();
        if (model.getRoot() instanceof TreeNodeInterface) {
            this.setRoot((TreeNodeInterface)model.getRoot());
        } else if (this.getRoot() == null || this.getNodeLoading() != 0) {
            try {
                TreeNodeAdaptor adaptedNode = new TreeNodeAdaptor(model, model.getRoot(), this.getId() + "_nodes", this.transform);
                this.setRoot(adaptedNode);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getRoot();
    }

    private void writeHTMLSelectionJS(PrintWriter out) {
        out.print(JavaScriptIncludeHandler.getStartScript());
        if (this.isNodeSelectionVisible()) {
            String childrenof;
            StringBuffer selectionJS = new StringBuffer();
            if (this.getRequest() != null && (childrenof = this.getRequest().getParameter(this.getId() + "_childrenOf")) != null) {
                selectionJS.append(" location.hash = \"" + childrenof + "\"; \n");
            }
            if (this.getSelectedNode() != null) {
                selectionJS.append("var prevObj = document.getElementById(\"" + this.getSelectedNode() + "s\");\n");
                selectionJS.append("var sNode =\"");
                selectionJS.append(this.getSelectedNode() + "s\";\n\n");
            } else {
                selectionJS.append("var prevObj = null; \n");
            }
            out.println(selectionJS.toString());
        }
        if (!this.isNodeSelectionVisible()) {
            out.print("var sNode=\"\"; \n");
        }
        out.print(JavaScriptIncludeHandler.getEndScript(null));
    }

    void writeFormAdditionalParameters(PrintWriter out) {
        out.println("<input type=\"hidden\" name=\"" + this.getId() + "_childrenOf\"/>");
        BaseUtil.writeAdditionalParameters(this.getAdditionalParameters(), out);
    }

    @SASScope
    public void getHTMLTreeNodes(ArrayList htmloc, TreeNodeInterface node, TreeNodeInterface root, String addOns, TreeNodeInterface parentNode, boolean firstChild) {
        String selectedNode;
        String toLookFor = this.getRequest().getParameter(this.getId() + "_childrenOf");
        if (toLookFor != null && toLookFor.length() > 0) {
            if (this.getLineStyle() == 4) {
                toLookFor = toLookFor.substring(0, toLookFor.length() - 1);
            }
            selectedNode = this.getRequest().getParameter("selectedNode");
            selectedNode = this.isNodeSelectionVisible() && selectedNode != null && selectedNode.length() > 0 ? selectedNode.substring(0, selectedNode.length() - 1) : null;
            if (selectedNode != null) {
                this.setSelectedNode(selectedNode);
            }
        } else {
            toLookFor = null;
            selectedNode = null;
        }
        if (toLookFor == null && (this.getExpansionLevel() == 1 || this.getInitialExpansionLevel() == -1) && !node.isLeaf() && node.isEnabled()) {
            node.setExpanded(true);
        }
        this.nodeHTMLCode = new StringBuffer(40);
        if (this.isRenderUsingDivs()) {
            this.nodeMultiRow = this.isNodeMultiRow(node);
            if (this.nodeMultiRow) {
                this.nodeHTMLCode.append("<div");
                String cName = this.getStyle(node, "TREEVIEW_FLOAT");
                if (cName != null) {
                    this.nodeHTMLCode.append(" class=\"").append(cName).append("\"");
                }
                this.nodeHTMLCode.append(">");
            }
        }
        if (parentNode != null && parentNode.isExpanded()) {
            String string = addOns = this.isRenderUsingDivs() ? this.getDivAddOns(node, addOns, parentNode, root) : this.getAddOns(node, addOns, parentNode, root);
        }
        if (!this.isRootNodeVisible() && !root.isExpanded()) {
            root.setExpanded(true);
        }
        if (toLookFor == null && this.getExpansionLevel() != 1 && this.getInitialExpansionLevel() > -1 && node == root) {
            this.expandNode(root, 0, this.getInitialExpansionLevel());
        }
        String PMLink = this.getRequest().getRequestURI();
        if (this.isRootNodeVisible() || node != root) {
            htmloc.add(this.nodeHTMLCode.append(this.getHTMLTreeText(toLookFor, PMLink, node, addOns, parentNode, root, firstChild, selectedNode)).toString());
        }
        if (node.isExpanded()) {
            int nodeChildCount = node.getChildCount();
            if (nodeChildCount > 0) {
                try {
                    ((TreeNodeInterface)node.getChildAt(nodeChildCount - 1)).setLastNode(true);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            int nodecnt = node.getChildCount();
            for (int i = 0; i < nodecnt; ++i) {
                if (!(node.getChildAt(i) instanceof TreeNodeInterface)) continue;
                this.getHTMLTreeNodes(htmloc, (TreeNodeInterface)node.getChildAt(i), root, addOns, node, i == 0);
            }
        }
    }

    private boolean isNodeMultiRow(TreeNodeInterface node) {
        String nodeText = node.getText().toLowerCase();
        return nodeText.indexOf("<br>") >= 0 || node.getDescription() != null;
    }

    public void expandNode(TreeNodeInterface node, int currentLevel, int maxLevel) {
        if (currentLevel > maxLevel) {
            return;
        }
        node.setExpanded(true);
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.expandNode((TreeNodeInterface)node.getChildAt(i), currentLevel + 1, maxLevel);
        }
    }

    protected String getDivAddOns(TreeNodeInterface node, String addOns, TreeNodeInterface parentNode, TreeNodeInterface rootOfTree) {
        StringBuffer imageString = new StringBuffer(40);
        if (rootOfTree != node && rootOfTree != parentNode) {
            String imgURI;
            imageString.append("<span");
            String className = this.getStyle(node, "TREEVIEW_BACKGROUND_IMAGE");
            if (className != null) {
                imageString.append(" class=\"").append(className).append("\"");
            }
            if (this.getLineStyle() == 4 && !parentNode.isLastNode() && this.isUsePlusMinus() && (imgURI = this.getImageURI("VERTICAL_LINE", "Vert_Line", node)) != null) {
                imageString.append(" style=\"background:url('").append(imgURI).append("')\"");
            }
            imageString.append("></span>");
        }
        addOns = addOns + imageString.toString();
        return addOns;
    }

    @SASScope
    protected String getAddOns(TreeNodeInterface node, String addOns, TreeNodeInterface parentNode, TreeNodeInterface rootOfTree) {
        StringBuffer imageString = new StringBuffer("");
        if (rootOfTree != node && rootOfTree != parentNode) {
            if (this.getLineStyle() == 4) {
                String height = "100%";
                String bgcolor = "#CCCCCC";
                if (parentNode.isLastNode() || !this.isUsePlusMinus()) {
                    this.addTableCell(imageString, "25", height, null, "Spacer");
                } else {
                    this.addTableCell(imageString, "6", height, null, "Spacer");
                    this.addTableCell(imageString, "1", height, bgcolor, "Spacer");
                    this.addTableCell(imageString, "18", height, null, "Spacer");
                }
            } else {
                imageString.append("<td>");
                this.addImageTag(imageString, "16", "22", parentNode.isLastNode() || !this.isUsePlusMinus() || !this.isUsePlusMinusLines() ? "Blank" : "Vert_Line");
                imageString.append("</td>");
            }
        }
        addOns = addOns + imageString.toString();
        return addOns;
    }

    @SASScope
    StringBuffer addTableCell(StringBuffer imageString, String width, String height, String bgColor, String imageKey) {
        imageString.append("<td");
        imageString.append(" align=\"center\"");
        imageString.append(" width=\"" + width + "\" height=\"" + height + "\"");
        if (bgColor != null) {
            imageString.append(" bgcolor=\"" + bgColor + "\"");
        }
        imageString.append(">");
        this.addImageTag(imageString, width, "100%", imageKey);
        imageString.append("</td>");
        return imageString;
    }

    @SASScope
    StringBuffer addImageTag(StringBuffer imageString, String width, String height, String imageKey) {
        ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(this.getRequest());
        imageString.append("<img src=\"");
        if (imageKey != null) {
            imageString.append(cpm.getImageURI(imageKey, this.imageLocation));
        }
        imageString.append("\"");
        imageString.append(" border=\"0\" width=\"" + width + "\" height=\"" + height + "\"");
        imageString.append(">");
        return imageString;
    }

    StringBuffer addTableCell(StringBuffer imageString, String width, String bgColor, String image) {
        imageString.append("<td");
        imageString.append(" align=\"center\"");
        imageString.append(" width=\"" + width + "\"");
        if (bgColor != null) {
            imageString.append(" bgcolor=\"" + bgColor + "\"");
        }
        imageString.append(">");
        this.addImageTag(imageString, width, "100%", image);
        imageString.append("</td>");
        return imageString;
    }

    StringBuffer addTableCell(StringBuffer imageString, String width, String bgColor) {
        imageString.append("<td");
        imageString.append(" align=\"center\"");
        imageString.append(" width=\"" + width + "px" + "\"");
        if (bgColor != null) {
            imageString.append(" height=\"9px\" bgcolor=\"" + bgColor + "\"");
        }
        imageString.append(">");
        imageString.append("</td>");
        return imageString;
    }

    @SASScope
    StringBuffer addIconTableCell(StringBuffer imageString, String width, String height, String bgColor) {
        imageString.append("<td");
        imageString.append(" align=\"center\"");
        imageString.append(" width=\"" + width + "px\" height=\"" + height + "px\"" + "\"");
        if (bgColor != null) {
            imageString.append(" bgcolor=\"" + bgColor + "\"");
        }
        imageString.append(">");
        imageString.append("</td>");
        return imageString;
    }

    @SASScope
    StringBuffer addPlusMinusTableCell(StringBuffer imageString, String width, String bgColor) {
        imageString.append("<td");
        imageString.append(" align=\"center\"");
        imageString.append(" width=\"" + width + " px\" height=\"4px\"" + "\"");
        if (bgColor != null) {
            imageString.append(" height=\"4px\" bgcolor=\"" + bgColor + "\"");
        }
        imageString.append(">");
        imageString.append("</td>");
        return imageString;
    }

    @SASScope
    StringBuffer addPlusMinusTableCell(StringBuffer imageString, String width, String height, String bgColor) {
        imageString.append("<td");
        imageString.append(" align=\"center\"");
        imageString.append(" width=\"" + width + " px\" height=\"" + height + "px\"" + "\"");
        if (bgColor != null) {
            imageString.append(" bgcolor=\"" + bgColor + "\"");
        }
        imageString.append(">");
        imageString.append("</td>");
        return imageString;
    }

    @SASScope
    protected StringBuffer addStartTableRowDataStyle(StringBuffer tableString, NodeInterface node) {
        tableString.append("<table  cellspacing=\"0\" cellpadding=\"0\" border=\"0\" height=\"1\" summary=\"\">");
        tableString.append("<tr>");
        tableString.append("<td").append(" class=\"");
        tableString.append(this.getNodeCellStyle(node));
        tableString.append("\"");
        tableString.append(">");
        return tableString;
    }

    @SASScope
    protected StringBuffer addEndTableRowData(StringBuffer tableString) {
        tableString.append("</td>").append("</tr>").append("</table>");
        return tableString;
    }

    @SASScope
    protected String getHTMLTreeText(String toLookFor, String PMLink, TreeNodeInterface node, String addOns, TreeNodeInterface parentNode, TreeNodeInterface rootOfTree, boolean firstChild, String selectedNode) {
        if (this.getLineStyle() == 3) {
            return this.isRenderUsingDivs() ? this.getDivHTMLTreeTextImage(toLookFor, PMLink, node, addOns, parentNode, rootOfTree, firstChild, selectedNode) : this.getHTMLTreeTextImage(toLookFor, PMLink, node, addOns, parentNode, rootOfTree, firstChild, selectedNode);
        }
        return this.isRenderUsingDivs() ? this.getDivHTMLTreeTextNoImage(toLookFor, PMLink, node, addOns, parentNode, rootOfTree, firstChild, selectedNode) : this.getHTMLTreeTextNoImage(toLookFor, PMLink, node, addOns, parentNode, rootOfTree, firstChild, selectedNode);
    }

    private int getNRows(String str) {
        int nRows = 0;
        if (str != null) {
            String txt = str.toLowerCase();
            nRows = Strings.count((String)txt, (int)0, (int)-1, (String)"<br>", (boolean)false);
            if (nRows > 0) {
                boolean starts = txt.startsWith("<br>");
                boolean ends = txt.endsWith("<br>");
                if (nRows > 1) {
                    if (starts) {
                        ++nRows;
                    }
                    if (ends) {
                        ++nRows;
                    }
                    if (!starts && !ends) {
                        ++nRows;
                    }
                } else if (nRows == 1) {
                    nRows = starts && ends ? 1 : 2;
                }
            } else {
                nRows = 1;
            }
        }
        return nRows;
    }

    protected String getDivHTMLTreeTextNoImage(String toLookFor, String PMLink, TreeNodeInterface node, String addOns, TreeNodeInterface parentNode, TreeNodeInterface rootOfTree, boolean firstChild, String selectedNode) {
        StringBuffer tableString = new StringBuffer("");
        if (node.getName().equals(toLookFor)) {
            node.setExpanded(!node.isExpanded());
        }
        if (this.isUsePlusMinus()) {
            this.addDivNode(tableString, node, addOns, parentNode, rootOfTree, firstChild);
        } else {
            tableString.append(addOns);
        }
        if (this.isImageVisible()) {
            this.addDivFolderImageTag(tableString, node);
            if (node.isEnabled() && this.hasChildren(node)) {
                this.addDivExpansionLink(tableString, node.getName());
            }
            tableString.append(">");
        }
        if (this.nodeMultiRow) {
            int nRows = this.getNRows(node.getText()) + this.getNRows(node.getDescription());
            String className = this.getStyle(node, "TREEVIEW_BACKGROUND_IMAGE");
            boolean isExpanded = node.isExpanded();
            boolean isLast = node.isLastNode();
            boolean hasChild = node.getChildCount() > 0;
            String imgURI = this.getImageURI("VERTICAL_LINE", "Vert_Line", node);
            for (int i = 1; i < nRows; ++i) {
                tableString.append("<br>").append(addOns);
                if (isExpanded) {
                    tableString.append("<span");
                    if (className != null) {
                        tableString.append(" class=\"").append(className).append("\"");
                    }
                    if (!isLast && imgURI != null) {
                        tableString.append(" style=\"background:url('").append(imgURI).append("')\"");
                    }
                    tableString.append("></span>");
                }
                tableString.append("<span");
                if (className != null) {
                    tableString.append(" class=\"").append(className).append("\"");
                }
                if (isExpanded && hasChild || !isExpanded && !isLast && imgURI != null) {
                    tableString.append(" style=\"background:url('").append(imgURI).append("')\"");
                }
                tableString.append("></span>");
            }
            tableString.append("</div>");
        }
        this.addDivText(tableString, node);
        return tableString.toString();
    }

    @SASScope
    protected String getHTMLTreeTextNoImage(String toLookFor, String PMLink, TreeNodeInterface node, String addOns, TreeNodeInterface parentNode, TreeNodeInterface rootOfTree, boolean firstChild, String selectedNode) {
        StringBuffer tableString = new StringBuffer("");
        tableString.append("<table ");
        tableString.append("id=\"");
        tableString.append(node.getName() + "\"");
        Map map = this.getStyleMap();
        StyleInfo si = (StyleInfo)map.get("TREEVIEW_TABLE");
        if (si != null) {
            si.write(tableString, this.getStyleClassPrefix());
        }
        tableString.append(" cellspacing=\"0\" cellpadding=\"0\" border=\"0\">");
        tableString.append("<tr>");
        tableString.append("<td>");
        tableString.append("<table ");
        if (si != null) {
            si.write(tableString, this.getStyleClassPrefix());
        }
        tableString.append(" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" height=\"1\" summary=\"\"");
        tableString.append(">");
        tableString.append("<tr>");
        if (node.getName().equals(toLookFor)) {
            node.setExpanded(!node.isExpanded());
        }
        if (this.isUsePlusMinus()) {
            this.addNode(tableString, node, addOns, parentNode, rootOfTree, firstChild);
        } else {
            tableString.append("<td>");
            tableString.append(addOns);
            tableString.append("</td>");
        }
        if (this.isImageVisible()) {
            this.addNodeImage(tableString, node, rootOfTree);
        }
        this.addText(tableString, node, false);
        tableString.append("</tr>");
        tableString.append("</table>");
        tableString.append("</td>");
        tableString.append("</tr>");
        tableString.append("</table>");
        return tableString.toString();
    }

    protected void addDivNode(StringBuffer tableString, TreeNodeInterface node, String addOns, TreeNodeInterface parentNode, TreeNodeInterface rootOfTree, boolean firstChild) {
        String imgURI = null;
        String alt = null;
        if (this.hasChildren(node) && node != rootOfTree) {
            if (node.isExpanded()) {
                imgURI = parentNode == rootOfTree && firstChild ? (this.isRootNodeVisible() ? (node.isLastNode() ? this.getImageURI("MINUS_LAST_NODE", "Minus_Last_Node", node) : this.getImageURI("MISSING_ROOT_MINUS_NODE", "Missing_Root_Minus_Node", node)) : (node.isLastNode() ? this.getImageURI("MINUS_ONLY_NODE", "Only_Node_Minus", node) : this.getImageURI("MINUS_NODE", "Minus_Node", node))) : (node.isLastNode() ? this.getImageURI("MINUS_LAST_NODE", "Minus_Last_Node", node) : this.getImageURI("MINUS_NODE", "Minus_Node", node));
                alt = RB.getStringResource(RB_KEY, "Collapse.txt", this.getLocale());
            } else {
                imgURI = parentNode == rootOfTree && firstChild ? (this.isRootNodeVisible() ? (node.isLastNode() ? this.getImageURI("PLUS_LAST_NODE", "Plus_Last_Node", node) : this.getImageURI("MISSING_ROOT_PLUS_NODE", "Missing_Root_Plus_Node", node)) : (node.isLastNode() ? this.getImageURI("PLUS_ONLY_NODE", "Only_Node_Plus", node) : this.getImageURI("PLUS_NODE", "Plus_Node", node))) : (node.isLastNode() ? this.getImageURI("PLUS_LAST_NODE", "Plus_Last_Node", node) : this.getImageURI("PLUS_NODE", "Plus_Node", node));
                alt = RB.getStringResource(RB_KEY, "Expand.txt", this.getLocale());
            }
        }
        if (node.isLeaf()) {
            String string = imgURI = node.isLastNode() ? this.getImageURI("LAST_NODE", "Last_Node", node) : this.getImageURI("NODE", "Node", node);
        }
        if (imgURI != null) {
            tableString.append(addOns).append("<span");
            String className = this.getStyle(node, "TREEVIEW_BACKGROUND_IMAGE");
            if (className != null) {
                tableString.append(" class=\"").append(className).append("\"");
            }
            tableString.append(" style=\"background:url('").append(imgURI).append("')\"");
            if (node.isEnabled() && this.hasChildren(node)) {
                this.addDivExpansionLink(tableString, node.getName());
            }
            if (alt != null) {
                tableString.append(" title=\"").append(alt).append("\"");
            }
            tableString.append("></span>");
        }
    }

    @SASScope
    protected StringBuffer addNode(StringBuffer tableString, TreeNodeInterface node, String addOns, TreeNodeInterface parentNode, TreeNodeInterface rootOfTree, boolean firstChild) {
        String imgKey = null;
        String alt = "";
        if (this.hasChildren(node)) {
            if (node.isExpanded()) {
                imgKey = "Minnde2";
                alt = RB.getStringResource(RB_KEY, "Collapse.txt", this.getLocale());
            } else {
                imgKey = "Plus_Nde_2";
                alt = RB.getStringResource(RB_KEY, "Expand.txt", this.getLocale());
            }
        }
        boolean nodeMultiRow = this.isNodeMultiRow(node);
        int numRows = 1;
        if (nodeMultiRow) {
            String desc = node.getDescription();
            String delim = "<br>|<BR>";
            String[] descArr = desc.split(delim);
            numRows += descArr.length;
        }
        if (firstChild && !this.isRootNodeVisible() && rootOfTree == parentNode) {
            boolean hLine = this.hasChildren(node) || !node.isLastNode();
            tableString.append(this.createPlusMinus(false, null, imgKey, !node.isLastNode(), hLine, addOns, node.getName(), alt, node.isEnabled(), numRows));
        } else if (rootOfTree != node || node.isLastNode() && this.hasChildren(node)) {
            tableString.append(this.createPlusMinus(true, null, imgKey, !node.isLastNode(), true, addOns, node.getName(), alt, node.isEnabled(), numRows));
        }
        return tableString;
    }

    @SASScope
    protected String createPlusMinus(boolean vLine, String nImage, boolean vLine2, boolean hLine, String addOns, String nodeName, String altText, boolean enabled) {
        return this.createPlusMinus(vLine, nImage, null, vLine2, hLine, addOns, nodeName, altText, enabled, 1);
    }

    protected String createPlusMinus(boolean vLine, String nImage, String nImageKey, boolean vLine2, boolean hLine, String addOns, String nodeName, String altText, boolean enabled, int numRows) {
        String vLineColor = "#CCCCCC";
        String vLine2Color = "#CCCCCC";
        String hLineColor = "#CCCCCC";
        StringBuffer nodeTemplate = new StringBuffer();
        nodeTemplate.append(addOns);
        String width = "7";
        if (nImage != null && nImage.length() > 0 || nImageKey != null && nImageKey.length() > 0) {
            width = "11";
        }
        nodeTemplate.append("<td").append(" width=\"" + width + "px\">");
        nodeTemplate.append("<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" height=\"100%\">");
        this.createPlusMinusConnector(nodeTemplate, vLine, vLineColor, nImage, nImageKey, numRows);
        this.createPlusMinusImage(nodeTemplate, nImage, nImageKey, nodeName, altText, enabled);
        this.createPlusMinusConnector(nodeTemplate, vLine2, vLine2Color, nImage, nImageKey, numRows);
        nodeTemplate.append("</table>");
        nodeTemplate.append("</td>");
        this.createPlusMinusIconConnector(nodeTemplate, hLine, hLineColor, nImage, nImageKey);
        return nodeTemplate.toString();
    }

    @SASScope
    protected StringBuffer createPlusMinusConnector(StringBuffer nodeTemplate, boolean vLine, String vLineColor, String nImage) {
        this.createPlusMinusConnector(nodeTemplate, vLine, vLineColor, nImage, null, 1);
        return nodeTemplate;
    }

    protected StringBuffer createPlusMinusConnector(StringBuffer nodeTemplate, boolean vLine, String vLineColor, String nImage, String nImageKey, int numRows) {
        int height;
        boolean netScape = false;
        nodeTemplate.append("<tr>");
        boolean imagePresent = false;
        if (nImage != null && nImage.length() > 0 || nImageKey != null && nImageKey.length() > 0) {
            imagePresent = true;
        }
        if (numRows > 1) {
            this.addPlusMinusTableCell(nodeTemplate, "6", null);
        } else {
            this.addPlusMinusTableCell(nodeTemplate, "6", "6", null);
        }
        if (vLine) {
            if (numRows > 1) {
                height = 9;
                height = imagePresent ? (height += (numRows - 1) * 8) : (height += (numRows - 1) * 14);
                this.addPlusMinusTableCell(nodeTemplate, "1", new Integer(height).toString(), vLineColor);
            } else if (imagePresent) {
                this.addPlusMinusTableCell(nodeTemplate, "1", "7", vLineColor);
            } else {
                this.addPlusMinusTableCell(nodeTemplate, "1", "12", vLineColor);
            }
        } else if (!netScape) {
            if (imagePresent) {
                this.addPlusMinusTableCell(nodeTemplate, "1", null);
            } else if (numRows > 1) {
                height = 11;
                this.addPlusMinusTableCell(nodeTemplate, "1", new Integer(height += (numRows - 1) * 11).toString(), null);
            } else {
                this.addPlusMinusTableCell(nodeTemplate, "1", "11", null);
            }
        }
        if (nImage != null && nImage.length() > 0 || nImageKey != null && nImageKey.length() > 0) {
            if (numRows > 1) {
                height = 17;
                if (numRows > 2) {
                    height += (numRows - 1) * 4;
                }
                this.addPlusMinusTableCell(nodeTemplate, "4", new Integer(height).toString(), null);
            } else {
                this.addPlusMinusTableCell(nodeTemplate, "4", "7", null);
            }
        }
        nodeTemplate.append("</tr>");
        return nodeTemplate;
    }

    @SASScope
    protected StringBuffer createPlusMinusImage(StringBuffer nodeTemplate, String nImage, String nodeName, String altText, boolean enabled) {
        this.createPlusMinusImage(nodeTemplate, nImage, null, nodeName, altText, enabled);
        return nodeTemplate;
    }

    protected StringBuffer createPlusMinusImage(StringBuffer nodeTemplate, String nImage, String nImageKey, String nodeName, String altText, boolean enabled) {
        if (nImage != null && nImage.length() > 0 || nImageKey != null && nImageKey.length() > 0) {
            nodeTemplate.append("<tr  valign=\"middle\">");
            nodeTemplate.append(" <td colspan=\"3\" align=\"center\" height=\"11\">");
            if (enabled) {
                this.addExpansionLink(nodeTemplate, nodeName);
            }
            nodeTemplate.append("<img src=\"");
            if (nImage != null) {
                nodeTemplate.append(this.getImageLocation()).append(nImage);
            } else if (nImageKey != null) {
                nodeTemplate.append(ComponentPropertyManager.getInstance(this.getRequest()).getImageURI(nImageKey, this.imageLocation));
            }
            nodeTemplate.append("\" border=\"0\"");
            if (altText != null) {
                nodeTemplate.append(" alt=\"").append(altText).append("\" ");
            }
            nodeTemplate.append(">");
            nodeTemplate.append("</a>");
            nodeTemplate.append("</td>");
            nodeTemplate.append("</tr>");
        }
        return nodeTemplate;
    }

    protected StringBuffer addDivExpansionLink(StringBuffer imageTemplate, String nodeName) {
        if (this.isFolderExpandCollapseEnabled()) {
            imageTemplate.append(" onclick=\"javaScript:sas_TreeView_onExpansion('").append(nodeName + "s', '" + this.getId() + "_childrenOf','").append(this.getFormObject().getName() + "')\"");
        }
        return imageTemplate;
    }

    @SASScope
    protected StringBuffer addExpansionLink(StringBuffer imageTemplate, String nodeName) {
        if (this.isFolderExpandCollapseEnabled()) {
            imageTemplate.append("<a href=\"javaScript:sas_TreeView_onExpansion('").append(nodeName + "s', '" + this.getId() + "_childrenOf','").append(this.getFormObject().getName() + "')\" class=\"anchor\">");
        }
        return imageTemplate;
    }

    @SASScope
    protected StringBuffer createPlusMinusIconConnector(StringBuffer nodeTemplate, boolean hLine, String hLineColor, String nImage) {
        this.createPlusMinusIconConnector(nodeTemplate, hLine, hLineColor, nImage, null);
        return nodeTemplate;
    }

    protected StringBuffer createPlusMinusIconConnector(StringBuffer nodeTemplate, boolean hLine, String hLineColor, String nImage, String nImageKey) {
        String width = "0";
        if (hLine) {
            width = nImage != null && nImage.length() == 0 || nImageKey != null && nImageKey.length() == 0 ? "14" : "10";
        }
        nodeTemplate.append("<td").append(" width=\"" + width + "px\">");
        nodeTemplate.append("<table  cellspacing=\"0\" cellpadding=\"0\" border=\"0\" height=\"1\" summary=\"\">");
        nodeTemplate.append("<tr>");
        if (hLine) {
            nodeTemplate.append("<td valign=\"center\" bgcolor=\"" + hLineColor + "\" width=\"" + width + "\" height=\"1\">");
            nodeTemplate.append("</td>");
        }
        nodeTemplate.append("</tr>");
        nodeTemplate.append("</table>");
        nodeTemplate.append("</td>");
        return nodeTemplate;
    }

    @SASScope
    protected StringBuffer addNodeImage(StringBuffer tableString, TreeNodeInterface node, TreeNodeInterface rootOfTree) {
        boolean addVLine = node.isExpanded() && node.getChildCount() != 0 && rootOfTree != node;
        tableString.append(this.createIcon(node.getName(), addVLine, node));
        return tableString;
    }

    @SASScope
    protected String createIcon(String nodeName, boolean addVLine, TreeNodeInterface node) {
        StringBuffer imageTemplate = new StringBuffer();
        boolean firstChild = false;
        TreeNodeInterface rNode = this.getRoot();
        if (rNode != null && node == (TreeNodeInterface)rNode.getChildAt(0)) {
            firstChild = true;
        }
        boolean nodeMultiRow = this.isNodeMultiRow(node);
        int numRows = 1;
        if (nodeMultiRow) {
            String desc = node.getDescription();
            String delim = "<br>|<BR>";
            String[] descArr = desc.split(delim);
            numRows += descArr.length;
        }
        imageTemplate.append("<td valign=\"middle\" width=\"24px\"><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" height=\"100%\">");
        this.createIconConnector(imageTemplate, false, "#CCCCCC", true, firstChild, numRows);
        this.addFolderImage(imageTemplate, nodeName, node);
        this.createIconConnector(imageTemplate, addVLine, "#CCCCCC", false, firstChild, numRows);
        imageTemplate.append("</table>");
        imageTemplate.append("</td>");
        return imageTemplate.toString();
    }

    protected StringBuffer createIconConnector(StringBuffer nodeTemplate, boolean vLine, String vLineColor, boolean row1, boolean firstChild, int numRows) {
        boolean netScape = false;
        nodeTemplate.append("<tr>");
        if (numRows > 1) {
            int height = 0;
            if (row1) {
                height = 8;
                height = firstChild && numRows > 2 || numRows > 2 ? (height += (numRows - 1) * 6) : (height += (numRows - 1) * 4);
            } else {
                height = 9;
                height += (numRows - 1) * 8;
            }
            this.addIconTableCell(nodeTemplate, "10", new Integer(height).toString(), null);
            if (vLine) {
                this.addIconTableCell(nodeTemplate, "1", new Integer(height).toString(), vLineColor);
            } else if (!netScape) {
                this.addIconTableCell(nodeTemplate, "1", new Integer(height).toString(), null);
            }
            this.addIconTableCell(nodeTemplate, "13", new Integer(height).toString(), null);
        } else {
            this.addIconTableCell(nodeTemplate, "10", "4", null);
            if (vLine) {
                this.addIconTableCell(nodeTemplate, "1", "5", vLineColor);
            } else if (!netScape) {
                this.addIconTableCell(nodeTemplate, "1", "4", null);
            }
            this.addIconTableCell(nodeTemplate, "13", "4", null);
        }
        nodeTemplate.append("</tr>");
        return nodeTemplate;
    }

    protected StringBuffer addDivFolderImageTag(StringBuffer imageTemplate, TreeNodeInterface node) {
        String img;
        String altText = null;
        String imgURI = null;
        if (!node.isEnabled()) {
            img = node.getDisabledImage();
            if (img != null) {
                altText = node.getDisabledImageAltText();
                imgURI = this.buildImageURI(node, img);
            } else {
                img = node.getExpandedImage();
                if (img != null) {
                    altText = node.getExpandedImageAltText();
                    imgURI = this.buildImageURI(node, img);
                } else {
                    img = node.getDefaultImage();
                    if (img != null) {
                        altText = node.getDefaultImageAltText();
                        imgURI = this.buildImageURI(node, img);
                    } else {
                        imgURI = this.getImageURI("DISABLED_FOLDER", "Folder_Disabled", node);
                    }
                }
            }
        } else if (node.isExpanded()) {
            img = node.getExpandedImage();
            if (img != null) {
                altText = node.getExpandedImageAltText();
                imgURI = this.buildImageURI(node, img);
            } else {
                img = node.getDefaultImage();
                if (img != null) {
                    altText = node.getDefaultImageAltText();
                    imgURI = this.buildImageURI(node, img);
                } else {
                    imgURI = this.getImageURI("OPEN_FOLDER", "Folder_Open", node);
                }
            }
        } else {
            img = node.getDefaultImage();
            if (img != null) {
                altText = node.getDefaultImageAltText();
                imgURI = this.buildImageURI(node, img);
            } else {
                imgURI = !this.hasChildren(node) ? this.getImageURI("LEAF_ICON", "Tree_View_Leaf_Node", node) : this.getImageURI("CLOSED_FOLDER", "Folder_Closed", node);
            }
        }
        imageTemplate.append("<IMG src=\"").append(imgURI);
        String imgClass = this.getStyle(node, "TREEVIEW_IMAGE");
        if (imgClass != null) {
            imageTemplate.append("\" class=\"").append(imgClass);
        }
        if (node.isEnabled() && this.hasChildren(node)) {
            imageTemplate.append(" ").append(this.getStyle(node, "TREEVIEW_CURSOR_HAND"));
        }
        imageTemplate.append("\"");
        if (altText != null) {
            imageTemplate.append(" alt=\"").append(altText).append("\"");
        }
        return imageTemplate;
    }

    @SASScope
    protected StringBuffer addFolderImageTag(StringBuffer imageTemplate, TreeNodeInterface node) {
        String img;
        String altText = null;
        String imgURI = null;
        if (!node.isEnabled()) {
            img = node.getDisabledImage();
            if (img != null) {
                altText = node.getDisabledImageAltText();
                imgURI = this.buildImageURI(node, img);
            } else {
                img = node.getExpandedImage();
                if (img != null) {
                    altText = node.getExpandedImageAltText();
                    imgURI = this.buildImageURI(node, img);
                } else {
                    img = node.getDefaultImage();
                    if (img != null) {
                        altText = node.getDefaultImageAltText();
                        imgURI = this.buildImageURI(node, img);
                    } else {
                        imgURI = this.getImageURI("DISABLED_FOLDER", "Folder_Disabled", node);
                    }
                }
            }
        } else if (node.isExpanded()) {
            img = node.getExpandedImage();
            if (img != null) {
                altText = node.getExpandedImageAltText();
                imgURI = this.buildImageURI(node, img);
            } else {
                img = node.getDefaultImage();
                if (img != null) {
                    altText = node.getDefaultImageAltText();
                    imgURI = this.buildImageURI(node, img);
                } else {
                    imgURI = this.getImageURI("OPEN_FOLDER", "Folder_Open", node);
                }
            }
        } else {
            img = node.getDefaultImage();
            if (img != null) {
                altText = node.getDefaultImageAltText();
                imgURI = this.buildImageURI(node, img);
            } else {
                imgURI = !this.hasChildren(node) ? this.getImageURI("LEAF_ICON", "Tree_View_Leaf_Node", node) : this.getImageURI("CLOSED_FOLDER", "Folder_Closed", node);
            }
        }
        imageTemplate.append("<img src=\"").append(imgURI);
        String imgClass = this.getStyle(node, "TREEVIEW_IMAGE");
        if (imgClass != null) {
            imageTemplate.append("\" class=\"").append(imgClass);
        }
        if (altText != null) {
            imageTemplate.append("\" alt=\"").append(altText);
        }
        imageTemplate.append("\" border=\"0\"");
        imageTemplate.append(">");
        return imageTemplate;
    }

    private String buildImageURI(TreeNodeInterface node, String image) {
        String imageLoc = node != null && node.getImageLocation() != null ? node.getImageLocation() : this.getImageLocation();
        return imageLoc + image;
    }

    @SASScope
    protected StringBuffer addFolderImage(StringBuffer imageTemplate, String nodeName, TreeNodeInterface node) {
        boolean useAnchor;
        imageTemplate.append("<tr  valign=\"middle\">");
        imageTemplate.append("<td colspan=\"").append("3\"").append(" align=\"center\"").append(" height=\"11\">");
        boolean enabled = node.isEnabled();
        boolean bl = useAnchor = enabled && this.hasChildren(node);
        if (useAnchor) {
            this.addExpansionLink(imageTemplate, nodeName);
        }
        this.addFolderImageTag(imageTemplate, node);
        if (useAnchor) {
            imageTemplate.append("</a>");
        }
        imageTemplate.append("</td>");
        imageTemplate.append("</tr>");
        return imageTemplate;
    }

    protected void addDivText(StringBuffer tableString, TreeNodeInterface node) {
        if (this.nodeMultiRow) {
            tableString.append("<div>");
        }
        if (this.isCheckboxSelectionMode() && (!this.isOnlyLeavesSelectable() || node.isLeaf())) {
            tableString.append("<input name=\"").append(this.getId()).append("\" id=\"").append(this.getId()).append("\" type=\"").append("checkbox\"").append("\" value=\"").append(node.getName()).append("\"/>");
        }
        if (!this.isUsingURLLinks()) {
            this.addDivTextSpan(tableString, node);
        } else if (this.isURL(node)) {
            this.addDivLink(tableString, node);
        } else {
            this.addDivTextSpan(tableString, node);
        }
        if (this.nodeMultiRow) {
            tableString.append("</div>");
        }
    }

    @SASScope
    protected StringBuffer addText(StringBuffer tableString, TreeNodeInterface node, boolean nowrap) {
        if (this.isCheckboxSelectionMode() && (!this.isOnlyLeavesSelectable() || node.isLeaf())) {
            tableString.append("<td>").append("<input name=\"").append(this.getId()).append("\" id=\"").append(this.getId()).append("\" type=\"").append("checkbox\"").append("\" value=\"").append(node.getName()).append("\"/>").append("</td>");
        }
        if (!this.isUsingURLLinks()) {
            tableString.append(nowrap ? "<td nowrap=\"nowrap\"" : "<td");
            tableString.append(this.isImageVisible() ? " valign=\"middle\"" : " valign=\"top\"");
            tableString.append(" class=\"").append(this.getNodeCellStyle(node)).append("\"");
            tableString.append(">");
            this.addTextSpan(tableString, node);
            tableString.append("</td>");
        } else if (this.isURL(node)) {
            this.addLink(tableString, node, false);
        } else {
            tableString.append(nowrap ? "<td nowrap=\"nowrap\"" : "<td");
            tableString.append(this.isImageVisible() ? " valign=\"middle\"" : " valign=\"top\"");
            tableString.append(">");
            this.addTextSpan(tableString, node);
            tableString.append("</td>");
        }
        return tableString;
    }

    protected StringBuffer addDivTextSpan(StringBuffer tableString, TreeNodeInterface node) {
        tableString.append("<span class=\"");
        String key = "TREEVIEW_TEXT";
        if (!node.isEnabled()) {
            key = "TREEVIEW_DISABLED";
        }
        tableString.append(this.getStyle(node, key));
        tableString.append("\"");
        tableString.append(">");
        tableString.append(TreeView.reformatTreeText(node.getText()));
        tableString.append("</span>");
        if (node.getDescription() != null) {
            tableString.append("<br><span class=\"").append(this.getStyle(node, "TREEVIEW_DESCRIPTION")).append("\">").append(node.getDescription()).append("</span>");
        }
        return tableString;
    }

    @SASScope
    protected StringBuffer addTextSpan(StringBuffer tableString, TreeNodeInterface node) {
        tableString.append("<span class=\"");
        String key = "TREEVIEW_TEXT";
        if (!node.isEnabled()) {
            key = "TREEVIEW_DISABLED";
        }
        tableString.append(this.getStyle(node, key));
        tableString.append("\"");
        tableString.append(">");
        tableString.append(TreeView.reformatTreeText(node.getText()));
        tableString.append("</span>");
        if (node.getDescription() != null) {
            tableString.append("<br><span class=\"").append(this.getStyle(node, "TREEVIEW_DESCRIPTION")).append("\">").append(node.getDescription()).append("</span>");
        }
        return tableString;
    }

    protected void addDivLink(StringBuffer tableString, TreeNodeInterface node) {
        tableString.append("<a ");
        String stylekey = "TREEVIEW_LINK";
        if (this.isNodeSelectionVisible()) {
            this.addOnSelect(tableString, node);
            if (this.getSelectedNode() != null && this.getSelectedNode().equalsIgnoreCase(node.getName())) {
                stylekey = "TREEVIEW_LINKACTIVE";
            }
        }
        String style = this.getLinkStyle(node, stylekey);
        tableString.append(" class=\"").append(style).append("\"");
        tableString.append(" href=\"").append(node.getURL()).append("\" ");
        String target = node.getTarget() != null ? node.getTarget() : this.getTarget();
        tableString.append("target= \"").append(target).append("\" ");
        this.addAccessibility(tableString, node);
        tableString.append(">");
        tableString.append(TreeView.reformatTreeText(node.getText()));
        tableString.append("</a>");
        if (node.getDescription() != null) {
            tableString.append("<br><span class=\"").append(this.getStyle(node, "TREEVIEW_DESCRIPTION")).append("\">").append(node.getDescription()).append("</span>");
        }
    }

    @SASScope
    protected StringBuffer addLink(StringBuffer tableString, TreeNodeInterface node, boolean isImage) {
        if (isImage) {
            tableString.append("<td nowrap=\"nowrap\"");
        } else {
            tableString.append("<td");
        }
        tableString.append(this.isImageVisible() ? " valign=\"middle\"" : " valign=\"top\"");
        tableString.append(">");
        if (!isImage) {
            this.addStartTableRowDataStyle(tableString, node);
        }
        tableString.append("<a ");
        String stylekey = "TREEVIEW_LINK";
        if (this.isNodeSelectionVisible()) {
            this.addOnSelect(tableString, node);
            if (this.getSelectedNode() != null && this.getSelectedNode().equalsIgnoreCase(node.getName())) {
                stylekey = "TREEVIEW_LINKACTIVE";
            }
        }
        String style = this.getLinkStyle(node, stylekey);
        tableString.append(" class=\"").append(style).append("\"");
        tableString.append(" href=\"").append(node.getURL()).append("\" ");
        String target = node.getTarget() != null ? node.getTarget() : this.getTarget();
        tableString.append("target= \"").append(target).append("\" ");
        this.addAccessibility(tableString, node);
        tableString.append(">");
        tableString.append(TreeView.reformatTreeText(node.getText()));
        tableString.append("</a>");
        if (node.getDescription() != null) {
            tableString.append("<br><span class=\"").append(this.getStyle(node, "TREEVIEW_DESCRIPTION")).append("\">").append(node.getDescription()).append("</span>");
        }
        if (!isImage) {
            this.addEndTableRowData(tableString);
        }
        tableString.append("</td>");
        return tableString;
    }

    @SASScope
    protected StringBuffer addOnSelect(StringBuffer jScript, TreeNodeInterface node) {
        jScript.append(" id=\"").append(node.getName()).append("s").append("\" onClick=\"sas_TreeView_onSelect(this, '").append(this.getLinkStyle(node, "TREEVIEW_LINK")).append("','").append(this.getLinkStyle(node, "TREEVIEW_LINKACTIVE")).append("')\"");
        return jScript;
    }

    @SASScope
    protected StringBuffer addAccessibility(StringBuffer tableString, TreeNodeInterface treenode) {
        String title = treenode.getTitle();
        int tabIndex = treenode.getTabIndex();
        String accessKey = treenode.getAccessKey();
        if (tabIndex != -1) {
            tableString.append(" tabindex=\"" + tabIndex + "\" ");
        }
        if (title != null) {
            tableString.append(" title=\"" + title + "\" ");
        }
        if (accessKey != null) {
            tableString.append(" accesskey=\"" + accessKey + "\" ");
        }
        return tableString;
    }

    @SASScope
    protected boolean isURL(TreeNodeInterface node) {
        return node.getURL() != null && !node.getURL().trim().equals(".") && !node.getURL().trim().equals("") && node.isEnabled();
    }

    protected String getDivHTMLTreeTextImage(String toLookFor, String PMLink, TreeNodeInterface node, String addOns, TreeNodeInterface parentNode, TreeNodeInterface rootOfTree, boolean firstChild, String selectedNode) {
        StringBuffer tableString = new StringBuffer(addOns);
        if (node.getName().equals(toLookFor)) {
            node.setExpanded(!node.isExpanded());
        }
        String plusMinusLink = null;
        if (node.isEnabled() && this.isFolderExpandCollapseEnabled()) {
            plusMinusLink = "javaScript:sas_TreeView_onExpansion('" + node.getName() + "','" + this.getId() + "_childrenOf','" + this.getFormObject().getName() + "')";
        }
        if (this.isImageVisible()) {
            this.addDivNodeImage(tableString, node, plusMinusLink);
        }
        if (this.nodeMultiRow) {
            int nRows = this.getNRows(node.getText()) + this.getNRows(node.getDescription());
            String className = this.getStyle(node, "TREEVIEW_BACKGROUND_IMAGE");
            for (int i = 1; i < nRows; ++i) {
                tableString.append("<br>").append(addOns).append("<span class=\"").append(className).append("\"></span>");
            }
            tableString.append("</div>");
        }
        this.addDivText(tableString, node);
        return tableString.toString();
    }

    protected void addDivNodeImage(StringBuffer tableString, TreeNodeInterface node, String plusMinusLink) {
        boolean clickable;
        String img;
        String altText = null;
        String imgURI = null;
        tableString.append("<IMG");
        if (!node.isEnabled()) {
            img = node.getDisabledImage();
            if (img != null) {
                altText = node.getDisabledImageAltText();
                imgURI = this.buildImageURI(node, img);
            } else {
                img = node.getExpandedImage();
                if (img != null) {
                    altText = node.getExpandedImageAltText();
                    imgURI = this.buildImageURI(node, img);
                } else {
                    img = node.getDefaultImage();
                    if (img != null) {
                        altText = node.getDefaultImageAltText();
                        imgURI = this.buildImageURI(node, img);
                    } else {
                        imgURI = this.getImageURI("DISABLED_FOLDER", "Folder_Disabled", node);
                    }
                }
            }
        } else if (node.isExpanded()) {
            img = node.getExpandedImage();
            if (img != null) {
                altText = node.getExpandedImageAltText();
                imgURI = this.buildImageURI(node, img);
            } else {
                img = node.getDefaultImage();
                if (img != null) {
                    altText = node.getDefaultImageAltText();
                    imgURI = this.buildImageURI(node, img);
                } else {
                    imgURI = this.getImageURI("OPEN_FOLDER", "Folder_Open", node);
                }
            }
        } else {
            img = node.getDefaultImage();
            if (img != null) {
                altText = node.getDefaultImageAltText();
                imgURI = this.buildImageURI(node, img);
            } else {
                imgURI = this.hasChildren(node) ? this.getImageURI("CLOSED_FOLDER", "Folder_Closed", node) : this.getImageURI("LEAF_ICON", "Tree_View_Leaf_Node", node);
            }
        }
        tableString.append(" src=\"").append(imgURI).append("\"");
        String imgClass = this.getStyle(node, "TREEVIEW_IMAGE");
        boolean bl = clickable = node.isEnabled() && this.hasChildren(node);
        if (imgClass != null || clickable) {
            tableString.append(" class=\"");
            if (imgClass != null) {
                tableString.append(imgClass);
            }
            if (clickable) {
                tableString.append(" ").append(this.getStyle(node, "TREEVIEW_CURSOR_HAND"));
            }
            tableString.append("\"");
        }
        if (clickable) {
            tableString.append(" onclick=\"").append(plusMinusLink).append("\"");
        }
        if (altText != null) {
            tableString.append(" alt=\"").append(altText).append("\"");
        }
        tableString.append(">");
    }

    protected void addDivPlusMinusImage(StringBuffer tableString, TreeNodeInterface node, TreeNodeInterface parentNode, TreeNodeInterface rootOfTree, boolean firstChild, String plusMinusLink) {
        boolean isExpanded = node.isExpanded();
        boolean isLast = node.isLastNode();
        boolean hasChild = this.hasChildren(node);
        String className = this.getStyle(node, "TREEVIEW_BACKGROUND_IMAGE");
        tableString.append("<span");
        if (className != null) {
            tableString.append(" class=\"").append(className).append("\"");
        }
        String imgURI = null;
        if (firstChild && !this.isRootNodeVisible() && rootOfTree == parentNode) {
            if (hasChild) {
                imgURI = isExpanded ? (isLast ? this.getImageURI("MINUS_ONLY_NODE", "Only_Node_Minus", node) : this.getImageURI("MISSING_ROOT_MINUS_NODE", "Missing_Root_Minus_Node", node)) : (isLast ? this.getImageURI("PLUS_ONLY_NODE", "Only_Node_Plus", node) : this.getImageURI("MISSING_ROOT_PLUS_NODE", "Missing_Root_Plus_Node", node));
            } else if (!isLast) {
                imgURI = this.getImageURI("FIRST_NODE", "First_Node", node);
            }
        } else if (isLast && hasChild) {
            imgURI = isExpanded ? this.getImageURI("MINUS_LAST_NODE", "Minus_Last_Node", node) : this.getImageURI("PLUS_LAST_NODE", "Plus_Last_Node", node);
        } else if (!isLast && hasChild && rootOfTree != node) {
            imgURI = isExpanded ? this.getImageURI("MINUS_NODE", "Minus_Node", node) : this.getImageURI("PLUS_NODE", "Plus_Node", node);
        } else if (!isLast && !hasChild && rootOfTree != node && this.isUsePlusMinus()) {
            imgURI = this.getImageURI("NODE", "Node", node);
        } else if (isLast && !hasChild && rootOfTree != node && this.isUsePlusMinus()) {
            imgURI = this.getImageURI("LAST_NODE", "Last_Node", node);
        }
        if (imgURI != null) {
            tableString.append(" style=\"background:url('").append(imgURI).append("')\"");
        }
        tableString.append(" onclick=\"").append(plusMinusLink).append("\"");
        tableString.append("></span>");
    }

    @SASScope
    protected String getHTMLTreeTextImage(String toLookFor, String PMLink, TreeNodeInterface node, String addOns, TreeNodeInterface parentNode, TreeNodeInterface rootOfTree, boolean firstChild, String selectedNode) {
        StringBuffer tableString = new StringBuffer("");
        tableString.append("<table ");
        tableString.append("id=\"");
        tableString.append(node.getName() + "\"");
        tableString.append(" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" height=\"1\" summary=\"\"");
        tableString.append(">");
        tableString.append("<tr>");
        if (node.getName().equals(toLookFor)) {
            node.setExpanded(!node.isExpanded());
        }
        tableString.append(addOns);
        String plusMinusLink = null;
        if (node.isEnabled() && this.isFolderExpandCollapseEnabled()) {
            plusMinusLink = "javaScript:sas_TreeView_onExpansion('" + node.getName() + "','" + this.getId() + "_childrenOf','" + this.getFormObject().getName() + "')";
        }
        if (firstChild && !this.isRootNodeVisible() && rootOfTree == parentNode) {
            if (this.hasChildren(node)) {
                if (node.isExpanded() && !node.isLastNode()) {
                    this.addPlusMinusImageTop(tableString, plusMinusLink, null, "Missing_Root_Minus_Node");
                } else if (!node.isExpanded() && !node.isLastNode()) {
                    this.addPlusMinusImageTop(tableString, plusMinusLink, null, "Missing_Root_Plus_Node");
                }
                if (node.isExpanded() && node.isLastNode()) {
                    this.addPlusMinusImageTop(tableString, plusMinusLink, null, "Only_Node_Minus");
                } else if (!node.isExpanded() && node.isLastNode()) {
                    this.addPlusMinusImageTop(tableString, plusMinusLink, null, "Only_Node_Plus");
                }
            } else if (!node.isLastNode()) {
                this.addPlusMinusImageTop(tableString, plusMinusLink, null, "First_Node");
            } else {
                this.addPlusMinusImageTop(tableString, plusMinusLink, null, "Blank");
            }
        } else if (node.isLastNode() && this.hasChildren(node)) {
            if (node.isExpanded()) {
                this.addPlusMinusImageTop(tableString, plusMinusLink, null, "Minus_Last_Node");
            } else {
                this.addPlusMinusImageTop(tableString, plusMinusLink, null, "Plus_Last_Node");
            }
        } else if (!node.isLastNode() && this.hasChildren(node) && rootOfTree != node) {
            if (node.isExpanded()) {
                this.addPlusMinusImage(tableString, plusMinusLink, null, "Minus_Node");
            } else {
                this.addPlusMinusImage(tableString, plusMinusLink, null, "Plus_Node");
            }
        } else if (!node.isLastNode() && !this.hasChildren(node) && rootOfTree != node) {
            if (this.isUsePlusMinusLines()) {
                tableString.append("<td>");
                tableString.append("<img src=\"");
                ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(this.getRequest());
                if (this.isUsePlusMinus()) {
                    tableString.append(cpm.getImageURI("Node", this.imageLocation));
                } else {
                    tableString.append(cpm.getImageURI("Blank", this.imageLocation));
                }
                tableString.append("\" border=\"0\" width=\"16\" height=\"22\"></td>\n");
            }
        } else if (node.isLastNode() && !this.hasChildren(node) && rootOfTree != node && this.isUsePlusMinusLines()) {
            tableString.append("<td>");
            tableString.append("<img src=\"");
            ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(this.getRequest());
            if (this.isUsePlusMinus()) {
                tableString.append(cpm.getImageURI("Last_Node", this.imageLocation));
            } else {
                tableString.append(cpm.getImageURI("Blank", this.imageLocation));
            }
            tableString.append("\" border=\"0\" width=\"16\" height=\"22\"></td>\n");
        }
        tableString.append("<td valign=\"top\">");
        if (this.isImageVisible()) {
            if (node.isEnabled() && this.hasChildren(node) && this.isFolderExpandCollapseEnabled()) {
                tableString.append("<a href=\"");
                tableString.append(plusMinusLink);
                tableString.append("\"");
                tableString.append(">");
            }
            this.addFolderImageTag(tableString, node);
            if (this.hasChildren(node) && this.isFolderExpandCollapseEnabled()) {
                tableString.append("</a>");
            }
        }
        tableString.append("</td>");
        this.addText(tableString, node, true);
        tableString.append("</tr>");
        tableString.append("</table>");
        return tableString.toString();
    }

    @SASScope
    protected void addPlusMinusImageTop(StringBuffer tableString, String plusMinusLink, String img) {
        this.addPlusMinusImageTop(tableString, plusMinusLink, img, null);
    }

    protected void addPlusMinusImageTop(StringBuffer tableString, String plusMinusLink, String img, String imgKey) {
        tableString.append("<td valign=\"top\">");
        this.addPlusMinusImageCommon(tableString, plusMinusLink, img, imgKey);
    }

    @SASScope
    protected void addPlusMinusImage(StringBuffer tableString, String plusMinusLink, String img) {
        this.addPlusMinusImage(tableString, plusMinusLink, img, null);
    }

    protected void addPlusMinusImage(StringBuffer tableString, String plusMinusLink, String img, String imgKey) {
        tableString.append("<td>");
        this.addPlusMinusImageCommon(tableString, plusMinusLink, img, imgKey);
    }

    @SASScope
    protected void addPlusMinusImageCommon(StringBuffer tableString, String plusMinusLink, String img) {
        this.addPlusMinusImageCommon(tableString, plusMinusLink, img, null);
    }

    protected void addPlusMinusImageCommon(StringBuffer tableString, String plusMinusLink, String img, String imgKey) {
        if (plusMinusLink != null && this.isFolderExpandCollapseEnabled()) {
            tableString.append("<a href=\"");
            tableString.append(plusMinusLink);
            tableString.append("\">");
        }
        tableString.append("<img src=\"");
        ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(this.getRequest());
        if (img != null) {
            if (this.isUsePlusMinus()) {
                tableString.append(this.getImageLocation());
                tableString.append(img);
            } else {
                tableString.append(cpm.getImageURI("Blank", this.imageLocation));
            }
        } else if (imgKey != null) {
            if (!this.isUsePlusMinus()) {
                imgKey = "Blank";
            } else if (!this.isUsePlusMinusLines()) {
                imgKey = imgKey.indexOf("Minus") >= 0 ? "Minus_No_Lines" : "Plus_No_Lines";
            }
            String imageURI = cpm.getImageURI(imgKey, this.imageLocation);
            tableString.append(imageURI);
        }
        tableString.append("\" border=\"0\" width=\"16\" height=\"22\">");
        if (plusMinusLink != null && this.isFolderExpandCollapseEnabled()) {
            tableString.append("</a>");
        }
        tableString.append("</td>\n");
    }

    @Override
    public void setFormObject(Form form) {
        this.formObject = form;
    }

    @Override
    public Form getFormObject() {
        if (this.formObject == null) {
            this.formObject = this.getDefaultFormObject();
        }
        return this.formObject;
    }

    @Override
    public Form getDefaultFormObject() {
        HttpServletResponse response;
        Form f = new Form(this.getId() + "_Form");
        String action = "";
        HttpServletRequest request = this.getRequest();
        if (request != null) {
            f.setRequest(request);
            action = request.getRequestURI();
        }
        if ((response = this.getResponse()) != null) {
            action = response.encodeURL(action);
        }
        f.setAction(action);
        return f;
    }

    @Override
    public HashMap getAdditionalParameters() {
        return this.additionalParameters;
    }

    @Override
    public void setAdditionalParameters(HashMap map) {
        this.additionalParameters = map;
    }

    @Override
    public void setAdditionalParameter(String name, String value) {
        if (this.additionalParameters == null) {
            this.additionalParameters = new HashMap(5);
        }
        this.additionalParameters.put(name, value);
    }

    @Override
    public boolean isFormEnabled() {
        return this.formEnabled;
    }

    @Override
    public void setFormEnabled(boolean enabled) {
        this.formEnabled = enabled;
    }

    @SASScope
    public void setJSType(String value) {
        this.JSType = value;
    }

    @SASScope
    public String getJSTreeType() {
        return this.JSType;
    }

    public boolean isDelayExecutionEnabled() {
        return this.delayExecutionEnabled;
    }

    public void setDelayExecutionEnabled(boolean enabled) {
        this.delayExecutionEnabled = enabled;
    }

    public boolean isRenderUsingDivs() {
        return this.renderUsingDivs;
    }

    public void setRenderUsingDivs(boolean enabled) {
        this.renderUsingDivs = enabled;
    }

    @Override
    public Map getStyleMap() {
        return this.componentStyleMap;
    }

    private static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0) {
            ImmutableStyleInfo treeTextStyle = new ImmutableStyleInfo("treeText");
            ImmutableStyleInfo treeSelectedStyle = new ImmutableStyleInfo("treeSelected");
            ImmutableStyleInfo treeDisabledStyle = new ImmutableStyleInfo("treeDisabled");
            ImmutableStyleInfo treeDescriptionStyle = new ImmutableStyleInfo("treeDescription");
            ImmutableStyleInfo treeImageStyle = new ImmutableStyleInfo("treeImage");
            ImmutableStyleInfo treePaneStyle = new ImmutableStyleInfo("treePane");
            ImmutableStyleInfo treeTableStyle = new ImmutableStyleInfo();
            ImmutableStyleInfo trvFloatStyle = new ImmutableStyleInfo("trvfl");
            ImmutableStyleInfo trvBackgroundImageStyle = new ImmutableStyleInfo("trvb");
            ImmutableStyleInfo trvBackgroundImageStyle1 = new ImmutableStyleInfo("trvg");
            ImmutableStyleInfo trvCursorHandStyle = new ImmutableStyleInfo("trvc");
            ImmutableStyleInfo treeImageSpaceStyle = new ImmutableStyleInfo("treeImageSpace");
            ImmutableStyleInfo treeDivImageSpaceStyle = new ImmutableStyleInfo("treeDivImageSpace");
            defaultStyleMap.put("TREEVIEW_TEXT", treeTextStyle);
            defaultStyleMap.put("TREEVIEW_SELECTED", treeSelectedStyle);
            defaultStyleMap.put("TREEVIEW_DISABLED", treeDisabledStyle);
            defaultStyleMap.put("TREEVIEW_DESCRIPTION", treeDescriptionStyle);
            defaultStyleMap.put("TREEVIEW_IMAGE", treeImageStyle);
            defaultStyleMap.put("TREEVIEW_PANE", treePaneStyle);
            defaultStyleMap.put("TREEVIEW_TABLE", treeTableStyle);
            defaultStyleMap.put("TREEVIEW_FLOAT", trvFloatStyle);
            defaultStyleMap.put("TREEVIEW_BACKGROUND_IMAGE", trvBackgroundImageStyle);
            defaultStyleMap.put("TREEVIEW_BACKGROUND_IMAGE1", trvBackgroundImageStyle1);
            defaultStyleMap.put("TREEVIEW_CURSOR_HAND", trvCursorHandStyle);
            defaultStyleMap.put("TREEVIEW_IMAGE_SPACE", treeImageSpaceStyle);
            defaultStyleMap.put("TREEVIEW_DIV_IMAGE_SPACE", treeDivImageSpaceStyle);
        }
    }

    @SASScope
    public static void servletInvocationMethod(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String treename = request.getParameter("treename");
        TreeView tv = (TreeView)request.getSession().getAttribute(treename);
        if (tv != null) {
            tv.getNodeAndExpandCollapse(request, response);
        } else {
            CommonLoggerInterface log = LoggerRepository2.getLogger((String)TreeView.class.getPackage().getName(), null);
            log.error(RB.getStringResource(RB_KEY, "nullTreeParameter.txt", request.getLocale()), (Throwable)new NullPointerException(RB.getStringResource(RB_KEY, "nullTreeParameter.txt", request.getLocale())));
        }
    }

    @SASScope
    public static void servletInvocationMethod(HttpServletRequest request, HttpServletResponse response, TreeView tree) throws IOException {
        String charset = BaseUtil.getOutputCharacterEncoding(request);
        response.setContentType("text/html; charset=" + charset);
        if (tree == null) {
            throw new NullPointerException(RB.getStringResource(RB_KEY, "nullTreeParameter.txt", request.getLocale()));
        }
        tree.getNodeAndExpandCollapse(request, response);
    }

    @SASScope
    public void getNodeAndExpandCollapse(HttpServletRequest request, HttpServletResponse response) throws IOException {
        TreeExpandAction action = new TreeExpandAction(this);
        if (this.getRemoteScripting() == 1) {
            action.setUseIFrame(true);
        } else {
            action.setUseIFrame(false);
        }
        action.expand(request, response);
    }

    @SASScope
    public static TreeNodeInterface findNode(String name, TreeNodeInterface node) {
        if (name.equals(node.getName())) {
            return node;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            TreeNodeInterface child = TreeView.findNode(name, (TreeNodeInterface)node.getChildAt(i));
            if (child == null) continue;
            return child;
        }
        return null;
    }

    @SASScope
    public TreeNodeInterface findNode(String name) {
        if (this.nodeMap == null) {
            return null;
        }
        return (TreeNodeInterface)this.nodeMap.get(name);
    }

    @SASScope
    public void clearNodeCache() {
        this.nodeMap = null;
    }

    @SASScope
    public Form getRemoteScriptForm() {
        if (this.rsForm == null) {
            TreeViewFull.RemoteScriptForm f = new TreeViewFull.RemoteScriptForm(this);
            f.addParm("treename", "");
            f.addParm("childrenOf", "");
            f.addParm("nodeState", "");
            this.rsForm = f;
        }
        return this.rsForm;
    }

    @SASScope
    public void setRemoteScriptForm(Form rsForm) {
        this.rsForm = rsForm;
    }

    @SASScope
    public TreeNodeInterface[] getSelectedNodes(HttpServletRequest request) {
        String[] vals = request.getParameterValues(this.getId());
        TreeNodeInterface[] ret = new TreeNodeInterface[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            ret[i] = this.findExpandedNode(vals[i], this.getRoot());
        }
        return ret;
    }

    private TreeNodeInterface findExpandedNode(String name, TreeNodeInterface node) {
        if (node.getName().equals(name)) {
            return node;
        }
        if (node.isExpanded()) {
            for (int ci = 0; ci < node.getChildCount(); ++ci) {
                TreeNodeInterface found = this.findExpandedNode(name, (TreeNodeInterface)node.getChildAt(ci));
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    public TreeNodeTransform getTransform() {
        return this.transform;
    }

    public void setTransform(TreeNodeTransform transform) {
        this.transform = transform;
    }

    public static void sort(MutableTreeNode node, Comparator comparator) {
        int i;
        Object[] children = new Object[node.getChildCount()];
        int nodecnt = node.getChildCount();
        for (i = 0; i < nodecnt; ++i) {
            children[i] = node.getChildAt(i);
            if (!(children[i] instanceof TreeNodeInterface)) continue;
            ((TreeNodeInterface)children[i]).setLastNode(false);
        }
        Arrays.sort(children, comparator);
        TreeView.removeAllChildren(node);
        for (i = 0; i < children.length; ++i) {
            DefaultMutableTreeNode mutableNode = (DefaultMutableTreeNode)children[i];
            node.insert(mutableNode, i);
            TreeView.sort(mutableNode, comparator);
        }
    }

    private static void removeAllChildren(MutableTreeNode node) {
        for (int i = node.getChildCount() - 1; i >= 0; --i) {
            node.remove(i);
        }
    }

    @SASScope
    public void setRemoteScripting(int remote_script_state) {
        this.remote_script_state = remote_script_state;
    }

    @SASScope
    public int getRemoteScripting() {
        return this.remote_script_state;
    }

    private String getImageURI(String treeImageKey, String webImageKey, TreeNodeInterface node) {
        String nonDefaultImageName = this.getNonDefaultImageName(treeImageKey);
        if (nonDefaultImageName != null) {
            return this.buildImageURI(node, nonDefaultImageName);
        }
        String overrideImageLocation = node != null && node.getImageLocation() != null ? node.getImageLocation() : this.imageLocation;
        return ComponentPropertyManager.getInstance(this.getRequest()).getImageURI(webImageKey, overrideImageLocation);
    }

    @SASScope
    String getNonDefaultImageName(String treeImageKey) {
        String imageName = (String)this.getImageMap().get(treeImageKey);
        if (imageName == null) {
            return null;
        }
        if (imageName.equals((String)defaultImageMap.get(treeImageKey))) {
            return null;
        }
        return imageName;
    }

    static {
        JavaScriptIncludeHandler.addAlias(TreeView.class, "TREEVIEW");
    }

    @SASScope
    public static class DefaultTreeNodeTransform
    implements TreeNodeTransform {
        @Override
        public void transform(TreeNodeInterface node, Object obj) {
            node.setText(obj.toString());
        }
    }

    @SASScope
    public static interface TreeNodeTransform {
        public void transform(TreeNodeInterface var1, Object var2);
    }

    @SASScope
    public static class TreeNodeAdaptor
    extends com.sas.servlet.tbeans.models.TreeNode {
        Object node;
        TreeModel model;
        com.sas.servlet.tbeans.models.TreeNode[] newchildren;
        TreeNodeTransform transform;

        public TreeNodeAdaptor(TreeModel model, Object node) {
            this(model, node, new DefaultTreeNodeTransform());
        }

        public TreeNodeAdaptor(TreeModel model, Object node, TreeNodeTransform transform) {
            this(model, node, Util.getName((String)"TREEVIEW"), transform);
        }

        public TreeNodeAdaptor(TreeModel model, Object node, String name, TreeNodeTransform transform) {
            super(name, "");
            this.node = node;
            this.model = model;
            this.transform = transform;
            this.newchildren = new com.sas.servlet.tbeans.models.TreeNode[model.getChildCount(node)];
            this.transform();
        }

        void transform() {
            this.transform.transform(this, this.node);
        }

        @Override
        public TreeNode getChildAt(int i) {
            if (this.newchildren[i] == null) {
                Object child = this.model.getChild(this.node, i);
                if (!(child instanceof TreeNodeInterface)) {
                    child = new TreeNodeAdaptor(this.model, child, this.getName() + "_" + i, this.transform);
                }
                this.newchildren[i] = (com.sas.servlet.tbeans.models.TreeNode)child;
                this.newchildren[i].setParent(this);
            }
            return this.newchildren[i];
        }

        @Override
        public int getChildCount() {
            return this.model.getChildCount(this.node);
        }

        public void collapse() {
            this.setExpanded(false);
            for (int i = 0; i < this.newchildren.length; ++i) {
                TreeNodeAdaptor tna = (TreeNodeAdaptor)this.newchildren[i];
                if (tna == null) continue;
                tna.collapse();
            }
        }

        public com.sas.servlet.tbeans.models.TreeNode getNode(TreePath path) {
            TreeNodeAdaptor node = this;
            for (int i = 0; i < path.getPathCount(); ++i) {
                node = (TreeNodeAdaptor)node.getChildAt(this.model.getIndexOfChild(node.node, path.getPath()[i]));
            }
            return node;
        }

        @Override
        public boolean isLeaf() {
            return this.model.isLeaf(this.node);
        }

        public TreeNode getChildNoLoad(int i) {
            return this.newchildren[i];
        }

        public Object getSourceNode() {
            return this.node;
        }
    }
}

