/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.html;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.html.TreeTableModelAdapter;
import com.sas.servlet.tbeans.html.TreeTableSorter;
import com.sas.servlet.tbeans.html.TreeView;
import com.sas.servlet.tbeans.models.TreeTableNode;
import com.sas.servlet.tbeans.tableview.html.CellContentsLabelRenderer;
import com.sas.servlet.tbeans.tableview.html.DefaultTableCellRenderer;
import com.sas.servlet.tbeans.tableview.html.TableView;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.Util;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@SASScope
public class TreeTableView
extends TableView {
    private TreeView _treeView;
    private TreeTableNode _ttRoot;
    private int _expansionLevel = 1;
    private int _initialExpansionLevel = -111960;

    public TreeTableView() {
        this.createTreeView();
        this.setId(Util.getName((String)"ttv"));
        this.setRowHeaderVisible(false);
        CellContentsLabelRenderer cclr = new CellContentsLabelRenderer();
        DefaultTableCellRenderer crenderer = new DefaultTableCellRenderer(cclr);
        cclr.setEncodeText(false);
        crenderer.setStyleInfo(new StyleInfo("tableData TreeTableColumn"));
        this.setCellRenderer(-1, 1, crenderer);
        this.setActionSupportType("TREETABLEVIEW_SUPPORT");
    }

    private void createTreeView() {
        this._treeView = new TreeView(this.getId() + "_TreeView");
        this._treeView.setLineStyle(3);
        this._treeView.setUsePlusMinus(true);
        this._treeView.setRootNodeVisible(false);
        this._treeView.getStyleMap().put("TREEVIEW_TABLE", new StyleInfo("treeTableViewTableStyle"));
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        JavaScriptIncludeHandler.writeIncludes(out, "TREEVIEW", this.getRequest());
        this.setAdditionalParameter(this._treeView.getId() + "_childrenOf", "");
        if (this._initialExpansionLevel >= -1) {
            this._treeView.setInitialExpansionLevel(this._initialExpansionLevel);
        } else {
            this._treeView.setExpansionLevel(this._expansionLevel);
        }
        this.setTreeListOnTableModel(this._ttRoot);
        this.initializeRowNumbers();
        super.write(out);
    }

    private List setTreeListOnTableModel(TreeTableNode root) {
        TreeTableModelAdapter model = (TreeTableModelAdapter)this.getModel();
        List list = this.buildTreeList(root);
        model.setTreeList(list);
        return list;
    }

    private List buildTreeList(TreeTableNode root) {
        this._treeView.setRequest(this.getRequest());
        this._treeView.setResponse(this.getResponse());
        this._treeView.setLocale(this.getLocale());
        this._treeView.setFormObject(this.getFormObject());
        this._treeView.setRoot(root);
        ArrayList htmloc = new ArrayList();
        this._treeView.getHTMLTreeNodes(htmloc, root, root, "", null, true);
        return htmloc;
    }

    public void setLinesVisible(boolean visible) {
        this._treeView.setLineStyle(visible ? 4 : 3);
        this._treeView.setUsePlusMinus(visible);
    }

    public void setTreeModel(TreeTableNode root, List columnNames) {
        this._ttRoot = root;
        TreeTableModelAdapter model = new TreeTableModelAdapter(this._ttRoot, columnNames);
        model.setSorter(new TreeTableSorter(this));
        this.setModel(model);
    }

    public void setTreeModel(TreeTableNode root, Object[] columnNames) {
        this.setTreeModel(root, Arrays.asList(columnNames));
    }

    public void setTreeModel(TreeTableNode root) {
        ArrayList<String> list = new ArrayList<String>(root.getColumns());
        list.add(0, root.getText());
        this.setTreeModel(root, list);
    }

    public TreeTableNode getRoot() {
        return this._ttRoot;
    }

    public int getExpansionLevel() {
        return this._expansionLevel;
    }

    public void setExpansionLevel(int i) {
        this._expansionLevel = i;
    }

    public int getInitialExpansionLevel() {
        return this._initialExpansionLevel;
    }

    public void setInitialExpansionLevel(int i) {
        this._initialExpansionLevel = i;
    }

    public TreeView getTreeView() {
        return this._treeView;
    }

    @Override
    public void setId(String id) {
        super.setId(id);
        if (this._treeView != null) {
            this._treeView.setId(id + "_TreeView");
        }
    }
}

