/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.html;

import com.sas.codepolicy.SASScope;
import com.sas.nls.collator.SASCollatorFactory;
import com.sas.nls.collator.SASStringComparator;
import com.sas.servlet.tbeans.html.TreeTableModelAdapter;
import com.sas.servlet.tbeans.html.TreeTableView;
import com.sas.servlet.tbeans.html.TreeView;
import com.sas.servlet.tbeans.models.TreeTableNode;
import com.sas.table.SortException;
import com.sas.table.SortableInterface;
import com.sas.util.GenericComparator;
import com.sas.util.SortDirectionInterface;
import java.util.Comparator;
import java.util.Locale;
import javax.swing.table.TableModel;

@SASScope
public class TreeTableSorter
implements SortableInterface {
    boolean sortAllowed = true;
    TreeTableView treeTableView;
    TreeTableComparator comparator;
    String lastColumn;
    int lastDirection;

    public TreeTableSorter(TreeTableView treeTableView) {
        this.treeTableView = treeTableView;
        this.comparator = new TreeTableComparator(treeTableView.getLocale());
    }

    public void sort(String[] columnNames, int[] direction) throws SortException {
        if (this.comparator == null) {
            return;
        }
        TreeTableModelAdapter ttmodel = (TreeTableModelAdapter)this.treeTableView.getModel();
        if (columnNames.length == 0) {
            return;
        }
        int column = this.findColumn(ttmodel, columnNames[0]);
        if (column >= 0) {
            this.lastColumn = columnNames[0];
            this.lastDirection = direction[0];
            this.comparator.setColumn(column);
            this.comparator.setDirection(direction[0]);
            TreeView.sort(ttmodel.getRoot(), this.comparator);
        }
    }

    private int findColumn(TableModel table, String columnName) {
        for (int i = 0; i < table.getColumnCount(); ++i) {
            if (!columnName.equals(table.getColumnName(i))) continue;
            return i;
        }
        return -1;
    }

    public boolean isColumnSortable(String columnName) {
        return true;
    }

    public boolean isSortAllowed() {
        return this.sortAllowed;
    }

    public void setSortAllowed(boolean allowed) {
        this.sortAllowed = allowed;
    }

    public String[] getSortedColumns() {
        if (this.lastColumn != null) {
            return new String[]{this.lastColumn};
        }
        return new String[0];
    }

    public int[] getSortedDirections() {
        if (this.lastColumn != null) {
            return new int[]{this.lastDirection};
        }
        return new int[0];
    }

    @SASScope
    private static class TreeTableComparator
    implements Comparator,
    SortDirectionInterface {
        int column = 0;
        int direction = 0;
        Comparator comparator;

        public TreeTableComparator(Locale locale) {
            SASStringComparator stringComparator = SASCollatorFactory.createCollator((Locale)locale);
            this.comparator = new GenericComparator(stringComparator);
        }

        public int compare(Object o1, Object o2) {
            if (this.direction == 2) {
                return 0;
            }
            if (o1 instanceof TreeTableNode && o2 instanceof TreeTableNode) {
                Object s2;
                Object s1;
                TreeTableNode n1 = (TreeTableNode)o1;
                TreeTableNode n2 = (TreeTableNode)o2;
                int result = 0;
                if (this.column == 0) {
                    s1 = n1.getText();
                    s2 = n2.getText();
                } else {
                    s1 = n1.getColumn(this.column - 1);
                    s2 = n2.getColumn(this.column - 1);
                }
                result = this.comparator.compare(s1, s2);
                if (this.direction == 1) {
                    result = -result;
                }
                return result;
            }
            return 0;
        }

        public int getColumn() {
            return this.column;
        }

        public void setColumn(int column) {
            this.column = column;
        }

        public int getDirection() {
            return this.direction;
        }

        public void setDirection(int direction) {
            this.direction = direction;
        }
    }
}

