/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.html;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.ComplexStyleInterface;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.html.Image;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.MapWithDefaults;
import com.sas.util.Util;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

@SASScope
public class ToggleImage
extends Image
implements ComplexStyleInterface {
    private MapWithDefaults componentStyleMap;
    private boolean selected;
    private boolean toggleEnabled;
    private static final HashMap defaultStyleMap = new HashMap();
    private static final ImmutableStyleInfo ImageStyle = new ImmutableStyleInfo("imageStyle");
    private static final ImmutableStyleInfo ImageSelectedStyle = new ImmutableStyleInfo("imageSelectedStyle");
    private static final ImmutableStyleInfo ToggleImageDisabledStyle = new ImmutableStyleInfo("toggleImageDisabled");
    private static final String IMAGE_STYLE = "IMAGE_STYLE";
    private static final String IMAGE_SELECTED_STYLE = "IMAGE_SELECTED_STYLE";
    private static final String TOGGLE_IMAGE_DISABLED_STYLE = "TOGGLE_IMAGE_DISABLED_STYLE";

    private static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0) {
            defaultStyleMap.put(IMAGE_STYLE, ImageStyle);
            defaultStyleMap.put(IMAGE_SELECTED_STYLE, ImageSelectedStyle);
            defaultStyleMap.put(TOGGLE_IMAGE_DISABLED_STYLE, ToggleImageDisabledStyle);
        }
    }

    public ToggleImage(String name, String image, int width, int height) {
        super(name, image, width, height);
        this.setSelected(false);
        this.setToggleEnabled(true);
        ToggleImage.setupDefaultStyleMap();
        this.componentStyleMap = new MapWithDefaults((Map)defaultStyleMap);
    }

    public ToggleImage() {
        this(Util.getName((String)"Image"), null, -1, -1);
    }

    public ToggleImage(String id) {
        this(id, null, -1, -1);
    }

    public ToggleImage(String id, String image) {
        this(id, image, -1, -1);
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        String imageStyle = ((StyleInfo)this.getStyleMap().get(IMAGE_STYLE)).getClassid();
        String imageSelectedStyle = ((StyleInfo)this.getStyleMap().get(IMAGE_SELECTED_STYLE)).getClassid();
        String currentStyle = this.selected ? imageSelectedStyle : imageStyle;
        StringBuffer sb = new StringBuffer();
        sb.append("<div id=\"_").append(this.getId()).append("\" class=\"").append(currentStyle).append("\">");
        String img_onclick = this.getOnClick();
        img_onclick = img_onclick != null ? img_onclick + "; sas_ToggleImageStyle('" + this.getId() + "', " + this.isToggleEnabled() + ")" : "sas_ToggleImageStyle('" + this.getId() + "', " + this.isToggleEnabled() + ")";
        this.setOnClick(img_onclick);
        this.setTagProlog(sb.toString());
        this.setTagEpilog("</div>");
        super.write(out);
        this.setOnClick(null);
    }

    @Override
    protected void writeJavaScript(PrintWriter out) throws IOException {
        out.println(JavaScriptIncludeHandler.getStartScript());
        out.println("var " + this.getId() + "= new sas_ToggleImage('" + this.getId() + "');");
        out.println(this.getId() + ".imageStyle = '" + ((StyleInfo)this.getStyleMap().get(IMAGE_STYLE)).getClassid() + "';");
        out.println(this.getId() + ".imageSelectedStyle = '" + ((StyleInfo)this.getStyleMap().get(IMAGE_SELECTED_STYLE)).getClassid() + "';");
        out.println(this.getId() + ".toggleImageDisabledStyle = '" + ((StyleInfo)this.getStyleMap().get(TOGGLE_IMAGE_DISABLED_STYLE)).getClassid() + "';");
        out.println(this.getId() + ".setSelected(" + this.isSelected() + ");");
        out.println(this.getId() + ".setEnabled(" + this.isEnabled() + ");");
        if (this.getDisabledImage() != null) {
            out.println(this.getId() + ".disabledImage = '" + this.getDisabledImage() + "';");
        } else if (this.getDisabledImageName() != null) {
            out.println(this.getId() + ".disabledImageName = '" + this.getDisabledImageName() + "';");
        }
        if (this.getImage() != null) {
            out.println(this.getId() + ".image = '" + this.getImage() + "';");
        } else if (this.getImageName() != null) {
            out.println(this.getId() + ".imageName = '" + this.getImageName() + "';");
        }
        out.println(this.getId() + ".imageLocation = '" + this.getImageLocation() + "';");
        if (this.getOnClick() != null) {
            out.println(this.getId() + ".onclick = function() {" + this.getOnClick() + "}");
        }
        if (this.getOnMouseOver() != null) {
            out.println(this.getId() + ".onmouseover = function() {" + this.getOnMouseOver() + "}");
        }
        if (this.getOnMouseOut() != null) {
            out.println(this.getId() + ".onmouseout = function() {" + this.getOnMouseOut() + "}");
        }
        out.println(JavaScriptIncludeHandler.getEndScript(null));
    }

    @Override
    public Map getStyleMap() {
        return this.componentStyleMap;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isToggleEnabled() {
        return this.toggleEnabled;
    }

    public void setToggleEnabled(boolean toggleEnabled) {
        this.toggleEnabled = toggleEnabled;
    }
}

