/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.html;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.html.RB;
import com.sas.servlet.tbeans.html.TabButton;
import com.sas.servlet.util.BaseUtil;
import com.sas.servlet.util.ClientInfo;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;

@SASScope
public class TabMenu
extends BaseTransformation {
    public static final String DEFAULT_TAB_LOOK = "Default";
    public static final String BANNER_TAB_LOOK = "Banner";
    public static final String SECONDARY_TAB_LOOK = "Secondary";
    private static final String DYNAMIC_TAB_BUTTON_SUFFIX = "TabButton";
    private static final String DYNAMIC_TAB_BUTTON_KEY_SUFFIX = "Tab_Button";
    protected ArrayList tabs;
    protected TabButton activeTab;
    protected String look = "Default";
    private static final String RB_KEY = "TabMenu.";

    public void add(TabButton tab) {
        if (this.tabs == null) {
            this.tabs = new ArrayList();
        }
        String existingOnClick = tab.getOnClick();
        StringBuffer modifiedOnClick = new StringBuffer();
        modifiedOnClick.append(this.getId()).append(".selectTab('").append(tab.getId() + "_Obj").append("');").append(existingOnClick);
        tab.setOnClick(modifiedOnClick.toString());
        this.tabs.add(tab);
    }

    public void setActiveTab(TabButton tab) {
        if (this.tabs != null && this.tabs.contains(tab)) {
            tab.setActive(true);
            this.activeTab = tab;
        }
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        super.write(out);
        if (this.tabs != null) {
            String title = RB.getStringResource(RB_KEY, "skipTabMenu.txt", this.getLocale());
            String skipLinkHref = this.getId() + "_skipTabMenu";
            out.println(BaseUtil.getSkipLinkAnchor(skipLinkHref, title));
            out.println("<table id=\"" + this.getId() + "_Table\" class=\"" + this.getLook() + "TabMenuTable\" cellspacing=\"0\" cellpadding=\"0\">");
            out.println("<tr>");
            for (TabButton tab : this.tabs) {
                tab.setDynamicRootName(this.getLook() + DYNAMIC_TAB_BUTTON_SUFFIX);
                tab.setDynamicRootKey(this.getLook() + "_" + DYNAMIC_TAB_BUTTON_KEY_SUFFIX);
                tab.setRequest(this.getRequest());
                tab.setResponse(this.getResponse());
                out.println("<td id=\"" + tab.getId() + "_TabCell\" >");
                tab.write(out);
                out.println("</td>");
            }
            if (this.getRequest() != null) {
                ClientInfo client = new ClientInfo(this.getRequest());
                if (client.isChrome() || client.isSafari()) {
                    out.println("<td class=\"" + this.getLook() + "TabMenuSpacerCell\" style=\"width:109px;\">" + "&#160;" + "</td>");
                } else {
                    out.println("<td class=\"" + this.getLook() + "TabMenuSpacerCell\">" + "&#160;" + "</td>");
                }
            } else {
                out.println("<td class=\"" + this.getLook() + "TabMenuSpacerCell\" style=\"width:109px;\">" + "&#160;" + "</td>");
            }
            out.println("</tr>");
            out.println("</table>");
            JavaScriptIncludeHandler.writeIncludes(out, "TABMENU", this.getRequest());
            this.writeJavaScript(out);
            out.println(BaseUtil.getSkipLinkAnchorTarget(skipLinkHref));
        }
    }

    protected void writeJavaScript(PrintWriter out) {
        out.println(JavaScriptIncludeHandler.getStartScript());
        out.println(this.getId() + " = new sas_TabMenu('" + this.getId() + "','" + this.getLook() + "');\n");
        for (TabButton tab : this.tabs) {
            out.println(this.getId() + ".addTab('" + tab.getId() + "_Obj');\n");
        }
        if (this.activeTab != null) {
            out.println(this.getId() + ".selectTab('" + this.activeTab.getId() + "_Obj');\n");
        }
        out.println(JavaScriptIncludeHandler.getEndScript(null));
    }

    @SASScope
    public String getLook() {
        return this.look;
    }

    @SASScope
    public void setLook(String look) {
        this.look = look;
    }

    static {
        JavaScriptIncludeHandler.addAlias(TabMenu.class, "TABMENU");
    }
}

