/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.html;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.BaseCompositeTransformation;
import com.sas.servlet.tbeans.EnabledInterface;
import com.sas.servlet.tbeans.TemplateSupport;
import com.sas.servlet.tbeans.html.FontPicker;
import com.sas.servlet.tbeans.html.RichTextEditField;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.MapWithDefaults;
import com.sas.util.Util;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

@SASScope
public class RichTextEditor
extends BaseCompositeTransformation
implements EnabledInterface {
    private static final String DEFAULT_TEMPLATE_FILE_NAME = "RichTextEditor.html";
    public static final String FONTPICKER_COMPONENT = "FONTPICKER_COMPONENT";
    public static final String RICHTEXTEDITFIELD_COMPONENT = "RICHTEXTEDITFIELD_COMPONENT";
    private static HashMap defaultStyleMap;
    private MapWithDefaults componentStyleMap;
    private boolean enabled = true;
    private FontPicker fontPicker = null;
    private RichTextEditField richTextEditField = null;

    public RichTextEditor() {
        this(null);
    }

    public RichTextEditor(String Id) {
        if (Id == null) {
            this.setId(Util.getName((String)"richTextEditor"));
        } else {
            this.setId(Id);
        }
        this.setTemplateKey("Rich_Text_Editor");
        this.componentStyleMap = new MapWithDefaults(RichTextEditor.getDefaultStyleMap());
        this.addComponents();
    }

    public FontPicker getFontPicker() {
        return this.fontPicker;
    }

    public RichTextEditField getRichTextEditField() {
        return this.richTextEditField;
    }

    private static Map getDefaultStyleMap() {
        if (defaultStyleMap == null) {
            defaultStyleMap = new HashMap();
        }
        return defaultStyleMap;
    }

    @Override
    public Map getStyleMap() {
        return this.componentStyleMap;
    }

    protected void addComponents() {
        if (this.getComponents().isEmpty()) {
            this.fontPicker = new FontPicker();
            this.fontPicker.setId(this.getId() + "_FontPicker");
            this.fontPicker.removeComponent("FONTPICKER_PREVIEW_TEXT_COMPONENT");
            this.setComponent(FONTPICKER_COMPONENT, this.fontPicker);
            this.richTextEditField = new RichTextEditField(this.getId() + "_RichTextEditField");
            this.setComponent(RICHTEXTEDITFIELD_COMPONENT, this.richTextEditField);
        }
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        super.write(out);
        JavaScriptIncludeHandler.writeIncludes(out, "RICHTEXTEDITOR", this.getRequest());
        HashMap<String, String> dictionary = this.getTemplateDictionary();
        if (dictionary == null) {
            dictionary = new HashMap<String, String>();
            this.setTemplateDictionary(dictionary);
        }
        dictionary.put("RICHTEXTEDITOR_ID", this.getId());
        TemplateSupport.writeTemplate(this, null, out);
        this.writeJavaScript(out);
        this.cleanUpResources();
    }

    public String getJavaScriptObjectName() {
        return this.getId();
    }

    public String getJavaScriptFontPickerObjectName() {
        String objectName = null;
        if (null != this.fontPicker && null != this.fontPicker.getId() && this.fontPicker.getId().length() > 0) {
            objectName = this.fontPicker.getId();
        }
        return objectName;
    }

    public String getJavaScriptTextEditObjectName() {
        return this.richTextEditField.getJavaScriptObjectName();
    }

    private void writeJavaScript(PrintWriter out) {
        String textEditVar;
        String fontPickerVar = this.getJavaScriptFontPickerObjectName();
        if (null == fontPickerVar) {
            fontPickerVar = "null";
        }
        if (null == (textEditVar = this.getJavaScriptTextEditObjectName())) {
            textEditVar = "null";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(JavaScriptIncludeHandler.getStartScript());
        sb.append("var ").append(this.getJavaScriptObjectName()).append(" = new sas_RichTextEditor(").append(fontPickerVar).append(", ").append(textEditVar).append(");\n");
        if (null != this.fontPicker && null != this.richTextEditField) {
            sb.append(fontPickerVar).append(".setOnChange('").append(textEditVar).append(".changeStyle(").append(fontPickerVar).append(".changedCSSName, ").append(fontPickerVar).append(".changedCSSValue);');\n");
            sb.append(textEditVar).append(".setFontPicker(").append(fontPickerVar).append(");\n");
        }
        sb.append(JavaScriptIncludeHandler.getEndScript(null));
        out.println(sb.toString());
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    static {
        JavaScriptIncludeHandler.addAlias(RichTextEditor.class, "RICHTEXTEDITOR");
    }
}

