/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.html;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.BaseCompositeTransformation;
import com.sas.servlet.tbeans.JavaScriptEventHandlerInterface;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.TemplateSupport;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.form.html.TextEntry;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.html.PalettePickerPopupWindow;
import com.sas.servlet.tbeans.models.Item;
import com.sas.servlet.util.BaseUtil;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.servlet.util.ComponentSessionManager;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.MapWithDefaults;
import com.sas.util.SimpleTemplate;
import com.sas.util.Strings;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@SASScope
public abstract class PalettePicker
extends BaseCompositeTransformation
implements JavaScriptEventHandlerInterface {
    protected List model = null;
    private static final String RB_KEY = "Palette.";
    public static final String DEFAULT_AJAX_PALETTE_URL_TEMPLATE = "%BASE_AJAX_URL(%BASE_AJAX_URL)%AJAX_URL_SUFFIX(%AJAX_URL_SUFFIX)CLASS_PARAMETER=" + PalettePicker.class.getName() + "&id=%id";
    public static final String PALETTE_CUSTOM_LABEL = "PALETTE_CUSTOM_LABEL";
    public static final String PALETTE_CUSTOM_COMPONENT = "PALETTE_CUSTOM_COMPONENT";
    public static final String PALETTE_PREVIEW_CELL = "PALETTE_PREVIEW_CELL";
    public static final String PALETTE_IMAGE_CELL = "PALETTE_IMAGE_CELL";
    public static final String PALETTE_TABLE = "PALETTE_TABLE";
    public static final String PALETTE_ITEM_CELL = "PALETTE_ITEM_CELL";
    public static final String PALETTE_SELECTED_ITEM_CELL = "PALETTE_SELECTED_ITEM_CELL";
    public static final String PALETTE_CONTAINER = "PALETTE_CONTAINER";
    public static final String PALETTE_CONTAINER_DISABLED = "PALETTE_CONTAINER_DISABLED";
    private static final String DEFAULT_TEMPLATE_FILE_NAME = "Palette.html";
    protected String defaultValue = null;
    protected String launchImage = null;
    protected String launchImageDisabled = null;
    protected String launchImageKey = null;
    protected String launchImageDisabledKey;
    protected String paletteCellTemplate = "PaletteCell.html";
    protected boolean enabled = true;
    private String onClick = null;
    private String onChange = null;
    private String onFocus = null;
    private String onBlur = null;
    protected boolean hideFormSelectObjects = true;
    private String title;
    protected boolean automaticVisible = true;
    private SimpleTemplate ajaxPaletteURLTemplate;
    private static HashMap defaultStyleMap;
    private MapWithDefaults componentStyleMap;

    public PalettePicker() {
    }

    public PalettePicker(String name) {
        this.setId(name);
        this.setTemplateKey("Palette");
        this.ajaxPaletteURLTemplate = new SimpleTemplate();
        this.ajaxPaletteURLTemplate.setTemplate(DEFAULT_AJAX_PALETTE_URL_TEMPLATE);
        this.ajaxPaletteURLTemplate.setValueDictionary(new HashMap());
        this.addComponents();
        this.componentStyleMap = new MapWithDefaults(PalettePicker.getDefaultStyleMap());
    }

    @Override
    protected void setLocaleDependentProperties(Locale locale) {
        super.setLocaleDependentProperties(locale);
        this._setLocaleDependentProperties(locale);
    }

    private void _setLocaleDependentProperties(Locale locale) {
    }

    private static Map getDefaultStyleMap() {
        if (defaultStyleMap == null) {
            defaultStyleMap = new HashMap();
            StyleInfo palettePreviewCellStyle = new StyleInfo("PalettePreviewCell");
            defaultStyleMap.put(PALETTE_PREVIEW_CELL, palettePreviewCellStyle);
            StyleInfo paletteImageCellStyle = new StyleInfo("PaletteImageCell");
            defaultStyleMap.put(PALETTE_IMAGE_CELL, paletteImageCellStyle);
            StyleInfo paletteTableStyle = new StyleInfo("PaletteTable");
            defaultStyleMap.put(PALETTE_TABLE, paletteTableStyle);
            StyleInfo paletteItemStyle = new StyleInfo("PaletteItemCell");
            defaultStyleMap.put(PALETTE_ITEM_CELL, paletteItemStyle);
            StyleInfo paletteSelectedItemStyle = new StyleInfo("PaletteSelectedItemCell");
            defaultStyleMap.put(PALETTE_SELECTED_ITEM_CELL, paletteSelectedItemStyle);
            StyleInfo paletteContainerStyle = new StyleInfo("PaletteContainer");
            defaultStyleMap.put(PALETTE_CONTAINER, paletteContainerStyle);
            StyleInfo paletteContainerDisabledStyle = new StyleInfo("PaletteContainerDisabled");
            defaultStyleMap.put(PALETTE_CONTAINER_DISABLED, paletteContainerDisabledStyle);
        }
        return defaultStyleMap;
    }

    @Override
    public Map getStyleMap() {
        return this.componentStyleMap;
    }

    @Override
    public void setId(String id) {
        super.setId(id);
    }

    @Override
    public void setName(String name) {
        super.setId(name);
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        String epilog;
        StyleInfo paletteTableStyle;
        StyleInfo containerStyle;
        StyleInfo imageCellStyle;
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        JavaScriptIncludeHandler.writeIncludes(out, "PALETTE", this.getRequest());
        ComponentSessionManager.getSessionManager(this.getRequest()).put(this.getId(), this);
        HashMap<String, String> dictionary = this.getTemplateDictionary();
        if (dictionary == null) {
            dictionary = new HashMap<String, String>();
            this.setTemplateDictionary(dictionary);
        }
        dictionary.put("PALETTE_CONTENTS", this.getPaletteCells());
        dictionary.put("PALETTE_AUTOMATIC", this.getAutomaticCell());
        dictionary.put("PALETTE_ID", this.getId());
        dictionary.put("SELECTED_ITEM_VALUE", this.getDefaultValue());
        StyleInfo previewStyle = (StyleInfo)this.getStyleMap().get(PALETTE_PREVIEW_CELL);
        if (previewStyle.getClassid() != null) {
            dictionary.put("PALETTE_PREVIEW_CELL_CLASS", previewStyle.getClassid());
        }
        if (previewStyle.getStyle() != null) {
            dictionary.put("PALETTE_PREVIEW_CELL_STYLE", previewStyle.getStyle());
        }
        if ((imageCellStyle = (StyleInfo)this.getStyleMap().get(PALETTE_IMAGE_CELL)).getClassid() != null) {
            dictionary.put("PALETTE_IMAGE_CELL_CLASS", imageCellStyle.getClassid());
        }
        if (imageCellStyle.getStyle() != null) {
            dictionary.put("PALETTE_IMAGE_CELL_STYLE", imageCellStyle.getStyle());
        }
        if ((containerStyle = (StyleInfo)this.getStyleMap().get(PALETTE_CONTAINER)).getClassid() != null) {
            dictionary.put("PALETTE_CONTAINER_CLASS", containerStyle.getClassid());
        }
        if ((paletteTableStyle = (StyleInfo)this.getStyleMap().get(PALETTE_TABLE)).getClassid() != null) {
            dictionary.put("PALETTE_TABLE_CLASS", paletteTableStyle.getClassid());
        }
        if (paletteTableStyle.getStyle() != null) {
            dictionary.put("PALETTE_TABLE_STYLE", paletteTableStyle.getStyle());
        }
        ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(this.getRequest());
        StringBuffer imageHtml = new StringBuffer();
        imageHtml.append("<img border=\"0\" id=\"").append(this.getId() + "_launchImage").append("\" alt=\"\" src=\"" + cpm.getImageURI("Spacer")).append("\"/>");
        dictionary.put("PALETTE_LAUNCH_IMAGE", imageHtml.toString());
        dictionary.put("PALETTE_LAUNCH_COMMAND", this.getId() + "_Obj.togglePaletteVisibility(event)");
        if (this.getOnFocus() != null) {
            dictionary.put("PALETTE_ONFOCUS", this.getOnFocus());
        }
        if (this.getOnBlur() != null) {
            dictionary.put("PALETTE_ONBLUR", this.getOnBlur());
        }
        if (this.getTitle() != null) {
            dictionary.put("PALETTE_TITLE", this.getTitle());
        }
        super.write(out);
        String prolog = this.getTagProlog();
        if (prolog != null) {
            out.write(prolog);
        }
        TemplateSupport.writeTemplate(this, null, out);
        out.println();
        String js = this.getJavaScript();
        if (js != null) {
            out.write(js);
        }
        if ((epilog = this.getTagEpilog()) != null) {
            out.write(epilog);
        }
        this.cleanUpResources();
    }

    protected String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    protected void addComponents() {
        if (this.getComponents().isEmpty()) {
            // empty if block
        }
    }

    public List getModel() {
        return this.model;
    }

    public void setModel(List model) {
        this.model = model;
    }

    private String getPaletteCells() {
        int mod = (int)Math.sqrt(this.model.size());
        int columnCount = 0;
        int count = 1;
        StringBuffer buf = new StringBuffer();
        buf.append("<tr>");
        Iterator itemIterator = this.model.iterator();
        while (itemIterator.hasNext()) {
            Item paletteItem = (Item)itemIterator.next();
            String itemHTML = this.getPaletteCell(paletteItem, count == 1, !itemIterator.hasNext());
            buf.append(itemHTML);
            if (count % mod == 0) {
                columnCount = mod;
                buf.append("</tr><tr>");
            }
            ++count;
        }
        buf.append("</tr>");
        if (columnCount == 0) {
            columnCount = count--;
        }
        HashMap dictionary = this.getTemplateDictionary();
        dictionary.put("PALETTE_CELL_COLUMN_COUNT", "" + columnCount);
        return buf.toString();
    }

    protected String getPaletteCell(Item paletteItem, boolean firstItem, boolean lastItem) {
        ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(this.getRequest());
        String paletteItemTemplate = this.getPaletteCellTemplate();
        HashMap<String, String> dictionary = new HashMap<String, String>();
        dictionary.put("SPACER_IMAGE", cpm.getImageURI("Spacer"));
        dictionary.put("ITEM_VALUE", paletteItem.getValue());
        StyleInfo paletteItemStyle = (StyleInfo)this.getStyleMap().get(PALETTE_ITEM_CELL);
        if (paletteItemStyle.getClassid() != null) {
            dictionary.put("ITEM_CLASS", paletteItemStyle.getClassid());
        }
        if (paletteItemStyle.getStyle() != null) {
            dictionary.put("ITEM_STYLE", paletteItemStyle.getStyle());
        }
        StringBuffer onClick = new StringBuffer();
        onClick.append(this.getId()).append("_Obj.selectItem('").append(paletteItem.getValue()).append("');");
        if (this.getOnClick() != null) {
            onClick.append(this.getOnClick());
        }
        dictionary.put("ONCLICK", onClick.toString());
        if (this.getAutomaticCell() == null || "".equals(this.getAutomaticCell()) && lastItem) {
            dictionary.put("ONTAB", "sas_Palette_BlurringLastFocusedItemInPalette(event);");
        }
        if (firstItem) {
            dictionary.put("ONTAB", "sas_Palette_BlurringFirstFocusedItemInPalette(event);");
        }
        String cellId = (this.getId() + paletteItem.getValue()).replace('#', '_');
        cellId = cellId.replace('/', '_');
        dictionary.put("CELLID", cellId);
        return SimpleTemplate.format((String)paletteItemTemplate, dictionary);
    }

    protected String getAutomaticCell() {
        return "";
    }

    protected String getJavaScript() {
        Map paletteMap = this.ajaxPaletteURLTemplate.getValueDictionary();
        paletteMap.put("BASE_AJAX_URL", this.getAJAXControllerURL());
        if (this.getAJAXControllerURL().indexOf("?") == -1) {
            paletteMap.put("AJAX_URL_SUFFIX", "?");
        } else {
            paletteMap.put("AJAX_URL_SUFFIX", "&");
        }
        paletteMap.put("id", this.getId());
        ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(this.getRequest());
        StringBuffer buf = new StringBuffer();
        buf.append(JavaScriptIncludeHandler.getStartScript());
        buf.append(this.getId() + "_Obj.setHideFormSelects('" + this.getHideFormSelectObjects() + "');\n");
        if (this.getLaunchImage() != null) {
            buf.append(this.getId() + "_Obj.setLaunchImage('" + this.getLaunchImage() + "');\n");
        } else if (this.getLaunchImageKey() != null) {
            buf.append(this.getId() + "_Obj.setLaunchImageURI('" + cpm.getImageURI(this.getLaunchImageKey()) + "');\n");
        }
        if (this.getLaunchImageDisabled() != null) {
            buf.append(this.getId() + "_Obj.setLaunchImageDisabled('" + this.getLaunchImageDisabled() + "');\n");
        } else if (this.getLaunchImageDisabledKey() != null) {
            buf.append(this.getId() + "_Obj.setLaunchImageDisabledURI('" + cpm.getImageURI(this.getLaunchImageDisabledKey()) + "');\n");
        }
        buf.append(this.getId() + "_Obj.setImageLocation('" + cpm.getImageLocation() + "');\n");
        buf.append(this.getId() + "_Obj.setImageURIs(" + this.getImageURIs() + ");\n");
        if (this.getOnChange() != null) {
            buf.append(this.getId() + "_Obj.onChange=\"" + this.getOnChange() + "\";\n");
        }
        buf.append(this.getId() + "_Obj.setSelectedItemClass('" + ((StyleInfo)this.getStyleMap().get(PALETTE_SELECTED_ITEM_CELL)).getClassid() + "');\n");
        if (this.getDefaultValue() != null) {
            buf.append(this.getId() + "_Obj.setSelectedItem('" + this.getDefaultValue() + "');");
        }
        if (this.isEnabled()) {
            buf.append(this.getId() + "_Obj.enable();\n");
        } else {
            buf.append(this.getId() + "_Obj.disable();\n");
        }
        buf.append(this.getId() + "_Obj.setupLaunchImage();\n");
        buf.append(this.getId() + "_Obj.paletteCreated = false;\n");
        buf.append(this.getId() + "_Obj.palette_url = '" + this.ajaxPaletteURLTemplate.format() + "';\n");
        buf.append(JavaScriptIncludeHandler.getEndScript(null));
        return buf.toString();
    }

    protected String getUpdatePreviewJavascript() {
        StringBuffer update = new StringBuffer();
        update.append("function ").append(this.getId()).append("_updatePreview()");
        update.append("{\n");
        update.append("}\n");
        return update.toString();
    }

    public String getDefaultCellTemplate() {
        StringBuffer template = new StringBuffer();
        template.append("<td onclick=\"%ONCLICK\" class=\"%ITEM_CLASS\" style=\"%ITEM_STYLE\">%ITEM_VALUE</td>");
        return template.toString();
    }

    @Override
    public void setRequest(HttpServletRequest request) {
        super.setRequest(request);
    }

    public String getOnClick() {
        return this.onClick;
    }

    public void setOnClick(String onClick) {
        this.onClick = onClick;
    }

    @Override
    @SASScope
    public void setOnChange(String value) {
        this.onChange = value;
    }

    @Override
    @SASScope
    public String getOnChange() {
        return this.onChange;
    }

    @Override
    @SASScope
    public void setOnFocus(String value) {
        this.onFocus = value;
    }

    @Override
    @SASScope
    public String getOnFocus() {
        return this.onFocus;
    }

    @Override
    @SASScope
    public void setOnBlur(String value) {
        this.onBlur = value;
    }

    @Override
    @SASScope
    public String getOnBlur() {
        return this.onBlur;
    }

    public String getLaunchImage() {
        return this.launchImage;
    }

    public void setLaunchImage(String launchImage) {
        this.launchImage = launchImage;
    }

    public void setHideFormSelectObjects(boolean hideFormSelects) {
        this.hideFormSelectObjects = hideFormSelects;
    }

    public boolean getHideFormSelectObjects() {
        return this.hideFormSelectObjects;
    }

    public String getPaletteCellTemplate() {
        return this.paletteCellTemplate;
    }

    public void setPaletteCellTemplate(String paletteCellTemplate) {
        this.paletteCellTemplate = paletteCellTemplate;
    }

    public String getLaunchImageDisabled() {
        return this.launchImageDisabled;
    }

    public void setLaunchImageDisabled(String launchImageDisabled) {
        this.launchImageDisabled = launchImageDisabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isAutomaticVisible() {
        return this.automaticVisible;
    }

    public void setAutomaticVisible(boolean showAutomatic) {
        this.automaticVisible = showAutomatic;
    }

    @SASScope
    public String getLaunchImageDisabledKey() {
        return this.launchImageDisabledKey;
    }

    @SASScope
    public void setLaunchImageDisabledKey(String launchImageDisabledKey) {
        this.launchImageDisabledKey = launchImageDisabledKey;
    }

    @SASScope
    public String getLaunchImageKey() {
        return this.launchImageKey;
    }

    @SASScope
    public void setLaunchImageKey(String launchImageKey) {
        this.launchImageKey = launchImageKey;
    }

    @SASScope
    public static void createPalettePickerPalette(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType(BaseUtil.TEXT_PLAIN_MIME_TYPE);
        PrintWriter out = response.getWriter();
        String pickerID = request.getParameter("pickerid");
        TransformationInterface ti = (TransformationInterface)ComponentSessionManager.getSessionManager(request).get(pickerID);
        if (ti instanceof PalettePicker) {
            TextEntry customComponent;
            PalettePicker picker = (PalettePicker)ti;
            PalettePickerPopupWindow popDialog = new PalettePickerPopupWindow(picker.getId());
            HashMap dictionary = picker.getTemplateDictionary();
            if (dictionary != null) {
                popDialog.setTemplateDictionary(dictionary);
            }
            popDialog.setRequest(request);
            Label customLabel = (Label)picker.getComponent(PALETTE_CUSTOM_LABEL);
            if (customLabel != null) {
                customLabel.setRequest(request);
                popDialog.setComponent(PALETTE_CUSTOM_LABEL, customLabel);
            }
            if ((customComponent = (TextEntry)picker.getComponent(PALETTE_CUSTOM_COMPONENT)) != null) {
                customComponent.setRequest(request);
                popDialog.setComponent(PALETTE_CUSTOM_COMPONENT, customComponent);
            }
            popDialog.write(out);
            if (ComponentSessionManager.getSessionManager(request).containsKey(pickerID)) {
                ComponentSessionManager.getSessionManager(request).remove(pickerID);
            }
        }
    }

    protected void addJSProp(StringBuffer props, String prefix, String propName, String propValue) {
        props.append(prefix).append(propName).append(":'").append(Strings.escapeForJavaScript((String)propValue)).append("'");
    }

    private String getImageURIs() {
        ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(this.getRequest());
        StringBuffer imageURIs = new StringBuffer("{");
        this.addJSProp(imageURIs, "", "OpenComboListClassicUp", cpm.getImageURI("Open_Combo_Box_List_Classic_up"));
        this.addJSProp(imageURIs, ",", "OpenComboListClassicDown", cpm.getImageURI("Open_Combo_Box_List_Classic_down"));
        this.addJSProp(imageURIs, ",", "OpenComboListStandard", cpm.getImageURI("Open_Combo_Box_List_Windows_Standard"));
        this.addJSProp(imageURIs, ",", "OpenComboListStandardSelected", cpm.getImageURI("Open_Combo_Box_List_Windows_Standard_selected"));
        this.addJSProp(imageURIs, ",", "OpenComboListXP", cpm.getImageURI("Open_Combo_Box_List_XP"));
        this.addJSProp(imageURIs, ",", "OpenComboListXPSelected", cpm.getImageURI("Open_Combo_Box_List_XP_Selected"));
        this.addJSProp(imageURIs, ",", "OpenComboListXPRollover", cpm.getImageURI("Open_Combo_Box_List_XP_Rollover"));
        this.addJSProp(imageURIs, ",", "OpenComboListXPSilver", cpm.getImageURI("Open_Combo_Box_List_XP_Silver"));
        this.addJSProp(imageURIs, ",", "OpenComboListXPSilverSelected", cpm.getImageURI("Open_Combo_Box_List_XP_Silver_selected"));
        this.addJSProp(imageURIs, ",", "OpenComboListXPSilverRollover", cpm.getImageURI("Open_Combo_Box_List_XP_Silver_rollover"));
        this.addJSProp(imageURIs, ",", "OpenComboListVista", cpm.getImageURI("Open_Combo_Box_List_Vista"));
        this.addJSProp(imageURIs, ",", "OpenComboListVistaSelected", cpm.getImageURI("Open_Combo_Box_List_Vista_selected"));
        this.addJSProp(imageURIs, ",", "OpenComboListVistaRollover", cpm.getImageURI("Open_Combo_Box_List_Vista_rollover"));
        this.addJSProp(imageURIs, ",", "OpenComboListVistaMozilla", cpm.getImageURI("Open_Combo_Box_List_Vista_Mozilla"));
        imageURIs.append("}");
        return imageURIs.toString();
    }

    static {
        JavaScriptIncludeHandler.addAlias(PalettePicker.class, "PALETTE");
    }
}

