/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.html;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;
import com.sas.servlet.tbeans.BaseButton;
import com.sas.servlet.tbeans.BaseListEditor;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.TemplateSupport;
import com.sas.servlet.tbeans.form.BaseListBox;
import com.sas.servlet.tbeans.form.html.ListBox;
import com.sas.servlet.tbeans.html.Button;
import com.sas.servlet.tbeans.html.ListEditorStyleKeysInterface;
import com.sas.servlet.tbeans.html.RB;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.MapWithDefaults;
import com.sas.util.Strings;
import com.sas.util.Util;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

@SASScope(value="ALL")
@SubjectToChange
public class ListEditor
extends BaseListEditor
implements ListEditorStyleKeysInterface {
    public static final String RB_KEY = "ListEditor.";
    public static final String DEFAULT_TEMPLATE_FILE_NAME = "ListEditor.html";
    private static HashMap defaultStyleMap;
    private static MapWithDefaults componentStyleMap;
    protected String confirmDeleteMsg = null;
    protected String confirmDelAllMsg = null;

    public ListEditor() {
        this(Util.getName((String)"le"));
    }

    public ListEditor(String name) {
        super(name);
        this.setTemplateKey("List_Editor");
        componentStyleMap = new MapWithDefaults(ListEditor.getDefaultStyleMap());
    }

    @Override
    protected void setLocaleDependentProperties(Locale locale) {
        super.setLocaleDependentProperties(locale);
        this._setLocaleDependentProperties(locale);
    }

    private void _setLocaleDependentProperties(Locale locale) {
        BaseButton addButton = (BaseButton)this.getComponent("LISTEDITOR_ADD_BUTTON");
        addButton.setLabel(this.getDefaultAddButtonLabel(locale));
        BaseButton updateButton = (BaseButton)this.getComponent("LISTEDITOR_UPDATE_BUTTON");
        updateButton.setLabel(this.getDefaultUpdateButtonLabel(locale));
        BaseButton deleteButton = (BaseButton)this.getComponent("LISTEDITOR_DELETE_BUTTON");
        deleteButton.setLabel(this.getDefaultDeleteButtonLabel(locale));
        BaseButton deleteAllButton = (BaseButton)this.getComponent("LISTEDITOR_DELETEALL_BUTTON");
        deleteAllButton.setLabel(this.getDefaultDeleteButtonLabel(locale));
    }

    private static Map getDefaultStyleMap() {
        if (defaultStyleMap == null) {
            defaultStyleMap = new HashMap();
            StyleInfo ListEditorContainerStyle = new StyleInfo("ListEditorContainer");
            StyleInfo ListEditorListContainerStyle = new StyleInfo("ListEditorListContainer");
            StyleInfo ListEditorButtonContainerStyle = new StyleInfo("ListEditorButtonContainer");
            StyleInfo ListEditorAddButtonContainerStyle = new StyleInfo("ListEditorAddButtonContainer");
            StyleInfo ListEditorUpdateButtonContainerStyle = new StyleInfo("ListEditorUpdateButtonContainer");
            StyleInfo ListEditorDeleteButtonContainerStyle = new StyleInfo("ListEditorDeleteButtonContainer");
            StyleInfo ListEditorDeleteAllButtonContainerStyle = new StyleInfo("ListEditorDeleteAllButtonContainer");
            defaultStyleMap.put("LISTEDITOR_CONTAINER", ListEditorContainerStyle);
            defaultStyleMap.put("LISTEDITOR_LIST_CONTAINER", ListEditorListContainerStyle);
            defaultStyleMap.put("LISTEDITOR_BUTTON_CONTAINER", ListEditorButtonContainerStyle);
            defaultStyleMap.put("LISTEDITOR_ADD_BUTTON_CONTAINER", ListEditorAddButtonContainerStyle);
            defaultStyleMap.put("LISTEDITOR_UPDATE_BUTTON_CONTAINER", ListEditorUpdateButtonContainerStyle);
            defaultStyleMap.put("LISTEDITOR_DELETE_BUTTON_CONTAINER", ListEditorDeleteButtonContainerStyle);
            defaultStyleMap.put("LISTEDITOR_DELETEALL_BUTTON_CONTAINER", ListEditorDeleteAllButtonContainerStyle);
        }
        return defaultStyleMap;
    }

    @Override
    public Map getStyleMap() {
        return componentStyleMap;
    }

    @Override
    public BaseListBox getDefaultListComponent() {
        ListBox listBox = new ListBox();
        listBox.setName(this.getId() + "_List");
        listBox.setId(listBox.getName());
        listBox.setSize(6);
        StyleInfo style = new StyleInfo();
        style.setClassid("selectorList");
        listBox.setStyleInfo(style);
        return listBox;
    }

    @Override
    public BaseButton getDefaultAddButton() {
        Button button = new Button();
        button.setId(this.getId() + "_Add");
        button.setLabel(this.getDefaultAddButtonLabel(this.getLocale()));
        button.setButtonType(3);
        button.setWrap(false);
        button.setWidthPercentage(100);
        return button;
    }

    @Override
    public BaseButton getDefaultUpdateButton() {
        Button button = new Button();
        button.setId(this.getId() + "_Update");
        button.setLabel(this.getDefaultUpdateButtonLabel(this.getLocale()));
        button.setButtonType(3);
        button.setWrap(false);
        button.setWidthPercentage(100);
        return button;
    }

    @Override
    public BaseButton getDefaultDeleteButton() {
        Button button = new Button();
        button.setId(this.getId() + "_Delete");
        button.setLabel(this.getDefaultDeleteButtonLabel(this.getLocale()));
        button.setButtonType(3);
        button.setWrap(false);
        button.setWidthPercentage(100);
        return button;
    }

    @Override
    public BaseButton getDefaultDeleteAllButton() {
        Button button = new Button();
        button.setId(this.getId() + "_DelAll");
        button.setLabel(this.getDefaultDeleteAllButtonLabel(this.getLocale()));
        button.setButtonType(3);
        button.setWrap(false);
        button.setWidthPercentage(100);
        return button;
    }

    private String getDefaultAddButtonLabel(Locale locale) {
        return RB.getStringResource(RB_KEY, "AddButtonLabel.txt", locale);
    }

    private String getDefaultUpdateButtonLabel(Locale locale) {
        return RB.getStringResource(RB_KEY, "UpdateButtonLabel.txt", locale);
    }

    private String getDefaultDeleteButtonLabel(Locale locale) {
        return RB.getStringResource(RB_KEY, "DeleteButtonLabel.txt", locale);
    }

    private String getDefaultDeleteAllButtonLabel(Locale locale) {
        return RB.getStringResource(RB_KEY, "DeleteAllButtonLabel.txt", locale);
    }

    @Override
    public void setId(String id) {
        super.setId(id);
        this.getListComponent().setName(id + "_List");
    }

    @Override
    public void setName(String name) {
        super.setId(name);
        this.getListComponent().setName(name + "_List");
    }

    protected String getListComponentOnChange() {
        StringBuffer js = new StringBuffer();
        js.append("if (" + this.getJavaScriptName() + ".preSelect( )) { ");
        if (this.getPreSelectTrigger() != null) {
            js.append("if (" + this.getPreSelectTrigger() + ") ");
        }
        js.append(" " + this.getJavaScriptName() + ".select( );");
        js.append(" }");
        if (this.getPostSelectTrigger() != null) {
            js.append("\n");
            js.append(this.getPostSelectTrigger() + ";");
        }
        return js.toString();
    }

    protected String getAddButtonOnClick() {
        StringBuffer js = new StringBuffer();
        js.append("if ( " + this.getJavaScriptName() + ".preAdd( ) ) { ");
        if (this.getPreAddTrigger() != null) {
            js.append("if (" + this.getPreAddTrigger() + ") ");
        }
        js.append(" " + this.getJavaScriptName() + ".add( );");
        js.append(" }");
        if (this.getPostAddTrigger() != null) {
            js.append("\n");
            js.append(this.getPostAddTrigger() + ";");
        }
        return js.toString();
    }

    protected String getUpdateButtonOnClick() {
        StringBuffer js = new StringBuffer();
        js.append("if (" + this.getJavaScriptName() + ".preUpdate( )) { ");
        if (this.getPreUpdateTrigger() != null) {
            js.append("if (" + this.getPreUpdateTrigger() + ") ");
        }
        js.append(" " + this.getJavaScriptName() + ".update( );");
        js.append(" }");
        if (this.getPostUpdateTrigger() != null) {
            js.append("\n");
            js.append(this.getPostUpdateTrigger() + ";");
        }
        return js.toString();
    }

    protected String getDeleteButtonOnClick() {
        StringBuffer js = new StringBuffer();
        js.append("if ( " + this.getJavaScriptName() + ".preRemove( )) { ");
        if (this.getPreDeleteTrigger() != null) {
            js.append("if (" + this.getPreDeleteTrigger() + ") ");
        }
        js.append(" " + this.getJavaScriptName() + ".remove( );");
        js.append(" }");
        if (this.getPostDeleteTrigger() != null) {
            js.append("\n");
            js.append(this.getPostDeleteTrigger() + ";");
        }
        return js.toString();
    }

    protected String getDeleteAllButtonOnClick() {
        StringBuffer js = new StringBuffer();
        js.append("if ( " + this.getJavaScriptName() + ".preRemoveAll( )) { ");
        if (this.getPreDeleteAllTrigger() != null) {
            js.append("if (" + this.getPreDeleteAllTrigger() + ") ");
        }
        js.append("  " + this.getJavaScriptName() + ".removeAll( );");
        js.append(" }");
        if (this.getPostDeleteAllTrigger() != null) {
            js.append("\n");
            js.append(this.getPostDeleteAllTrigger() + ";");
        }
        return js.toString();
    }

    public String getDefaultConfirmDeleteMessage() {
        return RB.getStringResource("ListEditor.DefaultConfirmDeleteMessage.txt", this.getLocale());
    }

    public String getDefaultConfirmDeleteAllMessage() {
        return RB.getStringResource("ListEditor.DefaultConfirmDeleteAllMessage.txt", this.getLocale());
    }

    public String getConfirmDeleteMessage() {
        if (this.confirmDeleteMsg == null) {
            return this.getDefaultConfirmDeleteMessage();
        }
        return this.confirmDeleteMsg;
    }

    public String getConfirmDeleteAllMessage() {
        if (this.confirmDelAllMsg == null) {
            return this.getDefaultConfirmDeleteAllMessage();
        }
        return this.confirmDelAllMsg;
    }

    public void setConfirmDeleteMessage(String value) {
        this.confirmDeleteMsg = value;
    }

    public void setConfirmDeleteAllMessage(String value) {
        this.confirmDelAllMsg = value;
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        String epilog;
        if (!this.isVisible()) {
            this.cleanUpResources();
            return;
        }
        super.write(out);
        String prolog = this.getTagProlog();
        if (prolog != null) {
            out.write(prolog);
        }
        JavaScriptIncludeHandler.writeIncludes(out, "LISTEDITOR", this.getRequest());
        this.getListComponent().setOnChange(this.getListComponentOnChange());
        this.getAddButton().setOnClick(this.getAddButtonOnClick());
        this.getUpdateButton().setOnClick(this.getUpdateButtonOnClick());
        this.getDeleteButton().setOnClick(this.getDeleteButtonOnClick());
        this.getDeleteAllButton().setOnClick(this.getDeleteAllButtonOnClick());
        TemplateSupport.writeTemplate(this, null, out);
        out.println();
        String js = this.getJavaScript();
        if (js != null) {
            out.write(js);
        }
        if ((epilog = this.getTagEpilog()) != null) {
            out.write(epilog);
        }
        this.cleanUpResources();
    }

    protected String getJavaScriptName() {
        return this.getId();
    }

    protected String getJavaScript() {
        StringBuffer buf = new StringBuffer();
        buf.append(JavaScriptIncludeHandler.getStartScript());
        buf.append(this.getJavaScriptName());
        buf.append(" = new sas_ListEditor('");
        buf.append(this.getJavaScriptName());
        buf.append("');\n");
        String message = this.getConfirmDeleteMessage();
        if (message != null) {
            buf.append(this.getJavaScriptName());
            buf.append(".confirmDeleteMsg=").append(Strings.quote((String)message)).append(";\n");
        }
        if ((message = this.getConfirmDeleteAllMessage()) != null) {
            buf.append(this.getJavaScriptName());
            buf.append(".confirmDeleteAllMsg=").append(Strings.quote((String)message)).append(";\n");
        }
        buf.append(JavaScriptIncludeHandler.getEndScript(null));
        return buf.toString();
    }

    @Override
    public void setRequest(HttpServletRequest request) {
        super.setRequest(request);
    }

    static {
        JavaScriptIncludeHandler.addAlias(ListEditor.class, "LISTEDITOR");
    }
}

